/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.util.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.ArrayLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BooleanConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Identifier;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NullLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NumericConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.PropertyAccess;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.TernaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.UnaryOperation;

public class NodeTransformer
implements NodeVisitor<ExpressionNode> {
    public final ExpressionNode transform(ExpressionNode node) {
        return node.accept(this);
    }

    @Override
    public ExpressionNode evaluate(PropertyAccess propertyAccess) {
        return new PropertyAccess(this.transform(propertyAccess.getTarget()), this.transform(propertyAccess.getProperty()));
    }

    @Override
    public ExpressionNode evaluate(Identifier identifier) {
        return identifier;
    }

    @Override
    public ExpressionNode evaluate(StringConstant text) {
        return text;
    }

    @Override
    public ExpressionNode evaluate(BinaryOperation binaryOperation) {
        return new BinaryOperation(binaryOperation.getOperator(), this.transform(binaryOperation.getLeftOperand()), this.transform(binaryOperation.getRightOperand()));
    }

    @Override
    public ExpressionNode evaluate(BooleanConstant booleanConstant) {
        return booleanConstant;
    }

    @Override
    public ExpressionNode evaluate(NumericConstant numericConstant) {
        return numericConstant;
    }

    @Override
    public ExpressionNode evaluate(UnaryOperation unaryOperation) {
        return new UnaryOperation(unaryOperation.getOperator(), this.transform(unaryOperation.getTarget()));
    }

    @Override
    public ExpressionNode evaluate(TernaryOperator ternaryOperator) {
        return new TernaryOperator(this.transform(ternaryOperator.getCondition()), this.transform(ternaryOperator.getThenBranch()), this.transform(ternaryOperator.getElseBranch()));
    }

    @Override
    public ExpressionNode evaluate(RuntimeCall runtimeCall) {
        List<ExpressionNode> children = this.transformList(runtimeCall.getArguments());
        return new RuntimeCall(runtimeCall.getFunctionName(), children);
    }

    @Override
    public ExpressionNode evaluate(MapLiteral mapLiteral) {
        HashMap<String, ExpressionNode> map = new HashMap<String, ExpressionNode>();
        for (Map.Entry<String, ExpressionNode> entry : mapLiteral.getMap().entrySet()) {
            map.put(entry.getKey(), this.transform(entry.getValue()));
        }
        return new MapLiteral(map);
    }

    @Override
    public ExpressionNode evaluate(ArrayLiteral arrayLiteral) {
        return new ArrayLiteral(this.transformList(arrayLiteral.getItems()));
    }

    @Override
    public ExpressionNode evaluate(NullLiteral nullLiteral) {
        return nullLiteral;
    }

    private List<ExpressionNode> transformList(List<ExpressionNode> nodes) {
        ArrayList<ExpressionNode> result = new ArrayList<ExpressionNode>();
        for (ExpressionNode node : nodes) {
            result.add(this.transform(node));
        }
        return result;
    }
}

