/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.filter.FilterComponent;
import org.apache.sling.scripting.sightly.impl.utils.PathInfo;
import org.apache.sling.scripting.sightly.impl.utils.RenderUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;

@Component
@Service(value={Filter.class, RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"uriManipulation"})})
public class URIManipulationFilter
extends FilterComponent
implements RuntimeExtension {
    public static final String URI_MANIPULATION_FUNCTION = "uriManipulation";
    public static final String SCHEME = "scheme";
    public static final String DOMAIN = "domain";
    public static final String PATH = "path";
    public static final String APPEND_PATH = "appendPath";
    public static final String PREPEND_PATH = "prependPath";
    public static final String SELECTORS = "selectors";
    public static final String ADD_SELECTORS = "addSelectors";
    public static final String REMOVE_SELECTORS = "removeSelectors";
    public static final String EXTENSION = "extension";
    public static final String SUFFIX = "suffix";
    public static final String PREPEND_SUFFIX = "prependSuffix";
    public static final String APPEND_SUFFIX = "appendSuffix";
    public static final String FRAGMENT = "fragment";
    public static final String QUERY = "query";
    public static final String ADD_QUERY = "addQuery";
    public static final String REMOVE_QUERY = "removeQuery";

    @Override
    public Expression apply(Expression expression, ExpressionContext expressionContext) {
        Map<String, ExpressionNode> uriOptions;
        if ((expression.containsOption(SCHEME) || expression.containsOption(DOMAIN) || expression.containsOption(PATH) || expression.containsOption(APPEND_PATH) || expression.containsOption(PREPEND_PATH) || expression.containsOption(SELECTORS) || expression.containsOption(ADD_SELECTORS) || expression.containsOption(REMOVE_SELECTORS) || expression.containsOption(EXTENSION) || expression.containsOption(SUFFIX) || expression.containsOption(PREPEND_SUFFIX) || expression.containsOption(APPEND_SUFFIX) || expression.containsOption(FRAGMENT) || expression.containsOption(QUERY) || expression.containsOption(ADD_QUERY) || expression.containsOption(REMOVE_QUERY)) && expressionContext != ExpressionContext.PLUGIN_DATA_SLY_USE && expressionContext != ExpressionContext.PLUGIN_DATA_SLY_TEMPLATE && expressionContext != ExpressionContext.PLUGIN_DATA_SLY_CALL && expressionContext != ExpressionContext.PLUGIN_DATA_SLY_RESOURCE && (uriOptions = this.getFilterOptions(expression, SCHEME, DOMAIN, PATH, APPEND_PATH, PREPEND_PATH, SELECTORS, ADD_SELECTORS, REMOVE_SELECTORS, EXTENSION, SUFFIX, PREPEND_SUFFIX, APPEND_SUFFIX, FRAGMENT, QUERY, ADD_QUERY, REMOVE_QUERY)).size() > 0) {
            RuntimeCall translation = new RuntimeCall(URI_MANIPULATION_FUNCTION, expression.getRoot(), new MapLiteral(uriOptions));
            return expression.withNode(translation);
        }
        return expression;
    }

    @Override
    public Object call(RenderContext renderContext, Object ... arguments) {
        String fragment;
        String newSuffix;
        String appendSuffix;
        String pathInfoSuffix;
        String suffix;
        String prependSuffix;
        String newPath;
        String appendPath;
        String path;
        String prependPath;
        ExtensionUtils.checkArgumentCount(URI_MANIPULATION_FUNCTION, arguments, 2);
        String uriString = RenderUtils.toString(arguments[0]);
        Map options = RenderUtils.toMap(arguments[1]);
        StringBuilder sb = new StringBuilder();
        PathInfo pathInfo = new PathInfo(uriString);
        this.uriAppender(sb, SCHEME, options, pathInfo.getScheme());
        if (sb.length() > 0) {
            sb.append(":");
            sb.append(StringUtils.defaultIfEmpty((String)pathInfo.getBeginPathSeparator(), (String)"//"));
        }
        if (sb.length() > 0) {
            this.uriAppender(sb, DOMAIN, options, pathInfo.getHost());
        } else {
            String domain = this.getOption(DOMAIN, options, pathInfo.getHost());
            if (StringUtils.isNotEmpty((String)domain)) {
                sb.append("//").append(domain);
            }
        }
        if (pathInfo.getPort() > -1) {
            sb.append(":").append(pathInfo.getPort());
        }
        if ((prependPath = this.getOption(PREPEND_PATH, options, "")) == null) {
            prependPath = "";
        }
        if (StringUtils.isNotEmpty((String)prependPath)) {
            if (sb.length() > 0 && !prependPath.startsWith("/")) {
                prependPath = "/" + prependPath;
            }
            if (!prependPath.endsWith("/")) {
                prependPath = prependPath + "/";
            }
        }
        if (StringUtils.isEmpty((String)(path = this.getOption(PATH, options, pathInfo.getPath())))) {
            path = pathInfo.getPath();
        }
        if ((appendPath = this.getOption(APPEND_PATH, options, "")) == null) {
            appendPath = "";
        }
        if (StringUtils.isNotEmpty((String)appendPath) && !appendPath.startsWith("/")) {
            appendPath = "/" + appendPath;
        }
        try {
            newPath = new URI(prependPath + path + appendPath).normalize().getPath();
        }
        catch (URISyntaxException e) {
            newPath = prependPath + path + appendPath;
        }
        if (sb.length() > 0 && sb.lastIndexOf("/") != sb.length() - 1 && StringUtils.isNotEmpty((String)newPath) && !newPath.startsWith("/")) {
            sb.append("/");
        }
        sb.append(newPath);
        Set<String> selectors = pathInfo.getSelectors();
        this.handleSelectors(selectors, options);
        for (String selector : selectors) {
            if (!StringUtils.isNotBlank((String)selector) || selector.contains(" ")) continue;
            sb.append(".").append(selector);
        }
        String extension = this.getOption(EXTENSION, options, pathInfo.getExtension());
        if (StringUtils.isNotEmpty((String)extension)) {
            sb.append(".").append(extension);
        }
        if (StringUtils.isNotEmpty((String)(prependSuffix = this.getOption(PREPEND_SUFFIX, options, "")))) {
            if (!prependSuffix.startsWith("/")) {
                prependSuffix = "/" + prependSuffix;
            }
            if (!prependSuffix.endsWith("/")) {
                prependSuffix = prependSuffix + "/";
            }
        }
        if ((suffix = this.getOption(SUFFIX, options, (pathInfoSuffix = pathInfo.getSuffix()) == null ? "" : pathInfoSuffix)) == null) {
            suffix = "";
        }
        if (StringUtils.isNotEmpty((String)(appendSuffix = this.getOption(APPEND_SUFFIX, options, "")))) {
            appendSuffix = "/" + appendSuffix;
        }
        if (StringUtils.isNotEmpty((String)(newSuffix = ResourceUtil.normalize((String)(prependSuffix + suffix + appendSuffix))))) {
            if (!newSuffix.startsWith("/")) {
                sb.append("/");
            }
            sb.append(newSuffix);
        }
        Map<String, Collection<String>> parameters = pathInfo.getParameters();
        this.handleParameters(parameters, options);
        if (!parameters.isEmpty()) {
            sb.append("?");
            for (Map.Entry<String, Collection<String>> entry : parameters.entrySet()) {
                for (String value : entry.getValue()) {
                    sb.append(entry.getKey()).append("=").append(value).append("&");
                }
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)(fragment = this.getOption(FRAGMENT, options, pathInfo.getFragment())))) {
            sb.append("#").append(fragment);
        }
        return sb.toString();
    }

    private void uriAppender(StringBuilder stringBuilder, String option, Map<String, Object> options, String defaultValue) {
        String value = (String)options.get(option);
        if (StringUtils.isNotEmpty((String)value)) {
            stringBuilder.append(value);
        } else if (StringUtils.isNotEmpty((String)defaultValue)) {
            stringBuilder.append(defaultValue);
        }
    }

    private String getOption(String option, Map<String, Object> options, String defaultValue) {
        if (options.containsKey(option)) {
            return (String)options.get(option);
        }
        return defaultValue;
    }

    private void handleSelectors(Set<String> selectors, Map<String, Object> options) {
        Object addSelectorsOption;
        int index;
        Object[] selectorsURIArray;
        String[] selectorsArray;
        String selectorString;
        if (options.containsKey(SELECTORS)) {
            Object selectorsOption = options.get(SELECTORS);
            if (selectorsOption == null) {
                selectors.clear();
            } else if (selectorsOption instanceof String) {
                selectorString = (String)selectorsOption;
                selectorsArray = selectorString.split("\\.");
                this.replaceSelectors(selectors, selectorsArray);
            } else if (selectorsOption instanceof Object[]) {
                selectorsURIArray = (Object[])selectorsOption;
                selectorsArray = new String[selectorsURIArray.length];
                index = 0;
                for (Object selector : selectorsURIArray) {
                    selectorsArray[index++] = RenderUtils.toString(selector);
                }
                this.replaceSelectors(selectors, selectorsArray);
            }
        }
        if ((addSelectorsOption = options.get(ADD_SELECTORS)) instanceof String) {
            selectorString = (String)addSelectorsOption;
            selectorsArray = selectorString.split("\\.");
            this.addSelectors(selectors, selectorsArray);
        } else if (addSelectorsOption instanceof Object[]) {
            selectorsURIArray = (Object[])addSelectorsOption;
            selectorsArray = new String[selectorsURIArray.length];
            index = 0;
            for (Object selector : selectorsURIArray) {
                selectorsArray[index++] = RenderUtils.toString(selector);
            }
            this.addSelectors(selectors, selectorsArray);
        }
        Object removeSelectorsOption = options.get(REMOVE_SELECTORS);
        if (removeSelectorsOption instanceof String) {
            String selectorString2 = (String)removeSelectorsOption;
            String[] selectorsArray2 = selectorString2.split("\\.");
            this.removeSelectors(selectors, selectorsArray2);
        } else if (removeSelectorsOption instanceof Object[]) {
            Object[] selectorsURIArray2 = (Object[])removeSelectorsOption;
            String[] selectorsArray3 = new String[selectorsURIArray2.length];
            int index2 = 0;
            for (Object selector : selectorsURIArray2) {
                selectorsArray3[index2++] = RenderUtils.toString(selector);
            }
            this.removeSelectors(selectors, selectorsArray3);
        }
    }

    private void replaceSelectors(Set<String> selectors, String[] selectorsArray) {
        selectors.clear();
        selectors.addAll(Arrays.asList(selectorsArray));
    }

    private void addSelectors(Set<String> selectors, String[] selectorsArray) {
        selectors.addAll(Arrays.asList(selectorsArray));
    }

    private void removeSelectors(Set<String> selectors, String[] selectorsArray) {
        selectors.removeAll(Arrays.asList(selectorsArray));
    }

    private void handleParameters(Map<String, Collection<String>> parameters, Map<String, Object> options) {
        Object removeQueryOption;
        Object addQueryOption;
        ArrayList<String> values;
        ArrayList<String> values2;
        Collection<Object> collection;
        Object entryValue;
        if (options.containsKey(QUERY)) {
            Object queryOption = options.get(QUERY);
            parameters.clear();
            Map queryParameters = RenderUtils.toMap(queryOption);
            for (Map.Entry entry : queryParameters.entrySet()) {
                entryValue = entry.getValue();
                if (RenderUtils.isCollection(entryValue)) {
                    collection = RenderUtils.toCollection(entryValue);
                    values2 = new ArrayList<String>(collection.size());
                    for (Object o : collection) {
                        values2.add(RenderUtils.toString(o));
                    }
                    parameters.put((String)entry.getKey(), (Collection<String>)values2);
                    continue;
                }
                values = new ArrayList<String>(1);
                values.add(RenderUtils.toString(entryValue));
                parameters.put((String)entry.getKey(), (Collection<String>)values);
            }
        }
        if ((addQueryOption = options.get(ADD_QUERY)) != null) {
            Map addParams = RenderUtils.toMap(addQueryOption);
            for (Map.Entry entry : addParams.entrySet()) {
                entryValue = entry.getValue();
                if (RenderUtils.isCollection(entryValue)) {
                    collection = RenderUtils.toCollection(entryValue);
                    values2 = new ArrayList(collection.size());
                    for (Object o : collection) {
                        values2.add(RenderUtils.toString(o));
                    }
                    parameters.put((String)entry.getKey(), (Collection<String>)values2);
                    continue;
                }
                values = new ArrayList(1);
                values.add(RenderUtils.toString(entryValue));
                parameters.put((String)entry.getKey(), (Collection<String>)values);
            }
        }
        if ((removeQueryOption = options.get(REMOVE_QUERY)) != null) {
            if (removeQueryOption instanceof String) {
                parameters.remove(removeQueryOption);
            } else if (removeQueryOption instanceof Object[]) {
                Object[] removeQueryParamArray;
                for (Object param : removeQueryParamArray = (Object[])removeQueryOption) {
                    String paramString = RenderUtils.toString(param);
                    if (paramString == null) continue;
                    parameters.remove(paramString);
                }
            }
        }
    }
}

