/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.common.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Conditional;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginComponent;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

@Component
@Service(value={Plugin.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.impl.plugin.name", value={"test"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.priority", intValue={1})})
public class TestPlugin
extends PluginComponent {
    @Override
    public PluginInvoke invoke(final Expression expressionNode, final PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private boolean globalBinding;

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                String variableName = this.decodeVariableName();
                boolean bl = this.globalBinding = variableName != null;
                if (variableName == null) {
                    variableName = compilerContext.generateVariable("testVariable");
                }
                if (this.globalBinding) {
                    stream.emit(new VariableBinding.Global(variableName, expressionNode.getRoot()));
                } else {
                    stream.emit(new VariableBinding.Start(variableName, expressionNode.getRoot()));
                }
                stream.emit(new Conditional.Start(variableName, true));
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.emit(Conditional.END);
                if (!this.globalBinding) {
                    stream.emit(VariableBinding.END);
                }
            }

            private String decodeVariableName() {
                String[] args = callInfo.getArguments();
                if (args.length > 0) {
                    return args[0];
                }
                return null;
            }
        };
    }
}

