/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.engine;

import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public final class ResourceResolution {
    private static final int RECURSION_LIMIT = 100;

    public static Resource getResourceFromSearchPath(Resource base, String path) {
        if (path.startsWith("/")) {
            Resource resource = base.getResourceResolver().getResource(path);
            if (resource != null) {
                return ResourceResolution.searchPathChecked(resource);
            }
            return null;
        }
        Resource internalBase = null;
        if (base != null) {
            internalBase = "nt:file".equals(base.getResourceType()) ? ResourceResolution.retrieveParent(base) : base;
        }
        return ResourceResolution.resolveComponentInternal(internalBase, path);
    }

    public static Resource getResourceForRequest(ResourceResolver resolver, SlingHttpServletRequest request) {
        String resourceType = request.getResource().getResourceType();
        if (StringUtils.isNotEmpty((String)resourceType)) {
            if (resourceType.startsWith("/")) {
                return resolver.getResource(resourceType);
            }
            for (String searchPath : resolver.getSearchPath()) {
                Resource componentResource;
                String componentPath = ResourceUtil.normalize((String)(searchPath + "/" + resourceType));
                if (componentPath == null || (componentResource = resolver.getResource(componentPath)) == null) continue;
                return componentResource;
            }
        }
        return null;
    }

    private static Resource resolveComponentInternal(Resource base, String path) {
        if (base == null || path == null) {
            throw new NullPointerException("Arguments cannot be null");
        }
        Resource resource = ResourceResolution.recursiveResolution(base, path);
        if (resource == null) {
            resource = ResourceResolution.locateInSearchPath(base.getResourceResolver(), path);
        }
        return resource != null ? ResourceResolution.searchPathChecked(resource) : null;
    }

    private static Resource recursiveResolution(Resource base, String path) {
        ResourceResolver resolver = base.getResourceResolver();
        for (int iteration = 0; iteration < 100; ++iteration) {
            Resource resource = resolver.getResource(base, path);
            if (resource != null) {
                return resource;
            }
            if ((base = ResourceResolution.findSuperComponent(base)) != null) continue;
            return null;
        }
        throw new IllegalStateException("Searching for resource in component chain took more than 100 steps");
    }

    private static Resource locateInSearchPath(ResourceResolver resourceResolver, String path) {
        for (String searchPath : resourceResolver.getSearchPath()) {
            String fullPath = searchPath + path;
            Resource resource = resourceResolver.getResource(fullPath);
            if (resource == null || !resource.getPath().startsWith(searchPath)) continue;
            return resource;
        }
        return null;
    }

    private static boolean isInSearchPath(Resource resource) {
        String resourcePath = resource.getPath();
        ResourceResolver resolver = resource.getResourceResolver();
        for (String path : resolver.getSearchPath()) {
            if (!resourcePath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private static Resource findSuperComponent(Resource base) {
        ResourceResolver resolver = base.getResourceResolver();
        String superType = resolver.getParentResourceType(base);
        if (superType == null) {
            return null;
        }
        return resolver.getResource(superType);
    }

    private static Resource searchPathChecked(Resource resource) {
        if (!ResourceResolution.isInSearchPath(resource)) {
            throw new UnsupportedOperationException("Access to resource " + resource.getPath() + " is denied, since the resource does not reside on the search path");
        }
        return resource;
    }

    private static Resource retrieveParent(Resource resource) {
        String parentPath = ResourceUtil.getParent((String)resource.getPath());
        if (parentPath == null) {
            return null;
        }
        return resource.getResourceResolver().getResource(parentPath);
    }
}

