/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ExtensionRegistryService.class})
public class ExtensionRegistryService {
    private volatile Map<String, RuntimeExtension> mapping = new HashMap<String, RuntimeExtension>();
    private Map<String, Integer> mappingPriorities = new HashMap<String, Integer>(10, 0.9f);

    public Map<String, RuntimeExtension> extensions() {
        return this.mapping;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, service=RuntimeExtension.class, cardinality=ReferenceCardinality.MULTIPLE)
    protected synchronized void bindExtensionService(RuntimeExtension extension, Map<String, Object> properties) {
        Integer newPriority = PropertiesUtil.toInteger((Object)properties.get("service.ranking"), (int)0);
        String extensionName = PropertiesUtil.toString((Object)properties.get("org.apache.sling.scripting.sightly.extension.name"), (String)"");
        Integer priority = PropertiesUtil.toInteger((Object)this.mappingPriorities.get(extensionName), (int)0);
        if (newPriority > priority) {
            this.mapping = Collections.unmodifiableMap(this.add(this.mapping, extension, extensionName));
            this.mappingPriorities.put(extensionName, newPriority);
        } else if (!this.mapping.containsKey(extensionName)) {
            this.mapping = Collections.unmodifiableMap(this.add(this.mapping, extension, extensionName));
            this.mappingPriorities.put(extensionName, newPriority);
        }
    }

    protected synchronized void unbindExtensionService(RuntimeExtension extension, Map<String, Object> properties) {
        String extensionName = PropertiesUtil.toString((Object)properties.get("org.apache.sling.scripting.sightly.extension.name"), (String)"");
        this.mappingPriorities.remove(extensionName);
        this.mapping = Collections.unmodifiableMap(this.remove(this.mapping, extensionName));
    }

    private Map<String, RuntimeExtension> add(Map<String, RuntimeExtension> oldMap, RuntimeExtension extension, String extensionName) {
        HashMap<String, RuntimeExtension> newMap = new HashMap<String, RuntimeExtension>(oldMap);
        newMap.put(extensionName, extension);
        return newMap;
    }

    private Map<String, RuntimeExtension> remove(Map<String, RuntimeExtension> oldMap, String extensionName) {
        HashMap<String, RuntimeExtension> newMap = new HashMap<String, RuntimeExtension>(oldMap);
        newMap.remove(extensionName);
        return newMap;
    }
}

