/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled.operator;

import java.util.EnumMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.impl.compiled.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.ComparisonOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.ConcatenateOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.EquivalenceOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.IsWhiteSpaceGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.LengthOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.LogicalOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.LongOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.NotOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.NumericOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.StrictEqGenOp;
import org.apache.sling.scripting.sightly.impl.compiled.operator.UnaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.UnaryOperator;

public class Operators {
    private static final Map<BinaryOperator, BinaryOpGen> representationMap = new EnumMap<BinaryOperator, BinaryOpGen>(BinaryOperator.class);
    private static final Map<UnaryOperator, UnaryOpGen> unaryMapping = new EnumMap<UnaryOperator, UnaryOpGen>(UnaryOperator.class);

    public static BinaryOpGen generatorFor(BinaryOperator operator) {
        return Operators.provide(representationMap, operator);
    }

    public static UnaryOpGen generatorFor(UnaryOperator operator) {
        return Operators.provide(unaryMapping, operator);
    }

    private static <K, V> V provide(Map<K, V> map, K key) {
        V v = map.get(key);
        if (v == null) {
            throw new UnsupportedOperationException("Cannot find generator for operator: " + key);
        }
        return v;
    }

    static {
        representationMap.put(BinaryOperator.AND, LogicalOpGen.AND);
        representationMap.put(BinaryOperator.OR, LogicalOpGen.OR);
        representationMap.put(BinaryOperator.CONCATENATE, ConcatenateOpGen.INSTANCE);
        representationMap.put(BinaryOperator.ADD, new NumericOpGen("+"));
        representationMap.put(BinaryOperator.SUB, new NumericOpGen("-"));
        representationMap.put(BinaryOperator.MUL, new NumericOpGen("*"));
        representationMap.put(BinaryOperator.I_DIV, new LongOpGen("/"));
        representationMap.put(BinaryOperator.REM, new LongOpGen("%"));
        representationMap.put(BinaryOperator.DIV, new NumericOpGen("/"));
        representationMap.put(BinaryOperator.EQ, new EquivalenceOpGen(false));
        representationMap.put(BinaryOperator.NEQ, new EquivalenceOpGen(true));
        representationMap.put(BinaryOperator.LT, new ComparisonOpGen(BinaryOperator.LT));
        representationMap.put(BinaryOperator.LEQ, new ComparisonOpGen(BinaryOperator.LEQ));
        representationMap.put(BinaryOperator.GT, new ComparisonOpGen(BinaryOperator.GT));
        representationMap.put(BinaryOperator.GEQ, new ComparisonOpGen(BinaryOperator.GEQ));
        representationMap.put(BinaryOperator.STRICT_EQ, new StrictEqGenOp(false));
        representationMap.put(BinaryOperator.STRICT_NEQ, new StrictEqGenOp(true));
        unaryMapping.put(UnaryOperator.LENGTH, LengthOpGen.INSTANCE);
        unaryMapping.put(UnaryOperator.IS_WHITESPACE, IsWhiteSpaceGen.INSTANCE);
        unaryMapping.put(UnaryOperator.NOT, NotOpGen.INSTANCE);
    }
}

