/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.VariableFinder;
import org.apache.sling.scripting.sightly.impl.compiler.ris.Command;
import org.apache.sling.scripting.sightly.impl.compiler.ris.CommandVisitor;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Conditional;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Loop;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutText;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutVariable;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Procedure;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;

public class CommandVariableUsage
implements CommandVisitor {
    private ArrayList<String> variables = new ArrayList();

    public static List<String> extractVariables(Command command) {
        CommandVariableUsage cvu = new CommandVariableUsage();
        command.accept(cvu);
        return cvu.variables;
    }

    @Override
    public void visit(Conditional.Start conditionalStart) {
        this.variables.add(conditionalStart.getVariable());
    }

    @Override
    public void visit(Conditional.End conditionalEnd) {
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        this.addFromExpression(variableBindingStart.getExpression());
    }

    @Override
    public void visit(VariableBinding.End variableBindingEnd) {
    }

    @Override
    public void visit(VariableBinding.Global globalAssignment) {
        this.addFromExpression(globalAssignment.getExpression());
    }

    private void addFromExpression(ExpressionNode node) {
        this.variables.addAll(VariableFinder.findVariables(node));
    }

    @Override
    public void visit(OutVariable outVariable) {
        this.variables.add(outVariable.getVariableName());
    }

    @Override
    public void visit(OutText outText) {
    }

    @Override
    public void visit(Loop.Start loopStart) {
        this.variables.add(loopStart.getListVariable());
    }

    @Override
    public void visit(Loop.End loopEnd) {
    }

    @Override
    public void visit(Procedure.Start startProcedure) {
    }

    @Override
    public void visit(Procedure.End endProcedure) {
    }

    @Override
    public void visit(Procedure.Call procedureCall) {
        this.variables.add(procedureCall.getTemplateVariable());
        this.variables.add(procedureCall.getArgumentsVariable());
    }
}

