/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.io.IOException;
import java.io.InputStream;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.Policy;

public class PolicyHandler {
    private Policy policy;
    private AntiSamy antiSamy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyHandler(InputStream policyStream) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            this.policy = Policy.getInstance(policyStream);
            this.antiSamy = new AntiSamy(this.policy);
        }
        finally {
            if (policyStream != null) {
                try {
                    policyStream.close();
                }
                catch (IOException ioe) {}
            }
            currentThread.setContextClassLoader(cl);
        }
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public AntiSamy getAntiSamy() {
        return this.antiSamy;
    }
}

