/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart.run;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.run.LauncherCallable;
import org.apache.sling.maven.slingstart.run.LaunchpadEnvironment;
import org.apache.sling.maven.slingstart.run.PortHelper;
import org.apache.sling.maven.slingstart.run.ServerConfiguration;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class StartMojo
extends AbstractMojo {
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skipLaunchpad;
    @Parameter
    private List<ServerConfiguration> servers;
    @Parameter(property="launchpad.debug")
    protected String debug;
    @Parameter(property="launchpad.ready.timeout", defaultValue="600")
    private int launchpadReadyTimeOutSec;
    @Parameter(property="launchpad.jar")
    private File launchpadJar;
    @Parameter
    private Dependency launchpadDependency;
    @Parameter(property="launchpad.clean.workdir", defaultValue="false")
    private boolean cleanWorkingDirectory;
    @Parameter(property="launchpad.keep.running", defaultValue="false")
    private boolean keepLaunchpadRunning;
    @Parameter(property="launchpad.parallelExecution", defaultValue="true")
    private boolean parallelExecution;
    @Parameter(defaultValue="${project.build.directory}/launchpad-runner.properties")
    protected File systemPropertiesFile;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession mavenSession;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;

    private Artifact getArtifact(Dependency d) throws MojoExecutionException {
        DefaultArtifact prjArtifact = new DefaultArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), d.getScope(), d.getType(), d.getClassifier(), this.artifactHandlerManager.getArtifactHandler(d.getType()));
        try {
            this.resolver.resolve((Artifact)prjArtifact, this.project.getRemoteArtifactRepositories(), this.mavenSession.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to get artifact for " + d, (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to get artifact for " + d, (Exception)((Object)e));
        }
        return prjArtifact;
    }

    /*
     * Exception decompiling
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isRunning(Collection<LauncherCallable> tasks) {
        for (LauncherCallable task : tasks) {
            if (task.isRunning()) continue;
            return false;
        }
        return true;
    }

    private void createLaunchpadRunnerProperties(Collection<ServerConfiguration> configurations) throws MojoExecutionException {
        FileOutputStream writer = null;
        Properties props = new Properties();
        try {
            writer = new FileOutputStream(this.systemPropertiesFile);
            props.put("launchpad.skip.startupcheck", "true");
            int index = 0;
            for (ServerConfiguration launchpadConfiguration : configurations) {
                props.put("launchpad.instance.id." + String.valueOf(++index), launchpadConfiguration.getId());
                String runMode = launchpadConfiguration.getRunmode();
                if (runMode == null) {
                    runMode = "";
                }
                props.put("launchpad.instance.runmode." + String.valueOf(index), runMode);
                props.put("launchpad.instance.server." + String.valueOf(index), launchpadConfiguration.getServer());
                props.put("launchpad.instance.port." + String.valueOf(index), launchpadConfiguration.getPort());
                props.put("launchpad.instance.contextPath." + String.valueOf(index), launchpadConfiguration.getContextPath());
                String url = StartMojo.createServerUrl(launchpadConfiguration);
                props.put("launchpad.instance.url." + String.valueOf(index), url);
            }
            props.put("launchpad.instances", String.valueOf(index));
            props.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)writer);
    }

    private static String createServerUrl(ServerConfiguration qc) {
        String contextPath;
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        sb.append(qc.getServer());
        if (!qc.getPort().equals("80")) {
            sb.append(':');
            sb.append(qc.getPort());
        }
        if ((contextPath = qc.getContextPath()) != null && contextPath.trim().length() > 0 && !contextPath.equals("/")) {
            if (!contextPath.startsWith("/")) {
                sb.append('/');
            }
            if (contextPath.endsWith("/")) {
                sb.append(contextPath, 0, contextPath.length() - 1);
            } else {
                sb.append(contextPath);
            }
        }
        return sb.toString();
    }

    private LauncherCallable createTask(ServerConfiguration launchpadConfiguration, LaunchpadEnvironment env) throws MojoExecutionException, MojoFailureException {
        String id = launchpadConfiguration.getId();
        this.getLog().debug((CharSequence)("Starting " + id + " with runmode " + launchpadConfiguration.getRunmode() + " on port " + launchpadConfiguration.getPort() + " in folder " + launchpadConfiguration.getFolder().getAbsolutePath()));
        return new LauncherCallable(this.getLog(), launchpadConfiguration, env);
    }

    private void validateConfiguration(ServerConfiguration launchpadConfiguration) throws MojoExecutionException {
        if (launchpadConfiguration.getPort() == null) {
            launchpadConfiguration.setPort(String.valueOf(PortHelper.getNextAvailablePort()));
        }
        if (launchpadConfiguration.getControlPort() == null) {
            launchpadConfiguration.setControlPort(String.valueOf(PortHelper.getNextAvailablePort()));
        }
        if (launchpadConfiguration.getId() == null || launchpadConfiguration.getId().trim().length() == 0) {
            String runMode = launchpadConfiguration.getRunmode();
            if (runMode == null) {
                runMode = "_";
            }
            String id = runMode.replace(',', '_') + '-' + launchpadConfiguration.getPort();
            launchpadConfiguration.setId(id);
        }
        if (launchpadConfiguration.getFolder() == null) {
            File folder = new File(this.project.getBuild().getDirectory() + '/' + launchpadConfiguration.getId());
            launchpadConfiguration.setFolder(folder);
        }
        if (launchpadConfiguration.getContextPath() == null) {
            launchpadConfiguration.setContextPath("");
        }
        if (launchpadConfiguration.getInstances() < 0) {
            launchpadConfiguration.setInstances(1);
        }
    }

    private File findLaunchpadJar() throws MojoFailureException, MojoExecutionException {
        File jarFile;
        if (this.launchpadJar != null) {
            return this.launchpadJar;
        }
        if (this.launchpadDependency != null) {
            return this.getArtifact(this.launchpadDependency).getFile();
        }
        if (this.project.getPackaging().equals("slingstart") && (jarFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".jar")).exists()) {
            return jarFile;
        }
        Set dependencies = this.project.getDependencyArtifacts();
        for (Artifact dep : dependencies) {
            if (!"slingstart".equals(dep.getType())) continue;
            Dependency d = new Dependency();
            d.setGroupId(dep.getGroupId());
            d.setArtifactId(dep.getArtifactId());
            d.setVersion(dep.getVersion());
            d.setScope("runtime");
            d.setType("jar");
            return this.getArtifact(d).getFile();
        }
        throw new MojoFailureException("Could not find the launchpad jar. Either specify the 'launchpadJar' configuration or use this inside a slingstart project.");
    }

    private Collection<ServerConfiguration> getLaunchpadConfigurations() {
        ArrayList<ServerConfiguration> configs = new ArrayList<ServerConfiguration>();
        if (this.servers != null && !this.servers.isEmpty()) {
            for (ServerConfiguration config : this.servers) {
                if (config.getInstances() == 0) continue;
                configs.add(config);
                for (int i = 2; i <= config.getInstances(); ++i) {
                    ServerConfiguration replicaConfig = config.copy();
                    replicaConfig.setPort(null);
                    File folder = replicaConfig.getFolder();
                    if (folder != null) {
                        replicaConfig.setFolder(new File(folder.getParentFile(), folder.getName() + '-' + String.valueOf(i)));
                    }
                    configs.add(replicaConfig);
                }
                config.setInstances(1);
            }
        } else {
            configs.add(new ServerConfiguration());
        }
        return configs;
    }
}

