/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.ModelPreprocessor;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.io.ModelReader;
import org.apache.sling.provisioning.model.io.ModelWriter;

public abstract class ProjectHelper {
    private static final String RAW_MODEL_TXT = Model.class.getName() + "/raw.txt";
    private static final String RAW_MODEL_CACHE = Model.class.getName() + "/raw.cache";
    private static final String EFFECTIVE_MODEL_TXT = Model.class.getName() + "/effective.txt";
    private static final String EFFECTIVE_MODEL_CACHE = Model.class.getName() + "/effective.cache";
    private static final String DEPENDENCY_MODEL = Model.class.getName() + "/dependency";

    public static void storeProjectInfo(ModelPreprocessor.ProjectInfo info) throws IOException {
        StringWriter w1 = new StringWriter();
        ModelWriter.write((Writer)w1, (Model)info.localModel);
        info.project.setContextValue(RAW_MODEL_TXT, (Object)w1.toString());
        StringWriter w2 = new StringWriter();
        ModelWriter.write((Writer)w2, (Model)info.model);
        info.project.setContextValue(EFFECTIVE_MODEL_TXT, (Object)w2.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Artifact, Model> entry : info.includedModels.entrySet()) {
            StringWriter w3 = new StringWriter();
            ModelWriter.write((Writer)w3, (Model)entry.getValue());
            map.put(entry.getKey().toMvnUrl(), w3.toString());
        }
        info.project.setContextValue(DEPENDENCY_MODEL, map);
    }

    public static Model getEffectiveModel(MavenProject project, ModelUtility.ResolverOptions resolverOptions) throws MojoExecutionException {
        Model result = (Model)project.getContextValue(EFFECTIVE_MODEL_CACHE);
        if (result == null) {
            try {
                StringReader r = new StringReader((String)project.getContextValue(EFFECTIVE_MODEL_TXT));
                result = ModelReader.read((Reader)r, (String)project.getId());
                result = ModelUtility.getEffectiveModel((Model)result, (ModelUtility.ResolverOptions)resolverOptions);
                project.setContextValue(EFFECTIVE_MODEL_CACHE, (Object)result);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
            }
        }
        return result;
    }

    public static Model getRawModel(MavenProject project) throws MojoExecutionException {
        Model result = (Model)project.getContextValue(RAW_MODEL_CACHE);
        if (result == null) {
            try {
                String text = (String)project.getContextValue(RAW_MODEL_TXT);
                if (text == null) {
                    throw new MojoExecutionException("No provisioning model found in project.");
                }
                StringReader r = new StringReader(text);
                result = ModelReader.read((Reader)r, (String)project.getId());
                project.setContextValue(RAW_MODEL_CACHE, (Object)result);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
            }
        }
        return result;
    }

    public static Map<String, String> getDependencyModel(MavenProject project) throws MojoExecutionException {
        return (Map)project.getContextValue(DEPENDENCY_MODEL);
    }
}

