/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientCache
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, SolrClient> solrClients = new HashMap<String, SolrClient>();
    private final HttpClient httpClient;

    public SolrClientCache() {
        this.httpClient = null;
    }

    public SolrClientCache(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public synchronized CloudSolrClient getCloudSolrClient(String zkHost) {
        CloudSolrClient client;
        Objects.requireNonNull(zkHost, "ZooKeeper host cannot be null!");
        if (this.solrClients.containsKey(zkHost)) {
            client = (CloudSolrClient)this.solrClients.get(zkHost);
        } else {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(zkHost);
            CloudSolrClient.Builder builder = (CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(hosts, Optional.empty()).withSocketTimeout(30000)).withConnectionTimeout(15000);
            if (this.httpClient != null) {
                builder = (CloudSolrClient.Builder)builder.withHttpClient(this.httpClient);
            }
            client = builder.build();
            client.connect();
            this.solrClients.put(zkHost, client);
        }
        return client;
    }

    public synchronized HttpSolrClient getHttpSolrClient(String host) {
        HttpSolrClient client;
        if (this.solrClients.containsKey(host)) {
            client = (HttpSolrClient)this.solrClients.get(host);
        } else {
            HttpSolrClient.Builder builder = new HttpSolrClient.Builder(host);
            if (this.httpClient != null) {
                builder = (HttpSolrClient.Builder)builder.withHttpClient(this.httpClient);
            }
            client = builder.build();
            this.solrClients.put(host, client);
        }
        return client;
    }

    public synchronized void close() {
        for (Map.Entry<String, SolrClient> entry : this.solrClients.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Error closing SolrClient for {}", (Object)entry.getKey(), (Object)e);
            }
        }
        this.solrClients.clear();
    }
}

