/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(input, bitLength) - Returns a checksum of SHA-2 family as a hex string of the input.\n            SHA-224, SHA-256, SHA-384, and SHA-512 are supported. Bit length of 0 is equivalent to 256.", extended="> SELECT _FUNC_('Spark', 0);\n               '529bc3b07127ecb7e53a4dcf1991d9152c24537d919178022b2c42657f79a26b'")
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001>\u0011Aa\u00155be)\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!QQR\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003#mI!\u0001\b\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0006\u0010\n\u0005}1\"a\u0002)s_\u0012,8\r\u001e\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!A.\u001a4u+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006Y\u00164G\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001E\u0005)!/[4ii\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!i\u0005AA-\u0019;b)f\u0004X-F\u00016!\t1\u0014(D\u00018\u0015\tAd!A\u0003usB,7/\u0003\u0002;o\tAA)\u0019;b)f\u0004X\rC\u0003=\u0001\u0011\u0005S(\u0001\u0005ok2d\u0017M\u00197f+\u0005q\u0004CA\u000b@\u0013\t\u0001eCA\u0004C_>dW-\u00198\t\u000b\t\u0003A\u0011I\"\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001E!\r)U*\u000e\b\u0003\r.s!a\u0012&\u000e\u0003!S!!\u0013\b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012B\u0001'\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0007M+\u0017O\u0003\u0002M-!)\u0011\u000b\u0001C)%\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u00191K\u0016-\u0011\u0005U!\u0016BA+\u0017\u0005\r\te.\u001f\u0005\u0006/B\u0003\raU\u0001\u0007S:\u0004X\u000f^\u0019\t\u000be\u0003\u0006\u0019A*\u0002\r%t\u0007/\u001e;3\u0011\u0015Y\u0006\u0001\"\u0011]\u0003\u001d9WM\\\"pI\u0016$2!\u00183m!\tq\u0016M\u0004\u0002\u0016?&\u0011\u0001MF\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'AB*ue&twM\u0003\u0002a-!)QM\u0017a\u0001M\u0006\u00191\r\u001e=\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003W\"\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003n5\u0002\u0007a.\u0001\u0002fmB\u0011qm\\\u0005\u0003a\"\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\be\u0002\t\t\u0011\"\u0001t\u0003\u0011\u0019w\u000e]=\u0015\u0007=\"X\u000fC\u0004\"cB\u0005\t\u0019A\u0012\t\u000f%\n\b\u0013!a\u0001G!9q\u000fAI\u0001\n\u0003A\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0002s*\u00121E_\u0016\u0002wB\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0001-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u0015QPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0001\"!\u0003\u0001#\u0003%\t\u0001_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\ti\u0001AA\u0001\n\u0003\ny!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003mC:<'BAA\u000e\u0003\u0011Q\u0017M^1\n\u0007\t\f)\u0002C\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0005\t\u0004+\u0005\u001d\u0012bAA\u0015-\t\u0019\u0011J\u001c;\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004'\u0006E\u0002BCA\u001a\u0003W\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005]\u0002!!A\u0005B\u0005e\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0002#BA\u001f\u0003\u0007\u001aVBAA \u0015\r\t\tEF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA#\u0003\u007f\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004}\u00055\u0003\"CA\u001a\u0003\u000f\n\t\u00111\u0001T\u0011%\t\t\u0006AA\u0001\n\u0003\n\u0019&\u0001\u0005iCND7i\u001c3f)\t\t)\u0003C\u0005\u0002X\u0001\t\t\u0011\"\u0011\u0002Z\u00051Q-];bYN$2APA.\u0011%\t\u0019$!\u0016\u0002\u0002\u0003\u00071\u000bK\u0006\u0001\u0003?\n)'a\u001a\u0002l\u00055\u0004cA\t\u0002b%\u0019\u00111\r\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011N\u0001\u0002\b~3UKT\"`Q%t\u0007/\u001e;-A\tLG\u000fT3oORD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\r[3dWN,X\u000eI8gAMC\u0015)\f\u001a!M\u0006l\u0017\u000e\\=!CN\u0004\u0013\r\t5fq\u0002\u001aHO]5oO\u0002zg\r\t;iK\u0002Jg\u000e];u])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'\"\u000bUF\r\u001a5Y\u0001\u001a\u0006*Q\u00173kYb\u0003e\u0015%B[MBD\u0007\f\u0011b]\u0012\u00043\u000bS!.kE\u0012\u0004%\u0019:fAM,\b\u000f]8si\u0016$g\u0006\t\"ji\u0002bWM\\4uQ\u0002zg\r\t\u0019!SN\u0004S-];jm\u0006dWM\u001c;!i>\u0004#'\u000e\u001c/\u0003!)\u0007\u0010^3oI\u0016$\u0017EAA8\u00039t\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\w\u0005\f\u00111SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003eJ\u001b3s\t\u001c7G\u0019\u00198cI:Tm\u001928KV\u001a\u0014\r\u000e3dMFJ\u0014(\r3:cU\u00124M\r\u001b6g]\"\u0017(M\u001d2oa\u0002$G\r23GR\u0012d'N\u001cgoe\n'G\u000e2(\u000f%\t\u0019HAA\u0001\u0012\u0003\t)(\u0001\u0003TQ\u0006\u0014\u0004cA\t\u0002x\u0019A\u0011AAA\u0001\u0012\u0003\tIhE\u0003\u0002x\u0005mD\u0003E\u0004\u0002~\u0005\r5eI\u0018\u000e\u0005\u0005}$bAAA-\u00059!/\u001e8uS6,\u0017\u0002BAC\u0003\u007f\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001di\u0013q\u000fC\u0001\u0003\u0013#\"!!\u001e\t\u0015\u00055\u0015qOA\u0001\n\u000b\ny)\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0002\u0003\u0006\u0002\u0014\u0006]\u0014\u0011!CA\u0003+\u000bQ!\u00199qYf$RaLAL\u00033Ca!IAI\u0001\u0004\u0019\u0003BB\u0015\u0002\u0012\u0002\u00071\u0005\u0003\u0006\u0002\u001e\u0006]\u0014\u0011!CA\u0003?\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\"\u00065\u0006#B\u000b\u0002$\u0006\u001d\u0016bAAS-\t1q\n\u001d;j_:\u0004R!FAUG\rJ1!a+\u0017\u0005\u0019!V\u000f\u001d7fe!I\u0011qVAN\u0003\u0003\u0005\raL\u0001\u0004q\u0012\u0002\u0004BCAZ\u0003o\n\t\u0011\"\u0003\u00026\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\f\u0005\u0003\u0002\u0014\u0005e\u0016\u0002BA^\u0003+\u0011aa\u00142kK\u000e$\b")
public class Sha2
extends BinaryExpression
implements Serializable,
ImplicitCastInputTypes {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Sha2 sha2) {
        return Sha2$.MODULE$.unapply(sha2);
    }

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        UTF8String uTF8String;
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            default: {
                uTF8String = null;
                break;
            }
            case 512: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
                break;
            }
            case 384: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
                break;
            }
            case 0: 
            case 256: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
                break;
            }
            case 224: {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-224");
                    md.update(input);
                    uTF8String = UTF8String.fromBytes((byte[])md.digest());
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    uTF8String = null;
                }
            }
        }
        return uTF8String;
    }

    @Override
    public String genCode(CodegenContext ctx, ExprCode ev) {
        String digestUtils = "org.apache.commons.codec.digest.DigestUtils";
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, digestUtils){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$1;
            private final String digestUtils$1;

            public final String apply(String eval1, String eval2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", " == 224) {\n          try {\n            java.security.MessageDigest md = java.security.MessageDigest.getInstance(\"SHA-224\");\n            md.update(", ");\n            ", " = UTF8String.fromBytes(md.digest());\n          } catch (java.security.NoSuchAlgorithmException e) {\n            ", " = true;\n          }\n        } else if (", " == 256 || ", " == 0) {\n          ", " =\n            UTF8String.fromString(", ".sha256Hex(", "));\n        } else if (", " == 384) {\n          ", " =\n            UTF8String.fromString(", ".sha384Hex(", "));\n        } else if (", " == 512) {\n          ", " =\n            UTF8String.fromString(", ".sha512Hex(", "));\n        } else {\n          ", " = true;\n        }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2, eval1, this.ev$1.value(), this.ev$1.isNull(), eval2, eval2, this.ev$1.value(), this.digestUtils$1, eval1, eval2, this.ev$1.value(), this.digestUtils$1, eval1, eval2, this.ev$1.value(), this.digestUtils$1, eval1, this.ev$1.isNull()}));
            }
            {
                this.ev$1 = ev$1;
                this.digestUtils$1 = digestUtils$1;
            }
        });
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

