/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ pattern - Returns true if str matches pattern, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n          The escape character is '\\'. If an escape character precedes a special symbol or another\n          escape character, the following character is matched literally. It is invalid to escape\n          any other character.\n\n          Since Spark 2.0, string literals are unescaped in our SQL parser. For example, in order\n          to match \"\\abc\", the pattern should be \"\\\\abc\".\n\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it fallbacks\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".\n  ", examples="\n    Examples:\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%'\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001>\u0011A\u0001T5lK*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!QQ\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005U\u0019FO]5oOJ+w-\u001a=FqB\u0014Xm]:j_:\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t=\u0001\u0011)\u001a!C\u0001?\u0005!A.\u001a4u+\u0005\u0001\u0003CA\t\"\u0013\t\u0011#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001\u0002\n\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0006Y\u00164G\u000f\t\u0005\tM\u0001\u0011)\u001a!C\u0001?\u0005)!/[4ii\"A\u0001\u0006\u0001B\tB\u0003%\u0001%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071jc\u0006\u0005\u0002\u0012\u0001!)a$\u000ba\u0001A!)a%\u000ba\u0001A!)\u0001\u0007\u0001C!c\u00051Qm]2ba\u0016$\"AM\u001d\u0011\u0005M2dBA\u000b5\u0013\t)d#\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u0017\u0011\u0015Qt\u00061\u00013\u0003\u00051\b\"\u0002\u001f\u0001\t\u0003j\u0014aB7bi\u000eDWm\u001d\u000b\u0004}\u0005c\u0005CA\u000b@\u0013\t\u0001eCA\u0004C_>dW-\u00198\t\u000b\t[\u0004\u0019A\"\u0002\u000bI,w-\u001a=\u0011\u0005\u0011SU\"A#\u000b\u0005\t3%BA$I\u0003\u0011)H/\u001b7\u000b\u0003%\u000bAA[1wC&\u00111*\u0012\u0002\b!\u0006$H/\u001a:o\u0011\u0015i5\b1\u00013\u0003\r\u0019HO\u001d\u0005\u0006\u001f\u0002!\t\u0005U\u0001\ti>\u001cFO]5oOR\t!\u0007C\u0003S\u0001\u0011E3+A\u0005e_\u001e+gnQ8eKR\u0019AKW0\u0011\u0005UCV\"\u0001,\u000b\u0005]\u0013\u0011aB2pI\u0016<WM\\\u0005\u00033Z\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u00067F\u0003\r\u0001X\u0001\u0004GRD\bCA+^\u0013\tqfK\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000b\u0001\f\u0006\u0019\u0001+\u0002\u0005\u00154\bb\u00022\u0001\u0003\u0003%\taY\u0001\u0005G>\u0004\u0018\u0010F\u0002-I\u0016DqAH1\u0011\u0002\u0003\u0007\u0001\u0005C\u0004'CB\u0005\t\u0019\u0001\u0011\t\u000f\u001d\u0004\u0011\u0013!C\u0001Q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A5+\u0005\u0001R7&A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017!C;oG\",7m[3e\u0015\t\u0001h#\u0001\u0006b]:|G/\u0019;j_:L!A]7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004u\u0001E\u0005I\u0011\u00015\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!9a\u000fAA\u0001\n\u0003:\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001y!\tIH0D\u0001{\u0015\tY\b*\u0001\u0003mC:<\u0017BA\u001c{\u0011\u001dq\b!!A\u0005\u0002}\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0001\u0011\u0007U\t\u0019!C\u0002\u0002\u0006Y\u00111!\u00138u\u0011%\tI\u0001AA\u0001\n\u0003\tY!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00111\u0003\t\u0004+\u0005=\u0011bAA\t-\t\u0019\u0011I\\=\t\u0015\u0005U\u0011qAA\u0001\u0002\u0004\t\t!A\u0002yIEB\u0011\"!\u0007\u0001\u0003\u0003%\t%a\u0007\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\b\u0011\r\u0005}\u0011QEA\u0007\u001b\t\t\tCC\u0002\u0002$Y\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9#!\t\u0003\u0011%#XM]1u_JD\u0011\"a\u000b\u0001\u0003\u0003%\t!!\f\u0002\u0011\r\fg.R9vC2$2APA\u0018\u0011)\t)\"!\u000b\u0002\u0002\u0003\u0007\u0011Q\u0002\u0005\n\u0003g\u0001\u0011\u0011!C!\u0003k\ta!Z9vC2\u001cHc\u0001 \u00028!Q\u0011QCA\u0019\u0003\u0003\u0005\r!!\u0004)/\u0001\tY$!\u0011\u0002D\u0005\u001d\u0013\u0011JA'\u0003\u001f\n\u0019&!\u0016\u0002Z\u0005m\u0003cA\t\u0002>%\u0019\u0011q\b\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QI\u0001kgR\u0014\be\u0018$V\u001d\u000e{\u0006\u0005]1ui\u0016\u0014h\u000eI\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u001aHO\u001d\u0011nCR\u001c\u0007.Z:!a\u0006$H/\u001a:oY\u0001rW\u000f\u001c7!S\u001a\u0004\u0013M\\=!CJ<W/\\3oiN\u0004\u0013M]3!]VdG\u000e\f\u0011gC2\u001cX\rI8uQ\u0016\u0014x/[:f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u0017\n\u0001r\u0007\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!a\u0006$H/\u001a:oA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]:\u0002C\u000b[3!a\u0006$H/\u001a:oA%\u001c\b%\u0019\u0011tiJLgn\u001a\u0011xQ&\u001c\u0007\u000eI5tA5\fGo\u00195fI\u0002b\u0017\u000e^3sC2d\u0017\u0010\f\u0011xSRD'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!Kb\u001cW\r\u001d;j_:\u0004Co\u001c\u0011uQ\u0016\u0004cm\u001c7m_^Lgn\u001a\u0011ta\u0016\u001c\u0017.\u00197!gfl'm\u001c7tu)Q\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011`A5\fGo\u00195fg\u0002\ng.\u001f\u0011p]\u0016\u00043\r[1sC\u000e$XM\u001d\u0011j]\u0002\"\b.\u001a\u0011j]B,H\u000f\t\u0015tS6LG.\u0019:!i>\u0004c\u0006I5oAA|7/\u001b=!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn]\u0015\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\n\u0011nCR\u001c\u0007.Z:!u\u0016\u0014x\u000eI8sA5|'/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002B3/[7jY\u0006\u0014\b\u0005^8!])\u0002\u0013N\u001c\u0011q_NL\u0007\u0010\t:fOVd\u0017M\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001*\u0007\u0010\u001d:fgNLwN\\:*\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t+iK\u0002*7oY1qK\u0002\u001a\u0007.\u0019:bGR,'\u000fI5tA\u001dbvE\f\u0011JM\u0002\ng\u000eI3tG\u0006\u0004X\rI2iCJ\f7\r^3sAA\u0014XmY3eKN\u0004\u0013\rI:qK\u000eL\u0017\r\u001c\u0011ts6\u0014w\u000e\u001c\u0011pe\u0002\ngn\u001c;iKJT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe2\u0002C\u000f[3!M>dGn\\<j]\u001e\u00043\r[1sC\u000e$XM\u001d\u0011jg\u0002j\u0017\r^2iK\u0012\u0004C.\u001b;fe\u0006dG.\u001f\u0018!\u0013R\u0004\u0013n\u001d\u0011j]Z\fG.\u001b3!i>\u0004Sm]2ba\u0016T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]f\u0004s\u000e\u001e5fe\u0002\u001a\u0007.\u0019:bGR,'O\f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023+\u001b8dK\u0002\u001a\u0006/\u0019:lAIr\u0003\u0007\f\u0011tiJLgn\u001a\u0011mSR,'/\u00197tA\u0005\u0014X\rI;oKN\u001c\u0017\r]3eA%t\u0007e\\;sAM\u000bF\n\t9beN,'O\f\u0011G_J\u0004S\r_1na2,G\u0006I5oA=\u0014H-\u001a:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002Co\u001c\u0011nCR\u001c\u0007\u000e\t\u0012]C\n\u001c'\u0005\f\u0011uQ\u0016\u0004\u0003/\u0019;uKJt\u0007e\u001d5pk2$\u0007EY3!Eqc\u0016MY2#])Q\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011XQ\u0016t\u0007eU)MA\r|gNZ5hA\u001d\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u0014!SN\u0004SM\\1cY\u0016$G\u0006I5uA\u0019\fG\u000e\u001c2bG.\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3oC\ndW\r\u001a\u0017!i\",\u0007\u0005]1ui\u0016\u0014h\u000e\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012!g\"|W\u000f\u001c3!E\u0016\u0004#\u0005X1cG\nr#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u0015\u0002O*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003s%J*zgR,W\u000e\u0012:jm\u0016,C,V:feNd&j\u001c5oO\u0001zf)\u0016(D?\u0002:C,J*zgR,W\u000e\u0012:jm\u0016dV\u0005\u0018/Vg\u0016\u00148/J\u0014\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003/\nQH\u0003\u0011!A\u0001*6/\u001a\u0011S\u0019&[U\t\t;pA5\fGo\u00195!o&$\b\u000eI:uC:$\u0017M\u001d3!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn\u001d\u0018\u000bA\u0001\nQa]5oG\u0016\f#!!\u0018\u0002\u000bEr\u0003G\f\u0019\b\u0013\u0005\u0005$!!A\t\u0002\u0005\r\u0014\u0001\u0002'jW\u0016\u00042!EA3\r!\t!!!A\t\u0002\u0005\u001d4#BA3\u0003SR\u0002cBA6\u0003c\u0002\u0003\u0005L\u0007\u0003\u0003[R1!a\u001c\u0017\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001d\u0002n\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f)\n)\u0007\"\u0001\u0002xQ\u0011\u00111\r\u0005\n\u001f\u0006\u0015\u0014\u0011!C#\u0003w\"\u0012\u0001\u001f\u0005\u000b\u0003\u007f\n)'!A\u0005\u0002\u0006\u0005\u0015!B1qa2LH#\u0002\u0017\u0002\u0004\u0006\u0015\u0005B\u0002\u0010\u0002~\u0001\u0007\u0001\u0005\u0003\u0004'\u0003{\u0002\r\u0001\t\u0005\u000b\u0003\u0013\u000b)'!A\u0005\u0002\u0006-\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001b\u000bI\nE\u0003\u0016\u0003\u001f\u000b\u0019*C\u0002\u0002\u0012Z\u0011aa\u00149uS>t\u0007#B\u000b\u0002\u0016\u0002\u0002\u0013bAAL-\t1A+\u001e9mKJB\u0011\"a'\u0002\b\u0006\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002 \u0006\u0015\u0014\u0011!C\u0005\u0003C\u000b1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0015\t\u0004s\u0006\u0015\u0016bAATu\n1qJ\u00196fGR\u0004")
public class Like
extends StringRegexExpression
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Like like) {
        return Like$.MODULE$.unapply(like);
    }

    public static Function1<Tuple2<Expression, Expression>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Like>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v);
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left(), this.right()}));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$")).append((Object)".escapeLikeRegex").toString();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal == null) {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)new Serializable(this, patternClass, regexStr){
                    public static final long serialVersionUID = 0L;
                    private final String patternClass$1;
                    private final String regexStr$1;

                    public final String apply(String v) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".compile(\"", "\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v, this.patternClass$1, this.regexStr$1}));
                    }
                    {
                        this.patternClass$1 = patternClass$1;
                        this.regexStr$1 = regexStr$1;
                    }
                }, ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval2 = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), eval2.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval2.value()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String pattern = ctx.freshName("pattern");
            String rightStr = ctx.freshName("rightStr");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, patternClass, escapeFunc, pattern, rightStr){
                public static final long serialVersionUID = 0L;
                private final ExprCode ev$1;
                private final String patternClass$1;
                private final String escapeFunc$1;
                private final String pattern$1;
                private final String rightStr$1;

                public final String apply(String eval1, String eval2) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          String ", " = ", ".toString();\n          ", " ", " = ", ".compile(", "(", "));\n          ", " = ", ".matcher(", ".toString()).matches();\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rightStr$1, eval2, this.patternClass$1, this.pattern$1, this.patternClass$1, this.escapeFunc$1, this.rightStr$1, this.ev$1.value(), this.pattern$1, eval1}));
                }
                {
                    this.ev$1 = ev$1;
                    this.patternClass$1 = patternClass$1;
                    this.escapeFunc$1 = escapeFunc$1;
                    this.pattern$1 = pattern$1;
                    this.rightStr$1 = rightStr$1;
                }
            });
        }
        return exprCode;
    }

    public Like copy(Expression left, Expression right) {
        return new Like(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

