/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the size of an array or a map.\n    The function returns -1 if its input is null and spark.sql.legacy.sizeOfNull is set to true.\n    If spark.sql.legacy.sizeOfNull is set to false, the function returns null for null input.\n    By default, the spark.sql.legacy.sizeOfNull parameter is set to true.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'));\n       4\n      > SELECT _FUNC_(map('a', 1, 'b', 2));\n       2\n      > SELECT _FUNC_(NULL);\n       -1\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001>\u0011AaU5{K*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002\u0012+%\u0011aC\u0001\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"a\u0002)s_\u0012,8\r\u001e\t\u00031yI!aH\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0005\u0002!Q3A\u0005\u0002\t\nQa\u00195jY\u0012,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0019\u0019\u0007.\u001b7eA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!&\u0001\tmK\u001e\f7-_*ju\u0016|eMT;mYV\t1\u0006\u0005\u0002\u0019Y%\u0011Q&\u0007\u0002\b\u0005>|G.Z1o\u0011!y\u0003A!E!\u0002\u0013Y\u0013!\u00057fO\u0006\u001c\u0017pU5{K>3g*\u001e7mA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"2a\r\u001b6!\t\t\u0002\u0001C\u0003\"a\u0001\u00071\u0005C\u0003*a\u0001\u00071\u0006C\u00032\u0001\u0011\u0005q\u0007\u0006\u00024q!)\u0011E\u000ea\u0001G!)!\b\u0001C!w\u0005AA-\u0019;b)f\u0004X-F\u0001=!\ti\u0004)D\u0001?\u0015\tyd!A\u0003usB,7/\u0003\u0002B}\tAA)\u0019;b)f\u0004X\rC\u0003D\u0001\u0011\u0005C)\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0012\t\u0004\r:\u000bfBA$M\u001d\tA5*D\u0001J\u0015\tQe\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011Q*G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005KA\u0002TKFT!!T\r\u0011\u0005u\u0012\u0016BA*?\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003V\u0001\u0011\u0005#&\u0001\u0005ok2d\u0017M\u00197f\u0011\u00159\u0006\u0001\"\u0011Y\u0003\u0011)g/\u00197\u0015\u0005ec\u0006C\u0001\r[\u0013\tY\u0016DA\u0002B]fDq!\u0018,\u0011\u0002\u0003\u0007a,A\u0003j]B,H\u000f\u0005\u0002`A6\tA!\u0003\u0002b\t\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003%!wnR3o\u0007>$W\rF\u0002fWB\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0002\u0002\u000f\r|G-Z4f]&\u0011!n\u001a\u0002\t\u000bb\u0004(oQ8eK\")AN\u0019a\u0001[\u0006\u00191\r\u001e=\u0011\u0005\u0019t\u0017BA8h\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ!\u001d2A\u0002\u0015\f!!\u001a<\t\u000fM\u0004\u0011\u0011!C\u0001i\u0006!1m\u001c9z)\r\u0019TO\u001e\u0005\bCI\u0004\n\u00111\u0001$\u0011\u001dI#\u000f%AA\u0002-Bq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u00110\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iT#aI>,\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007I\u0012AC1o]>$\u0018\r^5p]&\u0019\u0011q\u0001@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\f\u0001\t\n\u0011\"\u0001\u0002\u000e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\bU\tY3\u0010C\u0005\u0002\u0014\u0001\t\t\u0011\"\u0011\u0002\u0016\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005!A.\u00198h\u0015\t\t\t#\u0001\u0003kCZ\f\u0017\u0002BA\u0013\u00037\u0011aa\u0015;sS:<\u0007\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0003E\u0002\u0019\u0003_I1!!\r\u001a\u0005\rIe\u000e\u001e\u0005\n\u0003k\u0001\u0011\u0011!C\u0001\u0003o\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002Z\u0003sA!\"a\u000f\u00024\u0005\u0005\t\u0019AA\u0017\u0003\rAH%\r\u0005\n\u0003\u007f\u0001\u0011\u0011!C!\u0003\u0003\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0007\u0002R!!\u0012\u0002Lek!!a\u0012\u000b\u0007\u0005%\u0013$\u0001\u0006d_2dWm\u0019;j_:LA!!\u0014\u0002H\tA\u0011\n^3sCR|'\u000fC\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T\u0005A1-\u00198FcV\fG\u000eF\u0002,\u0003+B\u0011\"a\u000f\u0002P\u0005\u0005\t\u0019A-\t\u0013\u0005e\u0003!!A\u0005B\u0005m\u0013AB3rk\u0006d7\u000fF\u0002,\u0003;B\u0011\"a\u000f\u0002X\u0005\u0005\t\u0019A-)\u0017\u0001\t\t'a\u001a\u0002j\u00055\u0014q\u000e\t\u0004#\u0005\r\u0014bAA3\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA6\u0003\t5%\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!g&TX\rI8gA\u0005t\u0007%\u0019:sCf\u0004sN\u001d\u0011bA5\f\u0007O\f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002\u0012X\r^;s]N\u0004S&\r\u0011jM\u0002JGo\u001d\u0011j]B,H\u000fI5tA9,H\u000e\u001c\u0011b]\u0012\u00043\u000f]1sW:\u001a\u0018\u000f\u001c\u0018mK\u001e\f7-\u001f\u0018tSj,wJ\u001a(vY2\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011ueV,gF\u0003\u0011!A\u0001Je\rI:qCJ\\gf]9m]1,w-Y2z]ML'0Z(g\u001dVdG\u000eI5tAM,G\u000f\t;pA\u0019\fGn]3-AQDW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9,H\u000e\u001c\u0011g_J\u0004c.\u001e7mA%t\u0007/\u001e;/\u0015\u0001\u0002\u0003\u0005\t\"zA\u0011,g-Y;mi2\u0002C\u000f[3!gB\f'o\u001b\u0018tc2tC.Z4bGft3/\u001b>f\u001f\u001atU\u000f\u001c7!a\u0006\u0014\u0018-\\3uKJ\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011ueV,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA9\u0003\u0005E#\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bf\n2(Y\u0001:Cm\n\u0017!O\r<C\u0006I\u0014bO%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\f\u0007\u000fK\u0014bO1\u0002\u0013\u0007\f\u0011(E\u001eb\u0003EM\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b(V\u00192K3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00172\u0015\u0001\u0002saBA;\u0005!\u0005\u0011qO\u0001\u0005'&TX\rE\u0002\u0012\u0003s2a!\u0001\u0002\t\u0002\u0005m4#BA=\u0003{j\u0002c\u0001\r\u0002\u0000%\u0019\u0011\u0011Q\r\u0003\r\u0005s\u0017PU3g\u0011\u001d\t\u0014\u0011\u0010C\u0001\u0003\u000b#\"!a\u001e\t\u0011\u0005%\u0015\u0011\u0010C\u0001\u0003\u0017\u000bQ!\u00199qYf$2aMAG\u0011\u0019\t\u0013q\u0011a\u0001G!Q\u0011\u0011RA=\u0003\u0003%\t)!%\u0015\u000bM\n\u0019*!&\t\r\u0005\ny\t1\u0001$\u0011\u0019I\u0013q\u0012a\u0001W!Q\u0011\u0011TA=\u0003\u0003%\t)a'\u0002\u000fUt\u0017\r\u001d9msR!\u0011QTAU!\u0015A\u0012qTAR\u0013\r\t\t+\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\t)kI\u0016\n\u0007\u0005\u001d\u0016D\u0001\u0004UkBdWM\r\u0005\n\u0003W\u000b9*!AA\u0002M\n1\u0001\u001f\u00131\u0011)\ty+!\u001f\u0002\u0002\u0013%\u0011\u0011W\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00024B!\u0011\u0011DA[\u0013\u0011\t9,a\u0007\u0003\r=\u0013'.Z2u\u0001")
public class Size
extends UnaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression child;
    private final boolean legacySizeOfNull;

    public static Option<Tuple2<Expression, Object>> unapply(Size size) {
        return Size$.MODULE$.unapply(size);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean legacySizeOfNull() {
        return this.legacySizeOfNull;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$}))}));
    }

    @Override
    public boolean nullable() {
        return this.legacySizeOfNull() ? false : super.nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        DataType dataType2;
        block7: {
            Integer n;
            block4: {
                Integer n2;
                block6: {
                    Object value2;
                    block5: {
                        block3: {
                            value2 = this.child().eval(input);
                            if (value2 != null) break block3;
                            n = this.legacySizeOfNull() ? BoxesRunTime.boxToInteger((int)-1) : null;
                            break block4;
                        }
                        dataType2 = this.child().dataType();
                        if (!(dataType2 instanceof ArrayType)) break block5;
                        n2 = BoxesRunTime.boxToInteger((int)((ArrayData)value2).numElements());
                        break block6;
                    }
                    if (!(dataType2 instanceof MapType)) break block7;
                    n2 = BoxesRunTime.boxToInteger((int)((MapData)value2).numElements());
                }
                n = n2;
            }
            return n;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The size function doesn't support the operand type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType2.getClass().getCanonicalName()})));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        if (this.legacySizeOfNull()) {
            ExprCode childGen = this.child().genCode(ctx);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = false;\n      ", "\n      ", " ", " = ", " ? -1 :\n        (", ").numElements();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), childGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), childGen.isNull(), childGen.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String c) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ").numElements()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c}));
                }
            });
        }
        return exprCode;
    }

    public Size copy(Expression child, boolean legacySizeOfNull) {
        return new Size(child, legacySizeOfNull);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.legacySizeOfNull();
    }

    @Override
    public String productPrefix() {
        return "Size";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.legacySizeOfNull());
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Size)) return false;
        boolean bl = true;
        if (!bl) return false;
        Size size = (Size)x$1;
        Expression expression = this.child();
        Expression expression2 = size.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.legacySizeOfNull() != size.legacySizeOfNull()) return false;
        if (!size.canEqual(this)) return false;
        return true;
    }

    public Size(Expression child, boolean legacySizeOfNull) {
        this.child = child;
        this.legacySizeOfNull = legacySizeOfNull;
        ExpectsInputTypes$class.$init$(this);
    }

    public Size(Expression child) {
        this(child, SQLConf$.MODULE$.get().legacySizeOfNull());
    }
}

