/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011!9\u0005A!f\u0001\n\u0003\u0001\u0005\u0002\u0003%\u0001\u0005#\u0005\u000b\u0011B!\t\u000b%\u0003A\u0011\u0001&\t\u000b%\u0003A\u0011A(\t\u000bI\u0003A\u0011I*\t\u000bu\u0003A\u0011\t0\t\u000b1\u0004A\u0011I7\t\u000bQ\u0004A\u0011I;\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u00111\u0002\u0001\u0005B\u00055\u0001\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0011%\tI\u0003AI\u0001\n\u0003\tY\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002,!I\u00111\t\u0001\u0012\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003\u000b\u0002\u0011\u0011!C!\u0003\u000fB\u0011\"a\u0016\u0001\u0003\u0003%\t!!\u0017\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\tI\bAA\u0001\n\u0003\tY\bC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\u001eI\u0011QU\u0011\u0002\u0002#\u0005\u0011q\u0015\u0004\tA\u0005\n\t\u0011#\u0001\u0002*\"1\u0011J\u0007C\u0001\u0003oC\u0011\"!/\u001b\u0003\u0003%)%a/\t\u0013\u0005u&$!A\u0005\u0002\u0006}\u0006\"CAd5\u0005\u0005I\u0011QAe\u0011%\tYNGA\u0001\n\u0013\tiNA\u0007TiJLgn\u001a*fa2\f7-\u001a\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M)\u0001aL\u001a7yA\u0011\u0001'M\u0007\u0002C%\u0011!'\t\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00195\u0013\t)\u0014E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0001&o\u001c3vGR\u0004\"aN\u001f\n\u0005yB$\u0001D*fe&\fG.\u001b>bE2,\u0017aB:sG\u0016C\bO]\u000b\u0002\u0003B\u0011\u0001GQ\u0005\u0003\u0007\u0006\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003!\u0019(oY#yaJ\u0004\u0013AC:fCJ\u001c\u0007.\u0012=qe\u0006Y1/Z1sG\",\u0005\u0010\u001d:!\u0003-\u0011X\r\u001d7bG\u0016,\u0005\u0010\u001d:\u0002\u0019I,\u0007\u000f\\1dK\u0016C\bO\u001d\u0011\u0002\rqJg.\u001b;?)\u0011YE*\u0014(\u0011\u0005A\u0002\u0001\"B \b\u0001\u0004\t\u0005\"B#\b\u0001\u0004\t\u0005\"B$\b\u0001\u0004\tEcA&Q#\")q\b\u0003a\u0001\u0003\")Q\t\u0003a\u0001\u0003\u0006aa.\u001e7m'\u00064W-\u0012<bYR!AkV-\\!\t9T+\u0003\u0002Wq\t\u0019\u0011I\\=\t\u000baK\u0001\u0019\u0001+\u0002\u000fM\u00148-\u0012<bY\")!,\u0003a\u0001)\u0006Q1/Z1sG\",e/\u00197\t\u000bqK\u0001\u0019\u0001+\u0002\u0017I,\u0007\u000f\\1dK\u00163\u0018\r\\\u0001\nI><UM\\\"pI\u0016$2aX3k!\t\u00017-D\u0001b\u0015\t\u0011\u0017%A\u0004d_\u0012,w-\u001a8\n\u0005\u0011\f'\u0001C#yaJ\u001cu\u000eZ3\t\u000b\u0019T\u0001\u0019A4\u0002\u0007\r$\b\u0010\u0005\u0002aQ&\u0011\u0011.\u0019\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015Y'\u00021\u0001`\u0003\t)g/\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0007CA8s\u001b\u0005\u0001(BA9&\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\bO\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002mB\u0019qo 8\u000f\u0005alhBA=}\u001b\u0005Q(BA>.\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002\u007fq\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u00111aU3r\u0015\tq\b(\u0001\u0005dQ&dGM]3o+\t\tI\u0001E\u0002x\u007f\u0006\u000b!\u0002\u001d:fiRLh*Y7f+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003+\u0001\"!\u001f\u001d\n\u0007\u0005]\u0001(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/A\u0014\u0001B2paf$raSA\u0012\u0003K\t9\u0003C\u0004@\u001fA\u0005\t\u0019A!\t\u000f\u0015{\u0001\u0013!a\u0001\u0003\"9qi\u0004I\u0001\u0002\u0004\t\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003[Q3!QA\u0018W\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001eq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0007\u0002N\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\f\t\u0004o\u0005u\u0013bAA0q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A+!\u001a\t\u0013\u0005\u001dT#!AA\u0002\u0005m\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002nA)\u0011qNA;)6\u0011\u0011\u0011\u000f\u0006\u0004\u0003gB\u0014AC2pY2,7\r^5p]&!\u0011qOA9\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00141\u0011\t\u0004o\u0005}\u0014bAAAq\t9!i\\8mK\u0006t\u0007\u0002CA4/\u0005\u0005\t\u0019\u0001+\u0002\r\u0015\fX/\u00197t)\u0011\ti(!#\t\u0011\u0005\u001d\u0004$!AA\u0002QCs\u0002AAG\u0003'\u000b)*!'\u0002\u001c\u0006}\u0015\u0011\u0015\t\u0004a\u0005=\u0015bAAIC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAL\u0003U{f)\u0016(D?\"\u001aHO\u001d\u0017!g\u0016\f'o\u00195\\Y\u0001\u0012X\r\u001d7bG\u0016l\u0016\u0006I\u0017!%\u0016\u0004H.Y2fg\u0002\nG\u000e\u001c\u0011pG\u000e,(O]3oG\u0016\u001c\be\u001c4!AN,\u0017M]2iA\u0002:\u0018\u000e\u001e5!AJ,\u0007\u000f\\1dK\u0002t\u0013!C1sOVlWM\u001c;tC\t\ti*\u0001B9\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aX-\u0019:dQ\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:t\u0003%\u00134!AN,\u0017M]2iA\u0002J7\u000f\t8pi\u00022w.\u001e8eA%t\u0007\u0005Y:ue\u0002d\u0003\u0005Y:ue\u0002\u0004\u0013n\u001d\u0011sKR,(O\\3eAUt7\r[1oO\u0016$gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sKBd\u0017mY3![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o]\u0001Je\r\t1sKBd\u0017mY3aA%\u001c\bE\\8uAM\u0004XmY5gS\u0016$\u0007e\u001c:!SN\u0004\u0013M\u001c\u0011f[B$\u0018\u0010I:ue&tw\r\f\u0011o_RD\u0017N\\4!e\u0016\u0004H.Y2fg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;iK\u0002\u001aHO]5oO\u0002\"\b.\u0019;!SN\u0004#/Z7pm\u0016$\u0007E\u001a:p[\u0002\u00027\u000f\u001e:a])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019+\u0001(\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n%iQ1cG\u001eb\u0003eJ1cG\u001eb\u0003e\n#F\r\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!C\u0007\u0012+eI\u0003\u0011!\u00035\u0019FO]5oOJ+\u0007\u000f\\1dKB\u0011\u0001GG\n\u00055\u0005-F\b\u0005\u0005\u0002.\u0006M\u0016)Q!L\u001b\t\tyKC\u0002\u00022b\nqA];oi&lW-\u0003\u0003\u00026\u0006=&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011qU\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011J\u0001\u0006CB\u0004H.\u001f\u000b\b\u0017\u0006\u0005\u00171YAc\u0011\u0015yT\u00041\u0001B\u0011\u0015)U\u00041\u0001B\u0011\u00159U\u00041\u0001B\u0003\u001d)h.\u00199qYf$B!a3\u0002XB)q'!4\u0002R&\u0019\u0011q\u001a\u001d\u0003\r=\u0003H/[8o!\u00199\u00141[!B\u0003&\u0019\u0011Q\u001b\u001d\u0003\rQ+\b\u000f\\34\u0011!\tINHA\u0001\u0002\u0004Y\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u000e\u0005\u0003\u0002L\u0005\u0005\u0018\u0002BAr\u0003\u001b\u0012aa\u00142kK\u000e$\b")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace stringReplace) {
        return StringReplace$.MODULE$.unapply(stringReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return ((UTF8String)srcEval).replace((UTF8String)searchEval, (UTF8String)replaceEval);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(src, search, replace) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)src).append(".replace(").append((String)search).append(", ").append((String)replace).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.srcExpr();
        Expression expression2 = this.searchExpr();
        Expression expression3 = this.replaceExpr();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.srcExpr();
                break;
            }
            case 1: {
                expression = this.searchExpr();
                break;
            }
            case 2: {
                expression = this.replaceExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

