/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LengthOfJsonArray$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonArray) - Returns the number of elements in the outmost JSON array.", arguments="\n    Arguments:\n      * jsonArray - A JSON array. `NULL` is returned in case of any other valid JSON string,\n          `NULL` or an invalid JSON.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('[1,2,3,4]');\n        4\n      > SELECT _FUNC_('[1,2,3,{\"f1\":1,\"f2\":[5,6]},4]');\n        5\n      > SELECT _FUNC_('[1,2');\n        NULL\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\r\u001b\u0001\u001eB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\")A\t\u0001C\u0001\u000b\")\u0001\n\u0001C!\u0013\")A\f\u0001C!;\")a\f\u0001C!?\")1\r\u0001C!I\")Q\u000e\u0001C!]\")\u0001\u0010\u0001C\u0005s\"I\u00111\u0003\u0001\u0002\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u00033\u0001\u0011\u0013!C\u0001\u00037A\u0011\"!\r\u0001\u0003\u0003%\t%a\r\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA'\u0001\u0005\u0005I\u0011AA(\u0011%\t)\u0006AA\u0001\n\u0003\n9\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0001\u0002h!I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0013QN\u0004\n\u0003/S\u0012\u0011!E\u0001\u000333\u0001\"\u0007\u000e\u0002\u0002#\u0005\u00111\u0014\u0005\u0007\tN!\t!!+\t\u0013\u0005-6#!A\u0005F\u00055\u0006\"CAX'\u0005\u0005I\u0011QAY\u0011%\t)lEA\u0001\n\u0003\u000b9\fC\u0005\u0002DN\t\t\u0011\"\u0003\u0002F\n\tB*\u001a8hi\"|eMS:p]\u0006\u0013(/Y=\u000b\u0005ma\u0012aC3yaJ,7o]5p]NT!!\b\u0010\u0002\u0011\r\fG/\u00197zgRT!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u0015-eUZ\u0004CA\u0015+\u001b\u0005Q\u0012BA\u0016\u001b\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00171\u001b\u0005q#BA\u0018\u001b\u0003\u001d\u0019w\u000eZ3hK:L!!\r\u0018\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"!K\u001a\n\u0005QR\"!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t9\u0001K]8ek\u000e$\bC\u0001\u001c=\u0013\titG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001A!\tI\u0013)\u0003\u0002C5\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011ai\u0012\t\u0003S\u0001AQAP\u0002A\u0002\u0001\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005Q\u0005cA&T-:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u001a\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005I;\u0014a\u00029bG.\fw-Z\u0005\u0003)V\u00131aU3r\u0015\t\u0011v\u0007\u0005\u0002X56\t\u0001L\u0003\u0002Z=\u0005)A/\u001f9fg&\u00111\f\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001W\u0003!qW\u000f\u001c7bE2,W#\u00011\u0011\u0005Y\n\u0017B\u000128\u0005\u001d\u0011un\u001c7fC:\f!\u0002\u001d:fiRLh*Y7f+\u0005)\u0007C\u00014k\u001d\t9\u0007\u000e\u0005\u0002No%\u0011\u0011nN\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002jo\u0005!QM^1m)\ty'\u000f\u0005\u00027a&\u0011\u0011o\u000e\u0002\u0004\u0003:L\bbB:\t!\u0003\u0005\r\u0001^\u0001\u0006S:\u0004X\u000f\u001e\t\u0003kZl\u0011\u0001H\u0005\u0003or\u00111\"\u00138uKJt\u0017\r\u001c*po\u0006a\u0001/\u0019:tK\u000e{WO\u001c;feR!qN_A\t\u0011\u0015Y\u0018\u00021\u0001}\u0003\u0019\u0001\u0018M]:feB\u0019Q0!\u0004\u000e\u0003yT1a`A\u0001\u0003\u0011\u0019wN]3\u000b\t\u0005\r\u0011QA\u0001\bU\u0006\u001c7n]8o\u0015\u0011\t9!!\u0003\u0002\u0013\u0019\f7\u000f^3sq6d'BAA\u0006\u0003\r\u0019w.\\\u0005\u0004\u0003\u001fq(A\u0003&t_:\u0004\u0016M]:fe\")1/\u0003a\u0001i\u0006!1m\u001c9z)\r1\u0015q\u0003\u0005\b})\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\b+\u0007\u0001\u000byb\u000b\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!C;oG\",7m[3e\u0015\r\tYcN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003K\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0012\u0001\u00026bm\u0006L1a[A\u001d\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u0005E\u00027\u0003\u0013J1!a\u00138\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ry\u0017\u0011\u000b\u0005\n\u0003'r\u0011\u0011!a\u0001\u0003\u000f\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA-!\u0015\tY&!\u0019p\u001b\t\tiFC\u0002\u0002`]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019'!\u0018\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004A\u0006%\u0004\u0002CA*!\u0005\u0005\t\u0019A8\u0002\r\u0015\fX/\u00197t)\r\u0001\u0017q\u000e\u0005\t\u0003'\n\u0012\u0011!a\u0001_\":\u0002!a\u001d\u0002z\u0005m\u0014qPAA\u0003\u000b\u000b9)a#\u0002\u000e\u0006E\u00151\u0013\t\u0004S\u0005U\u0014bAA<5\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA?\u00035{f)\u0016(D?\"R7o\u001c8BeJ\f\u00170\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002*G.Z7f]R\u001c\b%\u001b8!i\",\u0007e\\;u[>\u001cH\u000f\t&T\u001f:\u0003\u0013M\u001d:bs:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\r\u0015!!\u000b\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001R7o\u001c8BeJ\f\u0017\u0010I\u0017!\u0003\u0002R5k\u0014(!CJ\u0014\u0018-\u001f\u0018!A:+F\n\u00141!SN\u0004#/\u001a;ve:,G\rI5oA\r\f7/\u001a\u0011pM\u0002\ng.\u001f\u0011pi\",'\u000f\t<bY&$\u0007ES*P\u001d\u0002\u001aHO]5oO2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011a\u001dVcE\n\u0019\u0011pe\u0002\ng\u000eI5om\u0006d\u0017\u000e\u001a\u0011K'>seF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAE\u0003\u0005m#\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014\\c1\u0012Df\r\u00175;\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u00115\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3,\r\u00173YMb3P\t42Ei\nDF\t43EiZV\u0007\f\u001c^{2\"TlJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001*$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014\\c1\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\u0012\u0011qR\u0001\u000bUN|gn\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAK\u0003\u0015\u0019d&\r\u00181\u0003EaUM\\4uQ>3'j]8o\u0003J\u0014\u0018-\u001f\t\u0003SM\u0019BaEAOwA1\u0011qTAS\u0001\u001ak!!!)\u000b\u0007\u0005\rv'A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0016\u0011\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAAM\u0003!!xn\u0015;sS:<GCAA\u001b\u0003\u0015\t\u0007\u000f\u001d7z)\r1\u00151\u0017\u0005\u0006}Y\u0001\r\u0001Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI,a0\u0011\tY\nY\fQ\u0005\u0004\u0003{;$AB(qi&|g\u000e\u0003\u0005\u0002B^\t\t\u00111\u0001G\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002HB!\u0011qGAe\u0013\u0011\tY-!\u000f\u0003\r=\u0013'.Z2u\u0001")
public class LengthOfJsonArray
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(LengthOfJsonArray lengthOfJsonArray) {
        return LengthOfJsonArray$.MODULE$.unapply(lengthOfJsonArray);
    }

    public static <A> Function1<Expression, A> andThen(Function1<LengthOfJsonArray, A> function1) {
        return LengthOfJsonArray$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, LengthOfJsonArray> compose(Function1<A, Expression> function1) {
        return LengthOfJsonArray$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_array_length";
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object object2 = new Object();
        try {
            UTF8String json = (UTF8String)this.child().eval(input);
            if (json == null) {
                return null;
            }
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable & scala.Serializable)parser -> {
                    if (parser.nextToken() == null) {
                        throw new NonLocalReturnControl(object2, null);
                    }
                    return this.parseCounter((JsonParser)parser, input);
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof IOException;
                if (!bl) {
                    throw throwable;
                }
                Object var2_7 = null;
                object = var2_7;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object parseCounter(JsonParser parser, InternalRow input) {
        int length = 0;
        JsonToken jsonToken = parser.currentToken();
        JsonToken jsonToken2 = JsonToken.START_ARRAY;
        if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
            return null;
        }
        while (true) {
            JsonToken jsonToken3 = parser.nextToken();
            JsonToken jsonToken4 = JsonToken.END_ARRAY;
            if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
            ++length;
            parser.skipChildren();
        }
        return BoxesRunTime.boxToInteger((int)length);
    }

    public LengthOfJsonArray copy(Expression child) {
        return new LengthOfJsonArray(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "LengthOfJsonArray";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LengthOfJsonArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LengthOfJsonArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        LengthOfJsonArray lengthOfJsonArray = (LengthOfJsonArray)x$1;
        Expression expression = this.child();
        Expression expression2 = lengthOfJsonArray.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!lengthOfJsonArray.canEqual(this)) return false;
        return true;
    }

    public LengthOfJsonArray(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

