/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SecondsToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(seconds) - Creates timestamp from the number of seconds (can be fractional) since UTC epoch.", examples="\n    Examples:\n      > SELECT _FUNC_(1230219000);\n       2008-12-25 07:30:00\n      > SELECT _FUNC_(1230219000.123);\n       2008-12-25 07:30:00.123\n  ", group="datetime_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\")a\t\u0001C\u0001\u000f\")!\n\u0001C!\u0017\")Q\f\u0001C!=\")!\r\u0001C!G\"Aq\r\u0001EC\u0002\u0013%\u0001\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u0013\u0005\u0005\u0002!!A\u0005\u0002\u0005\r\u0002\"CA\u0014\u0001E\u0005I\u0011AA\u0015\u0011%\ty\u0004AA\u0001\n\u0003\n\t\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003G\u0002\u0011\u0011!C!\u0003KB\u0011\"a\u001d\u0001\u0003\u0003%\t!!\u001e\t\u0013\u0005e\u0004!!A\u0005B\u0005mt!CAP7\u0005\u0005\t\u0012AAQ\r!Q2$!A\t\u0002\u0005\r\u0006B\u0002$\u0015\t\u0003\t\t\fC\u0005\u00024R\t\t\u0011\"\u0012\u00026\"I\u0011q\u0017\u000b\u0002\u0002\u0013\u0005\u0015\u0011\u0018\u0005\n\u0003{#\u0012\u0011!CA\u0003\u007fC\u0011\"a3\u0015\u0003\u0003%I!!4\u0003%M+7m\u001c8egR{G+[7fgR\fW\u000e\u001d\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M1\u0001!K\u00171ou\u0002\"AK\u0016\u000e\u0003mI!\u0001L\u000e\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\u000b\u0018\n\u0005=Z\"!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0011\u0007\u000e\b\u0003UIJ!aM\u000e\u0002\u000fA\f7m[1hK&\u0011QG\u000e\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t\u00194\u0004\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005ar\u0014BA :\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005\u0011\u0005C\u0001\u0016D\u0013\t!5D\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002I\u0013B\u0011!\u0006\u0001\u0005\u0006\u0001\u000e\u0001\rAQ\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001'\u0011\u00075#vK\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011kJ\u0001\u0007yI|w\u000e\u001e \n\u0003iJ!aM\u001d\n\u0005U3&aA*fc*\u00111'\u000f\t\u00031nk\u0011!\u0017\u0006\u00035~\tQ\u0001^=qKNL!\u0001X-\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003}\u0003\"\u0001\u00171\n\u0005\u0005L&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\u0012\u0001\u001a\t\u0003q\u0015L!AZ\u001d\u0003\u000f\t{w\u000e\\3b]\u0006AQM^1m\rVt7-F\u0001j!\u0011A$\u000e\u001c7\n\u0005-L$!\u0003$v]\u000e$\u0018n\u001c82!\tAT.\u0003\u0002os\t\u0019\u0011I\\=)\u0005\u001d\u0001\bC\u0001\u001dr\u0013\t\u0011\u0018HA\u0005ue\u0006t7/[3oi\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011A.\u001e\u0005\u0006m\"\u0001\r\u0001\\\u0001\u0006S:\u0004X\u000f^\u0001\nI><UM\\\"pI\u0016$B!_@\u0002\nA\u0011!0`\u0007\u0002w*\u0011ApG\u0001\bG>$WmZ3o\u0013\tq8P\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\t!\u0003a\u0001\u0003\u0007\t1a\u0019;y!\rQ\u0018QA\u0005\u0004\u0003\u000fY(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u0017I\u0001\u0019A=\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tYB\u0004\u0003\u0002\u0016\u0005]\u0001CA(:\u0013\r\tI\"O\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0011q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e\u0011(\u0001\u0003d_BLHc\u0001%\u0002&!9\u0001i\u0003I\u0001\u0002\u0004\u0011\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003WQ3AQA\u0017W\t\ty\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001ds\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00121\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00027b]\u001eT!!!\u0014\u0002\t)\fg/Y\u0005\u0005\u0003;\t9%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002VA\u0019\u0001(a\u0016\n\u0007\u0005e\u0013HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002m\u0003?B\u0011\"!\u0019\u0010\u0003\u0003\u0005\r!!\u0016\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0007E\u0003\u0002j\u0005=D.\u0004\u0002\u0002l)\u0019\u0011QN\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002r\u0005-$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001ZA<\u0011!\t\t'EA\u0001\u0002\u0004a\u0017AB3rk\u0006d7\u000fF\u0002e\u0003{B\u0001\"!\u0019\u0013\u0003\u0003\u0005\r\u0001\u001c\u0015\u0014\u0001\u0005\u0005\u0015qQAE\u0003\u001b\u000by)a%\u0002\u0016\u0006e\u00151\u0014\t\u0004U\u0005\r\u0015bAAC7\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAF\u0003\r|f)\u0016(D?\"\u001aXmY8oINL\u0003%\f\u0011De\u0016\fG/Z:!i&lWm\u001d;b[B\u0004cM]8nAQDW\r\t8v[\n,'\u000fI8gAM,7m\u001c8eg\u0002B3-\u00198!E\u0016\u0004cM]1di&|g.\u00197*AMLgnY3!+R\u001b\u0005%\u001a9pG\"t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0015!a\u000b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QE\u00124\u0007\r\u001a2sA\u0002\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\u0002\u0004(L\u00193[I*\u0004\u0005M\u001c;gAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cI\u001a\u0004GM\u0019:aA\u0002d&\r\u001a4SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007\r\u00199[E\u0012TFM\u001b!a]R4\u0007\r\u001e1a9\n$g\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011qS\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\ti*A\u00034]Er\u0003'\u0001\nTK\u000e|g\u000eZ:U_RKW.Z:uC6\u0004\bC\u0001\u0016\u0015'\u0011!\u0012QU\u001f\u0011\r\u0005\u001d\u0016Q\u0016\"I\u001b\t\tIKC\u0002\u0002,f\nqA];oi&lW-\u0003\u0003\u00020\u0006%&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011\u0011U\u0001\ti>\u001cFO]5oOR\u0011\u00111I\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0011\u0006m\u0006\"\u0002!\u0018\u0001\u0004\u0011\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0003\f9\r\u0005\u00039\u0003\u0007\u0014\u0015bAAcs\t1q\n\u001d;j_:D\u0001\"!3\u0019\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a4\u0011\t\u0005\u0015\u0013\u0011[\u0005\u0005\u0003'\f9E\u0001\u0004PE*,7\r\u001e")
public class SecondsToTimestamp
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Object, Object> evalFunc;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(SecondsToTimestamp secondsToTimestamp) {
        return SecondsToTimestamp$.MODULE$.unapply(secondsToTimestamp);
    }

    public static <A> Function1<Expression, A> andThen(Function1<SecondsToTimestamp, A> function1) {
        return SecondsToTimestamp$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, SecondsToTimestamp> compose(Function1<A, Expression> function1) {
        return SecondsToTimestamp$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType$[]{NumericType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        DataType dataType = this.child().dataType();
        boolean bl = dataType instanceof FloatType ? true : dataType instanceof DoubleType;
        boolean bl2 = bl ? true : this.child().nullable();
        return bl2;
    }

    private Function1<Object, Object> evalFunc$lzycompute() {
        SecondsToTimestamp secondsToTimestamp = this;
        synchronized (secondsToTimestamp) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.child().dataType();
                if (dataType instanceof IntegralType) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToLong((long)SecondsToTimestamp.$anonfun$evalFunc$1(input));
                } else if (dataType instanceof DecimalType) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToLong((long)SecondsToTimestamp.$anonfun$evalFunc$2(input));
                } else if (dataType instanceof FloatType) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        float f = BoxesRunTime.unboxToFloat((Object)input);
                        return Predef$.MODULE$.float2Float(f).isNaN() || Predef$.MODULE$.float2Float(f).isInfinite() ? null : BoxesRunTime.boxToLong((long)((long)((double)f * (double)1000000L)));
                    };
                } else if (dataType instanceof DoubleType) {
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        double d = BoxesRunTime.unboxToDouble((Object)input);
                        return Predef$.MODULE$.double2Double(d).isNaN() || Predef$.MODULE$.double2Double(d).isInfinite() ? null : BoxesRunTime.boxToLong((long)((long)(d * (double)1000000L)));
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.evalFunc = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.evalFunc;
    }

    private Function1<Object, Object> evalFunc() {
        return !this.bitmap$trans$0 ? this.evalFunc$lzycompute() : this.evalFunc;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.evalFunc().apply(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.child().dataType();
        if (dataType instanceof IntegralType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(33).append("java.lang.Math.multiplyExact(").append((String)c).append(", ").append(1000000L).append("L)").toString());
        } else if (dataType instanceof DecimalType) {
            String operand = new StringBuilder(26).append("new java.math.BigDecimal(").append(1000000L).append(")").toString();
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(47).append((String)c).append(".toJavaBigDecimal().multiply(").append(operand).append(").longValueExact()").toString());
        } else {
            String castToDouble = dataType instanceof FloatType ? "(double)" : "";
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
                String typeStr = CodeGenerator$.MODULE$.boxedType(dataType);
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n           |if (").append(typeStr).append(".isNaN(").append((String)c).append(") || ").append(typeStr).append(".isInfinite(").append((String)c).append(")) {\n           |  ").append(ev.isNull()).append(" = true;\n           |} else {\n           |  ").append(ev.value()).append(" = (long)(").append(castToDouble).append((String)c).append(" * ").append(1000000L).append(");\n           |}\n           |").toString())).stripMargin();
            });
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "timestamp_seconds";
    }

    public SecondsToTimestamp copy(Expression child) {
        return new SecondsToTimestamp(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "SecondsToTimestamp";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SecondsToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SecondsToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        SecondsToTimestamp secondsToTimestamp = (SecondsToTimestamp)x$1;
        Expression expression = this.child();
        Expression expression2 = secondsToTimestamp.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!secondsToTimestamp.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$evalFunc$1(Object input) {
        return Math.multiplyExact(((Number)input).longValue(), 1000000L);
    }

    public static final /* synthetic */ long $anonfun$evalFunc$2(Object input) {
        BigDecimal operand = new BigDecimal(1000000L);
        return ((Decimal)input).toJavaBigDecimal().multiply(operand).longValueExact();
    }

    public SecondsToTimestamp(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

