/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(value, min_value, max_value, num_bucket) - Returns the bucket number to which\n      `value` would be assigned in an equiwidth histogram with `num_bucket` buckets,\n      in the range `min_value` to `max_value`.\"\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(5.3, 0.2, 10.6, 5);\n       3\n      > SELECT _FUNC_(-2.1, 1.3, 3.4, 3);\n       0\n      > SELECT _FUNC_(8.1, 0.0, 5.7, 4);\n       5\n      > SELECT _FUNC_(-0.9, 5.2, 0.5, 2);\n       3\n  ", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\tmq!B\u0012%\u0011\u0003\td!B\u001a%\u0011\u0003!\u0004\"\u0002 \u0002\t\u0003y\u0004\"\u0002!\u0002\t\u0003\t\u0005bB,\u0002\u0003\u0003%\t\t\u0017\u0005\n\u0003{\f\u0011\u0011!CA\u0003\u007fD\u0011B!\u0005\u0002\u0003\u0003%IAa\u0005\u0007\tM\"\u0003I\u0017\u0005\t\u0017\u001e\u0011)\u001a!C\u0001W\"Aqn\u0002B\tB\u0003%A\u000e\u0003\u0005q\u000f\tU\r\u0011\"\u0001l\u0011!\txA!E!\u0002\u0013a\u0007\u0002\u0003:\b\u0005+\u0007I\u0011A6\t\u0011M<!\u0011#Q\u0001\n1D\u0001\u0002V\u0004\u0003\u0016\u0004%\ta\u001b\u0005\ti\u001e\u0011\t\u0012)A\u0005Y\")ah\u0002C\u0001k\")!p\u0002C!w\"9\u0011qB\u0004\u0005B\u0005E\u0001bBA\u0011\u000f\u0011\u0005\u00131\u0005\u0005\b\u0003W9A\u0011IA\u0017\u0011\u001d\t)d\u0002C!\u0003oAq!!\u0013\b\t#\nY\u0005C\u0004\u0002^\u001d!\t%a\u0018\t\u0013\u0005mt!!A\u0005\u0002\u0005u\u0004\"CAD\u000fE\u0005I\u0011AAE\u0011%\tyjBI\u0001\n\u0003\tI\tC\u0005\u0002\"\u001e\t\n\u0011\"\u0001\u0002\n\"I\u00111U\u0004\u0012\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003K;\u0011\u0011!C!\u0003OC\u0011\"!,\b\u0003\u0003%\t!a,\t\u0013\u0005]v!!A\u0005\u0002\u0005e\u0006\"CA`\u000f\u0005\u0005I\u0011IAa\u0011%\tymBA\u0001\n\u0003\t\t\u000eC\u0005\u0002V\u001e\t\t\u0011\"\u0011\u0002X\u0006Yq+\u001b3uQ\n+8m[3u\u0015\t)c%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0014)\u0003!\u0019\u0017\r^1msN$(BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u0001\u0001C\u0001\u001a\u0002\u001b\u0005!#aC,jIRD')^2lKR\u001c2!A\u001b<!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fMB\u0011a\u0007P\u0005\u0003{]\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A\u0019\u0002'\r|W\u000e];uK\n+8m[3u\u001dVl'-\u001a:\u0015\u000b\tSu*U*\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001\u00027b]\u001eT\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\t\n!Aj\u001c8h\u0011\u0015Y5\u00011\u0001M\u0003\u00151\u0018\r\\;f!\t1T*\u0003\u0002Oo\t1Ai\\;cY\u0016DQ\u0001U\u0002A\u00021\u000b1!\\5o\u0011\u0015\u00116\u00011\u0001M\u0003\ri\u0017\r\u001f\u0005\u0006)\u000e\u0001\r!V\u0001\n]Vl')^2lKR\u0004\"A\u000e,\n\u0005%;\u0014!B1qa2LH#C-\u0002v\u0006]\u0018\u0011`A~!\t\u0011ta\u0005\u0004\b7z\u000b\u0007n\u000f\t\u0003eqK!!\u0018\u0013\u0003)E+\u0018\r^3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0011t,\u0003\u0002aI\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002cK:\u0011!gY\u0005\u0003I\u0012\nq\u0001]1dW\u0006<W-\u0003\u0002gO\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u00013%!\t1\u0014.\u0003\u0002ko\t9\u0001K]8ek\u000e$X#\u00017\u0011\u0005Ij\u0017B\u00018%\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007m\u0006dW/\u001a\u0011\u0002\u00115LgNV1mk\u0016\f\u0011\"\\5o-\u0006dW/\u001a\u0011\u0002\u00115\f\u0007PV1mk\u0016\f\u0011\"\\1y-\u0006dW/\u001a\u0011\u0002\u00159,XNQ;dW\u0016$\b\u0005F\u0003Zm^D\u0018\u0010C\u0003L!\u0001\u0007A\u000eC\u0003q!\u0001\u0007A\u000eC\u0003s!\u0001\u0007A\u000eC\u0003U!\u0001\u0007A.\u0001\u0005dQ&dGM]3o+\u0005a\b\u0003B?\u0002\n1t1A`A\u0004\u001d\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u00011\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002eo%!\u00111BA\u0007\u0005\r\u0019V-\u001d\u0006\u0003I^\n!\"\u001b8qkR$\u0016\u0010]3t+\t\t\u0019\u0002E\u0003~\u0003\u0013\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002K\u0001\u0006if\u0004Xm]\u0005\u0005\u0003?\tIB\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002&A!\u0011qCA\u0014\u0013\u0011\tI#!\u0007\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003_\u00012ANA\u0019\u0013\r\t\u0019d\u000e\u0002\b\u0005>|G.Z1o\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003s\u0001B!a\u000f\u0002D9!\u0011QHA !\tyx'C\u0002\u0002B]\na\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003\u000f\u0012aa\u0015;sS:<'bAA!o\u0005aa.\u001e7m'\u00064W-\u0012<bYRQ\u0011QJA*\u0003/\nI&a\u0017\u0011\u0007Y\ny%C\u0002\u0002R]\u00121!\u00118z\u0011\u001d\t)F\u0006a\u0001\u0003\u001b\nQ!\u001b8qkRDa\u0001\u0015\fA\u0002\u00055\u0003B\u0002*\u0017\u0001\u0004\ti\u0005\u0003\u0004U-\u0001\u0007\u0011QJ\u0001\nI><UM\\\"pI\u0016$b!!\u0019\u0002n\u0005]\u0004\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001dD%A\u0004d_\u0012,w-\u001a8\n\t\u0005-\u0014Q\r\u0002\t\u000bb\u0004(oQ8eK\"9\u0011qN\fA\u0002\u0005E\u0014aA2uqB!\u00111MA:\u0013\u0011\t)(!\u001a\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011P\fA\u0002\u0005\u0005\u0014AA3w\u0003\u0011\u0019w\u000e]=\u0015\u0013e\u000by(!!\u0002\u0004\u0006\u0015\u0005bB&\u0019!\u0003\u0005\r\u0001\u001c\u0005\bab\u0001\n\u00111\u0001m\u0011\u001d\u0011\b\u0004%AA\u00021Dq\u0001\u0016\r\u0011\u0002\u0003\u0007A.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-%f\u00017\u0002\u000e.\u0012\u0011q\u0012\t\u0005\u0003#\u000bY*\u0004\u0002\u0002\u0014*!\u0011QSAL\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001a^\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti*a%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002*B\u00191)a+\n\u0007\u0005\u0015C)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00022B\u0019a'a-\n\u0007\u0005UvGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002N\u0005m\u0006\"CA_?\u0005\u0005\t\u0019AAY\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0019\t\u0007\u0003\u000b\fY-!\u0014\u000e\u0005\u0005\u001d'bAAeo\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0017q\u0019\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00020\u0005M\u0007\"CA_C\u0005\u0005\t\u0019AA'\u0003\u0019)\u0017/^1mgR!\u0011qFAm\u0011%\tiLIA\u0001\u0002\u0004\ti\u0005K\b\b\u0003;\f\u0019/!:\u0002j\u0006-\u0018q^Ay!\r\u0011\u0014q\\\u0005\u0004\u0003C$#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003O\f\u00111\u0019\u0006!A\u0001\u0002sLR+O\u0007~Cc/\u00197vK2\u0002S.\u001b8`m\u0006dW/\u001a\u0017![\u0006DxL^1mk\u0016d\u0003E\\;n?\n,8m[3uS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u0012WoY6fi\u0002rW/\u001c2fe\u0002\"x\u000eI<iS\u000eD'\u0002\t\u0011!A\u0001\u0002\u0003M^1mk\u0016\u0004\u0007e^8vY\u0012\u0004#-\u001a\u0011bgNLwM\\3eA%t\u0007%\u00198!KF,\u0018n^5ei\"\u0004\u0003.[:u_\u001e\u0014\u0018-\u001c\u0011xSRD\u0007\u0005\u00198v[~\u0013WoY6fi\u0002\u0004#-^2lKR\u001cHF\u0003\u0011!A\u0001\u0002\u0003%\u001b8!i\",\u0007E]1oO\u0016\u0004\u0003-\\5o?Z\fG.^3aAQ|\u0007\u0005Y7bq~3\u0018\r\\;fA:\u0012#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!<\u0002\u0003sS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u000e\u00184Y\u0001\u0002dF\r\u0017!cArc\u0007\f\u00116SmR\u0001\u0005\t\u0011!A\u0001\u00023G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015.e9\nD\u0006I\u0019/g1\u00023G\f\u001b-AMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Qar\u0013\u0007\f\u00111]Ab\u0003%\u000e\u00188Y\u0001\"\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0003GL\u001d-AUr#\u0007\f\u00111]Ub\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003g\fQa\r\u00182]ABQa\u0013\u0003A\u00021DQ\u0001\u001d\u0003A\u00021DQA\u001d\u0003A\u00021DQ\u0001\u0016\u0003A\u00021\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0002\t5\u0001#\u0002\u001c\u0003\u0004\t\u001d\u0011b\u0001B\u0003o\t1q\n\u001d;j_:\u0004rA\u000eB\u0005Y2dG.C\u0002\u0003\f]\u0012a\u0001V;qY\u0016$\u0004\u0002\u0003B\b\u000b\u0005\u0005\t\u0019A-\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u000b!\r\u0019%qC\u0005\u0004\u00053!%AB(cU\u0016\u001cG\u000f")
public class WidthBucket
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression value;
    private final Expression minValue;
    private final Expression maxValue;
    private final Expression numBucket;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket widthBucket) {
        return WidthBucket$.MODULE$.unapply(widthBucket);
    }

    public static Long computeBucketNumber(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumber(d, d2, d3, l);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression value() {
        return this.value;
    }

    public Expression minValue() {
        return this.minValue;
    }

    public Expression maxValue() {
        return this.maxValue;
    }

    public Expression numBucket() {
        return this.numBucket;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.value(), this.minValue(), this.maxValue(), this.numBucket()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{DoubleType$.MODULE$, DoubleType$.MODULE$, DoubleType$.MODULE$, LongType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "width_bucket";
    }

    @Override
    public Object nullSafeEval(Object input, Object min, Object max, Object numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(BoxesRunTime.unboxToDouble((Object)input), BoxesRunTime.unboxToDouble((Object)min), BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToLong((Object)numBucket));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(input, min, max, numBucket) -> new StringBuilder(81).append("org.apache.spark.sql.catalyst.expressions.WidthBucket").append(".computeBucketNumber(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(")").toString());
    }

    public WidthBucket copy(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.minValue();
    }

    public Expression copy$default$3() {
        return this.maxValue();
    }

    public Expression copy$default$4() {
        return this.numBucket();
    }

    @Override
    public String productPrefix() {
        return "WidthBucket";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.value();
                break;
            }
            case 1: {
                expression = this.minValue();
                break;
            }
            case 2: {
                expression = this.maxValue();
                break;
            }
            case 3: {
                expression = this.numBucket();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WidthBucket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WidthBucket)) return false;
        boolean bl = true;
        if (!bl) return false;
        WidthBucket widthBucket = (WidthBucket)x$1;
        Expression expression = this.value();
        Expression expression2 = widthBucket.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.minValue();
        Expression expression4 = widthBucket.minValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxValue();
        Expression expression6 = widthBucket.maxValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.numBucket();
        Expression expression8 = widthBucket.numBucket();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!widthBucket.canEqual(this)) return false;
        return true;
    }

    public WidthBucket(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numBucket = numBucket;
        ExpectsInputTypes.$init$(this);
    }
}

