/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import org.apache.spark.sql.catalyst.WalkedTypePath;
import org.apache.spark.sql.catalyst.analysis.UnresolvedExtractValue;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UpCast;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.StructType;
import scala.Function2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;

public final class DeserializerBuildHelper$ {
    public static DeserializerBuildHelper$ MODULE$;

    static {
        new DeserializerBuildHelper$();
    }

    public Expression addToPath(Expression path, String part, DataType dataType, WalkedTypePath walkedTypePath) {
        UnresolvedExtractValue newPath = new UnresolvedExtractValue(path, Literal$.MODULE$.apply(part));
        return this.upCastToExpectedType(newPath, dataType, walkedTypePath);
    }

    public Expression addToPathOrdinal(Expression path, int ordinal, DataType dataType, WalkedTypePath walkedTypePath) {
        GetStructField newPath = new GetStructField(path, ordinal, GetStructField$.MODULE$.apply$default$3());
        return this.upCastToExpectedType(newPath, dataType, walkedTypePath);
    }

    public Expression deserializerForWithNullSafetyAndUpcast(Expression expr, DataType dataType, boolean nullable, WalkedTypePath walkedTypePath, Function2<Expression, WalkedTypePath, Expression> funcForCreatingDeserializer) {
        Expression casted = this.upCastToExpectedType(expr, dataType, walkedTypePath);
        return this.expressionWithNullSafety((Expression)funcForCreatingDeserializer.apply((Object)casted, (Object)walkedTypePath), nullable, walkedTypePath);
    }

    public Expression expressionWithNullSafety(Expression expr, boolean nullable, WalkedTypePath walkedTypePath) {
        return nullable ? expr : new AssertNotNull(expr, walkedTypePath.getPaths());
    }

    public Expression createDeserializerForTypesSupportValueOf(Expression path, Class<?> clazz) {
        Class<?> x$1 = clazz;
        ObjectType x$2 = new ObjectType(clazz);
        String x$3 = "valueOf";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        boolean x$6 = StaticInvoke$.MODULE$.apply$default$5();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
    }

    public Expression createDeserializerForString(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toString";
        ObjectType x$3 = new ObjectType(String.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        boolean x$6 = Invoke$.MODULE$.apply$default$5();
        return new Invoke(x$1, x$2, x$3, x$5, x$6, x$4);
    }

    public Expression createDeserializerForSqlDate(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Date.class);
        String x$3 = "toJavaDate";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        boolean x$6 = StaticInvoke$.MODULE$.apply$default$5();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
    }

    public Expression createDeserializerForLocalDate(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(LocalDate.class);
        String x$3 = "daysToLocalDate";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        boolean x$6 = StaticInvoke$.MODULE$.apply$default$5();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
    }

    public Expression createDeserializerForInstant(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Instant.class);
        String x$3 = "microsToInstant";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        boolean x$6 = StaticInvoke$.MODULE$.apply$default$5();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
    }

    public Expression createDeserializerForSqlTimestamp(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Timestamp.class);
        String x$3 = "toJavaTimestamp";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        boolean x$6 = StaticInvoke$.MODULE$.apply$default$5();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
    }

    public Expression createDeserializerForJavaBigDecimal(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toJavaBigDecimal";
        ObjectType x$3 = new ObjectType(BigDecimal.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        boolean x$6 = Invoke$.MODULE$.apply$default$5();
        return new Invoke(x$1, x$2, x$3, x$5, x$6, x$4);
    }

    public Expression createDeserializerForScalaBigDecimal(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toBigDecimal";
        ObjectType x$3 = new ObjectType(scala.math.BigDecimal.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        boolean x$6 = Invoke$.MODULE$.apply$default$5();
        return new Invoke(x$1, x$2, x$3, x$5, x$6, x$4);
    }

    public Expression createDeserializerForJavaBigInteger(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toJavaBigInteger";
        ObjectType x$3 = new ObjectType(BigInteger.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        boolean x$6 = Invoke$.MODULE$.apply$default$5();
        return new Invoke(x$1, x$2, x$3, x$5, x$6, x$4);
    }

    public Expression createDeserializerForScalaBigInt(Expression path) {
        Expression x$1 = path;
        String x$2 = "toScalaBigInt";
        ObjectType x$3 = new ObjectType(BigInt.class);
        boolean x$4 = false;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        boolean x$6 = Invoke$.MODULE$.apply$default$5();
        return new Invoke(x$1, x$2, x$3, x$5, x$6, x$4);
    }

    public Expression createDeserializerForDuration(Expression path) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Duration.class);
        String x$3 = "microsToDuration";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        boolean x$6 = StaticInvoke$.MODULE$.apply$default$5();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
    }

    public Expression createDeserializerForPeriod(Expression path) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Period.class);
        String x$3 = "monthsToPeriod";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        boolean x$6 = StaticInvoke$.MODULE$.apply$default$5();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$5);
    }

    private Expression upCastToExpectedType(Expression expr, DataType expected, WalkedTypePath walkedTypePath) {
        DataType dataType = expected;
        Expression expression = dataType instanceof StructType ? expr : (dataType instanceof ArrayType ? expr : (dataType instanceof MapType ? expr : (dataType instanceof DecimalType ? new UpCast(expr, DecimalType$.MODULE$, walkedTypePath.getPaths()) : new UpCast(expr, expected, walkedTypePath.getPaths()))));
        return expression;
    }

    private DeserializerBuildHelper$() {
        MODULE$ = this;
    }
}

