/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\r\u001a\u0001\u0019B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005e!)q\u0007\u0001C\u0001q!91\b\u0001b\u0001\n\u0013a\u0004BB\"\u0001A\u0003%Q\bC\u0004E\u0001\t\u0007I\u0011B#\t\rq\u0003\u0001\u0015!\u0003G\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\t9\u0006\u0001C\u0005\u00033B\u0011\"!\u001b\u0001\u0005\u0004%I!a\u001b\t\u0011\u0005M\u0004\u0001)A\u0005\u0003[\u0012abQ*W\u0013:4WM]*dQ\u0016l\u0017M\u0003\u0002\u001b7\u0005\u00191m\u001d<\u000b\u0005qi\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005yy\u0012aA:rY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003Q9J!aL\u0015\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000f=\u0004H/[8ogV\t!\u0007\u0005\u00024i5\t\u0011$\u0003\u000263\tQ1i\u0015,PaRLwN\\:\u0002\u0011=\u0004H/[8og\u0002\na\u0001P5oSRtDCA\u001d;!\t\u0019\u0004\u0001C\u00031\u0007\u0001\u0007!'A\buS6,7\u000f^1naB\u000b'o]3s+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!\u001c\u0003\u0011)H/\u001b7\n\u0005\t{$A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\f\u0001\u0003^5nKN$\u0018-\u001c9QCJ\u001cXM\u001d\u0011\u0002\u001b\u0011,7-[7bYB\u000b'o]3s+\u00051\u0005\u0003\u0002\u0015H\u0013RK!\u0001S\u0015\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001&R\u001d\tYu\n\u0005\u0002MS5\tQJ\u0003\u0002OK\u00051AH]8pizJ!\u0001U\u0015\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!&\u0002\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\t5\fG\u000f\u001b\u0006\u00023\u0006!!.\u0019<b\u0013\tYfK\u0001\u0006CS\u001e$UmY5nC2\fa\u0002Z3dS6\fG\u000eU1sg\u0016\u0014\b%A\u0003j]\u001a,'\u000fF\u0002`KB\u0004\"\u0001Y2\u000e\u0003\u0005T!AY\u000f\u0002\u000bQL\b/Z:\n\u0005\u0011\f'AC*ueV\u001cG\u000fV=qK\")a\r\u0003a\u0001O\u0006AAo\\6f]J#E\tE\u0002iW6l\u0011!\u001b\u0006\u0003U~\t1A\u001d3e\u0013\ta\u0017NA\u0002S\t\u0012\u00032\u0001\u000b8J\u0013\ty\u0017FA\u0003BeJ\f\u0017\u0010C\u0003r\u0011\u0001\u0007Q.\u0001\u0004iK\u0006$WM]\u0001\u000fi>\u001cFO];di\u001aKW\r\u001c3t)\r!\bP \t\u0004Q9,\bC\u00011w\u0013\t9\u0018MA\u0006TiJ,8\r\u001e$jK2$\u0007\"B=\n\u0001\u0004Q\u0018A\u00034jK2$G+\u001f9fgB\u0019\u0001F\\>\u0011\u0005\u0001d\u0018BA?b\u0005!!\u0015\r^1UsB,\u0007\"B9\n\u0001\u0004i\u0017\u0001D5oM\u0016\u0014(k\\<UsB,G#\u0002>\u0002\u0004\u0005\u001d\u0001BBA\u0003\u0015\u0001\u0007!0\u0001\u0005s_^\u001cvNR1s\u0011\u0019\tIA\u0003a\u0001[\u0006!a.\u001a=u\u00035iWM]4f%><H+\u001f9fgR)!0a\u0004\u0002\u0014!1\u0011\u0011C\u0006A\u0002i\fQAZ5sgRDa!!\u0006\f\u0001\u0004Q\u0018AB:fG>tG-\u0001\u0006j]\u001a,'OR5fY\u0012$Ra_A\u000e\u0003?Aa!!\b\r\u0001\u0004Y\u0018!\u0003;za\u0016\u001cvNR1s\u0011\u0019\t\t\u0003\u0004a\u0001\u0013\u0006)a-[3mI\u0006Q\u0011n]%oM>\u0013h*\u00198\u0015\t\u0005\u001d\u0012Q\u0006\t\u0004Q\u0005%\u0012bAA\u0016S\t9!i\\8mK\u0006t\u0007BBA\u0011\u001b\u0001\u0007\u0011*A\buef\u0004\u0016M]:f\u0013:$XmZ3s)\rY\u00181\u0007\u0005\u0007\u0003Cq\u0001\u0019A%\u0002\u0019Q\u0014\u0018\u0010U1sg\u0016duN\\4\u0015\u0007m\fI\u0004\u0003\u0004\u0002\"=\u0001\r!S\u0001\u0010iJL\b+\u0019:tK\u0012+7-[7bYR\u001910a\u0010\t\r\u0005\u0005\u0002\u00031\u0001J\u00039!(/\u001f)beN,Gi\\;cY\u0016$2a_A#\u0011\u0019\t\t#\u0005a\u0001\u0013\u0006\tBO]=QCJ\u001cX\rV5nKN$\u0018-\u001c9\u0015\u0007m\fY\u0005\u0003\u0004\u0002\"I\u0001\r!S\u0001\u0010iJL\b+\u0019:tK\n{w\u000e\\3b]R\u001910!\u0015\t\r\u0005\u00052\u00031\u0001J\u0003)\u0019HO]5oORK\b/\u001a\u000b\u0002w\u0006q1m\\7qCRL'\r\\3UsB,GCBA.\u0003C\n)\u0007\u0005\u0003)\u0003;Z\u0018bAA0S\t1q\n\u001d;j_:Da!a\u0019\u0016\u0001\u0004Y\u0018A\u0001;2\u0011\u0019\t9'\u0006a\u0001w\u0006\u0011AOM\u0001\u0019M&tGmQ8na\u0006$\u0018N\u00197f)f\u0004XMR8s\u0007N3VCAA7!\u001dA\u0013qN>|\u00037J1!!\u001d*\u0005%1UO\\2uS>t''A\rgS:$7i\\7qCRL'\r\\3UsB,gi\u001c:D'Z\u0003\u0003")
public class CSVInferSchema
implements scala.Serializable {
    private final CSVOptions options;
    private final TimestampFormatter timestampParser;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV;

    public CSVOptions options() {
        return this.options;
    }

    private TimestampFormatter timestampParser() {
        return this.timestampParser;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header) {
        StructField[] structFieldArray;
        if (this.options().inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2 & Serializable & scala.Serializable)(rowSoFar, next) -> this.inferRowType((DataType[])rowSoFar, (String[])next), (Function2 & Serializable & scala.Serializable)(first, second) -> this.mergeRowTypes((DataType[])first, (DataType[])second), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = this.toStructFields(rootTypes, header);
        } else {
            structFieldArray = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).map((Function1 & Serializable & scala.Serializable)fieldName -> new StructField((String)fieldName, StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public StructField[] toStructFields(DataType[] fieldTypes, String[] header) {
        return (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String thisHeader = (String)tuple2._1();
            DataType rootType = (DataType)tuple2._2();
            DataType dataType = rootType;
            DataType dataType2 = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
            DataType dType = dataType2;
            StructField structField = new StructField(thisHeader, dType, true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public DataType[] inferRowType(DataType[] rowSoFar, String[] next) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next[i]);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])first)).zipAll((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType a = (DataType)tuple2._1();
            DataType b = (DataType)tuple2._2();
            DataType dataType = (DataType)this.compatibleType(a, b).getOrElse((Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$);
            return dataType;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public DataType inferField(DataType typeSoFar, String field) {
        DataType dataType;
        DataType dataType2;
        block19: {
            block18: {
                if (field == null || field.isEmpty()) break block18;
                String string = field;
                String string2 = this.options().nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block19;
            }
            dataType2 = typeSoFar;
            return dataType2;
        }
        DataType dataType3 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field);
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field);
        } else if (LongType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseLong(field);
        } else if (dataType3 instanceof DecimalType) {
            dataType = this.tryParseDecimal(field);
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseDouble(field);
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseTimestamp(field);
        } else if (BooleanType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseBoolean(field);
        } else {
            if (!StringType$.MODULE$.equals(dataType3)) {
                if (dataType3 == null) throw new MatchError((Object)dataType3);
                DataType dataType4 = dataType3;
                throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType4).toString());
            }
            dataType = StringType$.MODULE$;
        }
        DataType typeElemInfer = dataType;
        dataType2 = (DataType)this.compatibleType(typeSoFar, typeElemInfer).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
        return dataType2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field) {
        String string = field;
        String string2 = this.options().nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = this.options().negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = this.options().positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toInt()).isDefined() ? IntegerType$.MODULE$ : this.tryParseLong(field);
    }

    private DataType tryParseLong(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toLong()).isDefined() ? LongType$.MODULE$ : this.tryParseDecimal(field);
    }

    private DataType tryParseDecimal(String field) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field);
            return bigDecimal.scale() <= 0 ? new DecimalType(bigDecimal.precision(), bigDecimal.scale()) : this.tryParseDouble(field);
        });
        return (DataType)decimalTry.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.tryParseDouble(field));
    }

    private DataType tryParseDouble(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toDouble()).isDefined() || this.isInfOrNan(field) ? DoubleType$.MODULE$ : this.tryParseTimestamp(field);
    }

    private DataType tryParseTimestamp(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.timestampParser().parse(field)).isDefined() ? TimestampType$.MODULE$ : this.tryParseBoolean(field);
    }

    private DataType tryParseBoolean(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toBoolean()).isDefined() ? BooleanType$.MODULE$ : this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    private Option<DataType> compatibleType(DataType t1, DataType t2) {
        return TypeCoercion$.MODULE$.findTightestCommonType(t1, t2).orElse((Function0 & Serializable & scala.Serializable)() -> (Option)this.findCompatibleTypeForCSV().apply((Object)t1, (Object)t2));
    }

    private Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV() {
        return this.findCompatibleTypeForCSV;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$findCompatibleTypeForCSV$1(CSVInferSchema $this, DataType x0$1, DataType x1$1) {
        block5: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        var5_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                                        if (var5_3 == null || !StringType$.MODULE$.equals(var6_4 = (DataType)var5_3._1())) break block4;
                                        var3_5 = new Some((Object)StringType$.MODULE$);
                                        break block5;
                                    }
                                    if (var5_3 == null || !StringType$.MODULE$.equals(var7_6 = (DataType)var5_3._2())) break block6;
                                    var3_5 = new Some((Object)StringType$.MODULE$);
                                    break block5;
                                }
                                if (var5_3 == null) break block7;
                                t1 = (DataType)var5_3._1();
                                t2 = (DataType)var5_3._2();
                                if (!(t1 instanceof IntegralType)) break block7;
                                var10_9 = (IntegralType)t1;
                                if (!(t2 instanceof DecimalType)) break block7;
                                var11_10 = (DecimalType)t2;
                                var3_5 = $this.compatibleType(DecimalType$.MODULE$.forType(var10_9), var11_10);
                                break block5;
                            }
                            if (var5_3 == null) break block8;
                            t1 = (DataType)var5_3._1();
                            t2 = (DataType)var5_3._2();
                            if (!(t1 instanceof DecimalType)) break block8;
                            var14_13 = (DecimalType)t1;
                            if (!(t2 instanceof IntegralType)) break block8;
                            var15_14 = (IntegralType)t2;
                            var3_5 = $this.compatibleType(var14_13, DecimalType$.MODULE$.forType(var15_14));
                            break block5;
                        }
                        if (var5_3 == null || !DoubleType$.MODULE$.equals(var16_15 = (DataType)var5_3._1()) || !(var5_3._2() instanceof DecimalType)) break block9;
                        var4_16 = true;
                        break block10;
                    }
                    if (var5_3 == null) ** GOTO lbl-1000
                    var17_17 = (DataType)var5_3._2();
                    if (var5_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var17_17)) {
                        var4_16 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var4_16 = false;
                    }
                }
                if (!var4_16) break block11;
                var3_5 = new Some((Object)DoubleType$.MODULE$);
                break block5;
            }
            if (var5_3 == null) ** GOTO lbl-1000
            t1 = (DataType)var5_3._1();
            t2 = (DataType)var5_3._2();
            if (!(t1 instanceof DecimalType)) ** GOTO lbl-1000
            var20_20 = (DecimalType)t1;
            if (t2 instanceof DecimalType) {
                var21_21 = (DecimalType)t2;
                scale = package$.MODULE$.max(var20_20.scale(), var21_21.scale());
                range = package$.MODULE$.max(var20_20.precision() - var20_20.scale(), var21_21.precision() - var21_21.scale());
                var3_5 = range + scale > 38 ? new Some((Object)DoubleType$.MODULE$) : new Some((Object)new DecimalType(range + scale, scale));
            } else lbl-1000:
            // 3 sources

            {
                var3_5 = None$.MODULE$;
            }
        }
        return var3_5;
    }

    public CSVInferSchema(CSVOptions options) {
        this.options = options;
        this.timestampParser = TimestampFormatter$.MODULE$.apply(options.timestampFormat(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        Locale locale = options.locale();
        Locale locale2 = Locale.US;
        this.decimalParser = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? s -> new BigDecimal((String)s) : ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.findCompatibleTypeForCSV = (arg_0, arg_1) -> CSVInferSchema.$anonfun$findCompatibleTypeForCSV$1(this, arg_0, arg_1);
    }
}

