/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Abs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the absolute value of the numeric value.", examples="\n    Examples:\n      > SELECT _FUNC_(-1);\n       1\n  ", since="1.2.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0010!\u00016B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003N\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\t\u0006\u0001\"\u0001W\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015Y\u0007\u0001\"\u0011m\u0011!\u0001\b\u0001#b\u0001\n\u0013\t\b\"\u0002=\u0001\t\u0003J\bbBA\b\u0001\u0011E\u0013\u0011\u0003\u0005\b\u0003/\u0001A\u0011KA\r\u0011%\ty\u0002AA\u0001\n\u0003\t\t\u0003C\u0005\u0002(\u0001\t\n\u0011\"\u0001\u0002*!I\u0011q\b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003\u000b\u0002\u0011\u0011!C!\u0003\u000fB\u0011\"!\u0017\u0001\u0003\u0003%\t!a\u0017\t\u0013\u0005\r\u0004!!A\u0005\u0002\u0005\u0015\u0004\"CA6\u0001\u0005\u0005I\u0011IA7\u0011%\tY\bAA\u0001\n\u0003\ti\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\u001eI\u0011q\u0015\u0011\u0002\u0002#\u0005\u0011\u0011\u0016\u0004\t?\u0001\n\t\u0011#\u0001\u0002,\"1\u0011k\u0006C\u0001\u0003sC\u0011\"a/\u0018\u0003\u0003%)%!0\t\u0013\u0005}v#!A\u0005\u0002\u0006\u0005\u0007\"CAd/E\u0005I\u0011AA!\u0011%\tImFA\u0001\n\u0003\u000bY\rC\u0005\u0002^^\t\n\u0011\"\u0001\u0002B!I\u0011q\\\f\u0002\u0002\u0013%\u0011\u0011\u001d\u0002\u0004\u0003\n\u001c(BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001q#'\u000e\u001fC!\ty\u0003'D\u0001!\u0013\t\t\u0004EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ty3'\u0003\u00025A\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005YJdBA\u00188\u0013\tA\u0004%A\u0004qC\u000e\\\u0017mZ3\n\u0005iZ$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003q\u0001\u0002\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002>\u0007&\u0011AI\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u000fB\u0011q\u0006S\u0005\u0003\u0013\u0002\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005Ya-Y5m\u001f:,%O]8s+\u0005i\u0005CA\u001fO\u0013\tyeHA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\r\u0019F+\u0016\t\u0003_\u0001AQ!R\u0003A\u0002\u001dCqaS\u0003\u0011\u0002\u0003\u0007Q\n\u0006\u0002T/\")QI\u0002a\u0001\u000f\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003i\u00032a\u00172f\u001d\ta\u0016M\u0004\u0002^A6\taL\u0003\u0002`Y\u00051AH]8pizJ\u0011aP\u0005\u0003qyJ!a\u00193\u0003\u0007M+\u0017O\u0003\u00029}A\u0011a-[\u0007\u0002O*\u0011\u0001\u000eJ\u0001\u0006if\u0004Xm]\u0005\u0003U\u001e\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u001c\t\u0003M:L!a\\4\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fqA\\;nKJL7-F\u0001s!\rY6/^\u0005\u0003i\u0012\u0014qAT;nKJL7\r\u0005\u0002>m&\u0011qO\u0010\u0002\u0004\u0003:L\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0015Q\u0018\u0011AA\u0006!\tYh0D\u0001}\u0015\ti\b%A\u0004d_\u0012,w-\u001a8\n\u0005}d(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\r!\u00021\u0001\u0002\u0006\u0005\u00191\r\u001e=\u0011\u0007m\f9!C\u0002\u0002\nq\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u000e)\u0001\rA_\u0001\u0003KZ\fAB\\;mYN\u000bg-Z#wC2$2!^A\n\u0011\u0019\t)b\u0003a\u0001k\u0006)\u0011N\u001c9vi\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2aUA\u000e\u0011\u0019\ti\u0002\u0004a\u0001\u000f\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#B*\u0002$\u0005\u0015\u0002bB#\u000e!\u0003\u0005\ra\u0012\u0005\b\u00176\u0001\n\u00111\u0001N\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u000b+\u0007\u001d\u000bic\u000b\u0002\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012!C;oG\",7m[3e\u0015\r\tIDP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001f\u0003g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0011+\u00075\u000bi#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0003mC:<'BAA*\u0003\u0011Q\u0017M^1\n\t\u0005]\u0013Q\n\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0003cA\u001f\u0002`%\u0019\u0011\u0011\r \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007U\f9\u0007C\u0005\u0002jI\t\t\u00111\u0001\u0002^\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001c\u0011\u000b\u0005E\u0014qO;\u000e\u0005\u0005M$bAA;}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00141\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002N\u0003\u007fB\u0001\"!\u001b\u0015\u0003\u0003\u0005\r!^\u0001\u0007KF,\u0018\r\\:\u0015\u00075\u000b)\t\u0003\u0005\u0002jU\t\t\u00111\u0001vQM\u0001\u0011\u0011RAH\u0003#\u000b)*a&\u0002\u001c\u0006u\u0015\u0011UAR!\ry\u00131R\u0005\u0004\u0003\u001b\u0003#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003'\u000bqh\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013MY:pYV$X\r\t<bYV,\u0007e\u001c4!i\",\u0007E\\;nKJL7\r\t<bYV,g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI*A\u001b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAP\u0003\u0015\tdF\r\u00181\u0003\u00159'o\\;qC\t\t)+\u0001\u0006nCRDwLZ;oGN\f1!\u00112t!\tysc\u0005\u0003\u0018\u0003[\u0013\u0005cBAX\u0003k;UjU\u0007\u0003\u0003cS1!a-?\u0003\u001d\u0011XO\u001c;j[\u0016LA!a.\u00022\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005%\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0013!B1qa2LH#B*\u0002D\u0006\u0015\u0007\"B#\u001b\u0001\u00049\u0005bB&\u001b!\u0003\u0005\r!T\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BAg\u00033\u0004R!PAh\u0003'L1!!5?\u0005\u0019y\u0005\u000f^5p]B)Q(!6H\u001b&\u0019\u0011q\u001b \u0003\rQ+\b\u000f\\33\u0011!\tY\u000eHA\u0001\u0002\u0004\u0019\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001d\t\u0005\u0003\u0017\n)/\u0003\u0003\u0002h\u00065#AB(cU\u0016\u001cG\u000f")
public class Abs
extends UnaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Abs$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Abs abs) {
        return Abs$.MODULE$.unapply(abs);
    }

    public static boolean apply$default$2() {
        return Abs$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Abs> tupled() {
        return Abs$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Abs>> curried() {
        return Abs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType$[]{NumericType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private Numeric<Object> numeric$lzycompute() {
        Abs abs = this;
        synchronized (abs) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(6).append((String)c).append(".abs()").toString());
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType);
            if (bl && this.failOnError()) {
                String javaBoxedType = CodeGenerator$.MODULE$.boxedType(this.dataType());
                String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
                exprCode = this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n          |if (").append((String)eval).append(" == ").append(javaBoxedType).append(".MIN_VALUE) {\n          |  throw QueryExecutionErrors.unaryMinusCauseOverflowError(").append((String)eval).append(");\n          |} else if (").append((String)eval).append(" < 0) {\n          |  ").append(ev.value()).append(" = (").append(javaType).append(")-").append((String)eval).append(";\n          |} else {\n          |  ").append(ev.value()).append(" = ").append((String)eval).append(";\n          |}\n          |").toString())).stripMargin());
            } else {
                boolean bl2 = IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType);
                if (bl2 && this.failOnError()) {
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(38).append((String)c).append(" < 0 ? java.lang.Math.negateExact(").append((String)c).append(") : ").append((String)c).toString());
                } else if (dataType instanceof NumericType) {
                    NumericType numericType = (NumericType)dataType;
                    exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(24).append("(").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(java.lang.Math.abs(").append((String)c).append("))").toString());
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
        }
        return exprCode;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.numeric().abs(input);
    }

    @Override
    public Abs withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Abs copy(Expression child, boolean failOnError) {
        return new Abs(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Abs";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Abs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Abs)) return false;
        boolean bl = true;
        if (!bl) return false;
        Abs abs = (Abs)x$1;
        Expression expression = this.child();
        Expression expression2 = abs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.failOnError() != abs.failOnError()) return false;
        if (!abs.canEqual(this)) return false;
        return true;
    }

    public Abs(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public Abs(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

