/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(a1, a2) - Returns true if a1 contains at least a non-null element present also in a2. If the arrays have no common element and they are both non-empty and either of them contains a null element null is returned, false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(3, 4, 5));\n       true\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001\u0002\u0013&\u0001JB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005R\u0001\tE\t\u0015!\u0003M\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u00159\u0006\u0001\"\u0011Y\u0011!y\u0006\u0001#b\u0001\n\u0013\u0001\u0007\u0002C:\u0001\u0011\u000b\u0007I\u0011\u0002;\t\r}\u0004A\u0011IA\u0001\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005E\u0002\u0001\"\u0003\u00024!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003o\u0002A\u0011BA=\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!a&\u0001\t\u0003\nI\nC\u0004\u0002\u001c\u0002!\t&!(\t\u0013\u0005\u001d\u0006!!A\u0005\u0002\u0005%\u0006\"CAX\u0001E\u0005I\u0011AAY\u0011%\t9\rAI\u0001\n\u0003\t\t\fC\u0005\u0002J\u0002\t\t\u0011\"\u0011\u0002L\"I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0011Q\u001c\u0005\n\u0003K\u0004\u0011\u0011!C\u0001\u0003OD\u0011\"!<\u0001\u0003\u0003%\t%a<\t\u0013\u0005u\b!!A\u0005\u0002\u0005}\b\"\u0003B\u0002\u0001\u0005\u0005I\u0011\tB\u0003\u000f%\u0011I#JA\u0001\u0012\u0003\u0011YC\u0002\u0005%K\u0005\u0005\t\u0012\u0001B\u0017\u0011\u0019\u0011f\u0004\"\u0001\u0003<!I!Q\b\u0010\u0002\u0002\u0013\u0015#q\b\u0005\n\u0005\u0003r\u0012\u0011!CA\u0005\u0007B\u0011B!\u0013\u001f\u0003\u0003%\tIa\u0013\t\u0013\tuc$!A\u0005\n\t}#!D!se\u0006L8o\u0014<fe2\f\u0007O\u0003\u0002'O\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tA\u0013&\u0001\u0005dCR\fG._:u\u0015\tQ3&A\u0002tc2T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\u0019\u00011g\u000e\u001eB\u000fB\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\u000e\u001d\n\u0005e*#!\n\"j]\u0006\u0014\u00180\u0011:sCf,\u0005\u0010\u001d:fgNLwN\\,ji\"LU\u000e\u001d7jG&$8)Y:u!\tYdH\u0004\u00025y%\u0011Q(J\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004I\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005u*\u0003C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0005\"K!!S\"\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002\u0019B\u0011A'T\u0005\u0003\u001d\u0016\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2\u0001V+W!\t!\u0004\u0001C\u0003K\u000b\u0001\u0007A\nC\u0003Q\u000b\u0001\u0007A*A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001Z!\tQV,D\u0001\\\u0015\tav%\u0001\u0005b]\u0006d\u0017p]5t\u0013\tq6LA\bUsB,7\t[3dWJ+7/\u001e7u\u0003!y'\u000fZ3sS:<W#A1\u0011\u0007\tLGN\u0004\u0002dQ:\u0011AmZ\u0007\u0002K*\u0011a-M\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!!P\"\n\u0005)\\'\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0005u\u001a\u0005C\u0001\"n\u0013\tq7IA\u0002B]fD#a\u00029\u0011\u0005\t\u000b\u0018B\u0001:D\u0005%!(/\u00198tS\u0016tG/\u0001\u0007e_\u00163\u0018\r\\;bi&|g.F\u0001v!\u0015\u0011e\u000f\u001f=m\u0013\t98IA\u0005Gk:\u001cG/[8oeA\u0011\u0011\u0010`\u0007\u0002u*\u00111pJ\u0001\u0005kRLG.\u0003\u0002~u\nI\u0011I\u001d:bs\u0012\u000bG/\u0019\u0015\u0003\u0011A\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013I\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\u0007\u0003\u000f\u0011\u0001\u0002R1uCRK\b/Z\u0001\t]VdG.\u00192mKV\u0011\u00111\u0003\t\u0004\u0005\u0006U\u0011bAA\f\u0007\n9!i\\8mK\u0006t\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG#\u00027\u0002\u001e\u0005\u0005\u0002BBA\u0010\u0017\u0001\u0007A.\u0001\u0002bc!1\u00111E\u0006A\u00021\f!!\u0019\u001a\u0002\u0011\u0019\f7\u000f^#wC2$R\u0001\\A\u0015\u0003[Aa!a\u000b\r\u0001\u0004A\u0018\u0001B1seFBa!a\f\r\u0001\u0004A\u0018\u0001B1seJ\naB\u0019:vi\u00164uN]2f\u000bZ\fG\u000eF\u0003m\u0003k\t9\u0004\u0003\u0004\u0002,5\u0001\r\u0001\u001f\u0005\u0007\u0003_i\u0001\u0019\u0001=\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001f\u0003\u0013\n\u0019\u0006\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019%J\u0001\bG>$WmZ3o\u0013\u0011\t9%!\u0011\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0013\u000f\u0001\u0004\ti%A\u0002dib\u0004B!a\u0010\u0002P%!\u0011\u0011KA!\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0016\u000f\u0001\u0004\ti$\u0001\u0002fm\u0006Ya-Y:u\u0007>$WmZ3o))\tY&a\u001b\u0002n\u0005=\u00141\u000f\t\u0005\u0003;\n)G\u0004\u0003\u0002`\u0005\u0005\u0004C\u00013D\u0013\r\t\u0019gQ\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r4\tC\u0004\u0002L=\u0001\r!!\u0014\t\u000f\u0005Us\u00021\u0001\u0002>!9\u0011\u0011O\bA\u0002\u0005m\u0013aB:nC2dWM\u001d\u0005\b\u0003kz\u0001\u0019AA.\u0003\u0019\u0011\u0017nZ4fe\u0006\t\"M];uK\u001a{'oY3D_\u0012,w-\u001a8\u0015\u0015\u0005m\u00131PA?\u0003\u007f\n\t\tC\u0004\u0002LA\u0001\r!!\u0014\t\u000f\u0005U\u0003\u00031\u0001\u0002>!9\u0011\u0011\u000f\tA\u0002\u0005m\u0003bBA;!\u0001\u0007\u00111L\u0001\u0017]VdGnU1gK\u0016cW-\\3oi\u000e{G-Z4f]RQ\u00111LAD\u0003\u0017\u000by)a%\t\u000f\u0005%\u0015\u00031\u0001\u0002\\\u0005A\u0011M\u001d:bsZ\u000b'\u000fC\u0004\u0002\u000eF\u0001\r!a\u0017\u0002\u000b%tG-\u001a=\t\u000f\u0005E\u0015\u00031\u0001\u0002\\\u0005!1m\u001c3f\u0011\u001d\t)*\u0005a\u0001\u00037\n!\"[:Ok2d7i\u001c3f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00037\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bQ\u000by*a)\t\r\u0005\u00056\u00031\u0001M\u0003\u001dqWm\u001e'fMRDa!!*\u0014\u0001\u0004a\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006)\u0006-\u0016Q\u0016\u0005\b\u0015R\u0001\n\u00111\u0001M\u0011\u001d\u0001F\u0003%AA\u00021\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00024*\u001aA*!.,\u0005\u0005]\u0006\u0003BA]\u0003\u0007l!!a/\u000b\t\u0005u\u0016qX\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!1D\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\fYLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001b\u0004B!a4\u0002Z6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).\u0001\u0003mC:<'BAAl\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0014\u0011[\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003?\u00042AQAq\u0013\r\t\u0019o\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004Y\u0006%\b\"CAv3\u0005\u0005\t\u0019AAp\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001f\t\u0006\u0003g\fI\u0010\\\u0007\u0003\u0003kT1!a>D\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\f)P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\n\u0005\u0003A\u0001\"a;\u001c\u0003\u0003\u0005\r\u0001\\\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M!q\u0001\u0005\t\u0003Wd\u0012\u0011!a\u0001Y\"\u001a\u0002Aa\u0003\u0003\u0012\tM!q\u0003B\r\u0005;\u0011yBa\t\u0003&A\u0019AG!\u0004\n\u0007\t=QEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tU\u0011!a6`\rVs5i\u0018\u0015bc1\u0002\u0013MM\u0015![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007%Y\u0019!G>tG/Y5og\u0002\nG\u000f\t7fCN$\b%\u0019\u0011o_:lc.\u001e7mA\u0015dW-\\3oi\u0002\u0002(/Z:f]R\u0004\u0013\r\\:pA%t\u0007%\u0019\u001a/A%3\u0007\u0005\u001e5fA\u0005\u0014(/Y=tA!\fg/\u001a\u0011o_\u0002\u001aw.\\7p]\u0002*G.Z7f]R\u0004\u0013M\u001c3!i\",\u0017\u0010I1sK\u0002\u0012w\u000e\u001e5!]>tW&Z7qif\u0004\u0013M\u001c3!K&$\b.\u001a:!_\u001a\u0004C\u000f[3nA\r|g\u000e^1j]N\u0004\u0013\r\t8vY2\u0004S\r\\3nK:$\bE\\;mY\u0002J7\u000f\t:fiV\u0014h.\u001a3-A\u0019\fGn]3!_RDWM]<jg\u0016t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tm\u0011\u0001\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\n'O]1zQMb\u0003\u0005\u000e\u0017!k%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005C\t1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!qE\u0001\u0006e9\"d\u0006M\u0001\u000e\u0003J\u0014\u0018-_:Pm\u0016\u0014H.\u00199\u0011\u0005Qr2\u0003\u0002\u0010\u00030\u001d\u0003rA!\r\u000381cE+\u0004\u0002\u00034)\u0019!QG\"\u0002\u000fI,h\u000e^5nK&!!\u0011\bB\u001a\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005W\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001b\fQ!\u00199qYf$R\u0001\u0016B#\u0005\u000fBQAS\u0011A\u00021CQ\u0001U\u0011A\u00021\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003N\te\u0003#\u0002\"\u0003P\tM\u0013b\u0001B)\u0007\n1q\n\u001d;j_:\u0004RA\u0011B+\u00192K1Aa\u0016D\u0005\u0019!V\u000f\u001d7fe!A!1\f\u0012\u0002\u0002\u0003\u0007A+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\r\t\u0005\u0003\u001f\u0014\u0019'\u0003\u0003\u0003f\u0005E'AB(cU\u0016\u001cG\u000f")
public class ArraysOverlap
extends BinaryExpression
implements BinaryArrayExpressionWithImplicitCast,
package.NullIntolerant,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private transient Function2<ArrayData, ArrayData, Object> doEvaluation;
    private final Expression left;
    private final Expression right;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraysOverlap arraysOverlap) {
        return ArraysOverlap$.MODULE$.unapply(arraysOverlap);
    }

    public static Function1<Tuple2<Expression, Expression>, ArraysOverlap> tupled() {
        return ArraysOverlap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArraysOverlap>> curried() {
        return ArraysOverlap$.MODULE$.curried();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private DataType elementType$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
        TypeCheckResult typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult) ? TypeUtils$.MODULE$.checkForOrderingExpr(this.elementType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString()) : typeCheckResult;
        return typeCheckResult2;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.elementType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation$lzycompute() {
        ArraysOverlap arraysOverlap = this;
        synchronized (arraysOverlap) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.doEvaluation = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.fastEval((ArrayData)arr1, (ArrayData)arr2) : (Function2 & Serializable & scala.Serializable)(arr1, arr2) -> this.bruteForceEval((ArrayData)arr1, (ArrayData)arr2);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doEvaluation;
    }

    private Function2<ArrayData, ArrayData, Object> doEvaluation() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.doEvaluation$lzycompute() : this.doEvaluation;
    }

    @Override
    public DataType dataType() {
        return BooleanType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.left().nullable() || this.right().nullable() || ((ArrayType)this.left().dataType()).containsNull() || ((ArrayType)this.right().dataType()).containsNull();
    }

    @Override
    public Object nullSafeEval(Object a1, Object a2) {
        return this.doEvaluation().apply((Object)((ArrayData)a1), (Object)((ArrayData)a2));
    }

    private Object fastEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            Tuple2 tuple2;
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            Tuple2 tuple22 = tuple2 = arr1.numElements() > arr2.numElements() ? new Tuple2((Object)arr1, (Object)arr2) : new Tuple2((Object)arr2, (Object)arr1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayData bigger = (ArrayData)tuple2._1();
            ArrayData smaller = (ArrayData)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)bigger, (Object)smaller);
            Tuple2 tuple24 = tuple23;
            ArrayData bigger2 = (ArrayData)tuple24._1();
            ArrayData smaller2 = (ArrayData)tuple24._2();
            if (smaller2.numElements() > 0) {
                HashSet smallestSet = new HashSet();
                smaller2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$28, v) -> {
                    ArraysOverlap.$anonfun$fastEval$1(hasNull, smallestSet, BoxesRunTime.unboxToInt((Object)x$28), v);
                    return BoxedUnit.UNIT;
                });
                bigger2.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$29, v1) -> {
                    ArraysOverlap.$anonfun$fastEval$2(hasNull, smallestSet, object2, BoxesRunTime.unboxToInt((Object)x$29), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Object bruteForceEval(ArrayData arr1, ArrayData arr2) {
        Object object;
        Object object2 = new Object();
        try {
            BooleanRef hasNull = BooleanRef.create((boolean)false);
            if (arr1.numElements() > 0 && arr2.numElements() > 0) {
                arr1.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$30, v1) -> {
                    ArraysOverlap.$anonfun$bruteForceEval$1(this, hasNull, arr2, object2, BoxesRunTime.unboxToInt((Object)x$30), v1);
                    return BoxedUnit.UNIT;
                });
            }
            object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(a1, a2) -> {
            String smaller = ctx.freshName("smallerArray");
            String bigger = ctx.freshName("biggerArray");
            String comparisonCode = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? this.fastCodegen(ctx, ev, smaller, bigger) : this.bruteForceCodegen(ctx, ev, smaller, bigger);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(261).append("\n         |ArrayData ").append(smaller).append(";\n         |ArrayData ").append(bigger).append(";\n         |if (").append((String)a1).append(".numElements() > ").append((String)a2).append(".numElements()) {\n         |  ").append(bigger).append(" = ").append((String)a1).append(";\n         |  ").append(smaller).append(" = ").append((String)a2).append(";\n         |} else {\n         |  ").append(smaller).append(" = ").append((String)a1).append(";\n         |  ").append(bigger).append(" = ").append((String)a2).append(";\n         |}\n         |if (").append(smaller).append(".numElements() > 0) {\n         |  ").append(comparisonCode).append("\n         |}\n       ").toString())).stripMargin();
        });
    }

    private String fastCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), i);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String javaElementClass = CodeGenerator$.MODULE$.boxedType(this.elementType());
        String javaSet = java.util.HashSet.class.getName();
        String set = ctx.freshName("set");
        String addToSetFromSmallerCode = this.nullSafeElementCodegen(smaller, i, new StringBuilder(7).append(set).append(".add(").append(getFromSmaller).append(");").toString(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String elementIsInSetCode = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(set).append(".contains(").append(getFromBigger).append(")) {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |  break;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("\n       |").append(javaSet).append("<").append(javaElementClass).append("> ").append(set).append(" = new ").append(javaSet).append("<").append(javaElementClass).append(">();\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(smaller).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(addToSetFromSmallerCode).append("\n       |}\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements(); ").append(i).append(" ++) {\n       |  ").append(elementIsInSetCode).append("\n       |}\n     ").toString())).stripMargin();
    }

    private String bruteForceCodegen(CodegenContext ctx, ExprCode ev, String smaller, String bigger) {
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        String getFromSmaller = CodeGenerator$.MODULE$.getValue(smaller, this.elementType(), j);
        String getFromBigger = CodeGenerator$.MODULE$.getValue(bigger, this.elementType(), i);
        String setIsNullCode = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        String compareValues = this.nullSafeElementCodegen(smaller, j, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n         |if (").append(ctx.genEqual(this.elementType(), getFromSmaller, getFromBigger)).append(") {\n         |  ").append(setIsNullCode).append("\n         |  ").append(ev.value()).append(" = true;\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        String isInSmaller = this.nullSafeElementCodegen(bigger, i, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n         |for (int ").append(j).append(" = 0; ").append(j).append(" < ").append(smaller).append(".numElements() && !").append(ev.value()).append("; ").append(j).append(" ++) {\n         |  ").append(compareValues).append("\n         |}\n       ").toString())).stripMargin(), new StringBuilder(8).append(ev.isNull()).append(" = true;").toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(bigger).append(".numElements() && !").append(ev.value()).append("; ").append(i).append(" ++) {\n       |  ").append(isInSmaller).append("\n       |}\n     ").toString())).stripMargin();
    }

    public String nullSafeElementCodegen(String arrayVar, String index, String code, String isNullCode) {
        return this.inputTypes().exists((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)ArraysOverlap.$anonfun$nullSafeElementCodegen$1(x$32))) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n         |if (").append(arrayVar).append(".isNullAt(").append(index).append(")) {\n         |  ").append(isNullCode).append("\n         |} else {\n         |  ").append(code).append("\n         |}\n       ").toString())).stripMargin() : code;
    }

    @Override
    public String prettyName() {
        return "arrays_overlap";
    }

    @Override
    public ArraysOverlap withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArraysOverlap copy(Expression left, Expression right) {
        return new ArraysOverlap(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArraysOverlap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysOverlap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysOverlap)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysOverlap arraysOverlap = (ArraysOverlap)x$1;
        Expression expression = this.left();
        Expression expression2 = arraysOverlap.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arraysOverlap.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraysOverlap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$fastEval$1(BooleanRef hasNull$2, HashSet smallestSet$1, int x$28, Object v) {
        if (v == null) {
            hasNull$2.elem = true;
        } else {
            smallestSet$1.$plus$eq(v);
        }
    }

    public static final /* synthetic */ void $anonfun$fastEval$2(BooleanRef hasNull$2, HashSet smallestSet$1, Object nonLocalReturnKey2$1, int x$29, Object v1) {
        if (v1 == null) {
            hasNull$2.elem = true;
        } else if (smallestSet$1.contains(v1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$2(ArraysOverlap $this, BooleanRef hasNull$3, Object v1$1, Object nonLocalReturnKey3$1, int x$31, Object v2) {
        if (v2 == null) {
            hasNull$3.elem = true;
        } else if ($this.ordering().equiv(v1$1, v2)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey3$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$bruteForceEval$1(ArraysOverlap $this, BooleanRef hasNull$3, ArrayData arr2$1, Object nonLocalReturnKey3$1, int x$30, Object v1) {
        if (v1 == null) {
            hasNull$3.elem = true;
        } else {
            arr2$1.foreach($this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$31, v2) -> {
                ArraysOverlap.$anonfun$bruteForceEval$2($this, hasNull$3, v1, nonLocalReturnKey3$1, BoxesRunTime.unboxToInt((Object)x$31), v2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeElementCodegen$1(AbstractDataType x$32) {
        return ((ArrayType)x$32).containsNull();
    }

    public ArraysOverlap(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
    }
}

