/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic$;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0004\b\u0002\u0002mAQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u001bE1\u0006C\u00033\u0001\u0011\u00053\u0007\u0003\u0005;\u0001!\u0015\r\u0011\"\u0011,\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015A\u0005\u0001\"\u0001=\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u000f\u0015if\u0002#\u0001_\r\u0015ia\u0002#\u0001`\u0011\u00159#\u0002\"\u0001d\u0011\u0015!'\u0002\"\u0001f\u0005A\u0011\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7M\u0003\u0002\u0010!\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t\"#\u0001\u0005dCR\fG._:u\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0004\t\t\u0003;yi\u0011AD\u0005\u0003?9\u0011aBQ5oCJLx\n]3sCR|'\u000f\u0005\u0002\"I9\u0011QDI\u0005\u0003G9\tq\u0001]1dW\u0006<W-\u0003\u0002&M\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u0012\u000f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002\u001e\u0001\u0005Ya-Y5m\u001f:,%O]8s+\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#a\u0002\"p_2,\u0017M\\\u0001\tI\u0006$\u0018\rV=qKV\tA\u0007\u0005\u00026q5\taG\u0003\u00028%\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\t\t\u0006$\u0018\rV=qK\u0006A!/Z:pYZ,G-A\u0007eK\u000eLW.\u00197NKRDw\u000eZ\u000b\u0002{A\u0011a(\u0012\b\u0003\u007f\r\u0003\"\u0001\u0011\u0018\u000e\u0003\u0005S!A\u0011\u000e\u0002\rq\u0012xn\u001c;?\u0013\t!e&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u0013aa\u0015;sS:<'B\u0001#/\u0003Y\u0019\u0017\r\\3oI\u0006\u0014\u0018J\u001c;feZ\fG.T3uQ>$\u0017aD3yC\u000e$X*\u0019;i\u001b\u0016$\bn\u001c3\u0016\u0003-\u00032!\f'>\u0013\tieF\u0001\u0004PaRLwN\\\u0001\nI><UM\\\"pI\u0016$2\u0001\u0015,\\!\t\tF+D\u0001S\u0015\t\u0019f\"A\u0004d_\u0012,w-\u001a8\n\u0005U\u0013&\u0001C#yaJ\u001cu\u000eZ3\t\u000b]C\u0001\u0019\u0001-\u0002\u0007\r$\b\u0010\u0005\u0002R3&\u0011!L\u0015\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015a\u0006\u00021\u0001Q\u0003\t)g/\u0001\tCS:\f'/_!sSRDW.\u001a;jGB\u0011QDC\n\u0003\u0015\u0001\u0004\"!L1\n\u0005\tt#AB!osJ+g\rF\u0001_\u0003\u001d)h.\u00199qYf$\"AZ7\u0011\u00075bu\r\u0005\u0003.Q*T\u0017BA5/\u0005\u0019!V\u000f\u001d7feA\u0011Qd[\u0005\u0003Y:\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015qG\u00021\u0001*\u0003\u0005)\u0007")
public abstract class BinaryArithmetic
extends BinaryOperator
implements package.NullIntolerant {
    private boolean resolved;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(BinaryArithmetic binaryArithmetic) {
        return BinaryArithmetic$.MODULE$.unapply(binaryArithmetic);
    }

    public abstract boolean failOnError();

    @Override
    public DataType dataType() {
        return ((Expression)this.left()).dataType();
    }

    private boolean resolved$lzycompute() {
        BinaryArithmetic binaryArithmetic = this;
        synchronized (binaryArithmetic) {
            if (!this.bitmap$0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess();
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    public String decimalMethod() {
        throw package$.MODULE$.error("BinaryArithmetics must override either decimalMethod or genCode");
    }

    public String calendarIntervalMethod() {
        throw package$.MODULE$.error("BinaryArithmetics must override either calendarIntervalMethod or genCode");
    }

    public Option<String> exactMathMethod() {
        return None$.MODULE$;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(3).append((String)eval1).append(".").append(this.decimalMethod()).append("(").append((String)eval2).append(")").toString());
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            String iu = new StringOps(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
            exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(5).append(iu).append(".").append(this.calendarIntervalMethod()).append("(").append((String)eval1).append(", ").append((String)eval2).append(")").toString());
        } else {
            boolean bl = DayTimeIntervalType$.MODULE$.equals(dataType) ? true : YearMonthIntervalType$.MODULE$.equals(dataType);
            if (bl) {
                Predef$.MODULE$.assert(this.exactMathMethod().isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("The expression '").append(this.nodeName()).append("' must override the exactMathMethod() method ").append("if it is supposed to operate over interval types.").toString());
                String mathClass = Math.class.getName();
                exprCode = this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(5).append(mathClass).append(".").append(this.exactMathMethod().get()).append("(").append((String)eval1).append(", ").append((String)eval2).append(")").toString());
            } else {
                boolean bl2 = ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType);
                if (bl2) {
                    exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                        String string;
                        String tmpResult = ctx.freshName("tmpResult");
                        if (this.failOnError()) {
                            String javaType = CodeGenerator$.MODULE$.boxedType(this.dataType());
                            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(184).append("\n             |if (").append(tmpResult).append(" < ").append(javaType).append(".MIN_VALUE || ").append(tmpResult).append(" > ").append(javaType).append(".MAX_VALUE) {\n             |  throw QueryExecutionErrors.binaryArithmeticCauseOverflowError(\n             |  ").append((String)eval1).append(", \"").append(this.symbol()).append("\", ").append((String)eval2).append(");\n             |}\n           ").toString())).stripMargin();
                        } else {
                            string = "";
                        }
                        String overflowCheck = string;
                        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n           |").append("int").append(" ").append(tmpResult).append(" = ").append((String)eval1).append(" ").append(this.symbol()).append(" ").append((String)eval2).append(";\n           |").append(overflowCheck).append("\n           |").append(ev.value()).append(" = (").append(CodeGenerator$.MODULE$.javaType(this.dataType())).append(")(").append(tmpResult).append(");\n         ").toString())).stripMargin();
                    });
                } else {
                    boolean bl3 = IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType);
                    if (bl3) {
                        exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                            String string;
                            if (this.failOnError() && this.exactMathMethod().isDefined()) {
                                String mathClass = Math.class.getName();
                                string = new StringBuilder(5).append(mathClass).append(".").append(this.exactMathMethod().get()).append("(").append((String)eval1).append(", ").append((String)eval2).append(")").toString();
                            } else {
                                string = new StringBuilder(2).append((String)eval1).append(" ").append(this.symbol()).append(" ").append((String)eval2).toString();
                            }
                            String operation = string;
                            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(27).append("\n           |").append(ev.value()).append(" = ").append(operation).append(";\n         ").toString())).stripMargin();
                        });
                    } else {
                        boolean bl4 = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
                        if (bl4) {
                            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(29).append("\n           |").append(ev.value()).append(" = ").append((String)eval1).append(" ").append(this.symbol()).append(" ").append((String)eval2).append(";\n         ").toString())).stripMargin());
                        } else {
                            throw new MatchError((Object)dataType);
                        }
                    }
                }
            }
        }
        return exprCode;
    }
}

