/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeInterval$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple8;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(years, months, weeks, days, hours, mins, secs) - Make interval from years, months, weeks, days, hours, mins and secs.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n      * weeks - the number of weeks, positive or negative\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(100, 11, 1, 1, 12, 30, 01.001001);\n       100 years 11 months 8 days 12 hours 30 minutes 1.001001 seconds\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n      > SELECT _FUNC_(0, 1, 0, 1, 0, 0, 100.000001);\n       1 months 1 days 1 minutes 40.000001 seconds\n  ", since="3.0.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001\u0002\u001e<\u0001\"C\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tK\u0002\u0011\t\u0012)A\u0005E\"Aa\r\u0001BK\u0002\u0013\u0005\u0011\r\u0003\u0005h\u0001\tE\t\u0015!\u0003c\u0011!A\u0007A!f\u0001\n\u0003\t\u0007\u0002C5\u0001\u0005#\u0005\u000b\u0011\u00022\t\u0011)\u0004!Q3A\u0005\u0002\u0005D\u0001b\u001b\u0001\u0003\u0012\u0003\u0006IA\u0019\u0005\tY\u0002\u0011)\u001a!C\u0001C\"AQ\u000e\u0001B\tB\u0003%!\r\u0003\u0005o\u0001\tU\r\u0011\"\u0001b\u0011!y\u0007A!E!\u0002\u0013\u0011\u0007\u0002\u00039\u0001\u0005+\u0007I\u0011A1\t\u0011E\u0004!\u0011#Q\u0001\n\tD\u0001B\u001d\u0001\u0003\u0016\u0004%\ta\u001d\u0005\to\u0002\u0011\t\u0012)A\u0005i\")\u0001\u0010\u0001C\u0001s\"1\u0001\u0010\u0001C\u0001\u0003\u000fAa\u0001\u001f\u0001\u0005\u0002\u0005e\u0001B\u0002=\u0001\t\u0003\t9\u0003\u0003\u0004y\u0001\u0011\u0005\u00111\u0007\u0005\u0007q\u0002!\t!!\u0010\t\ra\u0004A\u0011AA#\u0011\u0019A\b\u0001\"\u0001\u0002L!1\u0001\u0010\u0001C\u0001\u0003\u001fBq!!\u0015\u0001\t\u0003\n\u0019\u0006C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000!1\u0011q\u0011\u0001\u0005BMDq!!#\u0001\t\u0003\nY\tC\u0004\u00024\u0002!\t%!.\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"9\u0011Q\u001d\u0001\u0005R\u0005\u001d\b\"CAz\u0001\u0005\u0005I\u0011AA{\u0011%\u00119\u0001AI\u0001\n\u0003\u0011I\u0001C\u0005\u0003 \u0001\t\n\u0011\"\u0001\u0003\n!I!\u0011\u0005\u0001\u0012\u0002\u0013\u0005!\u0011\u0002\u0005\n\u0005G\u0001\u0011\u0013!C\u0001\u0005\u0013A\u0011B!\n\u0001#\u0003%\tA!\u0003\t\u0013\t\u001d\u0002!%A\u0005\u0002\t%\u0001\"\u0003B\u0015\u0001E\u0005I\u0011\u0001B\u0005\u0011%\u0011Y\u0003AI\u0001\n\u0003\u0011i\u0003C\u0005\u00032\u0001\t\t\u0011\"\u0011\u00034!I!1\t\u0001\u0002\u0002\u0013\u0005!Q\t\u0005\n\u0005\u001b\u0002\u0011\u0011!C\u0001\u0005\u001fB\u0011B!\u0016\u0001\u0003\u0003%\tEa\u0016\t\u0013\t\u0015\u0004!!A\u0005\u0002\t\u001d\u0004\"\u0003B6\u0001\u0005\u0005I\u0011\tB7\u000f%\u00119jOA\u0001\u0012\u0003\u0011IJ\u0002\u0005;w\u0005\u0005\t\u0012\u0001BN\u0011\u0019A(\u0007\"\u0001\u0003*\"I!1\u0016\u001a\u0002\u0002\u0013\u0015#Q\u0016\u0005\n\u0005_\u0013\u0014\u0011!CA\u0005cC\u0011Ba13#\u0003%\tA!\f\t\u0013\t\u0015''!A\u0005\u0002\n\u001d\u0007\"\u0003BkeE\u0005I\u0011\u0001B\u0017\u0011%\u00119NMA\u0001\n\u0013\u0011IN\u0001\u0007NC.,\u0017J\u001c;feZ\fGN\u0003\u0002={\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqt(\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0015)A\u0002tc2T!AQ\"\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011+\u0015AB1qC\u000eDWMC\u0001G\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0011*\u0014)X;B\u0011!jS\u0007\u0002w%\u0011Aj\u000f\u0002\u0014'\u0016\u0004H/\u001a8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0015:K!aT\u001e\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0015+\u000f\u0005)\u0013\u0016BA*<\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u00111k\u000f\t\u00031nk\u0011!\u0017\u0006\u00025\u0006)1oY1mC&\u0011A,\u0017\u0002\b!J|G-^2u!\tAf,\u0003\u0002`3\na1+\u001a:jC2L'0\u00192mK\u0006)\u00110Z1sgV\t!\r\u0005\u0002KG&\u0011Am\u000f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB=fCJ\u001c\b%\u0001\u0004n_:$\bn]\u0001\b[>tG\u000f[:!\u0003\u00159X-Z6t\u0003\u00199X-Z6tA\u0005!A-Y=t\u0003\u0015!\u0017-_:!\u0003\u0015Aw.\u001e:t\u0003\u0019Aw.\u001e:tA\u0005!Q.\u001b8t\u0003\u0015i\u0017N\\:!\u0003\u0011\u0019XmY:\u0002\u000bM,7m\u001d\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002iB\u0011\u0001,^\u0005\u0003mf\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\rundXP`@\u0002\u0002\u0005\r\u0011Q\u0001\t\u0003\u0015\u0002AQ\u0001Y\tA\u0002\tDQAZ\tA\u0002\tDQ\u0001[\tA\u0002\tDQA[\tA\u0002\tDQ\u0001\\\tA\u0002\tDQA\\\tA\u0002\tDQ\u0001]\tA\u0002\tDqA]\t\u0011\u0002\u0003\u0007A\u000fF\b{\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0011\u0015\u0001'\u00031\u0001c\u0011\u00151'\u00031\u0001c\u0011\u0015A'\u00031\u0001c\u0011\u0015Q'\u00031\u0001c\u0011\u0015a'\u00031\u0001c\u0011\u0015q'\u00031\u0001c\u0011\u0019\t9B\u0005a\u0001E\u0006\u00191/Z2\u0015\u001bi\fY\"!\b\u0002 \u0005\u0005\u00121EA\u0013\u0011\u0015\u00017\u00031\u0001c\u0011\u001517\u00031\u0001c\u0011\u0015A7\u00031\u0001c\u0011\u0015Q7\u00031\u0001c\u0011\u0015a7\u00031\u0001c\u0011\u0015q7\u00031\u0001c)-Q\u0018\u0011FA\u0016\u0003[\ty#!\r\t\u000b\u0001$\u0002\u0019\u00012\t\u000b\u0019$\u0002\u0019\u00012\t\u000b!$\u0002\u0019\u00012\t\u000b)$\u0002\u0019\u00012\t\u000b1$\u0002\u0019\u00012\u0015\u0013i\f)$a\u000e\u0002:\u0005m\u0002\"\u00021\u0016\u0001\u0004\u0011\u0007\"\u00024\u0016\u0001\u0004\u0011\u0007\"\u00025\u0016\u0001\u0004\u0011\u0007\"\u00026\u0016\u0001\u0004\u0011Gc\u0002>\u0002@\u0005\u0005\u00131\t\u0005\u0006AZ\u0001\rA\u0019\u0005\u0006MZ\u0001\rA\u0019\u0005\u0006QZ\u0001\rA\u0019\u000b\u0006u\u0006\u001d\u0013\u0011\n\u0005\u0006A^\u0001\rA\u0019\u0005\u0006M^\u0001\rA\u0019\u000b\u0004u\u00065\u0003\"\u00021\u0019\u0001\u0004\u0011G#\u0001>\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"!!\u0016\u0011\u000b\u0005]\u0013Q\r2\u000f\t\u0005e\u00131\r\b\u0005\u00037\n\t'\u0004\u0002\u0002^)\u0019\u0011qL$\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0016BA*Z\u0013\u0011\t9'!\u001b\u0003\u0007M+\u0017O\u0003\u0002T3\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005=\u0004CBA,\u0003K\n\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9hP\u0001\u0006if\u0004Xm]\u0005\u0005\u0003w\n)H\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0002B!\u00111OAB\u0013\u0011\t))!\u001e\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0011\u0003\u001b\u000b\u0019*a&\u0002\u001c\u0006}\u00151UAT\u0003W\u00032\u0001WAH\u0013\r\t\t*\u0017\u0002\u0004\u0003:L\bbBAK=\u0001\u0007\u0011QR\u0001\u0005s\u0016\f'\u000fC\u0004\u0002\u001az\u0001\r!!$\u0002\u000b5|g\u000e\u001e5\t\u000f\u0005ue\u00041\u0001\u0002\u000e\u0006!q/Z3l\u0011\u001d\t\tK\ba\u0001\u0003\u001b\u000b1\u0001Z1z\u0011\u001d\t)K\ba\u0001\u0003\u001b\u000bA\u0001[8ve\"9\u0011\u0011\u0016\u0010A\u0002\u00055\u0015aA7j]\"9\u0011q\u0003\u0010A\u0002\u00055\u0006#\u0002-\u00020\u00065\u0015bAAY3\n1q\n\u001d;j_:\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005]\u00161YAg!\u0011\tI,a0\u000e\u0005\u0005m&bAA_w\u000591m\u001c3fO\u0016t\u0017\u0002BAa\u0003w\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u000b|\u0002\u0019AAd\u0003\r\u0019G\u000f\u001f\t\u0005\u0003s\u000bI-\u0003\u0003\u0002L\u0006m&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u001f|\u0002\u0019AA\\\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!6\u0011\t\u0005]\u0017q\u001c\b\u0005\u00033\fY\u000eE\u0002\u0002\\eK1!!8Z\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011]Ar\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\\-\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001>\u0002j\"9\u00111^\u0011A\u0002\u00055\u0018a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004R!a\u0016\u0002p\nLA!!=\u0002j\tQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0012u\u0006]\u0018\u0011`A~\u0003{\fyP!\u0001\u0003\u0004\t\u0015\u0001b\u00021#!\u0003\u0005\rA\u0019\u0005\bM\n\u0002\n\u00111\u0001c\u0011\u001dA'\u0005%AA\u0002\tDqA\u001b\u0012\u0011\u0002\u0003\u0007!\rC\u0004mEA\u0005\t\u0019\u00012\t\u000f9\u0014\u0003\u0013!a\u0001E\"9\u0001O\tI\u0001\u0002\u0004\u0011\u0007b\u0002:#!\u0003\u0005\r\u0001^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YAK\u0002c\u0005\u001bY#Aa\u0004\u0011\t\tE!1D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053I\u0016AC1o]>$\u0018\r^5p]&!!Q\u0004B\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012:\u0014AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005_Q3\u0001\u001eB\u0007\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0007\t\u0005\u0005o\u0011\t%\u0004\u0002\u0003:)!!1\bB\u001f\u0003\u0011a\u0017M\\4\u000b\u0005\t}\u0012\u0001\u00026bm\u0006LA!!9\u0003:\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\t\t\u00041\n%\u0013b\u0001B&3\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u0012B)\u0011%\u0011\u0019&LA\u0001\u0002\u0004\u00119%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00053\u0002bAa\u0017\u0003b\u00055UB\u0001B/\u0015\r\u0011y&W\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B2\u0005;\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019AO!\u001b\t\u0013\tMs&!AA\u0002\u00055\u0015AB3rk\u0006d7\u000fF\u0002u\u0005_B\u0011Ba\u00151\u0003\u0003\u0005\r!!$)/\u0001\u0011\u0019H!\u001f\u0003|\t}$\u0011\u0011BC\u0005\u000f\u0013YI!$\u0003\u0012\nM\u0005c\u0001&\u0003v%\u0019!qO\u001e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QP\u0001}?\u001a+fjQ0)s\u0016\f'o\u001d\u0017![>tG\u000f[:-A],Wm[:-A\u0011\f\u0017p\u001d\u0017!Q>,(o\u001d\u0017![&t7\u000f\f\u0011tK\u000e\u001c\u0018\u0006I\u0017!\u001b\u0006\\W\rI5oi\u0016\u0014h/\u00197!MJ|W\u000eI=fCJ\u001cH\u0006I7p]RD7\u000f\f\u0011xK\u0016\\7\u000f\f\u0011eCf\u001cH\u0006\t5pkJ\u001cH\u0006I7j]N\u0004\u0013M\u001c3!g\u0016\u001c7OL\u0001\nCJ<W/\\3oiN\f#Aa!\u0002\u0007\u001fS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I=fCJ\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011zK\u0006\u00148\u000f\f\u0011q_NLG/\u001b<fA=\u0014\bE\\3hCRLg/\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>tG\u000f[:![\u0001\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002jwN\u001c;ig2\u0002\u0003o\\:ji&4X\rI8sA9,w-\u0019;jm\u0016T\u0001\u0005\t\u0011!A\u0001R\u0003e^3fWN\u0004S\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\rI<fK.\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eCf\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011eCf\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011i_V\u00148\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!Q>,(o\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+A5Lgn\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gA5Lg.\u001e;fg2\u0002\u0003o\\:ji&4X\rI8sA9,w-\u0019;jm\u0016T\u0001\u0005\t\u0011!A\u0001R\u0003e]3dg\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007e]3d_:$7\u000fI<ji\"\u0004C\u000f[3!MJ\f7\r^5p]\u0006d\u0007\u0005]1si\u0002Jg\u000eI7jGJ|7/Z2p]\u0012\u0004\u0003O]3dSNLwN\u001c\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0013\u000b!Q\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cA\u0002D\u0006I\u00192Y\u0001\nD\u0006I\u0019-AE\u0012D\u0006I\u001a1Y\u0001\u0002\u0014G\f\u00191cA\u0002\u0014'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cA\u0002\u0004%_3beN\u0004\u0013'\r\u0011n_:$\bn\u001d\u00119A\u0011\f\u0017p\u001d\u00112e\u0001Bw.\u001e:tAM\u0002\u0004%\\5okR,7\u000fI\u0019/aA\n\u0004\u0007M\u0019!g\u0016\u001cwN\u001c3t\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0004\u0007\r\u0017!]VdG\u000e\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0002D\u0006I\u0019-AAb\u0003%\r\u0017!a1\u0002\u0003\u0007\f\u00112aAr\u0003\u0007\r\u00191aEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019![>tG\u000f[:!c\u0001\"\u0017-_:!c\u0001j\u0017N\\;uKN\u0004C\u0007\r\u00181aA\u0002\u0004'\r\u0011tK\u000e|g\u000eZ:\u000bA\u0001\nQa]5oG\u0016\f#Aa$\u0002\u000bMr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tU\u0015A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\r\u001b\u0006\\W-\u00138uKJ4\u0018\r\u001c\t\u0003\u0015J\u001aBA\rBO;Bi!q\u0014BSE\n\u0014'M\u00192cijl!A!)\u000b\u0007\t\r\u0016,A\u0004sk:$\u0018.\\3\n\t\t\u001d&\u0011\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:DDC\u0001BM\u0003!!xn\u0015;sS:<GC\u0001B\u001b\u0003\u0015\t\u0007\u000f\u001d7z)EQ(1\u0017B[\u0005o\u0013ILa/\u0003>\n}&\u0011\u0019\u0005\u0006AV\u0002\rA\u0019\u0005\u0006MV\u0002\rA\u0019\u0005\u0006QV\u0002\rA\u0019\u0005\u0006UV\u0002\rA\u0019\u0005\u0006YV\u0002\rA\u0019\u0005\u0006]V\u0002\rA\u0019\u0005\u0006aV\u0002\rA\u0019\u0005\beV\u0002\n\u00111\u0001u\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012B\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0013\u0014\t\u000eE\u0003Y\u0003_\u0013Y\rE\u0006Y\u0005\u001b\u0014'M\u00192cE\n$\u0018b\u0001Bh3\n1A+\u001e9mKbB\u0001Ba58\u0003\u0003\u0005\rA_\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bn!\u0011\u00119D!8\n\t\t}'\u0011\b\u0002\u0007\u001f\nTWm\u0019;")
public class MakeInterval
extends SeptenaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression years;
    private final Expression months;
    private final Expression weeks;
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$8() {
        return MakeInterval$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Object>> unapply(MakeInterval makeInterval) {
        return MakeInterval$.MODULE$.unapply(makeInterval);
    }

    public static boolean apply$default$8() {
        return MakeInterval$.MODULE$.apply$default$8();
    }

    public static Function1<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Object>, MakeInterval> tupled() {
        return MakeInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeInterval>>>>>>>> curried() {
        return MakeInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    public Expression weeks() {
        return this.weeks;
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.years(), this.months(), this.weeks(), this.days(), this.hours(), this.mins(), this.secs()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)}));
    }

    @Override
    public DataType dataType() {
        return CalendarIntervalType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nullable())) : true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object week, Object day, Object hour, Object min, Option<Object> sec) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = IntervalUtils$.MODULE$.makeInterval(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)week), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec.map((Function1 & Serializable & scala.Serializable)x$2 -> (Decimal)x$2).getOrElse((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof ArithmeticException) || this.failOnError()) {
                throw throwable;
            }
            CalendarInterval calendarInterval2 = null;
            calendarInterval = calendarInterval2;
        }
        return calendarInterval;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable & scala.Serializable)(year, month, week, day, hour, min, sec) -> {
            String iu = new StringOps(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            String secFrac = (String)sec.getOrElse((Function0 & Serializable & scala.Serializable)() -> "0");
            String failOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
            return new StringBuilder(136).append("\n        try {\n          ").append(ev.value()).append(" = ").append(iu).append(".makeInterval(").append((String)year).append(", ").append((String)month).append(", ").append((String)week).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", ").append(secFrac).append(");\n        } catch (java.lang.ArithmeticException e) {\n          ").append(failOnErrorBranch).append("\n        }\n      ").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_interval";
    }

    @Override
    public MakeInterval withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Expression)newChildren.apply(6), this.copy$default$8());
    }

    public MakeInterval copy(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, boolean failOnError) {
        return new MakeInterval(years, months, weeks, days, hours, mins, secs, failOnError);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    public Expression copy$default$3() {
        return this.weeks();
    }

    public Expression copy$default$4() {
        return this.days();
    }

    public Expression copy$default$5() {
        return this.hours();
    }

    public Expression copy$default$6() {
        return this.mins();
    }

    public Expression copy$default$7() {
        return this.secs();
    }

    public boolean copy$default$8() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeInterval";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.years();
                break;
            }
            case 1: {
                object = this.months();
                break;
            }
            case 2: {
                object = this.weeks();
                break;
            }
            case 3: {
                object = this.days();
                break;
            }
            case 4: {
                object = this.hours();
                break;
            }
            case 5: {
                object = this.mins();
                break;
            }
            case 6: {
                object = this.secs();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeInterval makeInterval = (MakeInterval)x$1;
        Expression expression = this.years();
        Expression expression2 = makeInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = makeInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.weeks();
        Expression expression6 = makeInterval.weeks();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.days();
        Expression expression8 = makeInterval.days();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.hours();
        Expression expression10 = makeInterval.hours();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.mins();
        Expression expression12 = makeInterval.mins();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Expression expression13 = this.secs();
        Expression expression14 = makeInterval.secs();
        if (expression13 == null) {
            if (expression14 != null) {
                return false;
            }
        } else if (!expression13.equals(expression14)) return false;
        if (this.failOnError() != makeInterval.failOnError()) return false;
        if (!makeInterval.canEqual(this)) return false;
        return true;
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, boolean failOnError) {
        this.years = years;
        this.months = months;
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression sec) {
        this(years, months, weeks, days, hours, mins, sec, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins) {
        this(years, months, weeks, days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours) {
        this(years, months, weeks, days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days) {
        this(years, months, weeks, days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks) {
        this(years, months, weeks, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months) {
        this(years, months, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

