/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005a\t\u0003\u0005K\u0001\tE\t\u0015!\u0003H\u0011!Y\u0005A!f\u0001\n\u0003\u0001\u0005\u0002\u0003'\u0001\u0005#\u0005\u000b\u0011B!\t\u000b5\u0003A\u0011\u0001(\t\u000b5\u0003A\u0011A*\t\u000b5\u0003A\u0011\u0001,\t\u000ba\u0003A\u0011I-\t\u000b%\u0004A\u0011\t6\t\u000b9\u0004A\u0011I8\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0005\u0001\u0001\"\u0015\u0002\u0004!I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003'\u0001\u0011\u0013!C\u0001\u0003+A\u0011\"a\u000b\u0001#\u0003%\t!!\f\t\u0013\u0005E\u0002!%A\u0005\u0002\u0005U\u0001\"CA\u001a\u0001\u0005\u0005I\u0011IA\u001b\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\f\u0005\n\u0003K\u0002\u0011\u0011!C\u0001\u0003OB\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\b\u0013\u0005u\u0015%!A\t\u0002\u0005}e\u0001\u0003\u0011\"\u0003\u0003E\t!!)\t\r5SB\u0011AAX\u0011%\t\tLGA\u0001\n\u000b\n\u0019\fC\u0005\u00026j\t\t\u0011\"!\u00028\"I\u0011q\u0018\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u0019\u0005\n\u0003\u001fT\u0012\u0011!C\u0005\u0003#\u0014\u0001\u0003U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9\u000b\u0005\t\u001a\u0013aC3yaJ,7o]5p]NT!\u0001J\u0013\u0002\u0011\r\fG/\u00197zgRT!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00184mq\u0002\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\r\u001b\n\u0005U\n#A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00028{%\u0011a\b\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001B!\t\u0001$)\u0003\u0002DC\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\r\u0019|'/\\1u+\u00059\u0005cA\u001cI\u0003&\u0011\u0011\n\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000f\u0019|'/\\1uA\u0005)1\r[5mI\u000611\r[5mI\u0002\na\u0001P5oSRtD\u0003B(Q#J\u0003\"\u0001\r\u0001\t\u000b}:\u0001\u0019A!\t\u000b\u0015;\u0001\u0019A$\t\u000b-;\u0001\u0019A!\u0015\u0007=#V\u000bC\u0003@\u0011\u0001\u0007\u0011\tC\u0003F\u0011\u0001\u0007\u0011\t\u0006\u0002P/\")q(\u0003a\u0001\u0003\u0006ia\r\\1u\u0003J<W/\\3oiN,\u0012A\u0017\t\u00047\u000e4gB\u0001/b\u001d\ti\u0006-D\u0001_\u0015\tyV&\u0001\u0004=e>|GOP\u0005\u0002s%\u0011!\rO\u0001\ba\u0006\u001c7.Y4f\u0013\t!WM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t\u0011\u0007\b\u0005\u00028O&\u0011\u0001\u000e\u000f\u0002\u0004\u0003:L\u0018!D3yaJ\u001c(+\u001a9mC\u000e,G-F\u0001l!\rYF.Q\u0005\u0003[\u0016\u00141aU3r\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002aB\u0011\u0011/\u001e\b\u0003eN\u0004\"!\u0018\u001d\n\u0005QD\u0014A\u0002)sK\u0012,g-\u0003\u0002wo\n11\u000b\u001e:j]\u001eT!\u0001\u001e\u001d\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{\u0016\nQ\u0001^=qKNL!a ?\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA(\u0002\u0006!1\u0011q\u0001\bA\u0002\u0005\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0004P\u0003\u001b\ty!!\u0005\t\u000f}z\u0001\u0013!a\u0001\u0003\"9Qi\u0004I\u0001\u0002\u00049\u0005bB&\u0010!\u0003\u0005\r!Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9BK\u0002B\u00033Y#!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003KA\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011FA\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyCK\u0002H\u00033\tabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0001B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0003mC:<'BAA!\u0003\u0011Q\u0017M^1\n\u0007Y\fY$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002JA\u0019q'a\u0013\n\u0007\u00055\u0003HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002g\u0003'B\u0011\"!\u0016\u0016\u0003\u0003\u0005\r!!\u0013\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u0006E\u0003\u0002^\u0005\rd-\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u001d\u0002\u0015\r|G\u000e\\3di&|g.C\u0002e\u0003?\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003S\ny\u0007E\u00028\u0003WJ1!!\u001c9\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0016\u0018\u0003\u0003\u0005\rAZ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u0014Q\u000f\u0005\t\u0003+B\u0012\u0011!a\u0001M\":\u0002!!\u001f\u0002\u0000\u0005\u0005\u0015QQAD\u0003\u0017\u000bi)!%\u0002\u0014\u0006]\u0015\u0011\u0014\t\u0004a\u0005m\u0014bAA?C\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAB\u0003\u0005\u0005(\u0002\t\u0011!A}3UKT\"`QQLW.Z:uC6\u0004xl\u001d;s72\u0002c-\u001c;^S\u0001j\u0003\u0005U1sg\u0016\u001c\b\u0005\u001e5fA\u0001$\u0018.\\3ti\u0006l\u0007oX:ue\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!o&$\b\u000e\t;iK\u0002\u0002g-\u001c;aA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003\u0005^8!C\u0002\"\u0018.\\3ti\u0006l\u0007O\f\u0011SKR,(O\\:!]VdG\u000eI<ji\"\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkRt\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001JG\u000f\t4pY2|wo\u001d\u0011dCN$\u0018N\\4!eVdWm\u001d\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0005\u0004C/[7fgR\fW\u000e\u001d\u0011jM\u0002\"\b.\u001a\u0011aM6$\b\rI5tA=l\u0017\u000e\u001e;fI:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!!#\u0002\u0005{Q\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t;j[\u0016\u001cH/Y7q?N$(\u000fI\u0017!\u0003\u0002\u001aHO]5oO\u0002\"x\u000e\t2fAA\f'o]3eAQ|\u0007\u0005^5nKN$\u0018-\u001c9/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u00012W\u000e\u001e\u0011.AQKW.Z:uC6\u0004\bEZ8s[\u0006$\b\u0005]1ui\u0016\u0014h\u000e\t;pA\u0019|G\u000e\\8x]\u0001\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006Z1uKRLW.Z\u0017qCR$XM\u001d8/QRlGN\t ECR,G/[7fAA\u000bG\u000f^3s]Ndt&\u0019 !M>\u0014\bE^1mS\u0012T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C-\u0019;fA\u0005tG\r\t;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt7O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0010\u0006\t\tF\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'L\u00193[M\n\u0004\u0005\r\u0019;cIR\u0004\u0007M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001c.cIj3'\r\u00111ai\n$G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[E\u0012TfM\u0019(Y\u0001:\u00130_=z[5kU\u0006\u001a3(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00197[E\u0012TfM\u0019!aAR\u0004\u0007\r\u001e1a)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002\u0016\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAN\u0003\u0015\u0011dF\r\u00181\u0003A\u0001\u0016M]:f)>$\u0016.\\3ti\u0006l\u0007\u000f\u0005\u000215M!!$a)=!!\t)+a+B\u000f\u0006{UBAAT\u0015\r\tI\u000bO\u0001\beVtG/[7f\u0013\u0011\ti+a*\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002 \u0006AAo\\*ue&tw\r\u0006\u0002\u00028\u0005)\u0011\r\u001d9msR9q*!/\u0002<\u0006u\u0006\"B \u001e\u0001\u0004\t\u0005\"B#\u001e\u0001\u00049\u0005\"B&\u001e\u0001\u0004\t\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\fY\r\u0005\u00038\u0011\u0006\u0015\u0007CB\u001c\u0002H\u0006;\u0015)C\u0002\u0002Jb\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAg=\u0005\u0005\t\u0019A(\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAj!\u0011\tI$!6\n\t\u0005]\u00171\b\u0002\u0007\u001f\nTWm\u0019;")
public class ParseToTimestamp
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToTimestamp>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public String prettyName() {
        return "to_timestamp";
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public ParseToTimestamp withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToTimestamp(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestamp.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new GetTimestamp(left, format, GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()));
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

