/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.PercentRank$;
import org.apache.spark.sql.catalyst.expressions.RankLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Computes the percentage ranking of a value in a group of values.\n  ", arguments="\n    Arguments:\n      * children - this is to base the rank on; a change in the value of one the children will\n          trigger a change in rank. This is an internal parameter and will be assigned by the\n          Analyser.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t0.0\n       A1\t1\t0.0\n       A1\t2\t1.0\n       A2\t3\t0.0\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005w!)1\n\u0001C\u0001\u0019\")1\n\u0001C\u0001\u001f\")\u0001\u000b\u0001C!#\")A\u000b\u0001C!+\"9A\f\u0001b\u0001\n\u0003j\u0006BB1\u0001A\u0003%a\fC\u0003c\u0001\u0011\u00053\rC\u0003m\u0001\u0011ES\u000eC\u0004t\u0001\u0005\u0005I\u0011\u0001;\t\u000fY\u0004\u0011\u0013!C\u0001o\"I\u0011Q\u0001\u0001\u0002\u0002\u0013\u0005\u0013q\u0001\u0005\n\u0003/\u0001\u0011\u0011!C\u0001\u00033A\u0011\"!\t\u0001\u0003\u0003%\t!a\t\t\u0013\u0005=\u0002!!A\u0005B\u0005E\u0002\"CA \u0001\u0005\u0005I\u0011AA!\u0011%\tY\u0005AA\u0001\n\u0003\nieB\u0005\u0002xm\t\t\u0011#\u0001\u0002z\u0019A!dGA\u0001\u0012\u0003\tY\b\u0003\u0004L)\u0011\u0005\u0011\u0011\u0012\u0005\n\u0003\u0017#\u0012\u0011!C#\u0003\u001bC\u0011\"a$\u0015\u0003\u0003%\t)!%\t\u0013\u0005UE#!A\u0005\u0002\u0006]\u0005\"CAR)\u0005\u0005I\u0011BAS\u0005-\u0001VM]2f]R\u0014\u0016M\\6\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u0015.aY\u0002\"AK\u0016\u000e\u0003mI!\u0001L\u000e\u0003\u0011I\u000bgn\u001b'jW\u0016\u0004\"A\u000b\u0018\n\u0005=Z\"aF*ju\u0016\u0014\u0015m]3e/&tGm\\<Gk:\u001cG/[8o!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u001d\u0001&o\u001c3vGR\u0004\"!M\u001c\n\u0005a\u0012$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001C2iS2$'/\u001a8\u0016\u0003m\u00022\u0001\u0010#H\u001d\ti$I\u0004\u0002?\u00036\tqH\u0003\u0002AO\u00051AH]8pizJ\u0011aM\u0005\u0003\u0007J\nq\u0001]1dW\u0006<W-\u0003\u0002F\r\n\u00191+Z9\u000b\u0005\r\u0013\u0004C\u0001\u0016I\u0013\tI5D\u0001\u0006FqB\u0014Xm]:j_:\f\u0011b\u00195jY\u0012\u0014XM\u001c\u0011\u0002\rqJg.\u001b;?)\tie\n\u0005\u0002+\u0001!)\u0011h\u0001a\u0001wQ\tQ*A\u0005xSRDwJ\u001d3feR\u0011QJ\u0015\u0005\u0006'\u0016\u0001\raO\u0001\u0006_J$WM]\u0001\tI\u0006$\u0018\rV=qKV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Z?\u0005)A/\u001f9fg&\u00111\f\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006\u0011RM^1mk\u0006$X-\u0012=qe\u0016\u001c8/[8o+\u0005q\u0006C\u0001\u0016`\u0013\t\u00017D\u0001\u0002JM\u0006\u0019RM^1mk\u0006$X-\u0012=qe\u0016\u001c8/[8oA\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003\u0011\u0004\"!Z5\u000f\u0005\u0019<\u0007C\u0001 3\u0013\tA''\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u000153\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0002N]\")qN\u0003a\u0001a\u0006Ya.Z<DQ&dGM]3o!\ra\u0014oR\u0005\u0003e\u001a\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u00055+\bbB\u001d\f!\u0003\u0005\raO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005A(FA\u001ezW\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u007fJ\n!\"\u00198o_R\fG/[8o\u0013\r\t\u0019\u0001 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00027b]\u001eT!!a\u0005\u0002\t)\fg/Y\u0005\u0004U\u00065\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u000e!\r\t\u0014QD\u0005\u0004\u0003?\u0011$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0013\u0003W\u00012!MA\u0014\u0013\r\tIC\r\u0002\u0004\u0003:L\b\"CA\u0017\u001f\u0005\u0005\t\u0019AA\u000e\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0007\t\u0007\u0003k\tY$!\n\u000e\u0005\u0005]\"bAA\u001de\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0012q\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002D\u0005%\u0003cA\u0019\u0002F%\u0019\u0011q\t\u001a\u0003\u000f\t{w\u000e\\3b]\"I\u0011QF\t\u0002\u0002\u0003\u0007\u0011QE\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0013q\n\u0005\n\u0003[\u0011\u0012\u0011!a\u0001\u0003KAs\u0003AA*\u00033\nY&a\u0018\u0002b\u0005\u0015\u0014qMA6\u0003[\n\t(a\u001d\u0011\u0007)\n)&C\u0002\u0002Xm\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002^\u0005\u0019&\u0002\t\u0011!A}3UKT\"`Q%\u0002S\u0006I\"p[B,H/Z:!i\",\u0007\u0005]3sG\u0016tG/Y4fAI\fgn[5oO\u0002zg\rI1!m\u0006dW/\u001a\u0011j]\u0002\n\u0007e\u001a:pkB\u0004sN\u001a\u0011wC2,Xm\u001d\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\r\u0014!a2\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001a\u0007.\u001b7ee\u0016t\u0007%\f\u0011uQ&\u001c\b%[:!i>\u0004#-Y:fAQDW\r\t:b].\u0004sN\\\u001e!C\u0002\u001a\u0007.\u00198hK\u0002Jg\u000e\t;iK\u00022\u0018\r\\;fA=4\u0007e\u001c8fAQDW\rI2iS2$'/\u001a8!o&dGN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014\u0018nZ4fe\u0002\n\u0007e\u00195b]\u001e,\u0007%\u001b8!e\u0006t7N\f\u0011UQ&\u001c\b%[:!C:\u0004\u0013N\u001c;fe:\fG\u000e\t9be\u0006lW\r^3sA\u0005tG\rI<jY2\u0004#-\u001a\u0011bgNLwM\\3eA\tL\b\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00118bYf\u001cXM\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003S\n\u0011q\u0015\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!C2\u0002#\r\f\u0011`\rVs5i\u0018\u0015cS\u0001ze+\u0012*!QA\u000b%\u000bV%U\u0013>s\u0005EQ-!C\u0002z%\u000bR#SA\tK\u0006EY\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015(\u0003F:C\u0006\t\u001a*Y\u0001Bs%Q\u0019(Y\u0001\n\u0014\u0006\f\u0011)O\u0005\u0013t\u0005\f\u00114S1\u0002\u0003fJ!2O1\u0002\u0013'\u000b\u0011uC\nD\u0013\r\f\u0011cSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00052\u0013Ar\u0003G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0001G\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!'C\u0019/a)\u0001\u0003\u0005\t\u0011!A\u0001\n%'C\u001a\na9\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005=\u0014!\u0002\u001a/a9\u0002\u0014!B4s_V\u0004\u0018EAA;\u000319\u0018N\u001c3po~3WO\\2t\u0003-\u0001VM]2f]R\u0014\u0016M\\6\u0011\u0005)\"2\u0003\u0002\u000b\u0002~Y\u0002b!a \u0002\u0006njUBAAA\u0015\r\t\u0019IM\u0001\beVtG/[7f\u0013\u0011\t9)!!\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002z\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\n\u0005)\u0011\r\u001d9msR\u0019Q*a%\t\u000be:\u0002\u0019A\u001e\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011TAP!\u0011\t\u00141T\u001e\n\u0007\u0005u%G\u0001\u0004PaRLwN\u001c\u0005\t\u0003CC\u0012\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003O\u0003B!a\u0003\u0002*&!\u00111VA\u0007\u0005\u0019y%M[3di\u0002")
public class PercentRank
extends RankLike
implements SizeBasedWindowFunction {
    private final Seq<Expression> children;
    private final If evaluateExpression;
    private final AttributeReference n;

    public static Option<Seq<Expression>> unapply(PercentRank percentRank) {
        return PercentRank$.MODULE$.unapply(percentRank);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<PercentRank, A> function1) {
        return PercentRank$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PercentRank> compose(Function1<A, Seq<Expression>> function1) {
        return PercentRank$.MODULE$.compose(function1);
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public PercentRank withOrder(Seq<Expression> order) {
        return new PercentRank(order);
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public If evaluateExpression() {
        return this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "percent_rank";
    }

    @Override
    public PercentRank withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public PercentRank copy(Seq<Expression> children2) {
        return new PercentRank(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "PercentRank";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PercentRank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PercentRank)) return false;
        boolean bl = true;
        if (!bl) return false;
        PercentRank percentRank = (PercentRank)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = percentRank.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!percentRank.canEqual(this)) return false;
        return true;
    }

    public PercentRank(Seq<Expression> children2) {
        this.children = children2;
        SizeBasedWindowFunction.$init$(this);
        this.evaluateExpression = new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.n()).$greater(this.one())), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.rank()).$minus(this.one())).cast(DoubleType$.MODULE$)).$div(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$minus(this.one())).cast(DoubleType$.MODULE$)), package$expressions$.MODULE$.doubleToLiteral(0.0));
    }

    public PercentRank() {
        this((Seq<Expression>)Nil$.MODULE$);
    }
}

