/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVInferSchema;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SchemaOfCsv$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(csv[, options]) - Returns schema in the DDL format of CSV string.", examples="\n    Examples:\n      > SELECT _FUNC_('1,abc');\n       STRUCT<`_c0`: INT, `_c1`: STRING>\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0010!\u00016B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005X\u0001\tE\t\u0015!\u0003J\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015A\u0006\u0001\"\u0001^\u0011\u0015A\u0006\u0001\"\u0001`\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015Q\u0007\u0001\"\u0011l\u0011!y\u0007\u0001#b\u0001\n\u0013\u0001\b\"\u0002?\u0001\t\u0003j\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\t\u0019\u0003\u0001C)\u0003KA\u0011\"a\u000b\u0001\u0003\u0003%\t!!\f\t\u0013\u0005M\u0002!%A\u0005\u0002\u0005U\u0002\"CA&\u0001E\u0005I\u0011AA'\u0011%\t\t\u0006AA\u0001\n\u0003\n\u0019\u0006C\u0005\u0002d\u0001\t\t\u0011\"\u0001\u0002f!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0003k\u0002\u0011\u0011!C!\u0003oB\u0011\"!\"\u0001\u0003\u0003%\t!a\"\t\u0013\u0005-\u0005!!A\u0005B\u00055u!CAYA\u0005\u0005\t\u0012AAZ\r!y\u0002%!A\t\u0002\u0005U\u0006B\u0002-\u001a\t\u0003\t\u0019\rC\u0005\u0002Ff\t\t\u0011\"\u0012\u0002H\"I\u0011\u0011Z\r\u0002\u0002\u0013\u0005\u00151\u001a\u0005\n\u0003#L\u0012\u0011!CA\u0003'D\u0011\"!:\u001a\u0003\u0003%I!a:\u0003\u0017M\u001b\u0007.Z7b\u001f\u001a\u001c5O\u001e\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M)\u0001A\f\u001a9}A\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u00111GN\u0007\u0002i)\u0011Q\u0007I\u0001\bG>$WmZ3o\u0013\t9DGA\bD_\u0012,w-\u001a8GC2d'-Y2l!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u001d\u0001&o\u001c3vGR\u0004\"!O \n\u0005\u0001S$\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#A\"\u0011\u0005=\"\u0015BA#!\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u000f=\u0004H/[8ogV\t\u0011\n\u0005\u0003K#R#fBA&P!\ta%(D\u0001N\u0015\tqE&\u0001\u0004=e>|GOP\u0005\u0003!j\na\u0001\u0015:fI\u00164\u0017B\u0001*T\u0005\ri\u0015\r\u001d\u0006\u0003!j\u0002\"AS+\n\u0005Y\u001b&AB*ue&tw-\u0001\u0005paRLwN\\:!\u0003\u0019a\u0014N\\5u}Q\u0019!l\u0017/\u0011\u0005=\u0002\u0001\"B!\u0006\u0001\u0004\u0019\u0005\"B$\u0006\u0001\u0004IEC\u0001._\u0011\u0015\te\u00011\u0001D)\rQ\u0006-\u0019\u0005\u0006\u0003\u001e\u0001\ra\u0011\u0005\u0006\u000f\u001e\u0001\raQ\u0001\tI\u0006$\u0018\rV=qKV\tA\r\u0005\u0002fQ6\taM\u0003\u0002hI\u0005)A/\u001f9fg&\u0011\u0011N\u001a\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-F\u0001m!\tIT.\u0003\u0002ou\t9!i\\8mK\u0006t\u0017aA2tmV\t\u0011\u000f\u0005\u0002sm6\t1O\u0003\u0002hi*\u0011QOJ\u0001\u0007k:\u001c\u0018MZ3\n\u0005]\u001c(AC+U\rb\u001aFO]5oO\"\u0012!\"\u001f\t\u0003siL!a\u001f\u001e\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#\u0001@\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0012\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u0002\u0002\u0002\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0003fm\u0006dG\u0003BA\u0007\u0003'\u00012!OA\b\u0013\r\t\tB\u000f\u0002\u0004\u0003:L\b\"CA\u000b\u0019A\u0005\t\u0019AA\f\u0003\u00051\b\u0003BA\r\u00037i\u0011AI\u0005\u0004\u0003;\u0011#aC%oi\u0016\u0014h.\u00197S_^\f!\u0002\u001d:fiRLh*Y7f+\u0005!\u0016\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002[\u0003OAa!!\u000b\u000f\u0001\u0004\u0019\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u00065\u0006=\u0012\u0011\u0007\u0005\b\u0003>\u0001\n\u00111\u0001D\u0011\u001d9u\u0002%AA\u0002%\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00028)\u001a1)!\u000f,\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0012;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\nyDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002P)\u001a\u0011*!\u000f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0006\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\t1\fgn\u001a\u0006\u0003\u0003?\nAA[1wC&\u0019a+!\u0017\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0004cA\u001d\u0002j%\u0019\u00111\u000e\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u0011\u0011\u000f\u0005\n\u0003g\"\u0012\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA=!\u0019\tY(!!\u0002\u000e5\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fR\u0014AC2pY2,7\r^5p]&!\u00111QA?\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u00071\fI\tC\u0005\u0002tY\t\t\u00111\u0001\u0002\u000e\u00051Q-];bYN$2\u0001\\AH\u0011%\t\u0019hFA\u0001\u0002\u0004\ti\u0001K\n\u0001\u0003'\u000bI*a'\u0002 \u0006\u0005\u0016QUAT\u0003W\u000bi\u000bE\u00020\u0003+K1!a&!\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!(\u0002\u0011~3UKT\"`Q\r\u001cho\u0017\u0017!_B$\u0018n\u001c8t;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011tG\",W.\u0019\u0011j]\u0002\"\b.\u001a\u0011E\t2\u0003cm\u001c:nCR\u0004sN\u001a\u0011D'Z\u00033\u000f\u001e:j]\u001et\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0016A\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OEb\u0013MY2(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b\u0016*V\u0007Rc\u0004mX21Aj\u0002\u0013J\u0014+-A\u0001|6-\r1;AM#&+\u0013(H})\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002*\u0006)1G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011qV\u0001\nGN4xLZ;oGN\f1bU2iK6\fwJZ\"tmB\u0011q&G\n\u00053\u0005]f\bE\u0004\u0002:\u0006}6)\u0013.\u000e\u0005\u0005m&bAA_u\u00059!/\u001e8uS6,\u0017\u0002BAa\u0003w\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t\u0019,\u0001\u0005u_N#(/\u001b8h)\t\t)&A\u0003baBd\u0017\u0010F\u0003[\u0003\u001b\fy\rC\u0003B9\u0001\u00071\tC\u0003H9\u0001\u0007\u0011*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U\u0017\u0011\u001d\t\u0006s\u0005]\u00171\\\u0005\u0004\u00033T$AB(qi&|g\u000eE\u0003:\u0003;\u001c\u0015*C\u0002\u0002`j\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAr;\u0005\u0005\t\u0019\u0001.\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAu!\u0011\t9&a;\n\t\u00055\u0018\u0011\f\u0002\u0007\u001f\nTWm\u0019;")
public class SchemaOfCsv
extends UnaryExpression
implements CodegenFallback,
scala.Serializable {
    private transient UTF8String csv;
    private final Expression child;
    private final Map<String, String> options;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Map<String, String>>> unapply(SchemaOfCsv schemaOfCsv) {
        return SchemaOfCsv$.MODULE$.unapply(schemaOfCsv);
    }

    public static Function1<Tuple2<Expression, Map<String, String>>, SchemaOfCsv> tupled() {
        return SchemaOfCsv$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Map<String, String>, SchemaOfCsv>> curried() {
        return SchemaOfCsv$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private UTF8String csv$lzycompute() {
        SchemaOfCsv schemaOfCsv = this;
        synchronized (schemaOfCsv) {
            if (!this.bitmap$trans$0) {
                this.csv = (UTF8String)this.child().eval(this.child().eval$default$1());
                this.bitmap$trans$0 = true;
            }
        }
        return this.csv;
    }

    private UTF8String csv() {
        return !this.bitmap$trans$0 ? this.csv$lzycompute() : this.csv;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.child().foldable() && this.csv() != null ? super.checkInputDataTypes() : new TypeCheckResult.TypeCheckFailure(new StringBuilder(81).append("The input csv should be a foldable string expression and not null; ").append("however, got ").append(this.child().sql()).append(".").toString());
    }

    @Override
    public Object eval(InternalRow v) {
        CSVOptions parsedOptions = new CSVOptions(this.options(), true, "UTC");
        CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
        String[] row = parser.parseLine(this.csv().toString());
        Predef$.MODULE$.assert(row != null, (Function0 & Serializable & scala.Serializable)() -> "Parsed CSV record should not be null.");
        String[] header = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int index = tuple2._2$mcI$sp();
            String string = new StringBuilder(2).append("_c").append(index).toString();
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
        CSVInferSchema inferSchema = new CSVInferSchema(parsedOptions);
        DataType[] fieldTypes = inferSchema.inferRowType(startType, row);
        StructType st = new StructType(inferSchema.toStructFields(fieldTypes, header));
        return UTF8String.fromString((String)st.sql());
    }

    @Override
    public String prettyName() {
        return "schema_of_csv";
    }

    @Override
    public SchemaOfCsv withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public SchemaOfCsv copy(Expression child, Map<String, String> options) {
        return new SchemaOfCsv(child, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfCsv";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Map<String, String> map;
        int n = x$1;
        switch (n) {
            case 0: {
                map = this.child();
                break;
            }
            case 1: {
                map = this.options();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return map;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfCsv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfCsv schemaOfCsv = (SchemaOfCsv)x$1;
        Expression expression = this.child();
        Expression expression2 = schemaOfCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = schemaOfCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!schemaOfCsv.canEqual(this)) return false;
        return true;
    }

    public SchemaOfCsv(Expression child, Map<String, String> options) {
        this.child = child;
        this.options = options;
        CodegenFallback.$init$(this);
    }

    public SchemaOfCsv(Expression child) {
        this(child, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public SchemaOfCsv(Expression child, Expression options) {
        this(child, ExprUtils$.MODULE$.convertToMapData(options));
    }
}

