/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SchemaOfJson$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(json[, options]) - Returns schema in the DDL format of JSON string.", examples="\n    Examples:\n      > SELECT _FUNC_('[{\"col\":0}]');\n       ARRAY<STRUCT<`col`: BIGINT>>\n      > SELECT _FUNC_('[{\"col\":01}]', map('allowNumericLeadingZeros', 'true'));\n       ARRAY<STRUCT<`col`: BIGINT>>\n  ", group="json_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t=b\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005[\u0001\tE\t\u0015!\u0003M\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015Y\u0006\u0001\"\u0001a\u0011\u0015Y\u0006\u0001\"\u0001c\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015i\u0007\u0001\"\u0011o\u0011!\u0011\b\u0001#b\u0001\n\u0013\u0019\b\u0002\u0003@\u0001\u0011\u000b\u0007I\u0011B@\t\u0015\u0005m\u0001\u0001#b\u0001\n\u0013\ti\u0002C\u0005x\u0001!\u0015\r\u0011\"\u0003\u0002(!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003?\u0002A\u0011IA1\u0011\u001d\t\u0019\u0007\u0001C)\u0003KB\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005M\u0004!%A\u0005\u0002\u0005U\u0004\"CAF\u0001E\u0005I\u0011AAG\u0011%\t\t\nAA\u0001\n\u0003\n\u0019\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0002&\"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003k\u0003\u0011\u0011!C!\u0003oC\u0011\"!2\u0001\u0003\u0003%\t!a2\t\u0013\u0005-\u0007!!A\u0005B\u00055w!CAyG\u0005\u0005\t\u0012AAz\r!\u00113%!A\t\u0002\u0005U\bBB.\u001d\t\u0003\u0011\u0019\u0001C\u0005\u0003\u0006q\t\t\u0011\"\u0012\u0003\b!I!\u0011\u0002\u000f\u0002\u0002\u0013\u0005%1\u0002\u0005\n\u0005#a\u0012\u0011!CA\u0005'A\u0011B!\n\u001d\u0003\u0003%IAa\n\u0003\u0019M\u001b\u0007.Z7b\u001f\u001aT5o\u001c8\u000b\u0005\u0011*\u0013aC3yaJ,7o]5p]NT!AJ\u0014\u0002\u0011\r\fG/\u00197zgRT!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00196w\u0005\u0003\"AM\u001a\u000e\u0003\rJ!\u0001N\u0012\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u0012\u0002\u000f\r|G-Z4f]&\u0011!h\u000e\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\u001fC\u0013\t\u0019UH\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001G!\t\u0011t)\u0003\u0002IG\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u001dy\u0007\u000f^5p]N,\u0012\u0001\u0014\t\u0005\u001bR;vK\u0004\u0002O%B\u0011q*P\u0007\u0002!*\u0011\u0011kL\u0001\u0007yI|w\u000e\u001e \n\u0005Mk\u0014A\u0002)sK\u0012,g-\u0003\u0002V-\n\u0019Q*\u00199\u000b\u0005Mk\u0004CA'Y\u0013\tIfK\u0001\u0004TiJLgnZ\u0001\t_B$\u0018n\u001c8tA\u00051A(\u001b8jiz\"2!\u00180`!\t\u0011\u0004\u0001C\u0003E\u000b\u0001\u0007a\tC\u0003K\u000b\u0001\u0007A\n\u0006\u0002^C\")AI\u0002a\u0001\rR\u0019Ql\u00193\t\u000b\u0011;\u0001\u0019\u0001$\t\u000b);\u0001\u0019\u0001$\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u001e\nQ\u0001^=qKNL!\u0001\\5\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002_B\u0011A\b]\u0005\u0003cv\u0012qAQ8pY\u0016\fg.A\u0006kg>tw\n\u001d;j_:\u001cX#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005],\u0013\u0001\u00026t_:L!!\u001f<\u0003\u0017)\u001bvJT(qi&|gn\u001d\u0015\u0003\u0015m\u0004\"\u0001\u0010?\n\u0005ul$!\u0003;sC:\u001c\u0018.\u001a8u\u0003-Q7o\u001c8GC\u000e$xN]=\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003+i!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0005G>\u0014XM\u0003\u0003\u0002\f\u00055\u0011a\u00026bG.\u001cxN\u001c\u0006\u0005\u0003\u001f\t\t\"A\u0005gCN$XM\u001d=nY*\u0011\u00111C\u0001\u0004G>l\u0017\u0002BA\f\u0003\u000b\u00111BS:p]\u001a\u000b7\r^8ss\"\u00121b_\u0001\u0010UN|g.\u00138gKJ\u001c6\r[3nCV\u0011\u0011q\u0004\t\u0004k\u0006\u0005\u0012bAA\u0012m\ny!j]8o\u0013:4WM]*dQ\u0016l\u0017\r\u000b\u0002\rwV\u0011\u0011\u0011\u0006\t\u0005\u0003W\t\u0019$\u0004\u0002\u0002.)\u0019!.a\f\u000b\u0007\u0005E\u0012&\u0001\u0004v]N\fg-Z\u0005\u0005\u0003k\tiC\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD#!D>\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005u\u0002\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\rS%\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t9%!\u0011\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fA!\u001a<bYR!\u0011QJA*!\ra\u0014qJ\u0005\u0004\u0003#j$aA!os\"I\u0011QK\b\u0011\u0002\u0003\u0007\u0011qK\u0001\u0002mB!\u0011\u0011LA.\u001b\u0005)\u0013bAA/K\tY\u0011J\u001c;fe:\fGNU8x\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002/\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2!XA4\u0011\u0019\tI'\u0005a\u0001\r\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#B/\u0002p\u0005E\u0004b\u0002#\u0013!\u0003\u0005\rA\u0012\u0005\b\u0015J\u0001\n\u00111\u0001M\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001e+\u0007\u0019\u000bIh\u000b\u0002\u0002|A!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015!C;oG\",7m[3e\u0015\r\t))P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAE\u0003\u007f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a$+\u00071\u000bI(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003+\u0003B!a&\u0002\"6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*\u0001\u0003mC:<'BAAP\u0003\u0011Q\u0017M^1\n\u0007e\u000bI*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002(B\u0019A(!+\n\u0007\u0005-VHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002N\u0005E\u0006\"CAZ/\u0005\u0005\t\u0019AAT\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0018\t\u0007\u0003w\u000b\t-!\u0014\u000e\u0005\u0005u&bAA`{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0017Q\u0018\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002p\u0003\u0013D\u0011\"a-\u001a\u0003\u0003\u0005\r!!\u0014\u0002\r\u0015\fX/\u00197t)\ry\u0017q\u001a\u0005\n\u0003gS\u0012\u0011!a\u0001\u0003\u001bB3\u0003AAj\u00033\fY.a8\u0002b\u0006\u0015\u0018q]Av\u0003[\u00042AMAk\u0013\r\t9n\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti.\u0001&`\rVs5i\u0018\u0015kg>t7\f\f\u0011paRLwN\\:^S\u0001j\u0003EU3ukJt7\u000fI:dQ\u0016l\u0017\rI5oAQDW\r\t#E\u0019\u00022wN]7bi\u0002zg\r\t&T\u001f:\u00033\u000f\u001e:j]\u001et\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0018!a(\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ6PI2pY\nR\u0004'`/(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013I\u0015*B3r\u001aFKU+D)r\u00027m\u001c7au\u0001\u0012\u0015jR%O)zr$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014\\w\n\u001aw\u000e\u001c\u0012;aEjXl\n\u0017![\u0006\u0004\bfJ1mY><h*^7fe&\u001cG*Z1eS:<',\u001a:pg\u001eb\u0003e\n;sk\u0016<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003J\u0013\u0016)\u0017\u001fT)J+6\t\u0016\u001faG>d\u0007M\u000f\u0011C\u0013\u001eKe\n\u0016 ?\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAu\u0003)Q7o\u001c8`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003_\fQA\r\u00185]A\nAbU2iK6\fwJ\u001a&t_:\u0004\"A\r\u000f\u0014\tq\t90\u0011\t\b\u0003s\fyP\u0012'^\u001b\t\tYPC\u0002\u0002~v\nqA];oi&lW-\u0003\u0003\u0003\u0002\u0005m(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u00111_\u0001\ti>\u001cFO]5oOR\u0011\u0011QS\u0001\u0006CB\u0004H.\u001f\u000b\u0006;\n5!q\u0002\u0005\u0006\t~\u0001\rA\u0012\u0005\u0006\u0015~\u0001\r\u0001T\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)B!\t\u0011\u000bq\u00129Ba\u0007\n\u0007\teQH\u0001\u0004PaRLwN\u001c\t\u0006y\tua\tT\u0005\u0004\u0005?i$A\u0002+va2,'\u0007\u0003\u0005\u0003$\u0001\n\t\u00111\u0001^\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003*A!\u0011q\u0013B\u0016\u0013\u0011\u0011i#!'\u0003\r=\u0013'.Z2u\u0001")
public class SchemaOfJson
extends UnaryExpression
implements CodegenFallback,
scala.Serializable {
    private transient JSONOptions jsonOptions;
    private transient JsonFactory jsonFactory;
    private transient JsonInferSchema jsonInferSchema;
    private transient UTF8String json;
    private final Expression child;
    private final Map<String, String> options;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Map<String, String>>> unapply(SchemaOfJson schemaOfJson) {
        return SchemaOfJson$.MODULE$.unapply(schemaOfJson);
    }

    public static Function1<Tuple2<Expression, Map<String, String>>, SchemaOfJson> tupled() {
        return SchemaOfJson$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Map<String, String>, SchemaOfJson>> curried() {
        return SchemaOfJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private JSONOptions jsonOptions$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.jsonOptions = new JSONOptions(this.options(), "UTC", JSONOptions$.MODULE$.$lessinit$greater$default$3());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.jsonOptions;
    }

    private JSONOptions jsonOptions() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.jsonOptions$lzycompute() : this.jsonOptions;
    }

    private JsonFactory jsonFactory$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.jsonFactory = this.jsonOptions().buildJsonFactory();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.jsonFactory;
    }

    private JsonFactory jsonFactory() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.jsonFactory$lzycompute() : this.jsonFactory;
    }

    private JsonInferSchema jsonInferSchema$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.jsonInferSchema = new JsonInferSchema(this.jsonOptions());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.jsonInferSchema;
    }

    private JsonInferSchema jsonInferSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.jsonInferSchema$lzycompute() : this.jsonInferSchema;
    }

    private UTF8String json$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.json = (UTF8String)this.child().eval(this.child().eval$default$1());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.json;
    }

    private UTF8String json() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.json$lzycompute() : this.json;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.child().foldable() && this.json() != null ? super.checkInputDataTypes() : new TypeCheckResult.TypeCheckFailure(new StringBuilder(82).append("The input json should be a foldable string expression and not null; ").append("however, got ").append(this.child().sql()).append(".").toString());
    }

    @Override
    public Object eval(InternalRow v) {
        DataType dt = (DataType)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(this.jsonFactory(), this.json()), (Function1 & Serializable & scala.Serializable)parser -> {
            ArrayType arrayType;
            DataType dataType;
            parser.nextToken();
            DataType dataType2 = this.jsonInferSchema().inferField((JsonParser)parser);
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(structType, this.jsonOptions()).getOrElse((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$));
            } else if (dataType2 instanceof ArrayType && (arrayType = (ArrayType)dataType2).elementType() instanceof StructType) {
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(arrayType.elementType(), this.jsonOptions()).map((Function1 & Serializable & scala.Serializable)x$16 -> new ArrayType((DataType)x$16, arrayType.containsNull())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ArrayType(StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$), arrayType.containsNull()));
            } else if (dataType2 != null) {
                DataType dataType3 = dataType2;
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(dataType3, this.jsonOptions()).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
            } else {
                throw new MatchError((Object)dataType2);
            }
            return dataType;
        });
        return UTF8String.fromString((String)dt.sql());
    }

    @Override
    public String prettyName() {
        return "schema_of_json";
    }

    @Override
    public SchemaOfJson withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public SchemaOfJson copy(Expression child, Map<String, String> options) {
        return new SchemaOfJson(child, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfJson";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Map<String, String> map;
        int n = x$1;
        switch (n) {
            case 0: {
                map = this.child();
                break;
            }
            case 1: {
                map = this.options();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return map;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfJson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfJson schemaOfJson = (SchemaOfJson)x$1;
        Expression expression = this.child();
        Expression expression2 = schemaOfJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = schemaOfJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!schemaOfJson.canEqual(this)) return false;
        return true;
    }

    public SchemaOfJson(Expression child, Map<String, String> options) {
        this.child = child;
        this.options = options;
        CodegenFallback.$init$(this);
    }

    public SchemaOfJson(Expression child) {
        this(child, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public SchemaOfJson(Expression child, Expression options) {
        this(child, ExprUtils$.MODULE$.convertToMapData(options));
    }
}

