/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TruncDate$;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date, fmt) - Returns `date` with the time portion of the day truncated to the unit specified by the format model `fmt`.\n  ", arguments="\n    Arguments:\n      * date - date value or valid date string\n      * fmt - the format representing the unit to be truncated to\n          - \"YEAR\", \"YYYY\", \"YY\" - truncate to the first date of the year that the `date` falls in\n          - \"QUARTER\" - truncate to the first date of the quarter that the `date` falls in\n          - \"MONTH\", \"MM\", \"MON\" - truncate to the first date of the month that the `date` falls in\n          - \"WEEK\" - truncate to the Monday of the week that the `date` falls in\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2019-08-04', 'week');\n       2019-07-29\n      > SELECT _FUNC_('2019-08-04', 'quarter');\n       2019-07-01\n      > SELECT _FUNC_('2009-02-12', 'MM');\n       2009-02-01\n      > SELECT _FUNC_('2015-10-27', 'YEAR');\n       2015-01-01\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015a\u0005\u0001\"\u0011A\u0011\u0015i\u0005\u0001\"\u0011A\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u00159\u0007\u0001\"\u0011i\u0011\u001d\t\bA1A\u0005B\u0001CaA\u001d\u0001!\u0002\u0013\t\u0005\"B:\u0001\t\u0003\"\b\"\u0002@\u0001\t\u0003z\bbBA\u000e\u0001\u0011E\u0013Q\u0004\u0005\n\u0003O\u0001\u0011\u0011!C\u0001\u0003SA\u0011\"a\f\u0001#\u0003%\t!!\r\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005E\u0002\"CA%\u0001\u0005\u0005I\u0011IA&\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0001\u0002h!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0013q\u000e\u0005\n\u0003{\u0002\u0011\u0011!C\u0001\u0003\u007fB\u0011\"!#\u0001\u0003\u0003%\t%a#\b\u0013\u0005U\u0016%!A\t\u0002\u0005]f\u0001\u0003\u0011\"\u0003\u0003E\t!!/\t\r\u001dSB\u0011AAd\u0011%\tIMGA\u0001\n\u000b\nY\rC\u0005\u0002Nj\t\t\u0011\"!\u0002P\"I\u0011Q\u001b\u000e\u0002\u0002\u0013\u0005\u0015q\u001b\u0005\n\u0003ST\u0012\u0011!C\u0005\u0003W\u0014\u0011\u0002\u0016:v]\u000e$\u0015\r^3\u000b\u0005\t\u001a\u0013aC3yaJ,7o]5p]NT!\u0001J\u0013\u0002\u0011\r\fG/\u00197zgRT!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00184mq\u0002\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00195\u0013\t)\u0014E\u0001\u0007UeVt7-\u00138ti\u0006tG\u000f\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005]j\u0014B\u0001 9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011!\u0017\r^3\u0016\u0003\u0005\u0003\"\u0001\r\"\n\u0005\r\u000b#AC#yaJ,7o]5p]\u0006)A-\u0019;fA\u00051am\u001c:nCR\fqAZ8s[\u0006$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0013*[\u0005C\u0001\u0019\u0001\u0011\u0015yT\u00011\u0001B\u0011\u0015)U\u00011\u0001B\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001Q!\r\t\u0016\f\u0018\b\u0003%^s!a\u0015,\u000e\u0003QS!!V\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014B\u0001-9\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0007M+\u0017O\u0003\u0002YqA\u0011Q\fY\u0007\u0002=*\u0011q,J\u0001\u0006if\u0004Xm]\u0005\u0003Cz\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u001a\t\u0003;\u0016L!A\u001a0\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\u0005I\u0007C\u00016o\u001d\tYG\u000e\u0005\u0002Tq%\u0011Q\u000eO\u0001\u0007!J,G-\u001a4\n\u0005=\u0004(AB*ue&twM\u0003\u0002nq\u00059\u0011N\\:uC:$\u0018\u0001C5ogR\fg\u000e\u001e\u0011\u0002\t\u00154\u0018\r\u001c\u000b\u0003kb\u0004\"a\u000e<\n\u0005]D$aA!os\"9\u00110\u0004I\u0001\u0002\u0004Q\u0018!B5oaV$\bCA>}\u001b\u0005\u0019\u0013BA?$\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0001\u0003\u001b\t9\u0002\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9!I\u0001\bG>$WmZ3o\u0013\u0011\tY!!\u0002\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0004\u000f\u0001\u0004\t\t\"A\u0002dib\u0004B!a\u0001\u0002\u0014%!\u0011QCA\u0003\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0007\u000f\u0001\u0004\t\t!\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006\u0013\u0006}\u00111\u0005\u0005\u0007\u0003Cy\u0001\u0019A!\u0002\u000f9,w\u000fT3gi\"1\u0011QE\bA\u0002\u0005\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003J\u0003W\ti\u0003C\u0004@!A\u0005\t\u0019A!\t\u000f\u0015\u0003\u0002\u0013!a\u0001\u0003\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001aU\r\t\u0015QG\u0016\u0003\u0003o\u0001B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\t\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0005m\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002NA!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001\u00027b]\u001eT!!a\u0016\u0002\t)\fg/Y\u0005\u0004_\u0006E\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA0!\r9\u0014\u0011M\u0005\u0004\u0003GB$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA;\u0002j!I\u00111N\u000b\u0002\u0002\u0003\u0007\u0011qL\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0004#BA:\u0003s*XBAA;\u0015\r\t9\bO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA>\u0003k\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011QAD!\r9\u00141Q\u0005\u0004\u0003\u000bC$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003W:\u0012\u0011!a\u0001k\u00061Q-];bYN$B!!!\u0002\u000e\"A\u00111\u000e\r\u0002\u0002\u0003\u0007Q\u000fK\f\u0001\u0003#\u000b9*!'\u0002\u001e\u0006}\u00151UAS\u0003S\u000bY+a,\u00022B\u0019\u0001'a%\n\u0007\u0005U\u0015EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005m\u0015!!\u0004\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006Z1uK2\u0002c-\u001c;*A5\u0002#+\u001a;ve:\u001c\b\u0005\u00193bi\u0016\u0004\u0007e^5uQ\u0002\"\b.\u001a\u0011uS6,\u0007\u0005]8si&|g\u000eI8gAQDW\r\t3bs\u0002\"(/\u001e8dCR,G\r\t;pAQDW\rI;oSR\u00043\u000f]3dS\u001aLW\r\u001a\u0011cs\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011n_\u0012,G\u000e\t1g[R\u0004gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002\"\u0006\u0019iO\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!I\u0006$X\rI\u0017!I\u0006$X\r\t<bYV,\u0007e\u001c:!m\u0006d\u0017\u000e\u001a\u0011eCR,\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005\u001e5fA\u0019|'/\\1uAI,\u0007O]3tK:$\u0018N\\4!i\",\u0007%\u001e8ji\u0002\"x\u000e\t2fAQ\u0014XO\\2bi\u0016$\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012Z\u000b\u0006\u0013&\u0005\f\u0011#3fK\u0016L\t\u0017!EeK&\u0005I\u0017!iJ,hnY1uK\u0002\"x\u000e\t;iK\u00022\u0017N]:uA\u0011\fG/\u001a\u0011pM\u0002\"\b.\u001a\u0011zK\u0006\u0014\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011aI\u0006$X\r\u0019\u0011gC2d7\u000fI5o\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011##V\u000b%\u000bV#SE\u0001j\u0003\u0005\u001e:v]\u000e\fG/\u001a\u0011u_\u0002\"\b.\u001a\u0011gSJ\u001cH\u000f\t3bi\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013/^1si\u0016\u0014\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011aI\u0006$X\r\u0019\u0011gC2d7\u000fI5o\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b>sE\u000b\u0013\u0012-A\tjUJ\t\u0017!E5{eJ\t\u0011.AQ\u0014XO\\2bi\u0016\u0004Co\u001c\u0011uQ\u0016\u0004c-\u001b:ti\u0002\"\u0017\r^3!_\u001a\u0004C\u000f[3![>tG\u000f\u001b\u0011uQ\u0006$\b\u0005\u001e5fA\u0001$\u0017\r^3aA\u0019\fG\u000e\\:!S:T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t:V)R&#A5\u0002CO];oG\u0006$X\r\t;pAQDW\rI'p]\u0012\f\u0017\u0010I8gAQDW\rI<fK.\u0004C\u000f[1uAQDW\r\t1eCR,\u0007\r\t4bY2\u001c\b%\u001b8\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\u000b!Q\u0004\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014'O\u00171q5\u0002Dg\n\u0017!O],Wm[\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001d.a]j#'\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014'O\u00171q5\u0002Dg\n\u0017!OE,\u0018M\u001d;fe\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cej\u0003gN\u00171c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002$'L\u00193O1\u0002s%T'(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007\r\u0019:[A\u0012T\u0006M\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'M\u001b.cAj#gN\u0014-A\u001dJV)\u0011*(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00196[A\nT\u0006M\u0019\u000bA\u0001\nQa\u001a:pkB\f#!!,\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u00111W\u0001\u0006c9*d\u0006M\u0001\n)J,hn\u0019#bi\u0016\u0004\"\u0001\r\u000e\u0014\ti\tY\f\u0010\t\b\u0003{\u000b\u0019-Q!J\u001b\t\tyLC\u0002\u0002Bb\nqA];oi&lW-\u0003\u0003\u0002F\u0006}&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011qW\u0001\ti>\u001cFO]5oOR\u0011\u0011QJ\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0013\u0006E\u00171\u001b\u0005\u0006\u007fu\u0001\r!\u0011\u0005\u0006\u000bv\u0001\r!Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI.!:\u0011\u000b]\nY.a8\n\u0007\u0005u\u0007H\u0001\u0004PaRLwN\u001c\t\u0006o\u0005\u0005\u0018)Q\u0005\u0004\u0003GD$A\u0002+va2,'\u0007\u0003\u0005\u0002hz\t\t\u00111\u0001J\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002nB!\u0011qJAx\u0013\u0011\t\t0!\u0015\u0003\r=\u0013'.Z2u\u0001")
public class TruncDate
extends BinaryExpression
implements TruncInstant,
scala.Serializable {
    private final Expression date;
    private final Expression format;
    private final Expression instant;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TruncDate truncDate) {
        return TruncDate$.MODULE$.unapply(truncDate);
    }

    public static Function1<Tuple2<Expression, Expression>, TruncDate> tupled() {
        return TruncDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TruncDate>> curried() {
        return TruncDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int minLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, minLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int minLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, minLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncDate truncDate = this;
        synchronized (truncDate) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    public Expression date() {
        return this.date;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    @Override
    public Expression left() {
        return this.date();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_DATE_TRUNC(), (Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(d, level) -> BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.truncDate(BoxesRunTime.unboxToInt((Object)d), BoxesRunTime.unboxToInt((Object)level))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_DATE_TRUNC(), this.codeGenHelper$default$4(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(date, fmt) -> new StringBuilder(14).append("truncDate(").append((String)date).append(", ").append((String)fmt).append(");").toString());
    }

    @Override
    public TruncDate withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public TruncDate copy(Expression date, Expression format) {
        return new TruncDate(date, format);
    }

    public Expression copy$default$1() {
        return this.date();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "TruncDate";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.date();
                break;
            }
            case 1: {
                expression = this.format();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncDate truncDate = (TruncDate)x$1;
        Expression expression = this.date();
        Expression expression2 = truncDate.date();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = truncDate.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!truncDate.canEqual(this)) return false;
        return true;
    }

    public TruncDate(Expression date, Expression format) {
        this.date = date;
        this.format = format;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        this.instant = date;
    }
}

