/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(value, min_value, max_value, num_bucket) - Returns the bucket number to which\n      `value` would be assigned in an equiwidth histogram with `num_bucket` buckets,\n      in the range `min_value` to `max_value`.\"\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(5.3, 0.2, 10.6, 5);\n       3\n      > SELECT _FUNC_(-2.1, 1.3, 3.4, 3);\n       0\n      > SELECT _FUNC_(8.1, 0.0, 5.7, 4);\n       5\n      > SELECT _FUNC_(-0.9, 5.2, 0.5, 2);\n       3\n  ", since="3.1.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\t]r!B\u0014)\u0011\u0003)d!B\u001c)\u0011\u0003A\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005\"\u0002#\u0002\t\u0003)\u0005bB.\u0002\u0003\u0003%\t\t\u0018\u0005\n\u00053\t\u0011\u0011!CA\u00057A\u0011B!\f\u0002\u0003\u0003%IAa\f\u0007\t]B\u0003I\u0018\u0005\t\u001f\u001e\u0011)\u001a!C\u0001_\"A1o\u0002B\tB\u0003%\u0001\u000f\u0003\u0005u\u000f\tU\r\u0011\"\u0001p\u0011!)xA!E!\u0002\u0013\u0001\b\u0002\u0003<\b\u0005+\u0007I\u0011A8\t\u0011]<!\u0011#Q\u0001\nAD\u0001\u0002W\u0004\u0003\u0016\u0004%\ta\u001c\u0005\tq\u001e\u0011\t\u0012)A\u0005a\")!i\u0002C\u0001s\")ap\u0002C!\u007f\"9\u00111E\u0004\u0005B\u0005\u0015\u0002bBA\u0017\u000f\u0011\u0005\u0013q\u0006\u0005\b\u0003o9A\u0011IA\u001d\u0011\u001d\tYe\u0002C)\u0003\u001bBq!a\u0018\b\t\u0003\n\t\u0007\u0003\u0004\u0002~\u001d!\te\u001c\u0005\u0007\u0003\u007f:A\u0011I8\t\r\u0005\u0005u\u0001\"\u0011p\u0011\u0019\t\u0019i\u0002C!_\"9\u0011QQ\u0004\u0005R\u0005\u001d\u0005\"CAI\u000f\u0005\u0005I\u0011AAJ\u0011%\tijBI\u0001\n\u0003\ty\nC\u0005\u00026\u001e\t\n\u0011\"\u0001\u0002 \"I\u0011qW\u0004\u0012\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003s;\u0011\u0013!C\u0001\u0003?C\u0011\"a/\b\u0003\u0003%\t%!0\t\u0013\u0005\rw!!A\u0005\u0002\u0005\u0015\u0007\"CAg\u000f\u0005\u0005I\u0011AAh\u0011%\t)nBA\u0001\n\u0003\n9\u000eC\u0005\u0002f\u001e\t\t\u0011\"\u0001\u0002h\"I\u00111^\u0004\u0002\u0002\u0013\u0005\u0013Q^\u0001\f/&$G\u000f\u001b\"vG.,GO\u0003\u0002*U\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tYC&\u0001\u0005dCR\fG._:u\u0015\tic&A\u0002tc2T!a\f\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0002\u0001!\t1\u0014!D\u0001)\u0005-9\u0016\u000e\u001a;i\u0005V\u001c7.\u001a;\u0014\u0007\u0005It\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0004B]f\u0014VM\u001a\t\u0003u\u0001K!!Q\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005)\u0014aE2p[B,H/\u001a\"vG.,GOT;nE\u0016\u0014H#\u0002$O'V;\u0006CA$M\u001b\u0005A%BA%K\u0003\u0011a\u0017M\\4\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\u0005\u0019>tw\rC\u0003P\u0007\u0001\u0007\u0001+A\u0003wC2,X\r\u0005\u0002;#&\u0011!k\u000f\u0002\u0007\t>,(\r\\3\t\u000bQ\u001b\u0001\u0019\u0001)\u0002\u00075Lg\u000eC\u0003W\u0007\u0001\u0007\u0001+A\u0002nCbDQ\u0001W\u0002A\u0002e\u000b\u0011B\\;n\u0005V\u001c7.\u001a;\u0011\u0005iR\u0016BA'<\u0003\u0015\t\u0007\u000f\u001d7z)%i&\u0011\u0003B\n\u0005+\u00119\u0002\u0005\u00027\u000fM1qa\u00182fY~\u0002\"A\u000e1\n\u0005\u0005D#\u0001F)vCR,'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00027G&\u0011A\r\u000b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011a-\u001b\b\u0003m\u001dL!\u0001\u001b\u0015\u0002\u000fA\f7m[1hK&\u0011!n\u001b\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tA\u0007\u0006\u0005\u0002;[&\u0011an\u000f\u0002\b!J|G-^2u+\u0005\u0001\bC\u0001\u001cr\u0013\t\u0011\bF\u0001\u0006FqB\u0014Xm]:j_:\faA^1mk\u0016\u0004\u0013\u0001C7j]Z\u000bG.^3\u0002\u00135LgNV1mk\u0016\u0004\u0013\u0001C7bqZ\u000bG.^3\u0002\u00135\f\u0007PV1mk\u0016\u0004\u0013A\u00038v[\n+8m[3uAQ)QL_>}{\")q\n\u0005a\u0001a\")A\u000f\u0005a\u0001a\")a\u000f\u0005a\u0001a\")\u0001\f\u0005a\u0001a\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005\u0005\u0001CBA\u0002\u0003#\t9B\u0004\u0003\u0002\u0006\u0005=a\u0002BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-A'\u0001\u0004=e>|GOP\u0005\u0002y%\u0011\u0001nO\u0005\u0005\u0003'\t)BA\u0002TKFT!\u0001[\u001e\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b-\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t#a\u0007\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u001d\u0002\u0003BA\r\u0003SIA!a\u000b\u0002\u001c\tAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\t\t\t\u0004E\u0002;\u0003gI1!!\u000e<\u0005\u001d\u0011un\u001c7fC:\f!\u0002\u001d:fiRLh*Y7f+\t\tY\u0004\u0005\u0003\u0002>\u0005\u0015c\u0002BA \u0003\u0003\u00022!a\u0002<\u0013\r\t\u0019eO\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r3(\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0006\u0002P\u0005U\u0013\u0011LA.\u0003;\u00022AOA)\u0013\r\t\u0019f\u000f\u0002\u0004\u0003:L\bbBA,+\u0001\u0007\u0011qJ\u0001\u0006S:\u0004X\u000f\u001e\u0005\u0007)V\u0001\r!a\u0014\t\rY+\u0002\u0019AA(\u0011\u0019AV\u00031\u0001\u0002P\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003G\ny'!\u001f\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001b)\u0003\u001d\u0019w\u000eZ3hK:LA!!\u001c\u0002h\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002rY\u0001\r!a\u001d\u0002\u0007\r$\b\u0010\u0005\u0003\u0002f\u0005U\u0014\u0002BA<\u0003O\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002|Y\u0001\r!a\u0019\u0002\u0005\u00154\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0004g_V\u0014H\u000f[\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\u0012\"XAE\u0003\u0017\u000bi)a$\t\r\u0005u4\u00041\u0001q\u0011\u0019\tyh\u0007a\u0001a\"1\u0011\u0011Q\u000eA\u0002ADa!a!\u001c\u0001\u0004\u0001\u0018\u0001B2paf$\u0012\"XAK\u0003/\u000bI*a'\t\u000f=c\u0002\u0013!a\u0001a\"9A\u000f\bI\u0001\u0002\u0004\u0001\bb\u0002<\u001d!\u0003\u0005\r\u0001\u001d\u0005\b1r\u0001\n\u00111\u0001q\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!)+\u0007A\f\u0019k\u000b\u0002\u0002&B!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016!C;oG\",7m[3e\u0015\r\tykO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAZ\u0003S\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\fE\u0002H\u0003\u0003L1!a\u0012I\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\rE\u0002;\u0003\u0013L1!a3<\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty%!5\t\u0013\u0005M7%!AA\u0002\u0005\u001d\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002ZB1\u00111\\Aq\u0003\u001fj!!!8\u000b\u0007\u0005}7(\u0001\u0006d_2dWm\u0019;j_:LA!a9\u0002^\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t$!;\t\u0013\u0005MW%!AA\u0002\u0005=\u0013AB3rk\u0006d7\u000f\u0006\u0003\u00022\u0005=\b\"CAjM\u0005\u0005\t\u0019AA(QM9\u00111_A}\u0003w\fyP!\u0001\u0003\u0006\t\u001d!1\u0002B\u0007!\r1\u0014Q_\u0005\u0004\u0003oD#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003{\f\u00111\u0019\u0006!A\u0001\u0002sLR+O\u0007~Cc/\u00197vK2\u0002S.\u001b8`m\u0006dW/\u001a\u0017![\u0006DxL^1mk\u0016d\u0003E\\;n?\n,8m[3uS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u0012WoY6fi\u0002rW/\u001c2fe\u0002\"x\u000eI<iS\u000eD'\u0002\t\u0011!A\u0001\u0002\u0003M^1mk\u0016\u0004\u0007e^8vY\u0012\u0004#-\u001a\u0011bgNLwM\\3eA%t\u0007%\u00198!KF,\u0018n^5ei\"\u0004\u0003.[:u_\u001e\u0014\u0018-\u001c\u0011xSRD\u0007\u0005\u00198v[~\u0013WoY6fi\u0002\u0004#-^2lKR\u001cHF\u0003\u0011!A\u0001\u0002\u0003%\u001b8!i\",\u0007E]1oO\u0016\u0004\u0003-\\5o?Z\fG.^3aAQ|\u0007\u0005Y7bq~3\u0018\r\\;fA:\u0012#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u0001\u0002\u0003sS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u000e\u00184Y\u0001\u0002dF\r\u0017!cArc\u0007\f\u00116SmR\u0001\u0005\t\u0011!A\u0001\u00023G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015.e9\nD\u0006I\u0019/g1\u00023G\f\u001b-AMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Qar\u0013\u0007\f\u00111]Ab\u0003%\u000e\u00188Y\u0001\"\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0003GL\u001d-AUr#\u0007\f\u00111]Ub\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0013\tQa\r\u00182]A\nQa\u001a:pkB\f#Aa\u0004\u0002\u00155\fG\u000f[0gk:\u001c7\u000fC\u0003P\t\u0001\u0007\u0001\u000fC\u0003u\t\u0001\u0007\u0001\u000fC\u0003w\t\u0001\u0007\u0001\u000fC\u0003Y\t\u0001\u0007\u0001/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu!\u0011\u0006\t\u0006u\t}!1E\u0005\u0004\u0005CY$AB(qi&|g\u000eE\u0004;\u0005K\u0001\b\u000f\u001d9\n\u0007\t\u001d2H\u0001\u0004UkBdW\r\u000e\u0005\t\u0005W)\u0011\u0011!a\u0001;\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005c\u00012a\u0012B\u001a\u0013\r\u0011)\u0004\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class WidthBucket
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression value;
    private final Expression minValue;
    private final Expression maxValue;
    private final Expression numBucket;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket widthBucket) {
        return WidthBucket$.MODULE$.unapply(widthBucket);
    }

    public static Long computeBucketNumber(double d, double d2, double d3, long l) {
        return WidthBucket$.MODULE$.computeBucketNumber(d, d2, d3, l);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression value() {
        return this.value;
    }

    public Expression minValue() {
        return this.minValue;
    }

    public Expression maxValue() {
        return this.maxValue;
    }

    public Expression numBucket() {
        return this.numBucket;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{DoubleType$.MODULE$, DoubleType$.MODULE$, DoubleType$.MODULE$, LongType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "width_bucket";
    }

    @Override
    public Object nullSafeEval(Object input, Object min, Object max, Object numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(BoxesRunTime.unboxToDouble((Object)input), BoxesRunTime.unboxToDouble((Object)min), BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToLong((Object)numBucket));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(input, min, max, numBucket) -> new StringBuilder(81).append("org.apache.spark.sql.catalyst.expressions.WidthBucket").append(".computeBucketNumber(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(")").toString());
    }

    @Override
    public Expression first() {
        return this.value();
    }

    @Override
    public Expression second() {
        return this.minValue();
    }

    @Override
    public Expression third() {
        return this.maxValue();
    }

    @Override
    public Expression fourth() {
        return this.numBucket();
    }

    @Override
    public WidthBucket withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public WidthBucket copy(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.minValue();
    }

    public Expression copy$default$3() {
        return this.maxValue();
    }

    public Expression copy$default$4() {
        return this.numBucket();
    }

    @Override
    public String productPrefix() {
        return "WidthBucket";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.value();
                break;
            }
            case 1: {
                expression = this.minValue();
                break;
            }
            case 2: {
                expression = this.maxValue();
                break;
            }
            case 3: {
                expression = this.numBucket();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WidthBucket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WidthBucket)) return false;
        boolean bl = true;
        if (!bl) return false;
        WidthBucket widthBucket = (WidthBucket)x$1;
        Expression expression = this.value();
        Expression expression2 = widthBucket.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.minValue();
        Expression expression4 = widthBucket.minValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxValue();
        Expression expression6 = widthBucket.maxValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.numBucket();
        Expression expression8 = widthBucket.numBucket();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!widthBucket.canEqual(this)) return false;
        return true;
    }

    public WidthBucket(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numBucket = numBucket;
        ExpectsInputTypes.$init$(this);
    }
}

