/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitXorAgg$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bitwise XOR of all non-null input values, or null if none.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (3), (5) AS tab(col);\n       6\n  ", group="agg_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\f\u0018\u0001\u001aB\u0001\u0002\u000e\u0001\u0003\u0016\u0004%\t!\u000e\u0005\tu\u0001\u0011\t\u0012)A\u0005m!)1\b\u0001C\u0001y!)q\b\u0001C!\u0001\")A\n\u0001C!\u001b\")Q\u000b\u0001C)-\"9\u0011\fAA\u0001\n\u0003Q\u0006b\u0002/\u0001#\u0003%\t!\u0018\u0005\bQ\u0002\t\t\u0011\"\u0011j\u0011\u001d\t\b!!A\u0005\u0002IDqA\u001e\u0001\u0002\u0002\u0013\u0005q\u000fC\u0004~\u0001\u0005\u0005I\u0011\t@\t\u0013\u0005-\u0001!!A\u0005\u0002\u00055\u0001\"CA\f\u0001\u0005\u0005I\u0011IA\r\u000f%\tidFA\u0001\u0012\u0003\tyD\u0002\u0005\u0017/\u0005\u0005\t\u0012AA!\u0011\u0019Y\u0004\u0003\"\u0001\u0002P!I\u0011\u0011\u000b\t\u0002\u0002\u0013\u0015\u00131\u000b\u0005\n\u0003+\u0002\u0012\u0011!CA\u0003/B\u0011\"a\u0017\u0011\u0003\u0003%\t)!\u0018\t\u0013\u0005%\u0004#!A\u0005\n\u0005-$!\u0003\"jib{'/Q4h\u0015\tA\u0012$A\u0005bO\u001e\u0014XmZ1uK*\u0011!dG\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001d;\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u001f?\u0005\u00191/\u001d7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001O-\n\u0004C\u0001\u0015*\u001b\u00059\u0012B\u0001\u0016\u0018\u00051\u0011\u0015\u000e^!hOJ,w-\u0019;f!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\f\u001a\n\u0005Mj#\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u0001\u001c\u0011\u0005]BT\"A\r\n\u0005eJ\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDCA\u001f?!\tA\u0003\u0001C\u00035\u0007\u0001\u0007a'\u0001\u0005o_\u0012,g*Y7f+\u0005\t\u0005C\u0001\"J\u001d\t\u0019u\t\u0005\u0002E[5\tQI\u0003\u0002GK\u00051AH]8pizJ!\u0001S\u0017\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u00116\n1BY5u\u001fB,'/\u0019;peR\u0019a*U*\u0011\u0005]z\u0015B\u0001)\u001a\u0005A\u0011\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7\rC\u0003S\u000b\u0001\u0007a'\u0001\u0003mK\u001a$\b\"\u0002+\u0006\u0001\u00041\u0014!\u0002:jO\"$\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000e\u0006\u00027/\")\u0001L\u0002a\u0001m\u0005Aa.Z<DQ&dG-\u0001\u0003d_BLHCA\u001f\\\u0011\u001d!t\u0001%AA\u0002Y\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001_U\t1tlK\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-A\u0005v]\u000eDWmY6fI*\u0011Q-L\u0001\u000bC:tw\u000e^1uS>t\u0017BA4c\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003)\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\t1\fgn\u001a\u0006\u0002_\u0006!!.\u0019<b\u0013\tQE.\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001t!\taC/\u0003\u0002v[\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0011\u0001p\u001f\t\u0003YeL!A_\u0017\u0003\u0007\u0005s\u0017\u0010C\u0004}\u0017\u0005\u0005\t\u0019A:\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\u0005y\b#BA\u0001\u0003\u000fAXBAA\u0002\u0015\r\t)!L\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0005\u0003\u0007\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qBA\u000b!\ra\u0013\u0011C\u0005\u0004\u0003'i#a\u0002\"p_2,\u0017M\u001c\u0005\by6\t\t\u00111\u0001y\u0003\u0019)\u0017/^1mgR!\u0011qBA\u000e\u0011\u001dah\"!AA\u0002aD3\u0003AA\u0010\u0003K\t9#a\u000b\u0002.\u0005E\u00121GA\u001c\u0003s\u00012aNA\u0011\u0013\r\t\u0019#\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI#A+`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t2ji^L7/\u001a\u0011Y\u001fJ\u0003sN\u001a\u0011bY2\u0004cn\u001c8.]VdG\u000eI5oaV$\bE^1mk\u0016\u001cH\u0006I8sA9,H\u000e\u001c\u0011jM\u0002rwN\\3/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA\u0018\u0003]S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!QMJC\u0006\t\u00156S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AYR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003k\t\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005m\u0012!B\u001a/a9\u0002\u0014!\u0003\"jib{'/Q4h!\tA\u0003c\u0005\u0003\u0011\u0003\u0007\n\u0004CBA#\u0003\u00172T(\u0004\u0002\u0002H)\u0019\u0011\u0011J\u0017\u0002\u000fI,h\u000e^5nK&!\u0011QJA$\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002U\u0006)\u0011\r\u001d9msR\u0019Q(!\u0017\t\u000bQ\u001a\u0002\u0019\u0001\u001c\u0002\u000fUt\u0017\r\u001d9msR!\u0011qLA3!\u0011a\u0013\u0011\r\u001c\n\u0007\u0005\rTF\u0001\u0004PaRLwN\u001c\u0005\t\u0003O\"\u0012\u0011!a\u0001{\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u00022a[A8\u0013\r\t\t\b\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class BitXorAgg
extends BitAggregate {
    private final Expression child;

    public static Option<Expression> unapply(BitXorAgg bitXorAgg) {
        return BitXorAgg$.MODULE$.unapply(bitXorAgg);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitXorAgg, A> function1) {
        return BitXorAgg$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitXorAgg> compose(Function1<A, Expression> function1) {
        return BitXorAgg$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public String nodeName() {
        return "bit_xor";
    }

    @Override
    public BinaryArithmetic bitOperator(Expression left, Expression right) {
        return new BitwiseXor(left, right);
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitXorAgg copy(Expression child) {
        return new BitXorAgg(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitXorAgg";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitXorAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitXorAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitXorAgg bitXorAgg = (BitXorAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = bitXorAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitXorAgg.canEqual(this)) return false;
        return true;
    }

    public BitXorAgg(Expression child) {
        this.child = child;
    }
}

