/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.QuaternaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.sketch.CountMinSketch;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, eps, confidence, seed) - Returns a count-min sketch of a column with the given esp,\n      confidence and seed. The result is an array of bytes, which can be deserialized to a\n      `CountMinSketch` before usage. Count-min sketch is a probabilistic data structure used for\n      cardinality estimation using sub-linear space.\n  ", examples="\n    Examples:\n      > SELECT hex(_FUNC_(col, 0.5d, 0.5d, 1)) FROM VALUES (1), (2), (1) AS tab(col);\n       0000000100000000000000030000000100000004000000005D8D6AB90000000000000000000000000000000200000000000000010000000000000000\n  ", group="agg_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u001d;\u0001&C\u0001\u0002\u001c\u0001\u0003\u0016\u0004%\t!\u001c\u0005\t]\u0002\u0011\t\u0012)A\u0005A\"Aq\u000e\u0001BK\u0002\u0013\u0005Q\u000e\u0003\u0005q\u0001\tE\t\u0015!\u0003a\u0011!\t\bA!f\u0001\n\u0003i\u0007\u0002\u0003:\u0001\u0005#\u0005\u000b\u0011\u00021\t\u0011M\u0004!Q3A\u0005\u00025D\u0001\u0002\u001e\u0001\u0003\u0012\u0003\u0006I\u0001\u0019\u0005\tk\u0002\u0011)\u001a!C!m\"A!\u0010\u0001B\tB\u0003%q\u000f\u0003\u0005|\u0001\tU\r\u0011\"\u0011w\u0011!a\bA!E!\u0002\u00139\b\"B?\u0001\t\u0003q\bBB?\u0001\t\u0003\ti\u0001\u0003\u0006\u0002\u0018\u0001A)\u0019!C\u0005\u00033A!\"!\t\u0001\u0011\u000b\u0007I\u0011BA\r\u0011%\t\u0019\u0003\u0001EC\u0002\u0013%a\u000fC\u0004\u0002&\u0001!\t%a\n\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u0003+\u0002A\u0011IA,\u0011\u001d\t\t\u0007\u0001C!\u0003GBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002|\u0001!\t%! \t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u00111\u0012\u0001\u0005B\u00055\u0005bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\t9\r\u0001C!\u0003\u0013Dq!a6\u0001\t\u0003\nI\u000e\u0003\u0004\u0002l\u0002!\t%\u001c\u0005\u0007\u0003[\u0004A\u0011I7\t\r\u0005=\b\u0001\"\u0011n\u0011\u0019\t\t\u0010\u0001C![\"9\u00111\u001f\u0001\u0005R\u0005U\b\"CA\u0000\u0001\u0005\u0005I\u0011\u0001B\u0001\u0011%\u0011y\u0001AI\u0001\n\u0003\u0011\t\u0002C\u0005\u0003(\u0001\t\n\u0011\"\u0001\u0003\u0012!I!\u0011\u0006\u0001\u0012\u0002\u0013\u0005!\u0011\u0003\u0005\n\u0005W\u0001\u0011\u0013!C\u0001\u0005#A\u0011B!\f\u0001#\u0003%\tAa\f\t\u0013\tM\u0002!%A\u0005\u0002\t=\u0002\"\u0003B\u001b\u0001\u0005\u0005I\u0011\tB\u001c\u0011!\u00119\u0005AA\u0001\n\u00031\b\"\u0003B%\u0001\u0005\u0005I\u0011\u0001B&\u0011%\u0011\t\u0006AA\u0001\n\u0003\u0012\u0019\u0006C\u0005\u0003b\u0001\t\t\u0011\"\u0001\u0003d!I!q\r\u0001\u0002\u0002\u0013\u0005#\u0011N\u0004\n\u0005\u001bS\u0014\u0011!E\u0001\u0005\u001f3\u0001\"\u000f\u001e\u0002\u0002#\u0005!\u0011\u0013\u0005\u0007{N\"\tAa(\t\u0013\t\u00056'!A\u0005F\t\r\u0006\"\u0003BSg\u0005\u0005I\u0011\u0011BT\u0011%\u0011)lMA\u0001\n\u0003\u00139\fC\u0005\u0003FN\n\t\u0011\"\u0003\u0003H\n\t2i\\;oi6KgnU6fi\u000eD\u0017iZ4\u000b\u0005mb\u0014!C1hOJ,w-\u0019;f\u0015\tid(A\u0006fqB\u0014Xm]:j_:\u001c(BA A\u0003!\u0019\u0017\r^1msN$(BA!C\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0007\u0012\u000bQa\u001d9be.T!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO\u000e\u00011C\u0002\u0001K-j\u001b\u0017\u000eE\u0002L\u0019:k\u0011AO\u0005\u0003\u001bj\u0012\u0001\u0004V=qK\u0012LU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0004tW\u0016$8\r\u001b\u0006\u0003'\n\u000bA!\u001e;jY&\u0011Q\u000b\u0015\u0002\u000f\u0007>,h\u000e^'j]N[W\r^2i!\t9\u0006,D\u0001=\u0013\tIFHA\tFqB,7\r^:J]B,H\u000fV=qKN\u00042a\u00170a\u001b\u0005a&BA/?\u0003\u0015!(/Z3t\u0013\tyFL\u0001\bRk\u0006$XM\u001d8befd\u0015n[3\u0011\u0005]\u000b\u0017B\u00012=\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003I\u001el\u0011!\u001a\u0006\u0002M\u0006)1oY1mC&\u0011\u0001.\u001a\u0002\b!J|G-^2u!\t!'.\u0003\u0002lK\na1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t\u0001-\u0001\u0004dQ&dG\rI\u0001\u000eKB\u001cX\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001d\u0015\u00048/\u0012=qe\u0016\u001c8/[8oA\u0005!2m\u001c8gS\u0012,gnY3FqB\u0014Xm]:j_:\fQcY8oM&$WM\\2f\u000bb\u0004(/Z:tS>t\u0007%\u0001\btK\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001fM,W\rZ#yaJ,7o]5p]\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u0002oB\u0011A\r_\u0005\u0003s\u0016\u00141!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}Qiq0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\u0001\"a\u0013\u0001\t\u000b1l\u0001\u0019\u00011\t\u000b=l\u0001\u0019\u00011\t\u000bEl\u0001\u0019\u00011\t\u000bMl\u0001\u0019\u00011\t\u000bUl\u0001\u0019A<\t\u000bml\u0001\u0019A<\u0015\u0013}\fy!!\u0005\u0002\u0014\u0005U\u0001\"\u00027\u000f\u0001\u0004\u0001\u0007\"B8\u000f\u0001\u0004\u0001\u0007\"B9\u000f\u0001\u0004\u0001\u0007\"B:\u000f\u0001\u0004\u0001\u0017aA3qgV\u0011\u00111\u0004\t\u0004I\u0006u\u0011bAA\u0010K\n1Ai\\;cY\u0016\f!bY8oM&$WM\\2f\u0003\u0011\u0019X-\u001a3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=b(\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t\u0019$!\f\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fqc\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:\u0015\u00039\u000ba!\u001e9eCR,G#\u0002(\u0002>\u0005\u0005\u0003BBA )\u0001\u0007a*\u0001\u0004ck\u001a4WM\u001d\u0005\b\u0003\u0007\"\u0002\u0019AA#\u0003\u0015Ig\u000e];u!\u0011\t9%!\u0013\u000e\u0003yJ1!a\u0013?\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b5,'oZ3\u0015\u000b9\u000b\t&a\u0015\t\r\u0005}R\u00031\u0001O\u0011\u0019\t\u0019%\u0006a\u0001\u001d\u0006!QM^1m)\u0011\tI&a\u0018\u0011\u0007\u0011\fY&C\u0002\u0002^\u0015\u00141!\u00118z\u0011\u0019\tyD\u0006a\u0001\u001d\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003K\n\t\bE\u0003e\u0003O\nY'C\u0002\u0002j\u0015\u0014Q!\u0011:sCf\u00042\u0001ZA7\u0013\r\ty'\u001a\u0002\u0005\u0005f$X\r\u0003\u0004\u0002@]\u0001\rAT\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002O\u0003oBq!!\u001f\u0019\u0001\u0004\t)'A\u0007ti>\u0014\u0018mZ3G_Jl\u0017\r^\u0001\u001eo&$\bNT3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019q0a \t\r\u0005\u0005\u0015\u00041\u0001x\u0003eqWm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\ry\u0018q\u0011\u0005\u0007\u0003\u0013S\u0002\u0019A<\u0002/9,w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018AC5oaV$H+\u001f9fgV\u0011\u0011q\u0012\t\u0007\u0003#\u000b\t+a*\u000f\t\u0005M\u0015Q\u0014\b\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014%\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0017bAAPK\u00069\u0001/Y2lC\u001e,\u0017\u0002BAR\u0003K\u00131aU3r\u0015\r\ty*\u001a\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011Q\u0016!\u0002\u000bQL\b/Z:\n\t\u0005E\u00161\u0016\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003o\u00032\u0001ZA]\u0013\r\tY,\u001a\u0002\b\u0005>|G.Z1o\u0003!!\u0017\r^1UsB,WCAAa!\u0011\tI+a1\n\t\u0005\u0015\u00171\u0016\u0002\t\t\u0006$\u0018\rV=qK\u0006iA-\u001a4bk2$(+Z:vYR,\"!a3\u0011\u000b\u0011\fi-!5\n\u0007\u0005=WM\u0001\u0004PaRLwN\u001c\t\u0004/\u0006M\u0017bAAky\t9A*\u001b;fe\u0006d\u0017A\u00039sKR$\u0018PT1nKV\u0011\u00111\u001c\t\u0005\u0003;\f)O\u0004\u0003\u0002`\u0006\u0005\bcAAKK&\u0019\u00111]3\u0002\rA\u0013X\rZ3g\u0013\u0011\t9/!;\u0003\rM#(/\u001b8h\u0015\r\t\u0019/Z\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\r\u0019|WO\u001d;i\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0005\u0000\u0003o\fI0a?\u0002~\"1\u00111\u001e\u0013A\u0002\u0001Da!!<%\u0001\u0004\u0001\u0007BBAxI\u0001\u0007\u0001\r\u0003\u0004\u0002r\u0012\u0002\r\u0001Y\u0001\u0005G>\u0004\u0018\u0010F\u0007\u0000\u0005\u0007\u0011)Aa\u0002\u0003\n\t-!Q\u0002\u0005\bY\u0016\u0002\n\u00111\u0001a\u0011\u001dyW\u0005%AA\u0002\u0001Dq!]\u0013\u0011\u0002\u0003\u0007\u0001\rC\u0004tKA\u0005\t\u0019\u00011\t\u000fU,\u0003\u0013!a\u0001o\"910\nI\u0001\u0002\u00049\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005'Q3\u0001\u0019B\u000bW\t\u00119\u0002\u0005\u0003\u0003\u001a\t\rRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0011K\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\"1\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u00032)\u001aqO!\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u000f\u0011\t\tm\"QI\u0007\u0003\u0005{QAAa\u0010\u0003B\u0005!A.\u00198h\u0015\t\u0011\u0019%\u0001\u0003kCZ\f\u0017\u0002BAt\u0005{\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002Z\t5\u0003\u0002\u0003B(]\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u0006\u0005\u0004\u0003X\tu\u0013\u0011L\u0007\u0003\u00053R1Aa\u0017f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005?\u0012IF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\\\u0005KB\u0011Ba\u00141\u0003\u0003\u0005\r!!\u0017\u0002\r\u0015\fX/\u00197t)\u0011\t9La\u001b\t\u0013\t=\u0013'!AA\u0002\u0005e\u0003f\u0005\u0001\u0003p\tU$q\u000fB>\u0005{\u0012\tIa!\u0003\b\n%\u0005cA,\u0003r%\u0019!1\u000f\u001f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011P\u0001\u00032*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015d_2d\u0003%\u001a9tY\u0001\u001awN\u001c4jI\u0016t7-\u001a\u0017!g\u0016,G-\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007eY8v]RlS.\u001b8!g.,Go\u00195!_\u001a\u0004\u0013\rI2pYVlg\u000eI<ji\"\u0004C\u000f[3!O&4XM\u001c\u0011fgBd#\u0002\t\u0011!A\u0001\u00023m\u001c8gS\u0012,gnY3!C:$\u0007e]3fI:\u0002C\u000b[3!e\u0016\u001cX\u000f\u001c;!SN\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I8gA\tLH/Z:-A]D\u0017n\u00195!G\u0006t\u0007EY3!I\u0016\u001cXM]5bY&TX\r\u001a\u0011u_\u0002\n'\u0002\t\u0011!A\u0001\u0002\u0003mQ8v]Rl\u0015N\\*lKR\u001c\u0007\u000e\u0019\u0011cK\u001a|'/\u001a\u0011vg\u0006<WM\f\u0011D_VtG/L7j]\u0002\u001a8.\u001a;dQ\u0002J7\u000fI1!aJ|'-\u00192jY&\u001cH/[2!I\u0006$\u0018\rI:ueV\u001cG/\u001e:fAU\u001cX\r\u001a\u0011g_JT\u0001\u0005\t\u0011!A\u0001\u001a\u0017M\u001d3j]\u0006d\u0017\u000e^=!KN$\u0018.\\1uS>t\u0007%^:j]\u001e\u00043/\u001e2.Y&tW-\u0019:!gB\f7-\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u007f\n\u0011q\u001a\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!Q\u0016D\bf\u0018$V\u001d\u000e{\u0006fY8mY\u0001\u0002d&\u000e3-AArS\u0007\u001a\u0017!c%J\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0017!QIJC\u0006\t\u00152S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AA\u0002\u0004\u0007\r\u00191aE\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u00024\u0007\r\u00191aA\u0002\u0004'\r\u00191aA\u0002\u0004\u0007\r\u001b1aA\u0002\u0004\u0007\r\u00191k\u0011CDIN!CsA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004G\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00192aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u000b\u000b\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t-\u0015!\u0002\u001a/e9\u0002\u0014!E\"pk:$X*\u001b8TW\u0016$8\r[!hOB\u00111jM\n\u0005g\tM\u0015\u000eE\u0006\u0003\u0016\nm\u0005\r\u00191ao^|XB\u0001BL\u0015\r\u0011I*Z\u0001\beVtG/[7f\u0013\u0011\u0011iJa&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tg\u0007\u0006\u0002\u0003\u0010\u0006AAo\\*ue&tw\r\u0006\u0002\u0003:\u0005)\u0011\r\u001d9msRiqP!+\u0003,\n5&q\u0016BY\u0005gCQ\u0001\u001c\u001cA\u0002\u0001DQa\u001c\u001cA\u0002\u0001DQ!\u001d\u001cA\u0002\u0001DQa\u001d\u001cA\u0002\u0001DQ!\u001e\u001cA\u0002]DQa\u001f\u001cA\u0002]\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003:\n\u0005\u0007#\u00023\u0002N\nm\u0006#\u00033\u0003>\u0002\u0004\u0007\rY<x\u0013\r\u0011y,\u001a\u0002\u0007)V\u0004H.\u001a\u001c\t\u0011\t\rw'!AA\u0002}\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t%\u0007\u0003\u0002B\u001e\u0005\u0017LAA!4\u0003>\t1qJ\u00196fGR\u0004")
public class CountMinSketchAgg
extends TypedImperativeAggregate<CountMinSketch>
implements ExpectsInputTypes,
QuaternaryLike<Expression>,
Serializable {
    private double eps;
    private double confidence;
    private int seed;
    private final Expression child;
    private final Expression epsExpression;
    private final Expression confidenceExpression;
    private final Expression seedExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple6<Expression, Expression, Expression, Expression, Object, Object>> unapply(CountMinSketchAgg countMinSketchAgg) {
        return CountMinSketchAgg$.MODULE$.unapply(countMinSketchAgg);
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Expression, Object, Object>, CountMinSketchAgg> tupled() {
        return CountMinSketchAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, CountMinSketchAgg>>>>>> curried() {
        return CountMinSketchAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return QuaternaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return QuaternaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if (!this.bitmap$trans$0) {
                this.children = QuaternaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression epsExpression() {
        return this.epsExpression;
    }

    public Expression confidenceExpression() {
        return this.confidenceExpression;
    }

    public Expression seedExpression() {
        return this.seedExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private double eps$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.eps = BoxesRunTime.unboxToDouble((Object)this.epsExpression().eval(this.epsExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.eps;
    }

    private double eps() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.eps$lzycompute() : this.eps;
    }

    private double confidence$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.confidence = BoxesRunTime.unboxToDouble((Object)this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.confidence;
    }

    private double confidence() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.confidence$lzycompute() : this.confidence;
    }

    private int seed$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.seed = BoxesRunTime.unboxToInt((Object)this.seedExpression().eval(this.seedExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.seed;
    }

    private int seed() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.seed$lzycompute() : this.seed;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.epsExpression().foldable() || !this.confidenceExpression().foldable() || !this.seedExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided must be a literal or foldable") : (this.epsExpression().eval(this.epsExpression().eval$default$1()) == null || this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()) == null || this.seedExpression().eval(this.seedExpression().eval$default$1()) == null ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided should not be null") : (this.eps() <= 0.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Relative error must be positive (current value = ").append(this.eps()).append(")").toString()) : (this.confidence() <= 0.0 || this.confidence() >= 1.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(61).append("Confidence must be within range (0.0, 1.0) (current value = ").append(this.confidence()).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public CountMinSketch createAggregationBuffer() {
        return CountMinSketch.create((double)this.eps(), (double)this.confidence(), (int)this.seed());
    }

    @Override
    public CountMinSketch update(CountMinSketch buffer, InternalRow input) {
        block2: {
            Object value = this.child().eval(input);
            if (value == null) break block2;
            DataType dataType = this.child().dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                buffer.addBinary(((UTF8String)value).getBytes());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                buffer.add(value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return buffer;
    }

    @Override
    public CountMinSketch merge(CountMinSketch buffer, CountMinSketch input) {
        buffer.mergeInPlace(input);
        return buffer;
    }

    @Override
    public Object eval(CountMinSketch buffer) {
        return this.serialize(buffer);
    }

    @Override
    public byte[] serialize(CountMinSketch buffer) {
        return buffer.toByteArray();
    }

    @Override
    public CountMinSketch deserialize(byte[] storageFormat) {
        return CountMinSketch.readFrom((byte[])storageFormat);
    }

    @Override
    public CountMinSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    @Override
    public CountMinSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$})), DoubleType$.MODULE$, DoubleType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.create(this.eval(this.createAggregationBuffer()), this.dataType()));
    }

    @Override
    public String prettyName() {
        return "count_min_sketch";
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.epsExpression();
    }

    @Override
    public Expression third() {
        return this.confidenceExpression();
    }

    @Override
    public Expression fourth() {
        return this.seedExpression();
    }

    @Override
    public CountMinSketchAgg withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth, this.copy$default$5(), this.copy$default$6());
    }

    public CountMinSketchAgg copy(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CountMinSketchAgg(child, epsExpression, confidenceExpression, seedExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.epsExpression();
    }

    public Expression copy$default$3() {
        return this.confidenceExpression();
    }

    public Expression copy$default$4() {
        return this.seedExpression();
    }

    public int copy$default$5() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$6() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CountMinSketchAgg";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.epsExpression();
                break;
            }
            case 2: {
                object = this.confidenceExpression();
                break;
            }
            case 3: {
                object = this.seedExpression();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CountMinSketchAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CountMinSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        CountMinSketchAgg countMinSketchAgg = (CountMinSketchAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = countMinSketchAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.epsExpression();
        Expression expression4 = countMinSketchAgg.epsExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.confidenceExpression();
        Expression expression6 = countMinSketchAgg.confidenceExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.seedExpression();
        Expression expression8 = countMinSketchAgg.seedExpression();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (this.mutableAggBufferOffset() != countMinSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != countMinSketchAgg.inputAggBufferOffset()) return false;
        if (!countMinSketchAgg.canEqual(this)) return false;
        return true;
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.epsExpression = epsExpression;
        this.confidenceExpression = confidenceExpression;
        this.seedExpression = seedExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        QuaternaryLike.$init$(this);
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression) {
        this(child, epsExpression, confidenceExpression, seedExpression, 0, 0);
    }
}

