/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathInt$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns an integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\u000e\u001c\u0001*B\u0001\u0002\b\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\t{\u0001\u0011\t\u0012)A\u0005s!Aa\b\u0001BK\u0002\u0013\u0005\u0001\b\u0003\u0005@\u0001\tE\t\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\t\u0007\u0001\"\u0015c\u0011\u001d9\u0007!!A\u0005\u0002!Dqa\u001b\u0001\u0012\u0002\u0013\u0005A\u000eC\u0004x\u0001E\u0005I\u0011\u00017\t\u000fa\u0004\u0011\u0011!C!s\"I\u00111\u0001\u0001\u0002\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u0003\u001b\u0001\u0011\u0011!C\u0001\u0003\u001fA\u0011\"!\u0006\u0001\u0003\u0003%\t%a\u0006\t\u0013\u0005\u0015\u0002!!A\u0005\u0002\u0005\u001d\u0002\"CA\u0019\u0001\u0005\u0005I\u0011IA\u001a\u000f%\t9fGA\u0001\u0012\u0003\tIF\u0002\u0005\u001b7\u0005\u0005\t\u0012AA.\u0011\u0019\u0001E\u0003\"\u0001\u0002j!I\u00111\u000e\u000b\u0002\u0002\u0013\u0015\u0013Q\u000e\u0005\n\u0003_\"\u0012\u0011!CA\u0003cB\u0011\"a\u001e\u0015\u0003\u0003%\t)!\u001f\t\u0013\u0005-E#!A\u0005\n\u00055%\u0001\u0003-QCRD\u0017J\u001c;\u000b\u0005qi\u0012a\u0001=nY*\u0011adH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002!C\u0005A1-\u0019;bYf\u001cHO\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001W=*\u0004C\u0001\u0017.\u001b\u0005Y\u0012B\u0001\u0018\u001c\u00051A\u0006+\u0019;i\u000bb$(/Y2u!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\r\u001c\n\u0005]\n$\u0001D*fe&\fG.\u001b>bE2,W#A\u001d\u0011\u0005iZT\"A\u000f\n\u0005qj\"AC#yaJ,7o]5p]\u0006!\u00010\u001c7!\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)\r\u00115\t\u0012\t\u0003Y\u0001AQ\u0001H\u0003A\u0002eBQAP\u0003A\u0002e\n!\u0002\u001d:fiRLh*Y7f+\u00059\u0005C\u0001%P\u001d\tIU\n\u0005\u0002Kc5\t1J\u0003\u0002MS\u00051AH]8pizJ!AT\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dF\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002)B\u0011Q\u000bW\u0007\u0002-*\u0011q+I\u0001\u0006if\u0004Xm]\u0005\u00033Z\u0013\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00049~\u0003\u0007C\u0001\u0019^\u0013\tq\u0016GA\u0002B]fDQ\u0001\b\u0005A\u0002qCQA\u0010\u0005A\u0002q\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007e\u001aW\rC\u0003e\u0013\u0001\u0007\u0011(A\u0004oK^dUM\u001a;\t\u000b\u0019L\u0001\u0019A\u001d\u0002\u00119,wOU5hQR\fAaY8qsR\u0019!)\u001b6\t\u000fqQ\u0001\u0013!a\u0001s!9aH\u0003I\u0001\u0002\u0004I\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002[*\u0012\u0011H\\\u0016\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001^\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002wc\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\u0012A\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018\u0001\u00027b]\u001eT\u0011a`\u0001\u0005U\u00064\u0018-\u0003\u0002Qy\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0001\t\u0004a\u0005%\u0011bAA\u0006c\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A,!\u0005\t\u0013\u0005Mq\"!AA\u0002\u0005\u001d\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u001aA)\u00111DA\u001196\u0011\u0011Q\u0004\u0006\u0004\u0003?\t\u0014AC2pY2,7\r^5p]&!\u00111EA\u000f\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%\u0012q\u0006\t\u0004a\u0005-\u0012bAA\u0017c\t9!i\\8mK\u0006t\u0007\u0002CA\n#\u0005\u0005\t\u0019\u0001/\u0002\r\u0015\fX/\u00197t)\u0011\tI#!\u000e\t\u0011\u0005M!#!AA\u0002qC3\u0003AA\u001d\u0003\u007f\t\t%!\u0012\u0002H\u0005-\u0013QJA)\u0003'\u00022AOA\u001e\u0013\r\ti$\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019%AA\t?\u001a+fjQ0)q6dG\u0006\t=qCRD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005t\u0007%\u001b8uK\u001e,'\u000f\t<bYV,G\u0006I8sAQDW\r\t<bYV,\u0007E_3s_\u0002Jg\r\t8pA5\fGo\u00195!SN\u0004cm\\;oI2\u0002sN\u001d\u0011bA5\fGo\u00195!SN\u0004cm\\;oI\u0002\u0012W\u000f\u001e\u0011uQ\u0016\u0004c/\u00197vK\u0002J7\u000f\t8p]6rW/\\3sS\u000et\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005%\u0013\u0001\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oq\ng\b\u00102?cqz#M\u0010\u001fc}IbtF\u0019 =_\u0005tt\u0005\f\u0011(gVl\u0007&Y\u0018cS\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa]5oG\u0016\f#!a\u0014\u0002\u000bIr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005U\u0013!\u0003=nY~3WO\\2t\u0003!A\u0006+\u0019;i\u0013:$\bC\u0001\u0017\u0015'\u0011!\u0012QL\u001b\u0011\u000f\u0005}\u0013QM\u001d:\u00056\u0011\u0011\u0011\r\u0006\u0004\u0003G\n\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003O\n\tGA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!\u0017\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A_\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0005\u0006M\u0014Q\u000f\u0005\u00069]\u0001\r!\u000f\u0005\u0006}]\u0001\r!O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY(a\"\u0011\u000bA\ni(!!\n\u0007\u0005}\u0014G\u0001\u0004PaRLwN\u001c\t\u0006a\u0005\r\u0015(O\u0005\u0004\u0003\u000b\u000b$A\u0002+va2,'\u0007\u0003\u0005\u0002\nb\t\t\u00111\u0001C\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0010B\u001910!%\n\u0007\u0005MEP\u0001\u0004PE*,7\r\u001e")
public class XPathInt
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathInt xPathInt) {
        return XPathInt$.MODULE$.unapply(xPathInt);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathInt> tupled() {
        return XPathInt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathInt>> curried() {
        return XPathInt$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_int";
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToInteger((int)ret.intValue());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathInt copy(Expression xml, Expression path) {
        return new XPathInt(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathInt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathInt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathInt)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathInt xPathInt = (XPathInt)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathInt.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathInt.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathInt.canEqual(this)) return false;
        return true;
    }

    public XPathInt(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

