/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.LikeAll;
import org.apache.spark.sql.catalyst.expressions.LikeAny;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MultiLikeBase;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.NotLikeAll;
import org.apache.spark.sql.catalyst.expressions.NotLikeAny;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.Or$;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;

public final class LikeSimplification$
extends Rule<LogicalPlan> {
    public static LikeSimplification$ MODULE$;
    private final Regex startsWith;
    private final Regex endsWith;
    private final Regex startsAndEndsWith;
    private final Regex contains;
    private final Regex equalTo;

    static {
        new LikeSimplification$();
    }

    private Regex startsWith() {
        return this.startsWith;
    }

    private Regex endsWith() {
        return this.endsWith;
    }

    private Regex startsAndEndsWith() {
        return this.startsAndEndsWith;
    }

    private Regex contains() {
        return this.contains;
    }

    private Regex equalTo() {
        return this.equalTo;
    }

    public Option<Expression> org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyLike(Expression input, String pattern, char escapeChar) {
        None$ none$;
        if (new StringOps(Predef$.MODULE$.augmentString(pattern)).contains((Object)BoxesRunTime.boxToCharacter((char)escapeChar))) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            String string = pattern;
            Option option = this.startsWith().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String prefix = (String)((LinearSeqOptimized)option.get()).apply(0);
                some = new Some((Object)new StartsWith(input, Literal$.MODULE$.apply(prefix)));
            } else {
                Option option2 = this.endsWith().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    String postfix = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    some = new Some((Object)new EndsWith(input, Literal$.MODULE$.apply(postfix)));
                } else {
                    Option option3 = this.startsAndEndsWith().unapplySeq((CharSequence)string);
                    if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                        String prefix = (String)((LinearSeqOptimized)option3.get()).apply(0);
                        String postfix = (String)((LinearSeqOptimized)option3.get()).apply(1);
                        some = new Some((Object)new And(new GreaterThanOrEqual(new Length(input), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)(prefix.length() + postfix.length())))), new And(new StartsWith(input, Literal$.MODULE$.apply(prefix)), new EndsWith(input, Literal$.MODULE$.apply(postfix)))));
                    } else {
                        Option option4 = this.contains().unapplySeq((CharSequence)string);
                        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
                            String infix = (String)((LinearSeqOptimized)option4.get()).apply(0);
                            some = new Some((Object)new Contains(input, Literal$.MODULE$.apply(infix)));
                        } else {
                            Option option5 = this.equalTo().unapplySeq((CharSequence)string);
                            if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0) {
                                String str = (String)((LinearSeqOptimized)option5.get()).apply(0);
                                some = new Some((Object)new EqualTo(input, Literal$.MODULE$.apply(str)));
                            } else {
                                some = None$.MODULE$;
                            }
                        }
                    }
                }
            }
            none$ = some;
        }
        return none$;
    }

    private char simplifyLike$default$3() {
        return '\\';
    }

    public Expression org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(Expression child, Seq<UTF8String> patterns, MultiLikeBase multi) {
        Expression expression;
        Tuple2 tuple2 = ((TraversableLike)patterns.map((Function1 & Serializable & scala.Serializable)p2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p2), (Object)Option$.MODULE$.apply(p2).flatMap((Function1 & Serializable & scala.Serializable)p -> MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyLike(child, p.toString(), MODULE$.simplifyLike$default$3()))), Seq$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)LikeSimplification$.$anonfun$simplifyMultiLike$3(x$23)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq remainPatternMap = (Seq)tuple2._1();
        Seq replacementMap = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)remainPatternMap, (Object)replacementMap);
        Tuple2 tuple23 = tuple22;
        Seq remainPatternMap2 = (Seq)tuple23._1();
        Seq replacementMap2 = (Seq)tuple23._2();
        Seq remainPatterns = (Seq)remainPatternMap2.map((Function1 & Serializable & scala.Serializable)x$25 -> (UTF8String)x$25._1(), Seq$.MODULE$.canBuildFrom());
        Seq replacements = (Seq)replacementMap2.map((Function1 & Serializable & scala.Serializable)x$26 -> (Expression)((Option)x$26._2()).get(), Seq$.MODULE$.canBuildFrom());
        if (replacements.isEmpty()) {
            expression = multi;
        } else {
            BinaryOperator binaryOperator;
            MultiLikeBase multiLikeBase = multi;
            if (multiLikeBase instanceof LikeAll) {
                LikeAll likeAll = (LikeAll)multiLikeBase;
                Seq x$1 = remainPatterns;
                Expression x$2 = likeAll.copy$default$1();
                binaryOperator = new And((Expression)replacements.reduceLeft((Function2)And$.MODULE$), likeAll.copy(x$2, (Seq<UTF8String>)x$1));
            } else if (multiLikeBase instanceof NotLikeAll) {
                NotLikeAll notLikeAll = (NotLikeAll)multiLikeBase;
                Seq x$3 = remainPatterns;
                Expression x$4 = notLikeAll.copy$default$1();
                binaryOperator = new And((Expression)((TraversableOnce)replacements.map((Function1 & Serializable & scala.Serializable)x$27 -> new Not((Expression)x$27), Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)And$.MODULE$), notLikeAll.copy(x$4, (Seq<UTF8String>)x$3));
            } else if (multiLikeBase instanceof LikeAny) {
                LikeAny likeAny = (LikeAny)multiLikeBase;
                Seq x$5 = remainPatterns;
                Expression x$6 = likeAny.copy$default$1();
                binaryOperator = new Or((Expression)replacements.reduceLeft((Function2)Or$.MODULE$), likeAny.copy(x$6, (Seq<UTF8String>)x$5));
            } else if (multiLikeBase instanceof NotLikeAny) {
                NotLikeAny notLikeAny = (NotLikeAny)multiLikeBase;
                Seq x$7 = remainPatterns;
                Expression x$8 = notLikeAny.copy$default$1();
                binaryOperator = new Or((Expression)((TraversableOnce)replacements.map((Function1 & Serializable & scala.Serializable)x$28 -> new Not((Expression)x$28), Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)Or$.MODULE$), notLikeAny.copy(x$8, (Seq<UTF8String>)x$7));
            } else {
                throw new MatchError((Object)multiLikeBase);
            }
            expression = binaryOperator;
        }
        return expression;
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return (LogicalPlan)plan2.transformAllExpressions((PartialFunction<Expression, Expression>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Like) {
                    Like like = (Like)A1;
                    Expression input = like.left();
                    Expression expression = like.right();
                    char escapeChar = like.escapeChar();
                    if (expression instanceof Literal) {
                        Literal literal = (Literal)expression;
                        Object pattern = literal.value();
                        DataType dataType = literal.dataType();
                        if (StringType$.MODULE$.equals(dataType)) {
                            object = pattern == null ? new Literal(null, BooleanType$.MODULE$) : LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyLike(input, pattern.toString(), escapeChar).getOrElse((Function0 & Serializable & scala.Serializable)() -> like);
                            return (B1)object;
                        }
                    }
                }
                if (A1 instanceof LikeAll) {
                    LikeAll likeAll = (LikeAll)A1;
                    Expression child = likeAll.child();
                    Seq<UTF8String> patterns = likeAll.patterns();
                    object = LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(child, patterns, likeAll);
                    return (B1)object;
                }
                if (A1 instanceof NotLikeAll) {
                    NotLikeAll notLikeAll = (NotLikeAll)A1;
                    Expression child = notLikeAll.child();
                    Seq<UTF8String> patterns = notLikeAll.patterns();
                    object = LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(child, patterns, notLikeAll);
                    return (B1)object;
                }
                if (A1 instanceof LikeAny) {
                    LikeAny likeAny = (LikeAny)A1;
                    Expression child = likeAny.child();
                    Seq<UTF8String> patterns = likeAny.patterns();
                    object = LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(child, patterns, likeAny);
                    return (B1)object;
                }
                if (A1 instanceof NotLikeAny) {
                    NotLikeAny notLikeAny = (NotLikeAny)A1;
                    Expression child = notLikeAny.child();
                    Seq<UTF8String> patterns = notLikeAny.patterns();
                    object = LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(child, patterns, notLikeAny);
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Literal literal;
                DataType dataType;
                Like like;
                Expression expression;
                Expression expression2 = x1;
                boolean bl = expression2 instanceof Like && (expression = (like = (Like)expression2).right()) instanceof Literal && StringType$.MODULE$.equals(dataType = (literal = (Literal)expression).dataType()) ? true : (expression2 instanceof LikeAll ? true : (expression2 instanceof NotLikeAll ? true : (expression2 instanceof LikeAny ? true : expression2 instanceof NotLikeAny)));
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$55(org.apache.spark.sql.catalyst.expressions.Like )}, serializedLambda);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$simplifyMultiLike$3(Tuple2 x$23) {
        return ((Option)x$23._2()).isEmpty();
    }

    private LikeSimplification$() {
        MODULE$ = this;
        this.startsWith = new StringOps(Predef$.MODULE$.augmentString("([^_%]+)%")).r();
        this.endsWith = new StringOps(Predef$.MODULE$.augmentString("%([^_%]+)")).r();
        this.startsAndEndsWith = new StringOps(Predef$.MODULE$.augmentString("([^_%]+)%([^_%]+)")).r();
        this.contains = new StringOps(Predef$.MODULE$.augmentString("%([^_%]+)%")).r();
        this.equalTo = new StringOps(Predef$.MODULE$.augmentString("([^_%]*)")).r();
    }
}

