/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.QualifiedTableName;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException$;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException$;
import org.apache.spark.sql.catalyst.analysis.ResolvedNamespace;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.analysis.ResolvedView;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.InvalidUDFClassException;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GroupingID;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowFunction;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class QueryCompilationErrors$ {
    public static QueryCompilationErrors$ MODULE$;

    static {
        new QueryCompilationErrors$();
    }

    public Throwable groupingIDMismatchError(GroupingID groupingID, Seq<Expression> groupByExprs) {
        return new AnalysisException(new StringBuilder(60).append("Columns of grouping_id (").append(groupingID.groupByExprs().mkString(",")).append(") ").append("does not match grouping columns (").append(groupByExprs.mkString(",")).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable groupingColInvalidError(Expression groupingCol, Seq<Expression> groupByExprs) {
        return new AnalysisException(new StringBuilder(57).append("Column of grouping (").append(groupingCol).append(") can't be found ").append("in grouping columns ").append(groupByExprs.mkString(",")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable groupingSizeTooLargeError(int sizeLimit) {
        return new AnalysisException(new StringBuilder(42).append("Grouping sets size cannot be greater than ").append(sizeLimit).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unorderablePivotColError(Expression pivotCol) {
        return new AnalysisException(new StringBuilder(58).append("Invalid pivot column '").append(pivotCol).append("'. Pivot columns must be comparable.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonLiteralPivotValError(Expression pivotVal) {
        return new AnalysisException(new StringBuilder(55).append("Literal expressions required for pivot values, found '").append(pivotVal).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable pivotValDataTypeMismatchError(Expression pivotVal, Expression pivotCol) {
        return new AnalysisException(new StringBuilder(79).append("Invalid pivot value '").append(pivotVal).append("': ").append("value data type ").append(pivotVal.dataType().simpleString()).append(" does not match ").append("pivot column data type ").append(pivotCol.dataType().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedIfNotExistsError(String tableName) {
        return new AnalysisException(new StringBuilder(56).append("Cannot write, IF NOT EXISTS is not supported for table: ").append(tableName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonPartitionColError(String partitionName) {
        return new AnalysisException(new StringBuilder(61).append("PARTITION clause cannot contain a non-partition column name: ").append(partitionName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable addStaticValToUnknownColError(String staticName) {
        return new AnalysisException(new StringBuilder(44).append("Cannot add static value for unknown column: ").append(staticName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unknownStaticPartitionColError(String name) {
        return new AnalysisException(new StringBuilder(33).append("Unknown static partition column: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nestedGeneratorError(Expression trimmedNestedGenerator) {
        return new AnalysisException(new StringBuilder(71).append("Generators are not supported when it's nested in expressions, but got: ").append(package$.MODULE$.toPrettySQL(trimmedNestedGenerator)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable moreThanOneGeneratorError(Seq<Expression> generators, String clause) {
        return new AnalysisException(new StringBuilder(51).append("Only one generator allowed per ").append(clause).append(" clause but found ").append(generators.size()).append(": ").append(((TraversableOnce)generators.map((Function1 & Serializable & scala.Serializable)e -> package$.MODULE$.toPrettySQL((Expression)e), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable generatorOutsideSelectError(LogicalPlan plan2) {
        return new AnalysisException(new StringBuilder(65).append("Generators are not supported outside the SELECT clause, but got: ").append(plan2.simpleString(SQLConf$.MODULE$.get().maxToStringFields())).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable legacyStoreAssignmentPolicyError() {
        String configKey = SQLConf$.MODULE$.STORE_ASSIGNMENT_POLICY().key();
        return new AnalysisException(new StringBuilder(116).append("LEGACY store assignment policy is disallowed in Spark data source V2. ").append("Please set the configuration ").append(configKey).append(" to other values.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unresolvedUsingColForJoinError(String colName, LogicalPlan plan2, String side) {
        return new AnalysisException(new StringBuilder(82).append("USING column `").append(colName).append("` cannot be resolved on the ").append(side).append(" ").append("side of the join. The ").append(side).append("-side columns: [").append(((TraversableOnce)plan2.output().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataTypeMismatchForDeserializerError(DataType dataType, String desiredType) {
        String quantifier = desiredType.equals("array") ? "an" : "a";
        return new AnalysisException(new StringBuilder(21).append("need ").append(quantifier).append(" ").append(desiredType).append(" field but got ").append(dataType.catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable fieldNumberMismatchForDeserializerError(StructType schema, int maxOrdinal) {
        return new AnalysisException(new StringBuilder(74).append("Try to map ").append(schema.catalogString()).append(" to Tuple").append(maxOrdinal + 1).append(", ").append("but failed as the number of fields does not line up.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable upCastFailureError(String fromStr, Expression from, DataType to, Seq<String> walkedTypePath) {
        return new AnalysisException(new StringBuilder(187).append("Cannot up cast ").append(fromStr).append(" from ").append(from.dataType().catalogString()).append(" to ").append(to.catalogString()).append(".\n").append("The type path of the target object is:\n").append(walkedTypePath.mkString("", "\n", "\n")).append("You can either add an explicit cast to the input data or choose a higher precision ").append("type of the field in the target object").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedAbstractDataTypeForUpCastError(AbstractDataType gotType) {
        return new AnalysisException(new StringBuilder(66).append("UpCast only support DecimalType as AbstractDataType yet, but got: ").append(gotType).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable outerScopeFailureForNewInstanceError(String className) {
        return new AnalysisException(new StringBuilder(155).append("Unable to generate an encoder for inner class `").append(className).append("` without ").append("access to the scope that this class was defined in.\n").append("Try moving this class out of its parent class.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable referenceColNotFoundForAlterTableChangesError(TableChange.After after, String parentName) {
        return new AnalysisException(new StringBuilder(43).append("Couldn't find the reference column for ").append(after).append(" at ").append(parentName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable windowSpecificationNotDefinedError(String windowName) {
        return new AnalysisException(new StringBuilder(58).append("Window specification ").append(windowName).append(" is not defined in the WINDOW clause.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable selectExprNotInGroupByError(Expression expr, Seq<Alias> groupByAliases) {
        return new AnalysisException(new StringBuilder(38).append(expr).append(" doesn't show up in the GROUP BY list ").append(groupByAliases).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable groupingMustWithGroupingSetsOrCubeOrRollupError() {
        return new AnalysisException("grouping()/grouping_id() can only be used with GroupingSets/Cube/Rollup", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable pandasUDFAggregateNotSupportedInPivotError() {
        return new AnalysisException("Pandas UDF aggregate expressions are currently not supported in pivot.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable aggregateExpressionRequiredForPivotError(String sql2) {
        return new AnalysisException(new StringBuilder(89).append("Aggregate expression required for pivot, but '").append(sql2).append("' ").append("did not appear in any aggregate function.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable writeIntoTempViewNotAllowedError(String quoted) {
        return new AnalysisException(new StringBuilder(67).append("Cannot write into temp view ").append(quoted).append(" as it's not a data source v2 relation.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable expectTableOrPermanentViewNotTempViewError(String quoted, String cmd, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(54).append(quoted).append(" is a temp view. '").append(cmd).append("' expects a table or permanent view.").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable readNonStreamingTempViewError(String quoted) {
        return new AnalysisException(new StringBuilder(111).append(quoted).append(" is not a temp view of streaming ").append("logical plan, please use batch API such as `DataFrameReader.table` to read it.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable viewDepthExceedsMaxResolutionDepthError(TableIdentifier identifier, int maxNestedViewDepth, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(145).append("The depth of view ").append(identifier).append(" exceeds the maximum ").append("view resolution depth (").append(maxNestedViewDepth).append("). Analysis is aborted to ").append("avoid errors. Increase the value of ").append(SQLConf$.MODULE$.MAX_NESTED_VIEW_DEPTH().key()).append(" to work ").append("around this.").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable insertIntoViewNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(45).append("Inserting into a view is not allowed. View: ").append(identifier).append(".").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable writeIntoViewNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(43).append("Writing into a view is not allowed. View: ").append(identifier).append(".").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable writeIntoV1TableNotAllowedError(TableIdentifier identifier, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(29).append("Cannot write into v1 table: ").append(identifier).append(".").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable expectTableNotViewError(ResolvedView v, String cmd, Option<String> mismatchHint, TreeNode<?> t) {
        String viewStr = v.isTemp() ? "temp view" : "view";
        String hintStr = (String)mismatchHint.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(1).append(" ").append((String)x$2).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new AnalysisException(new StringBuilder(27).append(CatalogV2Implicits$.MODULE$.IdentifierHelper(v.identifier()).quoted()).append(" is a ").append(viewStr).append(". '").append(cmd).append("' expects a table.").append(hintStr).toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable expectViewNotTableError(ResolvedTable v, String cmd, Option<String> mismatchHint, TreeNode<?> t) {
        String hintStr = (String)mismatchHint.map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(1).append(" ").append((String)x$3).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new AnalysisException(new StringBuilder(31).append(CatalogV2Implicits$.MODULE$.IdentifierHelper(v.identifier()).quoted()).append(" is a table. '").append(cmd).append("' expects a view.").append(hintStr).toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable permanentViewNotSupportedByStreamingReadingAPIError(String quoted) {
        return new AnalysisException(new StringBuilder(107).append(quoted).append(" is a permanent view, which is not supported by ").append("streaming reading API such as `DataStreamReader.table` yet.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable starNotAllowedWhenGroupByOrdinalPositionUsedError() {
        return new AnalysisException("Star (*) is not allowed in select list when GROUP BY ordinal position is used", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidStarUsageError(String prettyName) {
        return new AnalysisException(new StringBuilder(24).append("Invalid usage of '*' in ").append(prettyName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable singleTableStarInCountNotAllowedError(String targetString) {
        return new AnalysisException(new StringBuilder(100).append("count(").append(targetString).append(".*) is not allowed. ").append("Please use count(*) or expand the columns manually, e.g. count(col1, col2)").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable orderByPositionRangeError(int index, int size, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(63).append("ORDER BY position ").append(index).append(" is not in select list ").append("(valid range is [1, ").append(size).append("])").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable groupByPositionRefersToAggregateFunctionError(int index, Expression expr) {
        return new AnalysisException(new StringBuilder(134).append("GROUP BY ").append(index).append(" refers to an expression that is or contains ").append("an aggregate function. Aggregate functions are not allowed in GROUP BY, ").append("but got ").append(expr.sql()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable groupByPositionRangeError(int index, int size) {
        return new AnalysisException(new StringBuilder(63).append("GROUP BY position ").append(index).append(" is not in select list ").append("(valid range is [1, ").append(size).append("])").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable generatorNotExpectedError(FunctionIdentifier name, String classCanonicalName) {
        return new AnalysisException(new StringBuilder(81).append(name).append(" is expected to be a generator. However, ").append("its class is ").append(classCanonicalName).append(", which is not a generator.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable functionWithUnsupportedSyntaxError(String prettyName, String syntax) {
        return new AnalysisException(new StringBuilder(27).append("Function ").append(prettyName).append(" does not support ").append(syntax).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonDeterministicFilterInAggregateError() {
        return new AnalysisException("FILTER expression is non-deterministic, it cannot be used in aggregate functions", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable aliasNumberNotMatchColumnNumberError(int columnSize, int outputSize, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(107).append("Number of column aliases does not match number of columns. ").append("Number of column aliases: ").append(columnSize).append("; ").append("number of columns: ").append(outputSize).append(".").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable aliasesNumberNotMatchUDTFOutputError(int aliasesSize, String aliasesNames) {
        return new AnalysisException(new StringBuilder(131).append("The number of aliases supplied in the AS clause does not ").append("match the number of columns output by the UDTF expected ").append(aliasesSize).append(" ").append("aliases but got ").append(aliasesNames).append(" ").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable windowAggregateFunctionWithFilterNotSupportedError() {
        return new AnalysisException("window aggregate function with filter predicate is not supported yet.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable windowFunctionInsideAggregateFunctionNotAllowedError() {
        return new AnalysisException("It is not allowed to use a window function inside an aggregate function. Please use the inner window function in a sub-query.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable expressionWithoutWindowExpressionError(NamedExpression expr) {
        return new AnalysisException(new StringBuilder(36).append(expr).append(" does not have any WindowExpression.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable expressionWithMultiWindowExpressionsError(NamedExpression expr, Seq<WindowSpecDefinition> distinctWindowSpec) {
        return new AnalysisException(new StringBuilder(116).append(expr).append(" has multiple Window Specifications (").append(distinctWindowSpec).append(").").append("Please file a bug report with this error message, stack trace, and the query.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable windowFunctionNotAllowedError(String clauseName) {
        return new AnalysisException(new StringBuilder(56).append("It is not allowed to use window functions inside ").append(clauseName).append(" clause").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotSpecifyWindowFrameError(String prettyName) {
        return new AnalysisException(new StringBuilder(41).append("Cannot specify window frame for ").append(prettyName).append(" function").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable windowFrameNotMatchRequiredFrameError(SpecifiedWindowFrame f, WindowFrame required) {
        return new AnalysisException(new StringBuilder(44).append("Window Frame ").append(f).append(" must match the required frame ").append(required).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable windowFunctionWithWindowFrameNotOrderedError(WindowFunction wf) {
        return new AnalysisException(new StringBuilder(180).append("Window function ").append(wf).append(" requires window to be ordered, please add ").append("ORDER BY clause. For example SELECT ").append(wf).append("(value_expr) OVER (PARTITION BY window_partition ").append("ORDER BY window_ordering) from table").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotResolveUserSpecifiedColumnsError(String col, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(27).append("Cannot resolve column name ").append(col).toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable writeTableWithMismatchedColumnsError(int columnSize, int outputSize, TreeNode<?> t) {
        return new AnalysisException(new StringBuilder(91).append("Cannot write to table due to mismatched user specified column ").append("size(").append(columnSize).append(") and data column size(").append(outputSize).append(")").toString(), t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multiTimeWindowExpressionsNotSupportedError(TreeNode<?> t) {
        return new AnalysisException("Multiple time window expressions would result in a cartesian product of rows, therefore they are currently not supported.", t.origin().line(), t.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable viewOutputNumberMismatchQueryColumnNamesError(Seq<Attribute> output, Seq<String> queryColumnNames) {
        return new AnalysisException(new StringBuilder(84).append("The view output ").append(output.mkString("[", ",", "]")).append(" doesn't have the same").append("number of columns with the query column names ").append(queryColumnNames.mkString("[", ",", "]")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable attributeNotFoundError(String colName, LogicalPlan child) {
        return new AnalysisException(new StringBuilder(41).append("Attribute with name '").append(colName).append("' is not found in ").append("'").append(((TraversableOnce)child.output().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom())).mkString("(", ",", ")")).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotUpCastAsAttributeError(Attribute fromAttr, Attribute toAttr) {
        return new AnalysisException(new StringBuilder(44).append("Cannot up cast ").append(fromAttr.sql()).append(" from ").append(fromAttr.dataType().catalogString()).append(" to ").append(toAttr.dataType().catalogString()).append(" ").append("as it may truncate").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable functionUndefinedError(FunctionIdentifier name) {
        return new AnalysisException(new StringBuilder(19).append("undefined function ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidFunctionArgumentsError(String name, String expectedInfo, int actualNumber) {
        return new AnalysisException(new StringBuilder(62).append("Invalid number of arguments for function ").append(name).append(". ").append("Expected: ").append(expectedInfo).append("; Found: ").append(actualNumber).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidFunctionArgumentNumberError(Seq<Object> validParametersCount, String name, Seq<Class<Expression>> params) {
        Throwable throwable;
        if (validParametersCount.length() == 0) {
            throwable = new AnalysisException(new StringBuilder(31).append("Invalid arguments for function ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        } else {
            String expectedNumberOfParameters = validParametersCount.length() == 1 ? validParametersCount.head().toString() : new StringBuilder(0).append(((TraversableOnce)validParametersCount.init()).mkString("one of ", ", ", " and ")).append(validParametersCount.last()).toString();
            throwable = this.invalidFunctionArgumentsError(name, expectedNumberOfParameters, params.length());
        }
        return throwable;
    }

    public Throwable functionAcceptsOnlyOneArgumentError(String name) {
        return new AnalysisException(new StringBuilder(35).append("Function ").append(name).append(" accepts only one argument").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterV2TableSetLocationWithPartitionNotSupportedError() {
        return new AnalysisException("ALTER TABLE SET LOCATION does not support partition for v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable joinStrategyHintParameterNotSupportedError(Object unsupported) {
        return new AnalysisException(new StringBuilder(73).append("Join strategy hint parameter ").append("should be an identifier or string but was ").append(unsupported).append(" (").append(unsupported.getClass()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidHintParameterError(String hintName, Seq<Object> invalidParams) {
        return new AnalysisException(new StringBuilder(50).append(hintName).append(" Hint parameter should include columns, but ").append(invalidParams.mkString(", ")).append(" found").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidCoalesceHintParameterError(String hintName) {
        return new AnalysisException(new StringBuilder(47).append(hintName).append(" Hint expects a partition number as a parameter").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable attributeNameSyntaxError(String name) {
        return new AnalysisException(new StringBuilder(32).append("syntax error in attribute name: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable starExpandDataTypeNotSupportedError(Seq<String> attributes) {
        return new AnalysisException(new StringBuilder(53).append("Can only star expand struct data types. Attribute: `").append(attributes).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotResolveStarExpandGivenInputColumnsError(String targetString, String columns) {
        return new AnalysisException(new StringBuilder(42).append("cannot resolve '").append(targetString).append(".*' given input columns '").append(columns).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable addColumnWithV1TableCannotSpecifyNotNullError() {
        return new AnalysisException("ADD COLUMN with v1 tables cannot specify NOT NULL.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable replaceColumnsOnlySupportedWithV2TableError() {
        return new AnalysisException("REPLACE COLUMNS is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterQualifiedColumnOnlySupportedWithV2TableError() {
        return new AnalysisException("ALTER COLUMN with qualified column is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterColumnWithV1TableCannotSpecifyNotNullError() {
        return new AnalysisException("ALTER COLUMN with v1 tables cannot specify NOT NULL.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterOnlySupportedWithV2TableError() {
        return new AnalysisException("ALTER COLUMN ... FIRST | ALTER is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterColumnCannotFindColumnInV1TableError(String colName, V1Table v1Table) {
        return new AnalysisException(new StringBuilder(57).append("ALTER COLUMN cannot find column ").append(colName).append(" in v1 table. ").append("Available: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])v1Table.schema().fieldNames())).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable renameColumnOnlySupportedWithV2TableError() {
        return new AnalysisException("RENAME COLUMN is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dropColumnOnlySupportedWithV2TableError() {
        return new AnalysisException("DROP COLUMN is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidDatabaseNameError(String quoted) {
        return new AnalysisException(new StringBuilder(32).append("The database name is not valid: ").append(quoted).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable replaceTableOnlySupportedWithV2TableError() {
        return new AnalysisException("REPLACE TABLE is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable replaceTableAsSelectOnlySupportedWithV2TableError() {
        return new AnalysisException("REPLACE TABLE AS SELECT is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotDropViewWithDropTableError() {
        return new AnalysisException("Cannot drop a view with DROP TABLE. Please use DROP VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable showColumnsWithConflictDatabasesError(Seq<String> db, TableIdentifier v1TableName) {
        return new AnalysisException(new StringBuilder(49).append("SHOW COLUMNS with conflicting databases: ").append("'").append(db.head()).append("' != '").append(v1TableName.database().get()).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable externalCatalogNotSupportShowViewsError(ResolvedNamespace resolved2) {
        return new AnalysisException(new StringBuilder(79).append("Catalog ").append(resolved2.catalog().name()).append(" doesn't support ").append("SHOW VIEWS, only SessionCatalog supports this command.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedFunctionNameError(String quoted) {
        return new AnalysisException(new StringBuilder(28).append("Unsupported function name '").append(quoted).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable sqlOnlySupportedWithV1TablesError(String sql2) {
        return new AnalysisException(new StringBuilder(34).append(sql2).append(" is only supported with v1 tables.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotCreateTableWithBothProviderAndSerdeError(Option<String> provider, Option<SerdeInfo> maybeSerdeInfo) {
        return new AnalysisException(new StringBuilder(41).append("Cannot create table with both USING ").append(provider).append(" and ").append(((SerdeInfo)maybeSerdeInfo.get()).describe()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidFileFormatForStoredAsError(SerdeInfo serdeInfo) {
        return new AnalysisException(new StringBuilder(41).append("STORED AS with file format '").append(serdeInfo.storedAs().get()).append("' is invalid.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable commandNotSupportNestedColumnError(String command, String quoted) {
        return new AnalysisException(new StringBuilder(33).append(command).append(" does not support nested column: ").append(quoted).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable columnDoesNotExistError(String colName) {
        return new AnalysisException(new StringBuilder(22).append("Column ").append(colName).append(" does not exist").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable renameTempViewToExistingViewError(String oldName, String newName) {
        return new AnalysisException(new StringBuilder(68).append("rename temporary view from '").append(oldName).append("' to '").append(newName).append("': destination view already exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable databaseNotEmptyError(String db, String details) {
        return new AnalysisException(new StringBuilder(43).append("Database ").append(db).append(" is not empty. One or more ").append(details).append(" exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidNameForTableOrDatabaseError(String name) {
        return new AnalysisException(new StringBuilder(105).append("`").append(name).append("` is not a valid name for tables/databases. ").append("Valid names only contain alphabet characters, numbers and _.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotCreateDatabaseWithSameNameAsPreservedDatabaseError(String database) {
        return new AnalysisException(new StringBuilder(77).append(database).append(" is a system preserved database, ").append("you cannot create a database with this name.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotDropDefaultDatabaseError() {
        return new AnalysisException("Can not drop default database", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotUsePreservedDatabaseAsCurrentDatabaseError(String database) {
        return new AnalysisException(new StringBuilder(196).append(database).append(" is a system preserved database, you cannot use it as ").append("current database. To access global temporary views, you should use qualified name with ").append("the GLOBAL_TEMP_DATABASE, e.g. SELECT * FROM ").append(database).append(".viewName.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createExternalTableWithoutLocationError() {
        return new AnalysisException("CREATE EXTERNAL TABLE must be accompanied by LOCATION", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotOperateManagedTableWithExistingLocationError(String methodName, TableIdentifier tableIdentifier, Path tableLocation) {
        return new AnalysisException(new StringBuilder(75).append("Can not ").append(methodName).append(" the managed table('").append(tableIdentifier).append("')").append(". The associated location('").append(tableLocation.toString()).append("') already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dropNonExistentColumnsNotSupportedError(Seq<String> nonExistentColumnNames) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n         |Some existing schema fields (").append(nonExistentColumnNames.mkString("[", ",", "]")).append(") are\n         |not present in the new schema. We don't support dropping columns yet.\n         ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotRetrieveTableOrViewNotInSameDatabaseError(Seq<QualifiedTableName> qualifiedTableNames) {
        return new AnalysisException(new StringBuilder(94).append("Only the tables/views belong to the same database can be retrieved. ").append("Querying tables/views are ").append(qualifiedTableNames).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable renameTableSourceAndDestinationMismatchError(String db, String newDb) {
        return new AnalysisException(new StringBuilder(68).append("RENAME TABLE source and destination databases do not match: '").append(db).append("' != '").append(newDb).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotRenameTempViewWithDatabaseSpecifiedError(TableIdentifier oldName, TableIdentifier newName) {
        return new AnalysisException(new StringBuilder(93).append("RENAME TEMPORARY VIEW from '").append(oldName).append("' to '").append(newName).append("': cannot ").append("specify database name '").append(newName.database().get()).append("' in the destination table").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotRenameTempViewToExistingTableError(TableIdentifier oldName, TableIdentifier newName) {
        return new AnalysisException(new StringBuilder(69).append("RENAME TEMPORARY VIEW from '").append(oldName).append("' to '").append(newName).append("': ").append("destination table already exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidPartitionSpecError(String details) {
        return new AnalysisException(new StringBuilder(27).append("Partition spec is invalid. ").append(details).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable functionAlreadyExistsError(FunctionIdentifier func) {
        return new AnalysisException(new StringBuilder(24).append("Function ").append(func).append(" already exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotLoadClassWhenRegisteringFunctionError(String className, FunctionIdentifier func) {
        return new AnalysisException(new StringBuilder(95).append("Can not load class '").append(className).append("' when registering ").append("the function '").append(func).append("', please make sure it is on the classpath").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable v2CatalogNotSupportFunctionError(String catalog, Seq<String> namespace) {
        return new AnalysisException(new StringBuilder(67).append("V2 catalog does not support functions yet. ").append("catalog: ").append(catalog).append(", namespace: '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(namespace).quoted()).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable resourceTypeNotSupportedError(String resourceType) {
        return new AnalysisException(new StringBuilder(34).append("Resource Type '").append(resourceType).append("' is not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable tableNotSpecifyDatabaseError(TableIdentifier identifier) {
        return new AnalysisException(new StringBuilder(31).append("table ").append(identifier).append(" did not specify database").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable tableNotSpecifyLocationUriError(TableIdentifier identifier) {
        return new AnalysisException(new StringBuilder(34).append("table ").append(identifier).append(" did not specify locationUri").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionNotSpecifyLocationUriError(String specString) {
        return new AnalysisException(new StringBuilder(40).append("Partition [").append(specString).append("] did not specify locationUri").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidBucketNumberError(int bucketingMaxBuckets, int numBuckets) {
        return new AnalysisException(new StringBuilder(102).append("Number of buckets should be greater than 0 but less than or equal to ").append("bucketing.maxBuckets (`").append(bucketingMaxBuckets).append("`). Got `").append(numBuckets).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable corruptedTableNameContextInCatalogError(int numParts, int index) {
        return new AnalysisException(new StringBuilder(79).append("Corrupted table name context in catalog: ").append(numParts).append(" parts expected, but part ").append(index).append(" is missing.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable corruptedViewSQLConfigsInCatalogError(Exception e) {
        String x$1 = "Corrupted view SQL configs in catalog";
        Some x$2 = new Some((Object)e);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2);
    }

    public Throwable corruptedViewQueryOutputColumnsInCatalogError(String numCols, int index) {
        return new AnalysisException(new StringBuilder(91).append("Corrupted view query output column names in catalog: ").append(numCols).append(" parts expected, but part ").append(index).append(" is missing.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable corruptedViewReferredTempViewInCatalogError(Exception e) {
        String x$1 = "corrupted view referred temp view names in catalog";
        Some x$2 = new Some((Object)e);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2);
    }

    public Throwable corruptedViewReferredTempFunctionsInCatalogError(Exception e) {
        String x$1 = "corrupted view referred temp functions names in catalog";
        Some x$2 = new Some((Object)e);
        Option<Object> x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option<Object> x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option<LogicalPlan> x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option<Throwable>)x$2);
    }

    public Throwable columnStatisticsDeserializationNotSupportedError(String name, DataType dataType) {
        return new AnalysisException(new StringBuilder(78).append("Column statistics deserialization is not supported for ").append("column ").append(name).append(" of data type: ").append(dataType).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable columnStatisticsSerializationNotSupportedError(String colName, DataType dataType) {
        return new AnalysisException(new StringBuilder(76).append("Column statistics serialization is not supported for ").append("column ").append(colName).append(" of data type: ").append(dataType).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotReadCorruptedTablePropertyError(String key, String details) {
        return new AnalysisException(new StringBuilder(48).append("Cannot read table property '").append(key).append("' as it's corrupted.").append(details).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public String cannotReadCorruptedTablePropertyError$default$2() {
        return "";
    }

    public Throwable invalidSchemaStringError(Expression exp) {
        return new AnalysisException(new StringBuilder(47).append("The expression '").append(exp.sql()).append("' is not a valid schema string.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable schemaNotFoldableError(Expression exp) {
        return new AnalysisException(new StringBuilder(128).append("Schema should be specified in DDL format as a string literal or output of ").append("the schema_of_json/schema_of_csv functions instead of ").append(exp.sql()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable schemaIsNotStructTypeError(DataType dataType) {
        return new AnalysisException(new StringBuilder(38).append("Schema should be struct type but got ").append(dataType.sql()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable keyValueInMapNotStringError(CreateMap m) {
        return new AnalysisException(new StringBuilder(59).append("A type of keys and values in map() must be string, but got ").append(m.dataType().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonMapFunctionNotAllowedError() {
        return new AnalysisException("Must use a map() function for options", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidFieldTypeForCorruptRecordError() {
        return new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataTypeUnsupportedByClassError(DataType x, String className) {
        return new AnalysisException(new StringBuilder(33).append("DataType '").append(x).append("' is not supported by ").append(className).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable parseModeUnsupportedError(String funcName, ParseMode mode) {
        return new AnalysisException(new StringBuilder(57).append(funcName).append("() doesn't support the ").append(mode.name()).append(" mode. ").append("Acceptable modes are ").append(PermissiveMode$.MODULE$.name()).append(" and ").append(FailFastMode$.MODULE$.name()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unfoldableFieldUnsupportedError() {
        return new AnalysisException("The field parameter needs to be a foldable string value.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable literalTypeUnsupportedForSourceTypeError(String field, Expression source) {
        return new AnalysisException(new StringBuilder(62).append("Literals of type '").append(field).append("' are currently not supported ").append("for the ").append(source.dataType().catalogString()).append(" type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable arrayComponentTypeUnsupportedError(Class<?> clz) {
        return new AnalysisException(new StringBuilder(37).append("Unsupported component type ").append(clz).append(" in arrays").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable secondArgumentNotDoubleLiteralError() {
        return new AnalysisException("The second argument should be a double literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataTypeUnsupportedByExtractValueError(DataType dataType, Expression extraction, Expression child) {
        DataType dataType2 = dataType;
        String string = dataType2 instanceof StructType ? new StringBuilder(46).append("Field name should be String Literal, but it's ").append(extraction).toString() : new StringBuilder(52).append("Can't extract value from ").append(child).append(": need struct type but got ").append(dataType2.catalogString()).toString();
        String errorMsg = string;
        return new AnalysisException(errorMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable noHandlerForUDAFError(String name) {
        return new InvalidUDFClassException(new StringBuilder(67).append("No handler for UDAF '").append(name).append("'. ").append("Use sparkSession.udf.register(...) instead.").toString());
    }

    public Throwable batchWriteCapabilityError(Table table, String v2WriteClassName, String v1WriteClassName) {
        return new AnalysisException(new StringBuilder(55).append("Table ").append(table.name()).append(" declares ").append((Object)TableCapability.V1_BATCH_WRITE).append(" capability but ").append(v2WriteClassName).append(" is not an instance of ").append(v1WriteClassName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedDeleteByConditionWithSubqueryError(Option<Expression> condition) {
        return new AnalysisException(new StringBuilder(52).append("Delete by condition with subquery is not supported: ").append(condition).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotTranslateExpressionToSourceFilterError(Expression f) {
        return new AnalysisException(new StringBuilder(66).append("Exec update failed:").append(" cannot translate expression to source filter: ").append(f).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotDeleteTableWhereFiltersError(Table table, Filter[] filters) {
        return new AnalysisException(new StringBuilder(32).append("Cannot delete from table ").append(table.name()).append(" where ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).mkString("[", ", ", "]")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable deleteOnlySupportedWithV2TablesError() {
        return new AnalysisException("DELETE is only supported with v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable describeDoesNotSupportPartitionForV2TablesError() {
        return new AnalysisException("DESCRIBE does not support partition for v2 tables.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotReplaceMissingTableError(Identifier tableIdentifier) {
        return new CannotReplaceMissingTableException(tableIdentifier, CannotReplaceMissingTableException$.MODULE$.$lessinit$greater$default$2());
    }

    public Throwable cannotReplaceMissingTableError(Identifier tableIdentifier, Option<Throwable> cause) {
        return new CannotReplaceMissingTableException(tableIdentifier, cause);
    }

    public Throwable unsupportedTableOperationError(Table table, String cmd) {
        return new AnalysisException(new StringBuilder(25).append("Table ").append(table.name()).append(" does not support ").append(cmd).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedBatchReadError(Table table) {
        return this.unsupportedTableOperationError(table, "batch scan");
    }

    public Throwable unsupportedMicroBatchOrContinuousScanError(Table table) {
        return this.unsupportedTableOperationError(table, "either micro-batch or continuous scan");
    }

    public Throwable unsupportedAppendInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table, "append in batch mode");
    }

    public Throwable unsupportedDynamicOverwriteInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table, "dynamic overwrite in batch mode");
    }

    public Throwable unsupportedTruncateInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table, "truncate in batch mode");
    }

    public Throwable unsupportedOverwriteByFilterInBatchModeError(Table table) {
        return this.unsupportedTableOperationError(table, "overwrite by filter in batch mode");
    }

    public Throwable streamingSourcesDoNotSupportCommonExecutionModeError(Seq<String> microBatchSources, Seq<String> continuousSources) {
        return new AnalysisException(new StringBuilder(138).append("The streaming sources in a query do not have a common supported execution mode.\nSources support micro-batch: ").append(microBatchSources.mkString(", ")).append("\n").append("Sources support continuous: ").append(continuousSources.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable noSuchTableError(Identifier ident) {
        return new NoSuchTableException(ident);
    }

    public Throwable noSuchNamespaceError(String[] namespace) {
        return new NoSuchNamespaceException(namespace);
    }

    public Throwable tableAlreadyExistsError(Identifier ident) {
        return new TableAlreadyExistsException(ident);
    }

    public Throwable requiresSinglePartNamespaceError(Identifier ident) {
        return new NoSuchTableException(new StringBuilder(53).append("V2 session catalog requires a single-part namespace: ").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString(), NoSuchTableException$.MODULE$.$lessinit$greater$default$2());
    }

    public Throwable namespaceAlreadyExistsError(String[] namespace) {
        return new NamespaceAlreadyExistsException(namespace);
    }

    private Throwable notSupportedInJDBCCatalog(String cmd) {
        return new AnalysisException(new StringBuilder(34).append(cmd).append(" is not supported in JDBC catalog.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotCreateJDBCTableUsingProviderError() {
        return this.notSupportedInJDBCCatalog("CREATE TABLE ... USING ...");
    }

    public Throwable cannotCreateJDBCTableUsingLocationError() {
        return this.notSupportedInJDBCCatalog("CREATE TABLE ... LOCATION ...");
    }

    public Throwable cannotCreateJDBCNamespaceUsingProviderError() {
        return this.notSupportedInJDBCCatalog("CREATE NAMESPACE ... LOCATION ...");
    }

    public Throwable cannotCreateJDBCNamespaceWithPropertyError(String k) {
        return this.notSupportedInJDBCCatalog(new StringBuilder(31).append("CREATE NAMESPACE with property ").append(k).toString());
    }

    public Throwable cannotSetJDBCNamespaceWithPropertyError(String k) {
        return this.notSupportedInJDBCCatalog(new StringBuilder(28).append("SET NAMESPACE with property ").append(k).toString());
    }

    public Throwable cannotUnsetJDBCNamespaceWithPropertyError(String k) {
        return this.notSupportedInJDBCCatalog(new StringBuilder(26).append("Remove NAMESPACE property ").append(k).toString());
    }

    public Throwable unsupportedJDBCNamespaceChangeInCatalogError(Seq<NamespaceChange> changes) {
        return new AnalysisException(new StringBuilder(45).append("Unsupported NamespaceChange ").append(changes).append(" in JDBC catalog.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private Throwable tableDoesNotSupportError(String cmd, Table table) {
        return new AnalysisException(new StringBuilder(25).append("Table does not support ").append(cmd).append(": ").append(table.name()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable tableDoesNotSupportReadsError(Table table) {
        return this.tableDoesNotSupportError("reads", table);
    }

    public Throwable tableDoesNotSupportWritesError(Table table) {
        return this.tableDoesNotSupportError("writes", table);
    }

    public Throwable tableDoesNotSupportDeletesError(Table table) {
        return this.tableDoesNotSupportError("deletes", table);
    }

    public Throwable tableDoesNotSupportTruncatesError(Table table) {
        return this.tableDoesNotSupportError("truncates", table);
    }

    public Throwable tableDoesNotSupportPartitionManagementError(Table table) {
        return this.tableDoesNotSupportError("partition management", table);
    }

    public Throwable tableDoesNotSupportAtomicPartitionManagementError(Table table) {
        return this.tableDoesNotSupportError("atomic partition management", table);
    }

    public Throwable cannotRenameTableWithAlterViewError() {
        return new AnalysisException("Cannot rename a table with ALTER VIEW. Please use ALTER TABLE instead.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private Throwable notSupportedForV2TablesError(String cmd) {
        return new AnalysisException(new StringBuilder(32).append(cmd).append(" is not supported for v2 tables.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable analyzeTableNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ANALYZE TABLE");
    }

    public Throwable alterTableRecoverPartitionsNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ALTER TABLE ... RECOVER PARTITIONS");
    }

    public Throwable alterTableSerDePropertiesNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("ALTER TABLE ... SET [SERDE|SERDEPROPERTIES]");
    }

    public Throwable loadDataNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("LOAD DATA");
    }

    public Throwable showCreateTableNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("SHOW CREATE TABLE");
    }

    public Throwable truncateTableNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("TRUNCATE TABLE");
    }

    public Throwable showColumnsNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("SHOW COLUMNS");
    }

    public Throwable repairTableNotSupportedForV2TablesError() {
        return this.notSupportedForV2TablesError("MSCK REPAIR TABLE");
    }

    public Throwable databaseFromV1SessionCatalogNotSpecifiedError() {
        return new AnalysisException("Database from v1 session catalog is not specified", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nestedDatabaseUnsupportedByV1SessionCatalogError(String catalog) {
        return new AnalysisException(new StringBuilder(58).append("Nested databases are not supported by v1 session catalog: ").append(catalog).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidRepartitionExpressionsError(Seq<Object> sortOrders) {
        return new AnalysisException(new StringBuilder(91).append("Invalid partitionExprs specified: ").append(sortOrders).append(" For range ").append("partitioning use REPARTITION_BY_RANGE instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionColumnNotSpecifiedError(String format, String partitionColumn) {
        return new AnalysisException(new StringBuilder(92).append("Failed to resolve the schema for ").append(format).append(" for ").append("the partition column: ").append(partitionColumn).append(". It must be specified manually.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataSchemaNotSpecifiedError(String format) {
        return new AnalysisException(new StringBuilder(59).append("Unable to infer schema for ").append(format).append(". It must be specified manually.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataPathNotExistError(String path) {
        return new AnalysisException(new StringBuilder(21).append("Path does not exist: ").append(path).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataSourceOutputModeUnsupportedError(String className, OutputMode outputMode) {
        return new AnalysisException(new StringBuilder(42).append("Data source ").append(className).append(" does not support ").append(outputMode).append(" output mode").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable schemaNotSpecifiedForSchemaRelationProviderError(String className) {
        return new AnalysisException(new StringBuilder(43).append("A schema needs to be specified when using ").append(className).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable userSpecifiedSchemaMismatchActualSchemaError(StructType schema, StructType actualSchema) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(306).append("\n         |The user-specified schema doesn't match the actual schema:\n         |user-specified: ").append(schema.toDDL()).append(", actual: ").append(actualSchema.toDDL()).append(". If you're using\n         |DataFrameReader.schema API or creating a table, please do not specify the schema.\n         |Or if you're scanning an existed table, please drop it and re-create it.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataSchemaNotSpecifiedError(String format, String fileCatalog) {
        return new AnalysisException(new StringBuilder(62).append("Unable to infer schema for ").append(format).append(" at ").append(fileCatalog).append(". It must be specified manually").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidDataSourceError(String className) {
        return new AnalysisException(new StringBuilder(38).append(className).append(" is not a valid Spark SQL Data Source.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotSaveIntervalIntoExternalStorageError() {
        return new AnalysisException("Cannot save interval data type into external storage.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotResolveAttributeError(String name, LogicalPlan data) {
        return new AnalysisException(new StringBuilder(27).append("Unable to resolve ").append(name).append(" given [").append(((TraversableOnce)data.output().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable orcNotUsedWithHiveEnabledError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString("\n         |Hive built-in ORC data source must be used with Hive support enabled.\n         |Please use the native ORC data source by setting 'spark.sql.orc.impl' to 'native'\n       ")).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable failedToFindAvroDataSourceError(String provider) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |Failed to find data source: ").append(provider).append(". Avro is built-in but external data\n         |source module since Spark 2.4. Please deploy the application as per\n         |the deployment section of \"Apache Avro Data Source Guide\".\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable failedToFindKafkaDataSourceError(String provider) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(171).append("\n         |Failed to find data source: ").append(provider).append(". Please deploy the application as\n         |per the deployment section of \"Structured Streaming + Kafka Integration Guide\".\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable findMultipleDataSourceError(String provider, Seq<String> sourceNames) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(108).append("\n         |Multiple sources found for ").append(provider).append(" (").append(sourceNames.mkString(", ")).append("),\n         | please specify the fully qualified class name.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable writeEmptySchemasUnsupportedByDataSourceError() {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString("\n         |Datasource does not support writing empty or nested empty schemas.\n         |Please make sure the data schema has at least one or more column(s).\n       ")).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable insertMismatchedColumnNumberError(Seq<Attribute> targetAttributes, Seq<Attribute> sourceAttributes, int staticPartitionsSize) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(278).append("\n         |The data to be inserted needs to have the same number of columns as the\n         |target table: target table has ").append(targetAttributes.size()).append(" column(s) but the\n         |inserted data has ").append(sourceAttributes.size() + staticPartitionsSize).append(" column(s),\n         |which contain ").append(staticPartitionsSize).append(" partition column(s) having assigned\n         |constant values.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable insertMismatchedPartitionNumberError(StructType targetPartitionSchema, int providedPartitionsSize) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(238).append("\n         |The data to be inserted needs to have the same number of partition columns\n         |as the target table: target table has ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields())).size()).append("\n         |partition column(s) but the inserted data has ").append(providedPartitionsSize).append("\n         |partition columns specified.\n       ").toString())).stripMargin().replaceAll("\n", " "), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidPartitionColumnError(String partKey, StructType targetPartitionSchema) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |").append(partKey).append(" is not a partition column. Partition columns are\n         |").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multiplePartitionColumnValuesSpecifiedError(StructField field, Map<String, String> potentialSpecs) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n         |Partition column ").append(field.name()).append(" have multiple values specified,\n         |").append(potentialSpecs.mkString("[", ", ", "]")).append(". Please only specify a single value.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidOrderingForConstantValuePartitionColumnError(StructType targetPartitionSchema) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("\n         |The ordering of partition columns is\n         |").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetPartitionSchema.fields())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")).append("\n         |All partition columns having constant values need to appear before other\n         |partition columns that do not have an assigned constant value.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotWriteDataToRelationsWithMultiplePathsError() {
        return new AnalysisException("Can only write data to relations with a single path.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable failedToRebuildExpressionError(Filter filter) {
        return new AnalysisException(new StringBuilder(68).append("Fail to rebuild expression: missing key ").append(filter).append(" in `translatedFilterToExpr`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataTypeUnsupportedByDataSourceError(String format, StructField field) {
        return new AnalysisException(new StringBuilder(41).append(format).append(" data source does not support ").append(field.dataType().catalogString()).append(" data type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable failToResolveDataSourceForTableError(CatalogTable table, String key) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(383).append("\n         |Fail to resolve data source for the table ").append(table.identifier()).append(" since the table\n         |serde property has the duplicated key ").append(key).append(" with extra options specified for this\n         |scan operation. To fix this, you can rollback to the legacy behavior of ignoring\n         |the extra options by setting the config\n         |").append(SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR().key()).append(" to `false`, or address the\n         |conflicts of the same config.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable outputPathAlreadyExistsError(Path outputPath) {
        return new AnalysisException(new StringBuilder(21).append("path ").append(outputPath).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotUseDataTypeForPartitionColumnError(StructField field) {
        return new AnalysisException(new StringBuilder(32).append("Cannot use ").append(field.dataType()).append(" for partition column").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotUseAllColumnsForPartitionColumnsError() {
        return new AnalysisException("Cannot use all columns for partition columns", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionColumnNotFoundInSchemaError(String col, String schemaCatalog) {
        return new AnalysisException(new StringBuilder(40).append("Partition column `").append(col).append("` not found in schema ").append(schemaCatalog).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable columnNotFoundInSchemaError(StructField col, Option<StructType> tableSchema) {
        return new AnalysisException(new StringBuilder(30).append("Column \"").append(col.name()).append("\" not found in schema ").append(tableSchema).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedDataSourceTypeForDirectQueryOnFilesError(String className) {
        return new AnalysisException(new StringBuilder(56).append("Unsupported data source type for direct query on files: ").append(className).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable saveDataIntoViewNotAllowedError() {
        return new AnalysisException("Saving data into a view is not allowed.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable mismatchedTableFormatError(String tableName, Class<?> existingProvider, Class<?> specifiedProvider) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n         |The format of the existing table ").append(tableName).append(" is `").append(existingProvider.getSimpleName()).append("`.\n         |It doesn't match the specified format `").append(specifiedProvider.getSimpleName()).append("`.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable mismatchedTableLocationError(TableIdentifier identifier, CatalogTable existingTable, CatalogTable tableDesc) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n         |The location of the existing table ").append(identifier.quotedString()).append(" is\n         |`").append(existingTable.location()).append("`. It doesn't match the specified location\n         |`").append(tableDesc.location()).append("`.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable mismatchedTableColumnNumberError(String tableName, CatalogTable existingTable, LogicalPlan query) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append("\n         |The column number of the existing table ").append(tableName).append("\n         |(").append(existingTable.schema().catalogString()).append(") doesn't match the data schema\n         |(").append(query.schema().catalogString()).append(")\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotResolveColumnGivenInputColumnsError(String col, String inputColumns) {
        return new AnalysisException(new StringBuilder(41).append("cannot resolve '").append(col).append("' given input columns: [").append(inputColumns).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable mismatchedTablePartitionColumnError(String tableName, Seq<String> specifiedPartCols, String existingPartCols) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("\n         |Specified partitioning does not match that of the existing table ").append(tableName).append(".\n         |Specified partition columns: [").append(specifiedPartCols.mkString(", ")).append("]\n         |Existing partition columns: [").append(existingPartCols).append("]\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable mismatchedTableBucketingError(String tableName, String specifiedBucketString, String existingBucketString) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(145).append("\n         |Specified bucketing does not match that of the existing table ").append(tableName).append(".\n         |Specified bucketing: ").append(specifiedBucketString).append("\n         |Existing bucketing: ").append(existingBucketString).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable specifyPartitionNotAllowedWhenTableSchemaNotDefinedError() {
        return new AnalysisException("It is not allowed to specify partitioning when the table schema is not defined.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bucketingColumnCannotBePartOfPartitionColumnsError(String bucketCol, Seq<String> normalizedPartCols) {
        return new AnalysisException(new StringBuilder(62).append("bucketing column '").append(bucketCol).append("' should not be part of ").append("partition columns '").append(normalizedPartCols.mkString(", ")).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bucketSortingColumnCannotBePartOfPartitionColumnsError(String sortCol, Seq<String> normalizedPartCols) {
        return new AnalysisException(new StringBuilder(67).append("bucket sorting column '").append(sortCol).append("' should not be part of ").append("partition columns '").append(normalizedPartCols.mkString(", ")).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable mismatchedInsertedDataColumnNumberError(String tableName, InsertIntoStatement insert, Set<String> staticPartCols) {
        return new AnalysisException(new StringBuilder(214).append(tableName).append(" requires that the data to be inserted have the same number of columns as ").append("the target table: target table has ").append(insert.table().output().size()).append(" column(s) but the ").append("inserted data has ").append(insert.query().output().length() + staticPartCols.size()).append(" column(s), ").append("including ").append(staticPartCols.size()).append(" partition column(s) having constant value(s).").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable requestedPartitionsMismatchTablePartitionsError(String tableName, Map<String, Option<String>> normalizedPartSpec, StructType partColNames) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n         |Requested partitioning does not match the table ").append(tableName).append(":\n         |Requested partitions: ").append(normalizedPartSpec.keys().mkString(",")).append("\n         |Table partitions: ").append(partColNames.mkString(",")).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable ddlWithoutHiveSupportEnabledError(String detail) {
        return new AnalysisException(new StringBuilder(28).append("Hive support is required to ").append(detail).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createTableColumnTypesOptionColumnNotFoundInSchemaError(String col, StructType schema) {
        return new AnalysisException(new StringBuilder(58).append("createTableColumnTypes option column ").append(col).append(" not found in schema ").append(schema.catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable parquetTypeUnsupportedYetError(String parquetType) {
        return new AnalysisException(new StringBuilder(32).append("Parquet type not yet supported: ").append(parquetType).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable illegalParquetTypeError(String parquetType) {
        return new AnalysisException(new StringBuilder(22).append("Illegal Parquet type: ").append(parquetType).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unrecognizedParquetTypeError(String field) {
        return new AnalysisException(new StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotConvertDataTypeToParquetTypeError(StructField field) {
        return new AnalysisException(new StringBuilder(22).append("Unsupported data type ").append(field.dataType().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable incompatibleViewSchemaChange(String viewName, String colName, int expectedNum, Seq<Attribute> actualCols) {
        return new AnalysisException(new StringBuilder(122).append("The SQL query of view ").append(viewName).append(" has an incompatible schema change ").append("and column ").append(colName).append(" cannot be resolved. Expected ").append(expectedNum).append(" columns named ").append(colName).append(" but ").append("got ").append(((TraversableOnce)actualCols.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable numberOfPartitionsNotAllowedWithUnspecifiedDistributionError() {
        throw new AnalysisException("The number of partitions can't be specified with unspecified distribution. Invalid writer requirements detected.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotApplyTableValuedFunctionError(String name, String arguments, String usage, String details) {
        return new AnalysisException(new StringBuilder(68).append("Table-valued function ").append(name).append(" with alternatives: ").append(usage).append("\n").append("cannot be applied to (").append(arguments).append("): ").append(details).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public String cannotApplyTableValuedFunctionError$default$4() {
        return "";
    }

    public Throwable incompatibleRangeInputDataTypeError(Expression expression, DataType dataType) {
        return new AnalysisException(new StringBuilder(49).append("Incompatible input data type. ").append("Expected: ").append(dataType.typeName()).append("; Found: ").append(expression.dataType().typeName()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private QueryCompilationErrors$() {
        MODULE$ = this;
    }
}

