/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTableOrView;
import org.apache.spark.sql.catalyst.analysis.UnresolvedView;
import org.apache.spark.sql.catalyst.plans.logical.DropTable;
import org.apache.spark.sql.catalyst.plans.logical.DropView;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.NoopCommand;
import org.apache.spark.sql.catalyst.plans.logical.UncacheTable;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public final class ResolveCommandsWithIfExists$
extends Rule<LogicalPlan> {
    public static ResolveCommandsWithIfExists$ MODULE$;

    static {
        new ResolveCommandsWithIfExists$();
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperatorsUpWithPruning((Function1<TreePatternBits, Object>)(Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.containsPattern(TreePattern$.MODULE$.COMMAND())), plan2.resolveOperatorsUpWithPruning$default$2(), (PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DropTable) {
                    DropTable dropTable = (DropTable)A1;
                    LogicalPlan u = dropTable.child();
                    boolean ifExists = dropTable.ifExists();
                    if (u instanceof UnresolvedTableOrView) {
                        UnresolvedTableOrView unresolvedTableOrView = (UnresolvedTableOrView)u;
                        if (ifExists) {
                            object = new NoopCommand("DROP TABLE", unresolvedTableOrView.multipartIdentifier());
                            return (B1)object;
                        }
                    }
                }
                if (A1 instanceof DropView) {
                    DropView dropView = (DropView)A1;
                    LogicalPlan u = dropView.child();
                    boolean ifExists = dropView.ifExists();
                    if (u instanceof UnresolvedView) {
                        UnresolvedView unresolvedView = (UnresolvedView)u;
                        if (ifExists) {
                            object = new NoopCommand("DROP VIEW", unresolvedView.multipartIdentifier());
                            return (B1)object;
                        }
                    }
                }
                if (A1 instanceof UncacheTable) {
                    UncacheTable uncacheTable = (UncacheTable)A1;
                    LogicalPlan u = uncacheTable.table();
                    boolean ifExists = uncacheTable.ifExists();
                    if (u instanceof UnresolvedRelation) {
                        UnresolvedRelation unresolvedRelation = (UnresolvedRelation)u;
                        if (ifExists) {
                            object = new NoopCommand("UNCACHE TABLE", unresolvedRelation.multipartIdentifier());
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof DropTable) {
                    DropTable dropTable = (DropTable)logicalPlan;
                    LogicalPlan u = dropTable.child();
                    boolean ifExists = dropTable.ifExists();
                    if (u instanceof UnresolvedTableOrView && ifExists) {
                        return true;
                    }
                }
                if (logicalPlan instanceof DropView) {
                    DropView dropView = (DropView)logicalPlan;
                    LogicalPlan u = dropView.child();
                    boolean ifExists = dropView.ifExists();
                    if (u instanceof UnresolvedView && ifExists) {
                        return true;
                    }
                }
                if (!(logicalPlan instanceof UncacheTable)) return false;
                UncacheTable uncacheTable = (UncacheTable)logicalPlan;
                LogicalPlan u = uncacheTable.table();
                boolean ifExists = uncacheTable.ifExists();
                if (!(u instanceof UnresolvedRelation)) return false;
                if (!ifExists) return false;
                return true;
            }
        });
    }

    private ResolveCommandsWithIfExists$() {
        MODULE$ = this;
    }
}

