/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.ArraysZip$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamePlaceholder$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(a1, a2, ...) - Returns a merged array of structs in which the N-th struct contains all\n    N-th values of input arrays.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(2, 3, 4));\n       [{\"0\":1,\"1\":2},{\"0\":2,\"1\":3},{\"0\":3,\"1\":4}]\n      > SELECT _FUNC_(array(1, 2), array(2, 3), array(3, 4));\n       [{\"0\":1,\"1\":2,\"2\":3},{\"0\":2,\"1\":3,\"2\":4}]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0013'\u0001NB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t%\u0002\u0011\t\u0012)A\u0005\r\"A1\u000b\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005U\u0001\tE\t\u0015!\u0003G\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015)\u0006\u0001\"\u0001[\u0011\u001da\u0006A1A\u0005FuCa\u0001\u001e\u0001!\u0002\u001bq\u0006\u0002C;\u0001\u0011\u000b\u0007I\u0011\t<\t\u000bi\u0004A\u0011I>\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0003\nI\u0001\u0003\u0004\u0002\u001a\u0001!\tE\u001e\u0005\u000b\u00037\u0001\u0001R1A\u0005\n\u0005u\u0001bBA\u0016\u0001\u0011%\u0011Q\u0006\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0019\u0001\t\u0003\n)\u0007C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u00111\u0013\u0001\u0005R\u0005U\u0005\"CAQ\u0001\u0005\u0005I\u0011AAR\u0011%\tI\u000bAI\u0001\n\u0003\tY\u000bC\u0005\u0002B\u0002\t\n\u0011\"\u0001\u0002,\"I\u00111\u0019\u0001\u0002\u0002\u0013\u0005\u0013Q\u0006\u0005\n\u0003\u000b\u0004\u0011\u0011!C\u0001\u0003\u000fD\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005]\u0007!!A\u0005B\u0005e\u0007\"CAq\u0001\u0005\u0005I\u0011AAr\u0011%\t9\u000fAA\u0001\n\u0003\nIoB\u0004\u0003\u000e\u0019B\tAa\u0004\u0007\r\u00152\u0003\u0012\u0001B\t\u0011\u0019)v\u0004\"\u0001\u0003\u001a!9!1D\u0010\u0005\u0002\tu\u0001\"\u0003B\u000e?\u0005\u0005I\u0011\u0011B\u0011\u0011%\u00119cHA\u0001\n\u0003\u0013I\u0003C\u0005\u0003<}\t\t\u0011\"\u0003\u0003>\tI\u0011I\u001d:bsNT\u0016\u000e\u001d\u0006\u0003O!\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011FK\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0006L\u0001\u0004gFd'BA\u0017/\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000e\u001d<\u0003B\u0011QGN\u0007\u0002M%\u0011qG\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u001b:\u0013\tQdEA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002=\u0005&\u00111)\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\tG\"LG\u000e\u001a:f]V\ta\tE\u0002H\u001fRr!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-\u0013\u0014A\u0002\u001fs_>$h(C\u0001?\u0013\tqU(A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&aA*fc*\u0011a*P\u0001\nG\"LG\u000e\u001a:f]\u0002\nQA\\1nKN\faA\\1nKN\u0004\u0013A\u0002\u001fj]&$h\bF\u0002X1f\u0003\"!\u000e\u0001\t\u000b\u0011+\u0001\u0019\u0001$\t\u000bM+\u0001\u0019\u0001$\u0015\u0005][\u0006\"\u0002#\u0007\u0001\u00041\u0015\u0001\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001cX#\u00010\u0011\u0007\u001d{u\f\u0005\u0002ac:\u0011\u0011M\u001c\b\u0003E2t!aY6\u000f\u0005\u0011TgBA3j\u001d\t1\u0007N\u0004\u0002JO&\t\u0011'\u0003\u00020a%\u0011QFL\u0005\u0003W1J!!\u000b\u0016\n\u00055D\u0013!\u0002;sK\u0016\u001c\u0018BA8q\u0003-!&/Z3QCR$XM\u001d8\u000b\u00055D\u0013B\u0001:t\u0005-!&/Z3QCR$XM\u001d8\u000b\u0005=\u0004\u0018!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%\u0001\u0005sKN|GN^3e+\u00059\bC\u0001\u001fy\u0013\tIXHA\u0004C_>dW-\u00198\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001}!\r9u* \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005!&A\u0003usB,7/C\u0002\u0002\u0006}\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0003\u0011\u0007y\fi!C\u0002\u0002\u0010}\u0014\u0001\u0002R1uCRK\b/\u001a\u0015\u0004\u0017\u0005M\u0001c\u0001\u001f\u0002\u0016%\u0019\u0011qC\u001f\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00038vY2\f'\r\\3\u0002#\u0005\u0014(/Y=FY\u0016lWM\u001c;UsB,7/\u0006\u0002\u0002 A1\u0011\u0011EA\u0014\u0003\u0017i!!a\t\u000b\u0007\u0005\u0015R(\u0001\u0006d_2dWm\u0019;j_:L1\u0001UA\u0012Q\ri\u00111C\u0001\u0011O\u0016tWM]5d\u0003J\u0014\u0018-\u001f#bi\u0006,\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005!A.\u00198h\u0015\t\tI$\u0001\u0003kCZ\f\u0017\u0002BA\u001f\u0003g\u0011aa\u0015;sS:<\u0017!E3naRL\u0018J\u001c9vi\u001e+gnQ8eKR!\u00111IA(!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%M\u000591m\u001c3fO\u0016t\u0017\u0002BA'\u0003\u000f\u0012\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003#z\u0001\u0019AA\"\u0003\t)g/\u0001\u000bo_:,U\u000e\u001d;z\u0013:\u0004X\u000f^$f]\u000e{G-\u001a\u000b\u0007\u0003\u0007\n9&!\u0019\t\u000f\u0005e\u0003\u00031\u0001\u0002\\\u0005\u00191\r\u001e=\u0011\t\u0005\u0015\u0013QL\u0005\u0005\u0003?\n9E\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005E\u0003\u00031\u0001\u0002D\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u0007\n9'!\u001b\t\u000f\u0005e\u0013\u00031\u0001\u0002\\!9\u0011\u0011K\tA\u0002\u0005\r\u0013\u0001B3wC2$B!a\u001c\u0002vA\u0019A(!\u001d\n\u0007\u0005MTHA\u0002B]fD\u0011\"a\u001e\u0013!\u0003\u0005\r!!\u001f\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005m\u0014QP\u0007\u0002Q%\u0019\u0011q\u0010\u0015\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000baJ,G\u000f^=OC6,WCAAC!\u0011\t9)a$\u000f\t\u0005%\u00151\u0012\t\u0003\u0013vJ1!!$>\u0003\u0019\u0001&/\u001a3fM&!\u0011QHAI\u0015\r\ti)P\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2aVAL\u0011\u001d\tI\n\u0006a\u0001\u00037\u000b1B\\3x\u0007\"LG\u000e\u001a:f]B!q)!(5\u0013\r\ty*\u0015\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$RaVAS\u0003OCq\u0001R\u000b\u0011\u0002\u0003\u0007a\tC\u0004T+A\u0005\t\u0019\u0001$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0016\u0016\u0004\r\u0006=6FAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mV(\u0001\u0006b]:|G/\u0019;j_:LA!a0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!3\u0011\u0007q\nY-C\u0002\u0002Nv\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001c\u0002T\"I\u0011Q\u001b\u000e\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0007CBA\u0011\u0003;\fy'\u0003\u0003\u0002`\u0006\r\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a^As\u0011%\t)\u000eHA\u0001\u0002\u0004\ty'\u0001\u0004fcV\fGn\u001d\u000b\u0004o\u0006-\b\"CAk;\u0005\u0005\t\u0019AA8QM\u0001\u0011q^A{\u0003o\fY0!@\u0003\u0002\t\r!q\u0001B\u0005!\r)\u0014\u0011_\u0005\u0004\u0003g4#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003s\f\u0011Q\u0002\u0006!A\u0001\u0002sLR+O\u0007~C\u0013-\r\u0017!CJb\u0003E\f\u0018/S\u0001j\u0003EU3ukJt7\u000fI1![\u0016\u0014x-\u001a3!CJ\u0014\u0018-\u001f\u0011pM\u0002\u001aHO];diN\u0004\u0013N\u001c\u0011xQ&\u001c\u0007\u000e\t;iK\u0002rU\u0006\u001e5!gR\u0014Xo\u0019;!G>tG/Y5og\u0002\nG\u000e\u001c\u0006!A\u0001\u0002c*\f;iAY\fG.^3tA=4\u0007%\u001b8qkR\u0004\u0013M\u001d:bsNt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a@\u0002\u0003+T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001a\u0014\u0006\f\u0011beJ\f\u0017\u0010\u000b\u001a-AMb\u0003\u0005N\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6P\t\u0019#uEb#%\r\u0012;eud3P\t\u0019#uIb#%\r\u0012;gud3P\t\u0019#uMb#%\r\u0012;iul&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e%b\u0003%\u0019:sCfD#\u0007\f\u00114S1\u0002\u0013M\u001d:bs\"\u001aD\u0006\t\u001b*SmR\u0001\u0005\t\u0011!A\u0001\u00023l\u001f\u00121Ei\nDFI\u0019#uIb#E\r\u0012;gud3P\t\u0019#uIb#%\r\u0012;g1\u0012#G\t\u001e5{vS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u000b\t1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!1B\u0001\u0006e9\"d\u0006M\u0001\n\u0003J\u0014\u0018-_:[SB\u0004\"!N\u0010\u0014\t}\u0011\u0019\"\u0011\t\u0004y\tU\u0011b\u0001B\f{\t1\u0011I\\=SK\u001a$\"Aa\u0004\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007]\u0013y\u0002C\u0003EC\u0001\u0007a\tF\u0003X\u0005G\u0011)\u0003C\u0003EE\u0001\u0007a\tC\u0003TE\u0001\u0007a)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-\"q\u0007\t\u0006y\t5\"\u0011G\u0005\u0004\u0005_i$AB(qi&|g\u000eE\u0003=\u0005g1e)C\u0002\u00036u\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u001dG\u0005\u0005\t\u0019A,\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B !\u0011\t\tD!\u0011\n\t\t\r\u00131\u0007\u0002\u0007\u001f\nTWm\u0019;")
public class ArraysZip
extends Expression
implements ExpectsInputTypes,
scala.Serializable {
    private boolean resolved;
    private transient DataType dataType;
    private transient Seq<DataType> arrayElementTypes;
    private final Seq<Expression> children;
    private final Seq<Expression> names;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Seq<Expression>, Seq<Expression>>> unapply(ArraysZip arraysZip) {
        return ArraysZip$.MODULE$.unapply(arraysZip);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public Seq<Expression> names() {
        return this.names;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        ArraysZip arraysZip = this;
        synchronized (arraysZip) {
            if (!this.bitmap$0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.names().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.resolved()));
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.fill(this.children().length(), (Function0 & Serializable & scala.Serializable)() -> ArrayType$.MODULE$);
    }

    private DataType dataType$lzycompute() {
        ArraysZip arraysZip = this;
        synchronized (arraysZip) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Seq fields = (Seq)((TraversableLike)this.arrayElementTypes().zip(this.names(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Object name;
                    DataType elementType;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block2;
                            elementType = (DataType)tuple2._1();
                            Expression expression = (Expression)tuple2._2();
                            if (!(expression instanceof Literal)) break block2;
                            Literal literal = (Literal)expression;
                            name = literal.value();
                            DataType dataType = literal.dataType();
                            if (StringType$.MODULE$.equals(dataType)) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    StructField structField = new StructField(name.toString(), elementType, true, StructField$.MODULE$.apply$default$4());
                    return structField;
                }, Seq$.MODULE$.canBuildFrom());
                this.dataType = new ArrayType(StructType$.MODULE$.apply((Seq<StructField>)fields), false);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nullable()));
    }

    private Seq<DataType> arrayElementTypes$lzycompute() {
        ArraysZip arraysZip = this;
        synchronized (arraysZip) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.arrayElementTypes = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$3 -> ((ArrayType)x$3.dataType()).elementType(), Seq$.MODULE$.canBuildFrom());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.arrayElementTypes;
    }

    private Seq<DataType> arrayElementTypes() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.arrayElementTypes$lzycompute() : this.arrayElementTypes;
    }

    private String genericArrayData() {
        return GenericArrayData.class.getName();
    }

    public ExprCode emptyInputGenCode(ExprCode ev) {
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |", " ", " = new ", "(new Object[0]);\n      |boolean ", " = false;\n    "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), this.genericArrayData(), ev.isNull()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    public ExprCode nonEmptyInputGenCode(CodegenContext ctx, ExprCode ev) {
        Seq getValuesAndCardinalities;
        String genericInternalRow = GenericInternalRow.class.getName();
        String arrVals = ctx.freshName("arrVals");
        String biggestCardinality = ctx.freshName("biggestCardinality");
        String currentRow = ctx.freshName("currentRow");
        String j = ctx.freshName("j");
        String i = ctx.freshName("i");
        String args = ctx.freshName("args");
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        Seq x$1 = getValuesAndCardinalities = (Seq)((TraversableLike)evals.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExprCode eval = (ExprCode)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(190).append("\n        |if (").append(biggestCardinality).append(" != -1) {\n        |  ").append(eval.code()).append("\n        |  if (!").append(eval.isNull()).append(") {\n        |    ").append(arrVals).append("[").append(index).append("] = ").append(eval.value()).append(";\n        |    ").append(biggestCardinality).append(" = Math.max(").append(biggestCardinality).append(", ").append(eval.value()).append(".numElements());\n        |  } else {\n        |    ").append(biggestCardinality).append(" = -1;\n        |  }\n        |}\n      ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        String x$2 = "getValuesAndCardinalities";
        String x$3 = "int";
        Function1 & Serializable & scala.Serializable x$42 = (Function1 & Serializable & scala.Serializable)body -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n          |").append((String)body).append("\n          |return ").append(biggestCardinality).append(";\n        ").toString())).stripMargin();
        Function1 & Serializable & scala.Serializable x$52 = (Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)x$5.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringBuilder(4).append(biggestCardinality).append(" = ").append((String)funcCall).append(";").toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        Tuple2 tuple2 = new Tuple2((Object)"ArrayData[]", (Object)arrVals);
        Tuple2 tuple22 = new Tuple2((Object)"int", (Object)biggestCardinality);
        List x$6 = Nil$.MODULE$.$colon$colon((Object)tuple22).$colon$colon((Object)tuple2);
        String splittedGetValuesAndCardinalities = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, x$2, (Seq<Tuple2<String, String>>)x$6, x$3, (Function1<String, String>)x$42, (Function1<Seq<String>, String>)x$52);
        Seq getValueForType = (Seq)((TraversableLike)this.arrayElementTypes().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType eleType = (DataType)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String g = CodeGenerator$.MODULE$.getValue(new StringBuilder(2).append(arrVals).append("[").append(idx).append("]").toString(), eleType, i);
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n        |if (").append(i).append(" < ").append(arrVals).append("[").append(idx).append("].numElements() && !").append(arrVals).append("[").append(idx).append("].isNullAt(").append(i).append(")) {\n        |  ").append(currentRow).append("[").append(idx).append("] = ").append(g).append(";\n        |} else {\n        |  ").append(currentRow).append("[").append(idx).append("] = null;\n        |}\n      ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple23 = new Tuple2((Object)"int", (Object)i);
        Tuple2 tuple24 = new Tuple2((Object)"Object[]", (Object)currentRow);
        Tuple2 tuple25 = new Tuple2((Object)"ArrayData[]", (Object)arrVals);
        String getValueForTypeSplitted = ctx.splitExpressions((Seq<String>)getValueForType, "extractValue", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple25).$colon$colon((Object)tuple24).$colon$colon((Object)tuple23), ctx.splitExpressions$default$4(), ctx.splitExpressions$default$5(), ctx.splitExpressions$default$6());
        String initVariables = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(78).append("\n      |ArrayData[] ").append(arrVals).append(" = new ArrayData[").append(this.children().length()).append("];\n      |int ").append(biggestCardinality).append(" = 0;\n      |").append(CodeGenerator$.MODULE$.javaType(this.dataType())).append(" ").append(ev.value()).append(" = null;\n    ").toString())).stripMargin();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |", "\n      |", "\n      |boolean ", " = ", " == -1;\n      |if (!", ") {\n      |  Object[] ", " = new Object[", "];\n      |  for (int ", " = 0; ", " < ", "; ", " ++) {\n      |    Object[] ", " = new Object[", "];\n      |    ", "\n      |    ", "[", "] = new ", "(", ");\n      |  }\n      |  ", " = new ", "(", ");\n      |}\n    "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{initVariables, splittedGetValuesAndCardinalities, ev.isNull(), biggestCardinality, ev.isNull(), args, biggestCardinality, i, i, biggestCardinality, i, currentRow, BoxesRunTime.boxToInteger((int)this.children().length()), getValueForTypeSplitted, args, i, genericInternalRow, currentRow, ev.value(), this.genericArrayData(), args})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.children().isEmpty() ? this.emptyInputGenCode(ev) : this.nonEmptyInputGenCode(ctx, ev);
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Seq inputArrays = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$11 -> (ArrayData)x$11.eval(input), Seq$.MODULE$.canBuildFrom());
        if (inputArrays.contains(null)) {
            genericArrayData = null;
        } else {
            int biggestCardinality = inputArrays.isEmpty() ? 0 : BoxesRunTime.unboxToInt((Object)((TraversableOnce)inputArrays.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.numElements()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            InternalRow[] result = new InternalRow[biggestCardinality];
            Seq zippedArrs = (Seq)inputArrays.zipWithIndex(Seq$.MODULE$.canBuildFrom());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), biggestCardinality).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Seq currentLayer = (Seq)zippedArrs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ArrayData arr = (ArrayData)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Object object = i < arr.numElements() && !arr.isNullAt(i) ? arr.get(i, (DataType)this.arrayElementTypes().apply(index)) : null;
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
                result$1[i] = InternalRow$.MODULE$.apply((Seq<Object>)currentLayer);
            });
            genericArrayData = new GenericArrayData((Object)result);
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "arrays_zip";
    }

    @Override
    public ArraysZip withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public ArraysZip copy(Seq<Expression> children2, Seq<Expression> names) {
        return new ArraysZip(children2, names);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public Seq<Expression> copy$default$2() {
        return this.names();
    }

    @Override
    public String productPrefix() {
        return "ArraysZip";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<Expression> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.children();
                break;
            }
            case 1: {
                seq = this.names();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return seq;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraysZip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraysZip)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraysZip arraysZip = (ArraysZip)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = arraysZip.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Expression> seq3 = this.names();
        Seq<Expression> seq4 = arraysZip.names();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (!arraysZip.canEqual(this)) return false;
        return true;
    }

    public ArraysZip(Seq<Expression> children2, Seq<Expression> names) {
        this.children = children2;
        this.names = names;
        ExpectsInputTypes.$init$(this);
        if (children2.size() != names.size()) {
            throw new IllegalArgumentException("The numbers of zipped arrays and field names should be the same");
        }
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.ARRAYS_ZIP(), (List)Nil$.MODULE$);
    }

    public ArraysZip(Seq<Expression> children2) {
        this(children2, (Seq<Expression>)((Seq)((TraversableLike)children2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final LeafExpression apply(Tuple2<Expression, Object> x0$1) {
                Expression e;
                NamedExpression namedExpression;
                Expression e2;
                LeafExpression leafExpression;
                Expression u;
                Tuple2<Expression, Object> tuple2 = x0$1;
                if (tuple2 != null && (u = (Expression)tuple2._1()) instanceof UnresolvedAttribute) {
                    UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)u;
                    leafExpression = Literal$.MODULE$.apply(unresolvedAttribute.nameParts().last());
                } else if (tuple2 != null && (e2 = (Expression)tuple2._1()) instanceof NamedExpression && ((Expression)((Object)(namedExpression = (NamedExpression)((Object)e2)))).resolved()) {
                    leafExpression = Literal$.MODULE$.apply(namedExpression.name());
                } else if (tuple2 != null && (e = (Expression)tuple2._1()) instanceof NamedExpression) {
                    leafExpression = NamePlaceholder$.MODULE$;
                } else if (tuple2 != null) {
                    int idx = tuple2._2$mcI$sp();
                    leafExpression = Literal$.MODULE$.apply(Integer.toString(idx));
                } else {
                    throw new MatchError(tuple2);
                }
                return leafExpression;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }
}

