/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0004\b\u0002\u0002mAQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0007\u0002)BQ!\r\u0001\u0007\u0012IBQA\u000e\u0001\u0005R]BQa\u000f\u0001\u0005R)BQ\u0001\u0010\u0001\u0005B)BQ!\u0010\u0001\u0005ByBQ!\u0015\u0001\u0005BICQA\u0016\u0001\u0005B)BQa\u0016\u0001\u0005\naCQA\u0018\u0001\u0005B}CQ!\u001b\u0001\u0005B)\u00141\u0002V8US6,7\u000f^1na*\u0011q\u0002E\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0012%\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00019\u0001\u001a\u0003CA\u000f\u001f\u001b\u0005q\u0011BA\u0010\u000f\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002\u001eC%\u0011!E\u0004\u0002\u0019)&lWm\u001d;b[B4uN]7biR,'\u000fS3ma\u0016\u0014\bCA\u000f%\u0013\t)cBA\tFqB,7\r^:J]B,H\u000fV=qKN\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005u\u0001\u0011a\u00034bS2|e.\u0012:s_J,\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\b\u0005>|G.Z1o\u0003=!wn\u001e8TG\u0006dWMR1di>\u0014X#A\u001a\u0011\u00051\"\u0014BA\u001b.\u0005\u0011auN\\4\u0002\u0019\u0019|'/\\1u'R\u0014\u0018N\\4\u0016\u0003a\u0002\"!H\u001d\n\u0005ir!AC#yaJ,7o]5p]\u0006I\u0011n\u001d)beNLgnZ\u0001\u0010M>\u0014H+[7fgR\fW\u000e\u001d(U5\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003}\u00022\u0001\u0011%L\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002E5\u00051AH]8pizJ\u0011AL\u0005\u0003\u000f6\nq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\n\u00191+Z9\u000b\u0005\u001dk\u0003C\u0001'P\u001b\u0005i%B\u0001(\u0013\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001VJ\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001T!\taE+\u0003\u0002V\u001b\nAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u00031I7\u000fU1sg\u0016,%O]8s)\tY\u0013\fC\u0003[\u0015\u0001\u00071,A\u0001f!\t\u0001E,\u0003\u0002^\u0015\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0005KZ\fG\u000e\u0006\u0002aGB\u0011A&Y\u0005\u0003E6\u00121!\u00118z\u0011\u001d!7\u0002%AA\u0002\u0015\fQ!\u001b8qkR\u0004\"AZ4\u000e\u0003AI!\u0001\u001b\t\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$2a[9w!\taw.D\u0001n\u0015\tqg\"A\u0004d_\u0012,w-\u001a8\n\u0005Al'\u0001C#yaJ\u001cu\u000eZ3\t\u000bId\u0001\u0019A:\u0002\u0007\r$\b\u0010\u0005\u0002mi&\u0011Q/\u001c\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u00159H\u00021\u0001l\u0003\t)g\u000f")
public abstract class ToTimestamp
extends BinaryExpression
implements TimestampFormatterHelper,
ExpectsInputTypes {
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatterOption$lzycompute() : this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public abstract boolean failOnError();

    public abstract long downScaleFactor();

    @Override
    public Expression formatString() {
        return (Expression)this.right();
    }

    @Override
    public boolean isParsing() {
        return true;
    }

    @Override
    public boolean forTimestampNTZ() {
        DataType dataType = ((Expression)this.left()).dataType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        return !(dataType != null ? !dataType.equals(timestampNTZType$) : timestampNTZType$ != null);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$})), (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.nullable())) : true;
    }

    private boolean isParseError(Throwable e) {
        Throwable throwable = e;
        boolean bl = throwable instanceof DateTimeParseException ? true : (throwable instanceof DateTimeException ? true : throwable instanceof ParseException);
        boolean bl2 = bl;
        return bl2;
    }

    @Override
    public Object eval(InternalRow input) {
        Long l;
        Object t = ((Expression)this.left()).eval(input);
        if (t == null) {
            l = null;
        } else {
            Long l2;
            DataType dataType = ((Expression)this.left()).dataType();
            if (DateType$.MODULE$.equals(dataType)) {
                l2 = BoxesRunTime.boxToLong((long)(DateTimeUtils$.MODULE$.daysToMicros(BoxesRunTime.unboxToInt((Object)t), this.zoneId()) / this.downScaleFactor()));
            } else {
                boolean bl = TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType);
                if (bl) {
                    l2 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)t) / this.downScaleFactor()));
                } else if (StringType$.MODULE$.equals(dataType)) {
                    Long l3;
                    Object fmt = ((Expression)this.right()).eval(input);
                    if (fmt == null) {
                        l3 = null;
                    } else {
                        TimestampFormatter formatter = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getFormatter(fmt.toString()));
                        try {
                            l3 = this.forTimestampNTZ() ? BoxesRunTime.boxToLong((long)formatter.parseWithoutTimeZone(((UTF8String)t).toString())) : BoxesRunTime.boxToLong((long)(formatter.parse(((UTF8String)t).toString()) / this.downScaleFactor()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (this.isParseError(throwable2)) {
                                if (this.failOnError()) {
                                    throw throwable2;
                                }
                            } else {
                                throw throwable;
                            }
                            Object var3_10 = null;
                            l3 = var3_10;
                        }
                    }
                    l2 = l3;
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
            l = l2;
        }
        return l;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String parseErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        String parseMethod = this.forTimestampNTZ() ? "parseWithoutTimeZone" : "parse";
        String downScaleCode = this.forTimestampNTZ() ? "" : new StringBuilder(2).append("/ ").append(this.downScaleFactor()).toString();
        DataType dataType = ((Expression)this.left()).dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            exprCode = (ExprCode)this.formatterOption().map((Function1 & Serializable & scala.Serializable)fmt -> {
                String df = TimestampFormatter.class.getName();
                String formatterName = ctx.addReferenceObj("formatter", fmt, df);
                return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(datetimeStr, x$5) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(315).append("\n             |try {\n             |  ").append(ev.value()).append(" = ").append(formatterName).append(".").append(parseMethod).append("(").append((String)datetimeStr).append(".toString()) ").append(downScaleCode).append(";\n             |} catch (java.time.DateTimeException e) {\n             |  ").append(parseErrorBranch).append("\n             |} catch (java.time.format.DateTimeParseException e) {\n             |  ").append(parseErrorBranch).append("\n             |} catch (java.text.ParseException e) {\n             |  ").append(parseErrorBranch).append("\n             |}\n             |").toString())).stripMargin());
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
                String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
                String ldf = new StringOps(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName())).stripSuffix("$");
                String timestampFormatter = ctx.freshName("timestampFormatter");
                return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(string, format) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(474).append("\n             |").append(tf).append(" ").append(timestampFormatter).append(" = ").append(tf).append("$.MODULE$.apply(\n             |  ").append((String)format).append(".toString(),\n             |  ").append(zid).append(",\n             |  ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(),\n             |  true);\n             |try {\n             |  ").append(ev.value()).append(" = ").append(timestampFormatter).append(".").append(parseMethod).append("(").append((String)string).append(".toString()) ").append(downScaleCode).append(";\n             |} catch (java.time.format.DateTimeParseException e) {\n             |    ").append(parseErrorBranch).append("\n             |} catch (java.time.DateTimeException e) {\n             |    ").append(parseErrorBranch).append("\n             |} catch (java.text.ParseException e) {\n             |    ").append(parseErrorBranch).append("\n             |}\n             |").toString())).stripMargin());
            });
        } else {
            boolean bl = TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType);
            if (bl) {
                ExprCode eval1 = ((Expression)this.left()).genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", " / ", ";\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval1.code(), ev.isNull(), eval1.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), eval1.value(), BoxesRunTime.boxToLong((long)this.downScaleFactor())})), ev.copy$default$2(), ev.copy$default$3());
            } else if (DateType$.MODULE$.equals(dataType)) {
                String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
                String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
                ExprCode eval1 = ((Expression)this.left()).genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".daysToMicros(", ", ", ") / ", ";\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval1.code(), ev.isNull(), eval1.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), dtu, eval1.value(), zid, BoxesRunTime.boxToLong((long)this.downScaleFactor())})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return exprCode;
    }

    public ToTimestamp() {
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

