/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.SparkException;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class Catalogs$ {
    public static Catalogs$ MODULE$;

    static {
        new Catalogs$();
    }

    public CatalogPlugin load(String name, SQLConf conf) throws CatalogNotFoundException, SparkException {
        CatalogPlugin catalogPlugin;
        String string;
        try {
            string = conf.getConfString(new StringBuilder(18).append("spark.sql.catalog.").append(name).toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw QueryExecutionErrors$.MODULE$.catalogPluginClassNotFoundError(name);
        }
        String pluginClassName = string;
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        try {
            Class<?> pluginClass = loader.loadClass(pluginClassName);
            if (!CatalogPlugin.class.isAssignableFrom(pluginClass)) {
                throw QueryExecutionErrors$.MODULE$.catalogPluginClassNotImplementedError(name, pluginClassName);
            }
            CatalogPlugin plugin = (CatalogPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            plugin.initialize(name, this.catalogOptions(name, conf));
            catalogPlugin = plugin;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw QueryExecutionErrors$.MODULE$.catalogPluginClassNotFoundForCatalogError(name, pluginClassName);
        }
        catch (NoSuchMethodException e) {
            throw QueryExecutionErrors$.MODULE$.catalogFailToFindPublicNoArgConstructorError(name, pluginClassName, e);
        }
        catch (IllegalAccessException e) {
            throw QueryExecutionErrors$.MODULE$.catalogFailToCallPublicNoArgConstructorError(name, pluginClassName, e);
        }
        catch (InstantiationException e) {
            throw QueryExecutionErrors$.MODULE$.cannotInstantiateAbstractCatalogPluginClassError(name, pluginClassName, e);
        }
        catch (InvocationTargetException e) {
            throw QueryExecutionErrors$.MODULE$.failedToInstantiateConstructorForCatalogError(name, pluginClassName, e);
        }
        return catalogPlugin;
    }

    private CaseInsensitiveStringMap catalogOptions(String name, SQLConf conf) {
        Pattern prefix = Pattern.compile(new StringBuilder(28).append("^spark\\.sql\\.catalog\\.").append(name).append("\\.(.+)").toString());
        HashMap<String, String> options = new HashMap<String, String>();
        conf.getAllConfs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Matcher matcher = prefix.matcher(key);
            BoxedUnit boxedUnit = matcher.matches() && matcher.groupCount() > 0 ? options.put(matcher.group(1), value) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        return new CaseInsensitiveStringMap(options);
    }

    private Catalogs$() {
        MODULE$ = this;
    }
}

