/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If Index is 0,\n      Spark will throw an error. If index < 0, accesses elements from the last to the first.\n      The function returns NULL if the index exceeds the length of the array and\n      `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL if the key is not\n       contained in the map.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0001\tmf\u0001\u0002\u00192\u0001zB\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005I\"A\u0001\u000e\u0001BK\u0002\u0013\u00051\r\u0003\u0005j\u0001\tE\t\u0015!\u0003e\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002\u0003:\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011M\u0004!Q3A\u0005\u0002QD\u0001\u0002\u001f\u0001\u0003\u0012\u0003\u0006I!\u001e\u0005\u0006s\u0002!\tA\u001f\u0005\u0007s\u0002!\t!!\u0001\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0013\tI\u0001C\u0005\u0002 \u0001A)\u0019!C\u0005i\"I\u00111\u0005\u0001\t\u0006\u0004%I\u0001\u001e\u0005\u000b\u0003O\u0001\u0001R1A\u0005\n\u0005%\u0002BCA%\u0001!\u0015\r\u0011\"\u0011\u0002\n!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA/\u0001\u0011\u0005\u0013q\f\u0005\b\u0003[\u0002A\u0011BA8\u0011\u0019\t\t\t\u0001C!i\"9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005BCAG\u0001!\u0015\r\u0011\"\u0003\u0002\u0010\"9\u0011\u0011\u0014\u0001\u0005B\u0005m\u0005bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003\u0017\u0004A\u0011KAg\u0011\u001d\t9\u000e\u0001C!\u00033D\u0011\"!;\u0001\u0003\u0003%\t!a;\t\u0013\u0005U\b!%A\u0005\u0002\u0005]\b\"\u0003B\u0007\u0001E\u0005I\u0011AA|\u0011%\u0011y\u0001AI\u0001\n\u0003\u0011\t\u0002C\u0005\u0003\u0016\u0001\t\n\u0011\"\u0001\u0003\u0018!I!1\u0004\u0001\u0002\u0002\u0013\u0005#Q\u0004\u0005\n\u0005[\u0001\u0011\u0011!C\u0001\u0005_A\u0011B!\r\u0001\u0003\u0003%\tAa\r\t\u0013\te\u0002!!A\u0005B\tm\u0002\"\u0003B%\u0001\u0005\u0005I\u0011\u0001B&\u0011%\u0011y\u0005AA\u0001\n\u0003\u0012\tfB\u0005\u0003vE\n\t\u0011#\u0001\u0003x\u0019A\u0001'MA\u0001\u0012\u0003\u0011I\b\u0003\u0004zM\u0011\u0005!q\u0011\u0005\n\u0005\u00133\u0013\u0011!C#\u0005\u0017C\u0011B!$'\u0003\u0003%\tIa$\t\u0013\tee%%A\u0005\u0002\tE\u0001\"\u0003BNME\u0005I\u0011\u0001B\f\u0011%\u0011iJJA\u0001\n\u0003\u0013y\nC\u0005\u0003.\u001a\n\n\u0011\"\u0001\u0003\u0012!I!q\u0016\u0014\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u0005c3\u0013\u0011!C\u0005\u0005g\u0013\u0011\"\u00127f[\u0016tG/\u0011;\u000b\u0005I\u001a\u0014aC3yaJ,7o]5p]NT!\u0001N\u001b\u0002\u0011\r\fG/\u00197zgRT!AN\u001c\u0002\u0007M\fHN\u0003\u00029s\u0005)1\u000f]1sW*\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h\u0007\u0001\u0019\u0012\u0002A D\r&\u00036+W0\u0011\u0005\u0001\u000bU\"A\u0019\n\u0005\t\u000b$\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0001E)\u0003\u0002Fc\tyq)\u001a;NCB4\u0016\r\\;f+RLG\u000e\u0005\u0002A\u000f&\u0011\u0001*\r\u0002\u0011\u000f\u0016$\u0018I\u001d:bs&#X-\\+uS2\u0004\"AS'\u000f\u0005\u0001[\u0015B\u0001'2\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011A*\r\t\u0003\u0001FK!AU\u0019\u0003'M+\b\u000f]8siF+XM]=D_:$X\r\u001f;\u0011\u0005Q;V\"A+\u000b\u0005Y+\u0014AB3se>\u00148/\u0003\u0002Y+\ny\u0011+^3ss\u0016\u0013(o\u001c:t\u0005\u0006\u001cX\r\u0005\u0002[;6\t1LC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6LA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0003\u0017BA1\\\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0011\u0004\"\u0001Q3\n\u0005\u0019\f$AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0003Z3gCVdGOV1mk\u0016|U\u000f^(g\u0005>,h\u000eZ\u000b\u0002YB\u0019!,\\8\n\u00059\\&AB(qi&|g\u000e\u0005\u0002Aa&\u0011\u0011/\r\u0002\b\u0019&$XM]1m\u0003]!WMZ1vYR4\u0016\r\\;f\u001fV$xJ\u001a\"pk:$\u0007%A\u0006gC&dwJ\\#se>\u0014X#A;\u0011\u0005i3\u0018BA<\\\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtD#B>}{z|\bC\u0001!\u0001\u0011\u0015\u0011\u0017\u00021\u0001e\u0011\u0015A\u0017\u00021\u0001e\u0011\u001dQ\u0017\u0002%AA\u00021Dqa]\u0005\u0011\u0002\u0003\u0007Q\u000fF\u0003|\u0003\u0007\t)\u0001C\u0003c\u0015\u0001\u0007A\rC\u0003i\u0015\u0001\u0007A-\u0001\u0006nCB\\U-\u001f+za\u0016,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u00056\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t)\"a\u0004\u0003\u0011\u0011\u000bG/\u0019+za\u0016D3aCA\r!\rQ\u00161D\u0005\u0004\u0003;Y&!\u0003;sC:\u001c\u0018.\u001a8u\u0003Qi\u0017\r\u001d,bYV,7i\u001c8uC&t7OT;mY\"\u001aA\"!\u0007\u0002)\u0005\u0014(/Y=FY\u0016lWM\u001c;Ok2d\u0017M\u00197fQ\ri\u0011\u0011D\u0001\t_J$WM]5oOV\u0011\u00111\u0006\t\u0007\u0003[\tY$!\u0011\u000f\t\u0005=\u0012\u0011\b\b\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0016B\u0001'\\\u0013\u0011\ti$a\u0010\u0003\u0011=\u0013H-\u001a:j]\u001eT!\u0001T.\u0011\u0007i\u000b\u0019%C\u0002\u0002Fm\u00131!\u00118zQ\rq\u0011\u0011D\u0001\tI\u0006$\u0018\rV=qK\"\u001aq\"!\u0007\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002RA1\u0011QFA*\u0003/JA!!\u0016\u0002@\t\u00191+Z9\u0011\t\u00055\u0011\u0011L\u0005\u0005\u00037\nyA\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM\u001a\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u001b\u0002f\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0006ok2d\u0017MY5mSRLH#B;\u0002r\u0005]\u0004bBA:%\u0001\u0007\u0011QO\u0001\tK2,W.\u001a8ugB)\u0011QFA*I\"9\u0011\u0011\u0010\nA\u0002\u0005m\u0014aB8sI&t\u0017\r\u001c\t\u00045\u0006u\u0014bAA@7\n\u0019\u0011J\u001c;\u0002\u00119,H\u000e\\1cY\u0016\fAB\\;mYN\u000bg-Z#wC2$b!!\u0011\u0002\b\u0006-\u0005bBAE)\u0001\u0007\u0011\u0011I\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003s\"\u0002\u0019AA!\u0003-!w.\u00127f[\u0016tG/\u0011;\u0016\u0005\u0005E\u0005#\u0003.\u0002\u0014\u0006\u0005\u0013\u0011IA!\u0013\r\t)j\u0017\u0002\n\rVt7\r^5p]JB3!FA\r\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u001e\u0006%\u00161\u0017\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111U\u0019\u0002\u000f\r|G-Z4f]&!\u0011qUAQ\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBAV-\u0001\u0007\u0011QV\u0001\u0004GRD\b\u0003BAP\u0003_KA!!-\u0002\"\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA[-\u0001\u0007\u0011QT\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\tY\f\u0005\u0003\u0002>\u0006\u0015g\u0002BA`\u0003\u0003\u00042!!\r\\\u0013\r\t\u0019mW\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0017\u0011\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r7,A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)10a4\u0002T\"1\u0011\u0011\u001b\rA\u0002\u0011\fqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002Vb\u0001\r\u0001Z\u0001\t]\u0016<(+[4ii\u0006\u0001\u0012N\\5u#V,'/_\"p]R,\u0007\u0010\u001e\u000b\u0003\u00037\u0004BAW7\u0002^B!\u0011q\\As\u001b\t\t\tOC\u0002\u0002dN\nQ\u0001\u001e:fKNLA!a:\u0002b\ny1+\u0015'Rk\u0016\u0014\u0018pQ8oi\u0016DH/\u0001\u0003d_BLH#C>\u0002n\u0006=\u0018\u0011_Az\u0011\u001d\u0011'\u0004%AA\u0002\u0011Dq\u0001\u001b\u000e\u0011\u0002\u0003\u0007A\rC\u0004k5A\u0005\t\u0019\u00017\t\u000fMT\u0002\u0013!a\u0001k\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA}U\r!\u00171`\u0016\u0003\u0003{\u0004B!a@\u0003\n5\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\u0011)!A\u0005v]\u000eDWmY6fI*\u0019!qA.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\f\t\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005'Q3\u0001\\A~\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!\u0007+\u0007U\fY0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005?\u0001BA!\t\u0003,5\u0011!1\u0005\u0006\u0005\u0005K\u00119#\u0001\u0003mC:<'B\u0001B\u0015\u0003\u0011Q\u0017M^1\n\t\u0005\u001d'1E\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003w\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002B\tU\u0002\"\u0003B\u001cC\u0005\u0005\t\u0019AA>\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\b\t\u0007\u0005\u007f\u0011)%!\u0011\u000e\u0005\t\u0005#b\u0001B\"7\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u001d#\u0011\t\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002v\u0005\u001bB\u0011Ba\u000e$\u0003\u0003\u0005\r!!\u0011\u0002\r\u0015\fX/\u00197t)\r)(1\u000b\u0005\n\u0005o!\u0013\u0011!a\u0001\u0003\u0003B3\u0003\u0001B,\u0005;\u0012yFa\u0019\u0003f\t%$1\u000eB8\u0005c\u00022\u0001\u0011B-\u0013\r\u0011Y&\r\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011\t'\u0001C3\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK1se\u0006LH\u0006I5oI\u0016D\u0018\u0006I\u0017!%\u0016$XO\u001d8tA\u0015dW-\\3oi\u0002zg\rI1se\u0006L\b%\u0019;!O&4XM\u001c\u0011)c5\u0012\u0017m]3eS\u0001Jg\u000eZ3y]\u0001Je\rI%oI\u0016D\b%[:!a1R\u0001\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:lA]LG\u000e\u001c\u0011uQJ|w\u000fI1oA\u0015\u0014(o\u001c:/A%3\u0007%\u001b8eKb\u0004C\b\t\u0019-A\u0005\u001c7-Z:tKN\u0004S\r\\3nK:$8\u000f\t4s_6\u0004C\u000f[3!Y\u0006\u001cH\u000f\t;pAQDW\r\t4jeN$hF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bET+M\u0019\u0002Jg\r\t;iK\u0002Jg\u000eZ3yA\u0015D8-Z3eg\u0002\"\b.\u001a\u0011mK:<G\u000f\u001b\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010I1oI*\u0001\u0003\u0005\t\u0011!A\u0001\u001c\b/\u0019:l]M\fHNL1og&tSM\\1cY\u0016$\u0007\rI5tAM,G\u000f\t;pA\u0019\fGn]3/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0003m\u001d9be.t3/\u001d7/C:\u001c\u0018NL3oC\ndW\r\u001a1!SN\u00043/\u001a;!i>\u0004CO];fY\u0001JG\u000f\t;ie><8\u000fI!se\u0006L\u0018J\u001c3fq>+Ho\u00144C_VtGm]#yG\u0016\u0004H/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!M>\u0014\b%\u001b8wC2LG\rI5oI&\u001cWm\u001d\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK7ba2\u00023.Z=*A5\u0002#+\u001a;ve:\u001c\bE^1mk\u0016\u0004cm\u001c:!O&4XM\u001c\u0011lKft\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bET+M\u0019\u0002Jg\r\t;iK\u0002ZW-\u001f\u0011jg\u0002rw\u000e\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011d_:$\u0018-\u001b8fI\u0002Jg\u000e\t;iK\u0002j\u0017\r\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005O\nAP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003eM\u0015-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\f\u0007\u000fK\u0019-A\u001d\nw\u0005\f\u00113Y\u0001:#mJ\u0015-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t2\u000bA\u0001\nQa]5oG\u0016\f#A!\u001c\u0002\u000bIrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tM\u0014!C7ba~3WO\\2t\u0003%)E.Z7f]R\fE\u000f\u0005\u0002AMM!aEa\u001f`!%\u0011iHa!eI2,80\u0004\u0002\u0003\u0000)\u0019!\u0011Q.\u0002\u000fI,h\u000e^5nK&!!Q\u0011B@\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0005o\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005?\tQ!\u00199qYf$\u0012b\u001fBI\u0005'\u0013)Ja&\t\u000b\tL\u0003\u0019\u00013\t\u000b!L\u0003\u0019\u00013\t\u000f)L\u0003\u0013!a\u0001Y\"91/\u000bI\u0001\u0002\u0004)\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\"\n%\u0006\u0003\u0002.n\u0005G\u0003rA\u0017BSI\u0012dW/C\u0002\u0003(n\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003BVY\u0005\u0005\t\u0019A>\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005k\u0003BA!\t\u00038&!!\u0011\u0018B\u0012\u0005\u0019y%M[3di\u0002")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
package.NullIntolerant,
SupportQueryContext,
QueryErrorsBase {
    private transient DataType mapKeyType;
    private transient boolean mapValueContainsNull;
    private transient boolean arrayElementNullable;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final Option<Literal> defaultValueOutOfBound;
    private final boolean failOnError;
    private Option<SQLQueryContext> queryContext;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ElementAt$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Literal> $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<Literal>, Object>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static boolean apply$default$4() {
        return ElementAt$.MODULE$.apply$default$4();
    }

    public static Option<Literal> apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<Literal>, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Literal>, Function1<Object, ElementAt>>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public Option<Literal> defaultValueOutOfBound() {
        return this.defaultValueOutOfBound;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.mapKeyType$lzycompute();
        }
        return this.mapKeyType;
    }

    private boolean mapValueContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.mapValueContainsNull = ((MapType)this.left().dataType()).valueContainsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.mapValueContainsNull;
    }

    private boolean mapValueContainsNull() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.mapValueContainsNull$lzycompute();
        }
        return this.mapValueContainsNull;
    }

    private boolean arrayElementNullable$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.arrayElementNullable = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.arrayElementNullable;
    }

    private boolean arrayElementNullable() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.arrayElementNullable$lzycompute();
        }
        return this.arrayElementNullable;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)new .colon.colon((Object)arrayType, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return (Seq)new .colon.colon((Object)new MapType(dt, valueType, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)Nil$.MODULE$;
            }
        }
        if (tuple2 != null) {
            return (Seq)Nil$.MODULE$;
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.right())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !DataTypeUtils$.MODULE$.sameType(e2, e12 = (mapType = (MapType)dataType).keyType())) {
                return new TypeCheckResult.DataTypeMismatch("MAP_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)MapType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.left())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType()))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        if (ordinal == 0) {
            return false;
        }
        if (elements.length() < package$.MODULE$.abs(ordinal)) {
            return !this.failOnError();
        }
        if (ordinal < 0) {
            return ((Expression)elements.apply(elements.length() + ordinal)).nullable();
        }
        return ((Expression)elements.apply(ordinal - 1)).nullable();
    }

    @Override
    public boolean nullable() {
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            return this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable & scala.Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        }
        if (dataType instanceof MapType) {
            return true;
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                Function2 & Serializable & scala.Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> {
                        int idx;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < package$.MODULE$.abs(index)) {
                            if (this.failOnError()) {
                                throw QueryExecutionErrors$.MODULE$.invalidElementAtIndexError(index, array.numElements(), this.getContextOrNull());
                            }
                            Option<Literal> option = this.defaultValueOutOfBound();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Literal value2 = (Literal)some.value();
                                return value2.eval(value2.eval$default$1());
                            }
                            if (None$.MODULE$.equals(option)) {
                                return null;
                            }
                            throw new MatchError(option);
                        }
                        if (index == 0) {
                            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
                        }
                        int n = idx = index > 0 ? index - 1 : array.numElements() + index;
                        if (this.arrayElementNullable() && array.isNullAt(idx)) {
                            return null;
                        }
                        return array.get(idx, this.dataType());
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
            return this.doElementAt$lzycompute();
        }
        return this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                String string;
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayElementNullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())).stripMargin() : "";
                String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
                if (this.failOnError()) {
                    string = new StringBuilder(74).append("throw QueryExecutionErrors.invalidElementAtIndexError(").append(index).append(", ").append((String)eval1).append(".numElements(), ").append(errorContext).append(");").toString();
                } else {
                    Option<Literal> option = this.defaultValueOutOfBound();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Literal value = (Literal)some.value();
                        ExprCode defaultValueEval = value.genCode(ctx);
                        string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(82).append("\n                  ").append(defaultValueEval.code()).append("\n                  ").append(ev.isNull()).append(" = ").append(defaultValueEval.isNull()).append(";\n                  ").append(ev.value()).append(" = ").append(defaultValueEval.value()).append(";\n                ").toString())).stripMargin();
                    } else if (None$.MODULE$.equals(option)) {
                        string = new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
                    } else {
                        throw new MatchError(option);
                    }
                }
                String indexOutOfBoundBranch = string;
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(461).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(indexOutOfBoundBranch).append("\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw QueryExecutionErrors.invalidIndexOfZeroError(").append(errorContext).append(");\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString())).stripMargin();
            });
        }
        if (dataType instanceof MapType) {
            return this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    @Override
    public ElementAt withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        if (this.failOnError() && this.left().resolved() && this.left().dataType() instanceof ArrayType) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    public ElementAt copy(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        return new ElementAt(left, right, defaultValueOutOfBound, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Literal> copy$default$3() {
        return this.defaultValueOutOfBound();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.defaultValueOutOfBound();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Literal> option = this.defaultValueOutOfBound();
        Option<Literal> option2 = elementAt.defaultValueOutOfBound();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.failOnError() != elementAt.failOnError()) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.defaultValueOutOfBound = defaultValueOutOfBound;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
        SupportQueryContext.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, (Option<Literal>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

