/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AggregateWindowFunction;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NthValue$;
import org.apache.spark.sql.catalyst.expressions.OffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset]) - Returns the value of `input` at the row that is the `offset`th row\n      from beginning of the window frame. Offset starts at 1. If ignoreNulls=true, we will skip\n      nulls when finding the `offset`th row. Otherwise, every row counts for the `offset`. If\n      there is no such an `offset`th row (e.g., when the offset is 10, size of the window frame\n      is less than 10), null is returned.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b, 2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", arguments="\n    Arguments:\n      * input - the target column or expression that the function operates on.\n      * offset - a positive int literal to indicate the offset in the window frame. It starts\n          with 1.\n      * ignoreNulls - an optional specification that indicates the NthValue should skip null\n          values in the determination of which row to use.\n  ", since="3.1.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001B\u0017/\u0001nB\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\tG\u0002\u0011\t\u0012)A\u0005\u0019\"AA\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005f\u0001\tE\t\u0015!\u0003M\u0011!1\u0007A!f\u0001\n\u00039\u0007\u0002C6\u0001\u0005#\u0005\u000b\u0011\u00025\t\u000b1\u0004A\u0011A7\t\u000b1\u0004A\u0011\u0001:\t\u0011Y\u0004\u0001R1A\u0005B]DQa\u001f\u0001\u0005B\tDQ\u0001 \u0001\u0005B\tDq! \u0001C\u0002\u0013\u0005c\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B@\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\u000b\u0003o\u0001\u0001R1A\u0005\n\u0005e\u0002BCA!\u0001!\u0015\r\u0011\"\u0003\u0002D!Q\u00111\n\u0001\t\u0006\u0004%I!a\u0011\t\u0015\u00055\u0003\u0001#b\u0001\n\u0003\ny\u0005\u0003\u0006\u0002T\u0001A)\u0019!C!\u0003+B!\"!\u0017\u0001\u0011\u000b\u0007I\u0011IA.\u0011)\ty\u0006\u0001EC\u0002\u0013\u0005\u00131\t\u0005\b\u0003C\u0002A\u0011IA2\u0011\u0019\u0019\u0004\u0001\"\u0011\u0002d!9\u0011Q\u000f\u0001\u0005R\u0005]\u0004\"CAA\u0001\u0005\u0005I\u0011AAB\u0011%\tY\tAI\u0001\n\u0003\ti\tC\u0005\u0002$\u0002\t\n\u0011\"\u0001\u0002\u000e\"I\u0011Q\u0015\u0001\u0012\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003W\u0003\u0011\u0011!C!\u0003[C\u0011\"!0\u0001\u0003\u0003%\t!a0\t\u0013\u0005\u001d\u0007!!A\u0005\u0002\u0005%\u0007\"CAk\u0001\u0005\u0005I\u0011IAl\u0011%\t)\u000fAA\u0001\n\u0003\t9\u000fC\u0005\u0002l\u0002\t\t\u0011\"\u0011\u0002n\"I\u0011\u0011\u001f\u0001\u0002\u0002\u0013\u0005\u00131_\u0004\n\u0005;q\u0013\u0011!E\u0001\u0005?1\u0001\"\f\u0018\u0002\u0002#\u0005!\u0011\u0005\u0005\u0007Y\u001e\"\tA!\u000f\t\u0013\tmr%!A\u0005F\tu\u0002\"\u0003B O\u0005\u0005I\u0011\u0011B!\u0011%\u0011IeJA\u0001\n\u0003\u0013Y\u0005C\u0005\u0003^\u001d\n\t\u0011\"\u0003\u0003`\tAa\n\u001e5WC2,XM\u0003\u00020a\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t$'\u0001\u0005dCR\fG._:u\u0015\t\u0019D'A\u0002tc2T!!\u000e\u001c\u0002\u000bM\u0004\u0018M]6\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0002\u0001'\u001d\u0001A\bQ\"G\u001fV\u0003\"!\u0010 \u000e\u00039J!a\u0010\u0018\u0003/\u0005;wM]3hCR,w+\u001b8e_^4UO\\2uS>t\u0007CA\u001fB\u0013\t\u0011eF\u0001\u000bPM\u001a\u001cX\r^,j]\u0012|wOR;oGRLwN\u001c\t\u0003{\u0011K!!\u0012\u0018\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042a\u0012&M\u001b\u0005A%BA%1\u0003\u0015!(/Z3t\u0013\tY\u0005J\u0001\u0006CS:\f'/\u001f'jW\u0016\u0004\"!P'\n\u00059s#AC#yaJ,7o]5p]B\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n9\u0001K]8ek\u000e$\bC\u0001,_\u001d\t9FL\u0004\u0002Y76\t\u0011L\u0003\u0002[u\u00051AH]8pizJ\u0011AU\u0005\u0003;F\u000bq\u0001]1dW\u0006<W-\u0003\u0002`A\na1+\u001a:jC2L'0\u00192mK*\u0011Q,U\u0001\u0006S:\u0004X\u000f^\u000b\u0002\u0019\u00061\u0011N\u001c9vi\u0002\naa\u001c4gg\u0016$\u0018aB8gMN,G\u000fI\u0001\fS\u001etwN]3Ok2d7/F\u0001i!\t\u0001\u0016.\u0003\u0002k#\n9!i\\8mK\u0006t\u0017\u0001D5h]>\u0014XMT;mYN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003o_B\f\bCA\u001f\u0001\u0011\u0015\tw\u00011\u0001M\u0011\u0015!w\u00011\u0001M\u0011\u00151w\u00011\u0001i)\rq7/\u001e\u0005\u0006i\"\u0001\r\u0001T\u0001\u0006G\"LG\u000e\u001a\u0005\u0006I\"\u0001\r\u0001T\u0001\bI\u00164\u0017-\u001e7u+\u0005A\bCA\u001fz\u0013\tQhFA\u0004MSR,'/\u00197\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u0006MJ\fW.Z\u000b\u0002\u007fB\u0019Q(!\u0001\n\u0007\u0005\raFA\u0006XS:$wn\u001e$sC6,\u0017A\u00024sC6,\u0007%\u0001\u0005eCR\fG+\u001f9f+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tBM\u0001\u0006if\u0004Xm]\u0005\u0005\u0003+\tyA\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u00037\u0001RAVA\u000f\u0003CI1!a\ba\u0005\r\u0019V-\u001d\t\u0005\u0003\u001b\t\u0019#\u0003\u0003\u0002&\u0005=!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\tY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004M\u0001\tC:\fG._:jg&!\u0011QGA\u0018\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018!C8gMN,GOV1m+\t\tY\u0004E\u0002Q\u0003{I1!a\u0010R\u0005\u0011auN\\4\u0002\rI,7/\u001e7u+\t\t)\u0005E\u0002>\u0003\u000fJ1!!\u0013/\u0005I\tE\u000f\u001e:jEV$XMU3gKJ,gnY3\u0002\u000b\r|WO\u001c;\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u0005E\u0003#\u0002,\u0002\u001e\u0005\u0015\u0013!D5oSRL\u0017\r\u001c,bYV,7/\u0006\u0002\u0002XA!a+!\by\u0003E)\b\u000fZ1uK\u0016C\bO]3tg&|gn]\u000b\u0003\u0003;\u0002BAVA\u000f\u0019\u0006\u0011RM^1mk\u0006$X-\u0012=qe\u0016\u001c8/[8o\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003K\u0002B!a\u001a\u0002p9!\u0011\u0011NA6!\tA\u0016+C\u0002\u0002nE\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA9\u0003g\u0012aa\u0015;sS:<'bAA7#\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006]\u0006e\u0014Q\u0010\u0005\u0007\u0003wR\u0002\u0019\u0001'\u0002\u000f9,w\u000fT3gi\"1\u0011q\u0010\u000eA\u00021\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0004o\u0003\u000b\u000b9)!#\t\u000f\u0005\\\u0002\u0013!a\u0001\u0019\"9Am\u0007I\u0001\u0002\u0004a\u0005b\u00024\u001c!\u0003\u0005\r\u0001[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyIK\u0002M\u0003#[#!a%\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\u000b\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011UAL\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!++\u0007!\f\t*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003_\u0003B!!-\u0002<6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,\u0001\u0003mC:<'BAA]\u0003\u0011Q\u0017M^1\n\t\u0005E\u00141W\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0003\u00042\u0001UAb\u0013\r\t)-\u0015\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\f\t\u000eE\u0002Q\u0003\u001bL1!a4R\u0005\r\te.\u001f\u0005\n\u0003'\f\u0013\u0011!a\u0001\u0003\u0003\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAm!\u0019\tY.!9\u0002L6\u0011\u0011Q\u001c\u0006\u0004\u0003?\f\u0016AC2pY2,7\r^5p]&!\u00111]Ao\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007!\fI\u000fC\u0005\u0002T\u000e\n\t\u00111\u0001\u0002L\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ty+a<\t\u0013\u0005MG%!AA\u0002\u0005\u0005\u0017AB3rk\u0006d7\u000fF\u0002i\u0003kD\u0011\"a5&\u0003\u0003\u0005\r!a3)/\u0001\tI0a@\u0003\u0002\t\u0015!q\u0001B\u0006\u0005\u001b\u0011\tBa\u0005\u0003\u0018\te\u0001cA\u001f\u0002|&\u0019\u0011Q \u0018\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1A\u0001\u0004Z)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015j]B,Ho\u0017\u0017!_\u001a47/\u001a;^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u00022\u0018\r\\;fA=4\u0007\u0005Y5oaV$\b\rI1uAQDW\r\t:po\u0002\"\b.\u0019;!SN\u0004C\u000f[3!A>4gm]3uARD\u0007E]8x\u0015\u0001\u0002\u0003\u0005\t\u0011!MJ|W\u000e\t2fO&tg.\u001b8hA=4\u0007\u0005\u001e5fA]Lg\u000eZ8xA\u0019\u0014\u0018-\\3/A=3gm]3uAM$\u0018M\u001d;tA\u0005$\b%\r\u0018!\u0013\u001a\u0004\u0013n\u001a8pe\u0016tU\u000f\u001c7t{Q\u0014X/\u001a\u0017!o\u0016\u0004s/\u001b7mAM\\\u0017\u000e\u001d\u0006!A\u0001\u0002\u0003\u0005\t8vY2\u001c\be\u001e5f]\u00022\u0017N\u001c3j]\u001e\u0004C\u000f[3!A>4gm]3uARD\u0007E]8x]\u0001zE\u000f[3so&\u001cX\r\f\u0011fm\u0016\u0014\u0018\u0010\t:po\u0002\u001aw.\u001e8ug\u00022wN\u001d\u0011uQ\u0016\u0004\u0003m\u001c4gg\u0016$\bM\f\u0011JM*\u0001\u0003\u0005\t\u0011!AQDWM]3!SN\u0004cn\u001c\u0011tk\u000eD\u0007%\u00198!A>4gm]3uARD\u0007E]8xA!*gf\u001a\u0018-A]DWM\u001c\u0011uQ\u0016\u0004sN\u001a4tKR\u0004\u0013n\u001d\u00112a1\u00023/\u001b>fA=4\u0007\u0005\u001e5fA]Lg\u000eZ8xA\u0019\u0014\u0018-\\3\u000bA\u0001\u0002\u0003\u0005\t\u0011jg\u0002bWm]:!i\"\fg\u000eI\u00191S1\u0002c.\u001e7mA%\u001c\bE]3ukJtW\r\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0013\t\u00111\u0015\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!C2\u0002#\r\f\u0011`\rVs5i\u0018\u0015cY\u0001\u0012\u0014\u0006I(W\u000bJ\u0003\u0003\u0006U!S)&#\u0016j\u0014(!\u0005f\u0003\u0013\rI(S\t\u0016\u0013\u0006EQ-!E&\u0002cIU(NAY\u000bE*V#TA!:\u0013)M\u0014-AIJC\u0006\t\u0015(\u0003F:C\u0006I\u0019*Y\u0001Bs%\u0011\u001a(Y\u0001\u001a\u0014\u0006\f\u0011)O\u0005\u000bt\u0005\f\u00112S\u0001\"\u0018M\u0019\u0015bY\u0001\u0012\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\t\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\t\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011Be%\u0019\u0014BT+M\u0019*\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012!qB\u0001\u0003T*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001b8qkR\u0004S\u0006\t;iK\u0002\"\u0018M]4fi\u0002\u001aw\u000e\\;n]\u0002z'\u000fI3yaJ,7o]5p]\u0002\"\b.\u0019;!i\",\u0007EZ;oGRLwN\u001c\u0011pa\u0016\u0014\u0018\r^3tA=tgF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011pM\u001a\u001cX\r\u001e\u0011.A\u0005\u0004\u0003o\\:ji&4X\rI5oi\u0002b\u0017\u000e^3sC2\u0004Co\u001c\u0011j]\u0012L7-\u0019;fAQDW\rI8gMN,G\u000fI5oAQDW\rI<j]\u0012|w\u000f\t4sC6,g\u0006I%uAM$\u0018M\u001d;t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e^5uQ\u0002\ndF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011jO:|'/\u001a(vY2\u001c\b%\f\u0011b]\u0002z\u0007\u000f^5p]\u0006d\u0007e\u001d9fG&4\u0017nY1uS>t\u0007\u0005\u001e5bi\u0002Jg\u000eZ5dCR,7\u000f\t;iK\u0002rE\u000f\u001b,bYV,\u0007e\u001d5pk2$\u0007e]6ja\u0002rW\u000f\u001c7\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002c/\u00197vKN\u0004\u0013N\u001c\u0011uQ\u0016\u0004C-\u001a;fe6Lg.\u0019;j_:\u0004sN\u001a\u0011xQ&\u001c\u0007\u000e\t:po\u0002\"x\u000eI;tK:R\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005+\tQa\r\u00182]A\nQa\u001a:pkB\f#Aa\u0007\u0002\u0019]Lg\u000eZ8x?\u001a,hnY:\u0002\u00119#\bNV1mk\u0016\u0004\"!P\u0014\u0014\u000b\u001d\u0012\u0019Ca\f\u0011\u0011\t\u0015\"1\u0006'MQ:l!Aa\n\u000b\u0007\t%\u0012+A\u0004sk:$\u0018.\\3\n\t\t5\"q\u0005\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\t\tU\u0012qW\u0001\u0003S>L1a\u0018B\u001a)\t\u0011y\"\u0001\u0005u_N#(/\u001b8h)\t\ty+A\u0003baBd\u0017\u0010F\u0004o\u0005\u0007\u0012)Ea\u0012\t\u000b\u0005T\u0003\u0019\u0001'\t\u000b\u0011T\u0003\u0019\u0001'\t\u000b\u0019T\u0003\u0019\u00015\u0002\u000fUt\u0017\r\u001d9msR!!Q\nB-!\u0015\u0001&q\nB*\u0013\r\u0011\t&\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rA\u0013)\u0006\u0014'i\u0013\r\u00119&\u0015\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tm3&!AA\u00029\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0007\u0005\u0003\u00022\n\r\u0014\u0002\u0002B3\u0003g\u0013aa\u00142kK\u000e$\b")
public class NthValue
extends AggregateWindowFunction
implements OffsetWindowFunction,
ImplicitCastInputTypes,
BinaryLike<Expression> {
    private Literal default;
    private long offsetVal;
    private AttributeReference result;
    private AttributeReference count;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private AttributeReference evaluateExpression;
    private final Expression input;
    private final Expression offset;
    private final boolean ignoreNulls;
    private final WindowFrame frame;
    private transient Seq<Expression> children;
    private SpecifiedWindowFrame fakeFrame;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NthValue x$0) {
        return NthValue$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NthValue> tupled() {
        return NthValue$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NthValue>>> curried() {
        return NthValue$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    private SpecifiedWindowFrame fakeFrame$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.fakeFrame = OffsetWindowFunction.fakeFrame$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.fakeFrame;
    }

    @Override
    public SpecifiedWindowFrame fakeFrame() {
        return (this.bitmap$0 & 0x100) == 0 ? this.fakeFrame$lzycompute() : this.fakeFrame;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    private Literal default$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 1) == 0) {
                this.default = Literal$.MODULE$.create(null, this.input().dataType());
                this.bitmap$0 |= 1;
            }
        }
        return this.default;
    }

    @Override
    public Literal default() {
        return (this.bitmap$0 & 1) == 0 ? this.default$lzycompute() : this.default;
    }

    @Override
    public Expression left() {
        return this.input();
    }

    @Override
    public Expression right() {
        return this.offset();
    }

    @Override
    public WindowFrame frame() {
        return this.frame;
    }

    @Override
    public DataType dataType() {
        return this.input().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult check = ExpectsInputTypes.checkInputDataTypes$(this);
        return check.isFailure() ? check : (!this.offset().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(39).append("Offset expression '").append(this.offset()).append("' must be a literal.").toString()) : (this.offsetVal() <= 0L ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("The 'offset' argument of nth_value must be greater than zero but it is ").append(this.offsetVal()).append(".").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$));
    }

    private long offsetVal$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 2) == 0) {
                this.offsetVal = BoxesRunTime.unboxToInt((Object)this.offset().eval(this.offset().eval$default$1()));
                this.bitmap$0 |= 2;
            }
        }
        return this.offsetVal;
    }

    private long offsetVal() {
        return (this.bitmap$0 & 2) == 0 ? this.offsetVal$lzycompute() : this.offsetVal;
    }

    private AttributeReference result$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "result";
                DataType x$2 = this.input().dataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("result", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("result", x$2, x$3, x$4);
                this.result = new AttributeReference("result", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.result;
    }

    private AttributeReference result() {
        return (this.bitmap$0 & 4) == 0 ? this.result$lzycompute() : this.result;
    }

    private AttributeReference count$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("count", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("count", x$2, x$3, x$4);
                this.count = new AttributeReference("count", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    private AttributeReference count() {
        return (this.bitmap$0 & 8) == 0 ? this.count$lzycompute() : this.count;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.result();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = package$.MODULE$.Nil().$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{this.default(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L))}));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.updateExpressions = this.ignoreNulls() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new If[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal())))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNotNull()))), this.input(), this.result()), new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)))})) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal()))), this.input(), this.result()), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L))}));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private AttributeReference evaluateExpression$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.result();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return (this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "nth_value";
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName()).append("(").append(this.input().sql()).append(", ").append(this.offset().sql()).append(")").append((Object)(this.ignoreNulls() ? " ignore nulls" : "")).toString();
    }

    @Override
    public NthValue withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public NthValue copy(Expression input, Expression offset, boolean ignoreNulls) {
        return new NthValue(input, offset, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.offset();
    }

    public boolean copy$default$3() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "NthValue";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.input();
                break;
            }
            case 1: {
                object = this.offset();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NthValue;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "input";
                break;
            }
            case 1: {
                string = "offset";
                break;
            }
            case 2: {
                string = "ignoreNulls";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NthValue)) return false;
        boolean bl = true;
        if (!bl) return false;
        NthValue nthValue = (NthValue)x$1;
        if (this.ignoreNulls() != nthValue.ignoreNulls()) return false;
        Expression expression = this.input();
        Expression expression2 = nthValue.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.offset();
        Expression expression4 = nthValue.offset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nthValue.canEqual(this)) return false;
        return true;
    }

    public NthValue(Expression input, Expression offset, boolean ignoreNulls) {
        this.input = input;
        this.offset = offset;
        this.ignoreNulls = ignoreNulls;
        OffsetWindowFunction.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        this.frame = UnspecifiedFrame$.MODULE$;
    }

    public NthValue(Expression child, Expression offset) {
        this(child, offset, false);
    }
}

