/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.ByteCodeStats;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeArrayWriter;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.expressions.codegen.package$ExpressionCanonicalizer$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GenerateUnsafeProjection$
extends CodeGenerator<Seq<Expression>, UnsafeProjection> {
    public static final GenerateUnsafeProjection$ MODULE$ = new GenerateUnsafeProjection$();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canSupport(DataType dataType) {
        ArrayType arrayType;
        DataType dataType2 = UserDefinedType$.MODULE$.sqlType(dataType);
        if (NullType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof CalendarIntervalType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1<StructField, Object>)(Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GenerateUnsafeProjection$.MODULE$.canSupport(field.dataType())));
        }
        if (dataType2 instanceof ArrayType && this.canSupport((arrayType = (ArrayType)dataType2).elementType())) {
            return true;
        }
        if (!(dataType2 instanceof MapType)) return false;
        MapType mapType = (MapType)dataType2;
        DataType kt = mapType.keyType();
        DataType vt = mapType.valueType();
        if (!this.canSupport(kt)) return false;
        if (!this.canSupport(vt)) return false;
        return true;
    }

    private String writeStructToBuffer(CodegenContext ctx, String input, String index, Seq<GenerateUnsafeProjection.Schema> schemas, String rowWriter) {
        String tmpInput = ctx.freshName("tmpInput");
        Seq fieldEvals = (Seq)((IterableOps)schemas.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            int i;
            GenerateUnsafeProjection.Schema schema;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    schema = (GenerateUnsafeProjection.Schema)tuple2._1();
                    i = tuple2._2$mcI$sp();
                    if (schema != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            DataType dt = schema.dataType();
            boolean nullable = schema.nullable();
            FalseLiteral$ isNull = nullable ? JavaCode$.MODULE$.isNullExpression(new StringBuilder(11).append(tmpInput).append(".isNullAt(").append(i).append(")").toString()) : FalseLiteral$.MODULE$;
            ExprCode exprCode = ExprCode$.MODULE$.apply(isNull, JavaCode$.MODULE$.expression(CodeGenerator$.MODULE$.getValue(tmpInput, dt, Integer.toString(i)), dt));
            return exprCode;
        });
        String rowWriterClass = UnsafeRowWriter.class.getName();
        String structRowWriter = ctx.addMutableState(rowWriterClass, "rowWriter", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(12).append((String)v).append(" = new ").append(rowWriterClass).append("(").append(rowWriter).append(", ").append(fieldEvals.length()).append(");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String previousCursor = ctx.freshName("previousCursor");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(344).append("\n       |final InternalRow ").append(tmpInput).append(" = ").append(input).append(";\n       |if (").append(tmpInput).append(" instanceof UnsafeRow) {\n       |  ").append(rowWriter).append(".write(").append(index).append(", (UnsafeRow) ").append(tmpInput).append(");\n       |} else {\n       |  // Remember the current cursor so that we can calculate how many bytes are\n       |  // written later.\n       |  final int ").append(previousCursor).append(" = ").append(rowWriter).append(".cursor();\n       |  ").append(this.writeExpressionsToBuffer(ctx, tmpInput, (Seq<ExprCode>)fieldEvals, schemas, structRowWriter, this.writeExpressionsToBuffer$default$6())).append("\n       |  ").append(rowWriter).append(".setOffsetAndSizeFromPreviousCursor(").append(index).append(", ").append(previousCursor).append(");\n       |}\n     ").toString()));
    }

    private String writeExpressionsToBuffer(CodegenContext ctx, String row, Seq<ExprCode> inputs, Seq<GenerateUnsafeProjection.Schema> schemas, String rowWriter, boolean isTopLevel) {
        String string;
        String resetWriter = isTopLevel ? (((IterableOnceOps)inputs.map((Function1 & Serializable)x$1 -> x$1.isNull())).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GenerateUnsafeProjection$.$anonfun$writeExpressionsToBuffer$2(x$2))) ? "" : new StringBuilder(20).append(rowWriter).append(".zeroOutNullBytes();").toString()) : new StringBuilder(18).append(rowWriter).append(".resetRowWriter();").toString();
        Seq writeFields = (Seq)((IterableOps)((IterableOps)inputs.zip(schemas)).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            DecimalType decimalType;
            GenerateUnsafeProjection.Schema schema;
            ExprCode input;
            int index;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    index = tuple2._2$mcI$sp();
                    if (tuple22 == null) break block2;
                    input = (ExprCode)tuple22._1();
                    schema = (GenerateUnsafeProjection.Schema)tuple22._2();
                    if (schema != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            DataType dataType = schema.dataType();
            boolean nullable = schema.nullable();
            DataType dt = UserDefinedType$.MODULE$.sqlType(dataType);
            DataType dataType2 = dt;
            String string = dataType2 instanceof DecimalType && (decimalType = (DecimalType)dataType2).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS() ? new StringBuilder(29).append(rowWriter).append(".write(").append(index).append(", (Decimal) null, ").append(decimalType.precision()).append(", ").append(decimalType.scale()).append(");").toString() : (CalendarIntervalType$.MODULE$.equals(dataType2) ? new StringBuilder(34).append(rowWriter).append(".write(").append(index).append(", (CalendarInterval) null);").toString() : new StringBuilder(13).append(rowWriter).append(".setNullAt(").append(index).append(");").toString());
            String setNull = string;
            String writeField = MODULE$.writeElement(ctx, ExprValue$.MODULE$.exprValueToString(input.value()), Integer.toString(index), dt, rowWriter);
            String string2 = !nullable ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(42).append("\n             |").append(input.code()).append("\n             |").append(writeField.trim()).append("\n           ").toString())) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n             |").append(input.code()).append("\n             |if (").append(input.isNull()).append(") {\n             |  ").append(setNull.trim()).append("\n             |} else {\n             |  ").append(writeField.trim()).append("\n             |}\n           ").toString()));
            return string2;
        });
        if (isTopLevel && (row == null || ctx.currentVars() != null)) {
            string = writeFields.mkString("\n");
        } else {
            Predef$.MODULE$.assert(row != null, (Function0 & Serializable)() -> "the input row name cannot be null when generating code to write it.");
            string = ctx.splitExpressions((Seq<String>)writeFields, "writeFields", (Seq<Tuple2<String, String>>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"InternalRow"), (Object)row)}))), ctx.splitExpressions$default$4(), ctx.splitExpressions$default$5(), ctx.splitExpressions$default$6());
        }
        String writeFieldsCode = string;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(24).append("\n       |").append(resetWriter).append("\n       |").append(writeFieldsCode).append("\n     ").toString()));
    }

    private boolean writeExpressionsToBuffer$default$6() {
        return false;
    }

    private String writeArrayToBuffer(CodegenContext ctx, String input, DataType elementType, boolean containsNull, String rowWriter) {
        DecimalType decimalType;
        String tmpInput = ctx.freshName("tmpInput");
        String numElements = ctx.freshName("numElements");
        String index = ctx.freshName("index");
        DataType et = UserDefinedType$.MODULE$.sqlType(elementType);
        String jt = CodeGenerator$.MODULE$.javaType(et);
        DataType dataType = et;
        int n = dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS() ? 8 : (CodeGenerator$.MODULE$.isPrimitiveType(jt) ? et.defaultSize() : 8);
        int elementOrOffsetSize = n;
        String arrayWriterClass = UnsafeArrayWriter.class.getName();
        String arrayWriter = ctx.addMutableState(arrayWriterClass, "arrayWriter", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(12).append((String)v).append(" = new ").append(arrayWriterClass).append("(").append(rowWriter).append(", ").append(elementOrOffsetSize).append(");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String element = CodeGenerator$.MODULE$.getValue(tmpInput, et, index);
        String elementAssignment = containsNull ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n         |if (").append(tmpInput).append(".isNullAt(").append(index).append(")) {\n         |  ").append(arrayWriter).append(".setNull").append(elementOrOffsetSize).append("Bytes(").append(index).append(");\n         |} else {\n         |  ").append(this.writeElement(ctx, element, index, et, arrayWriter)).append("\n         |}\n       ").toString())) : this.writeElement(ctx, element, index, et, arrayWriter);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(277).append("\n       |final ArrayData ").append(tmpInput).append(" = ").append(input).append(";\n       |if (").append(tmpInput).append(" instanceof UnsafeArrayData) {\n       |  ").append(rowWriter).append(".write((UnsafeArrayData) ").append(tmpInput).append(");\n       |} else {\n       |  final int ").append(numElements).append(" = ").append(tmpInput).append(".numElements();\n       |  ").append(arrayWriter).append(".initialize(").append(numElements).append(");\n       |\n       |  for (int ").append(index).append(" = 0; ").append(index).append(" < ").append(numElements).append("; ").append(index).append("++) {\n       |    ").append(elementAssignment).append("\n       |  }\n       |}\n     ").toString()));
    }

    private String writeMapToBuffer(CodegenContext ctx, String input, String index, DataType keyType, DataType valueType, boolean valueContainsNull, String rowWriter) {
        String tmpInput = ctx.freshName("tmpInput");
        String tmpCursor = ctx.freshName("tmpCursor");
        String previousCursor = ctx.freshName("previousCursor");
        String keyArray = this.writeArrayToBuffer(ctx, new StringBuilder(11).append(tmpInput).append(".keyArray()").toString(), keyType, false, rowWriter);
        String valueArray = this.writeArrayToBuffer(ctx, new StringBuilder(13).append(tmpInput).append(".valueArray()").toString(), valueType, valueContainsNull, rowWriter);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(816).append("\n       |final MapData ").append(tmpInput).append(" = ").append(input).append(";\n       |if (").append(tmpInput).append(" instanceof UnsafeMapData) {\n       |  ").append(rowWriter).append(".write(").append(index).append(", (UnsafeMapData) ").append(tmpInput).append(");\n       |} else {\n       |  // Remember the current cursor so that we can calculate how many bytes are\n       |  // written later.\n       |  final int ").append(previousCursor).append(" = ").append(rowWriter).append(".cursor();\n       |\n       |  // preserve 8 bytes to write the key array numBytes later.\n       |  ").append(rowWriter).append(".grow(8);\n       |  ").append(rowWriter).append(".increaseCursor(8);\n       |\n       |  // Remember the current cursor so that we can write numBytes of key array later.\n       |  final int ").append(tmpCursor).append(" = ").append(rowWriter).append(".cursor();\n       |\n       |  ").append(keyArray).append("\n       |\n       |  // Write the numBytes of key array into the first 8 bytes.\n       |  Platform.putLong(\n       |    ").append(rowWriter).append(".getBuffer(),\n       |    ").append(tmpCursor).append(" - 8,\n       |    ").append(rowWriter).append(".cursor() - ").append(tmpCursor).append(");\n       |\n       |  ").append(valueArray).append("\n       |  ").append(rowWriter).append(".setOffsetAndSizeFromPreviousCursor(").append(index).append(", ").append(previousCursor).append(");\n       |}\n     ").toString()));
    }

    private String writeElement(CodegenContext ctx, String input, String index, DataType dt, String writer) {
        DecimalType decimalType;
        Option<Tuple2<Object, Object>> option;
        String string;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            string = this.writeStructToBuffer(ctx, input, index, (Seq<GenerateUnsafeProjection.Schema>)((Seq)structType.map((Function1 & Serializable)e -> new GenerateUnsafeProjection.Schema(e.dataType(), e.nullable()))), writer);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean en = arrayType.containsNull();
            String previousCursor = ctx.freshName("previousCursor");
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(217).append("\n         |// Remember the current cursor so that we can calculate how many bytes are\n         |// written later.\n         |final int ").append(previousCursor).append(" = ").append(writer).append(".cursor();\n         |").append(this.writeArrayToBuffer(ctx, input, et, en, writer)).append("\n         |").append(writer).append(".setOffsetAndSizeFromPreviousCursor(").append(index).append(", ").append(previousCursor).append(");\n       ").toString()));
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean vn = mapType.valueContainsNull();
            string = this.writeMapToBuffer(ctx, input, index, kt, vt, vn, writer);
        } else if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            string = new StringBuilder(15).append(writer).append(".write(").append(index).append(", ").append(input).append(", ").append(precision).append(", ").append(scale).append(");").toString();
        } else {
            string = NullType$.MODULE$.equals(dataType) ? "" : new StringBuilder(11).append(writer).append(".write(").append(index).append(", ").append(input).append(");").toString();
        }
        return string;
    }

    public ExprCode createCode(CodegenContext ctx, Seq<Expression> expressions, boolean useSubexprElimination) {
        Seq<ExprCode> exprEvals = ctx.generateExpressions(expressions, useSubexprElimination);
        Seq exprSchemas = (Seq)expressions.map((Function1 & Serializable)e -> new GenerateUnsafeProjection.Schema(e.dataType(), e.nullable()));
        int numVarLenFields = exprSchemas.count((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GenerateUnsafeProjection$.$anonfun$createCode$2(x0$1)));
        String rowWriterClass = UnsafeRowWriter.class.getName();
        String rowWriter = ctx.addMutableState(rowWriterClass, "rowWriter", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(12).append((String)v).append(" = new ").append(rowWriterClass).append("(").append(expressions.length()).append(", ").append(numVarLenFields * 32).append(");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String evalSubexpr = ctx.subexprFunctionsCode();
        String writeExpressions = this.writeExpressionsToBuffer(ctx, ctx.INPUT_ROW(), exprEvals, (Seq<GenerateUnsafeProjection.Schema>)exprSchemas, rowWriter, true);
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", ".reset();\n         |", "\n         |", "\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{rowWriter, evalSubexpr, writeExpressions})).stripMargin();
        return new ExprCode(code, FalseLiteral$.MODULE$, JavaCode$.MODULE$.expression(new StringBuilder(9).append(rowWriter).append(".getRow()").toString(), UnsafeRow.class));
    }

    @Override
    public Seq<Expression> canonicalize(Seq<Expression> in) {
        return (Seq)in.map((Function1 & Serializable)plan2 -> package$ExpressionCanonicalizer$.MODULE$.execute(plan2));
    }

    @Override
    public Seq<Expression> bind(Seq<Expression> in, Seq<Attribute> inputSchema) {
        return BindReferences$.MODULE$.bindReferences(in, package$.MODULE$.AttributeSeq(inputSchema));
    }

    public UnsafeProjection generate(Seq<Expression> expressions, boolean subexpressionEliminationEnabled) {
        return this.create(this.canonicalize(expressions), subexpressionEliminationEnabled);
    }

    @Override
    public UnsafeProjection create(Seq<Expression> references2) {
        return this.create(references2, false);
    }

    private UnsafeProjection create(Seq<Expression> expressions, boolean subexpressionEliminationEnabled) {
        GeneratedClass clazz;
        CodegenContext ctx = this.newCodeGenContext();
        ExprCode eval = this.createCode(ctx, expressions, subexpressionEliminationEnabled);
        String codeBody = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(852).append("\n         |public java.lang.Object generate(Object[] references) {\n         |  return new SpecificUnsafeProjection(references);\n         |}\n         |\n         |class SpecificUnsafeProjection extends ").append(UnsafeProjection.class.getName()).append(" {\n         |\n         |  private Object[] references;\n         |  ").append(ctx.declareMutableStates()).append("\n         |\n         |  public SpecificUnsafeProjection(Object[] references) {\n         |    this.references = references;\n         |    ").append(ctx.initMutableStates()).append("\n         |  }\n         |\n         |  public void initialize(int partitionIndex) {\n         |    ").append(ctx.initPartition()).append("\n         |  }\n         |\n         |  // Scala.Function1 need this\n         |  public java.lang.Object apply(java.lang.Object row) {\n         |    return apply((InternalRow) row);\n         |  }\n         |\n         |  public UnsafeRow apply(InternalRow ").append(ctx.INPUT_ROW()).append(") {\n         |    ").append(eval.code()).append("\n         |    return ").append(eval.value()).append(";\n         |  }\n         |\n         |  ").append(ctx.declareAddedFunctions()).append("\n         |}\n       ").toString()));
        CodeAndComment code = CodeFormatter$.MODULE$.stripOverlappingComments(new CodeAndComment(codeBody, ctx.getPlaceHolderToComments()));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("code for ").append(expressions.mkString(",")).append(":\n").append(CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2())).toString());
        Tuple2<GeneratedClass, ByteCodeStats> tuple2 = CodeGenerator$.MODULE$.compile(code);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GeneratedClass generatedClass = clazz = (GeneratedClass)tuple2._1();
        GeneratedClass clazz2 = generatedClass;
        return (UnsafeProjection)clazz2.generate((Object[])ctx.references().toArray(ClassTag$.MODULE$.Any()));
    }

    public boolean createCode$default$3() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$writeExpressionsToBuffer$2(ExprValue x$2) {
        ExprValue exprValue = x$2;
        FalseLiteral$ falseLiteral$ = FalseLiteral$.MODULE$;
        return !(exprValue != null ? !exprValue.equals(falseLiteral$) : falseLiteral$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$createCode$2(GenerateUnsafeProjection.Schema x0$1) {
        GenerateUnsafeProjection.Schema schema = x0$1;
        if (schema == null) {
            throw new MatchError((Object)schema);
        }
        DataType dt = schema.dataType();
        boolean bl = !UnsafeRow.isFixedLength(dt);
        return bl;
    }

    private GenerateUnsafeProjection$() {
    }
}

