/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ElementAt;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.SplitPart$;
import org.apache.spark.sql.catalyst.expressions.StringSplitSQL;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, delimiter, partNum) - Splits `str` by delimiter and return\n      requested part of the split (1-based). If any input is null, returns null.\n      if `partNum` is out of range of split parts, returns empty string. If `partNum` is 0,\n      throws an error. If `partNum` is negative, the parts are counted backward from the\n      end of the string. If the `delimiter` is an empty string, the `str` is not split.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('11.12.13', '.', 3);\n       13\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u0010!\u00016B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005]!AQ\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005O\u0001\tE\t\u0015!\u0003/\u0011!y\u0005A!f\u0001\n\u0003Y\u0005\u0002\u0003)\u0001\u0005#\u0005\u000b\u0011\u0002\u0018\t\u000bE\u0003A\u0011\u0001*\t\u0011]\u0003\u0001R1A\u0005B-CQ\u0001\u0017\u0001\u0005BeCQA\u0019\u0001\u0005B\rDQ!\u001c\u0001\u0005\u00029DQ\u0001\u001d\u0001\u0005\u0012EDqa\u001e\u0001\u0002\u0002\u0013\u0005\u0001\u0010C\u0004}\u0001E\u0005I\u0011A?\t\u0011\u0005E\u0001!%A\u0005\u0002uD\u0001\"a\u0005\u0001#\u0003%\t! \u0005\n\u0003+\u0001\u0011\u0011!C!\u0003/A\u0011\"a\n\u0001\u0003\u0003%\t!!\u000b\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\ty\u0005AA\u0001\n\u0003\t\t\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0011\u0002^!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00131M\u0004\n\u0003\u000f\u0003\u0013\u0011!E\u0001\u0003\u00133\u0001b\b\u0011\u0002\u0002#\u0005\u00111\u0012\u0005\u0007#f!\t!a)\t\u0013\u0005\u0015\u0016$!A\u0005F\u0005\u001d\u0006\"CAU3\u0005\u0005I\u0011QAV\u0011%\t\u0019,GA\u0001\n\u0003\u000b)\fC\u0005\u0002Hf\t\t\u0011\"\u0003\u0002J\nI1\u000b\u001d7jiB\u000b'\u000f\u001e\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M1\u0001A\f\u001a6qy\u0002\"a\f\u0019\u000e\u0003\u0001J!!\r\u0011\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00020m%\u0011q\u0007\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t9\u0001K]8ek\u000e$\bCA H\u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002DY\u00051AH]8pizJ\u0011aO\u0005\u0003\rj\nq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\na1+\u001a:jC2L'0\u00192mK*\u0011aIO\u0001\u0004gR\u0014X#\u0001\u0018\u0002\tM$(\u000fI\u0001\nI\u0016d\u0017.\\5uKJ\f!\u0002Z3mS6LG/\u001a:!\u0003\u001d\u0001\u0018M\u001d;Ok6\f\u0001\u0002]1si:+X\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM#VK\u0016\t\u0003_\u0001AQAS\u0004A\u00029BQ!T\u0004A\u00029BQaT\u0004A\u00029\n1B]3qY\u0006\u001cW-\\3oi\u0006Aan\u001c3f\u001d\u0006lW-F\u0001[!\tYvL\u0004\u0002];B\u0011\u0011IO\u0005\u0003=j\na\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011aLO\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00013\u0011\u0007}*w-\u0003\u0002g\u0013\n\u00191+Z9\u0011\u0005!\\W\"A5\u000b\u0005)$\u0013!\u0002;za\u0016\u001c\u0018B\u00017j\u0005!!\u0015\r^1UsB,\u0017\u0001C2iS2$'/\u001a8\u0016\u0003=\u00042aP3/\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0002/e\")1\u000f\u0004a\u0001i\u0006Ya.Z<DQ&dGM]3o!\ryTOL\u0005\u0003m&\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\tMK(p\u001f\u0005\b\u00156\u0001\n\u00111\u0001/\u0011\u001diU\u0002%AA\u00029BqaT\u0007\u0011\u0002\u0003\u0007a&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003yT#AL@,\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0003;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\t)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\t1\fgn\u001a\u0006\u0003\u0003G\tAA[1wC&\u0019\u0001-!\b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0002cA\u001d\u0002.%\u0019\u0011q\u0006\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00121\b\t\u0004s\u0005]\u0012bAA\u001du\t\u0019\u0011I\\=\t\u0013\u0005u2#!AA\u0002\u0005-\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002DA1\u0011QIA&\u0003ki!!a\u0012\u000b\u0007\u0005%#(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0014\u0002H\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019&!\u0017\u0011\u0007e\n)&C\u0002\u0002Xi\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002>U\t\t\u00111\u0001\u00026\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tI\"a\u0018\t\u0013\u0005ub#!AA\u0002\u0005-\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002T\u0005\u0015\u0004\"CA\u001f/\u0005\u0005\t\u0019AA\u001bQM\u0001\u0011\u0011NA8\u0003c\n)(a\u001e\u0002|\u0005u\u0014\u0011QAB!\ry\u00131N\u0005\u0004\u0003[\u0002#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003g\n1\u0011\f\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:-A\u0011,G.[7ji\u0016\u0014H\u0006\t9beRtU/\\\u0015![\u0001\u001a\u0006\u000f\\5ug\u0002\u00027\u000f\u001e:aA\tL\b\u0005Z3mS6LG/\u001a:!C:$\u0007E]3ukJt'\u0002\t\u0011!A\u0001\u0002#/Z9vKN$X\r\u001a\u0011qCJ$\be\u001c4!i\",\u0007e\u001d9mSR\u0004\u0003&M\u0017cCN,G-\u000b\u0018!\u0013\u001a\u0004\u0013M\\=!S:\u0004X\u000f\u001e\u0011jg\u0002rW\u000f\u001c7-AI,G/\u001e:og\u0002rW\u000f\u001c7/\u0015\u0001\u0002\u0003\u0005\t\u0011!S\u001a\u0004\u0003\r]1si:+X\u000e\u0019\u0011jg\u0002zW\u000f\u001e\u0011pM\u0002\u0012\u0018M\\4fA=4\u0007e\u001d9mSR\u0004\u0003/\u0019:ug2\u0002#/\u001a;ve:\u001c\b%Z7qif\u00043\u000f\u001e:j]\u001et\u0003%\u00134!AB\f'\u000f\u001e(v[\u0002\u0004\u0013n\u001d\u00111Y)\u0001\u0003\u0005\t\u0011!AQD'o\\<tA\u0005t\u0007%\u001a:s_Jt\u0003%\u00134!AB\f'\u000f\u001e(v[\u0002\u0004\u0013n\u001d\u0011oK\u001e\fG/\u001b<fY\u0001\"\b.\u001a\u0011qCJ$8\u000fI1sK\u0002\u001aw.\u001e8uK\u0012\u0004#-Y2lo\u0006\u0014H\r\t4s_6\u0004C\u000f[3\u000bA\u0001\u0002\u0003\u0005\t\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001et\u0003%\u00134!i\",\u0007\u0005\u00193fY&l\u0017\u000e^3sA\u0002J7\u000fI1oA\u0015l\u0007\u000f^=!gR\u0014\u0018N\\4-AQDW\r\t1tiJ\u0004\u0007%[:!]>$\be\u001d9mSRt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u001f\u0002\r*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%M\u0019/cIr\u0013gM\u0014-A\u001drs\u0005\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013g\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qP\u0001\u0006g9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u000b\u000bAb\u001d;sS:<wLZ;oGN\f\u0011b\u00159mSR\u0004\u0016M\u001d;\u0011\u0005=J2#B\r\u0002\u000e\u0006e\u0005\u0003CAH\u0003+scFL*\u000e\u0005\u0005E%bAAJu\u00059!/\u001e8uS6,\u0017\u0002BAL\u0003#\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\tY*!)\u000e\u0005\u0005u%\u0002BAP\u0003C\t!![8\n\u0007!\u000bi\n\u0006\u0002\u0002\n\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u001a\u0005)\u0011\r\u001d9msR91+!,\u00020\u0006E\u0006\"\u0002&\u001d\u0001\u0004q\u0003\"B'\u001d\u0001\u0004q\u0003\"B(\u001d\u0001\u0004q\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\u000b\u0019\rE\u0003:\u0003s\u000bi,C\u0002\u0002<j\u0012aa\u00149uS>t\u0007CB\u001d\u0002@:rc&C\u0002\u0002Bj\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAc;\u0005\u0005\t\u0019A*\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002LB!\u00111DAg\u0013\u0011\ty-!\b\u0003\r=\u0013'.Z2u\u0001")
public class SplitPart
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression str;
    private final Expression delimiter;
    private final Expression partNum;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SplitPart x$0) {
        return SplitPart$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SplitPart> tupled() {
        return SplitPart$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SplitPart>>> curried() {
        return SplitPart$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        SplitPart splitPart = this;
        synchronized (splitPart) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression str() {
        return this.str;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Expression partNum() {
        return this.partNum;
    }

    private Expression replacement$lzycompute() {
        SplitPart splitPart = this;
        synchronized (splitPart) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new ElementAt(new StringSplitSQL(this.str(), this.delimiter()), this.partNum(), (Option<Literal>)new Some((Object)Literal$.MODULE$.create("", StringType$.MODULE$)), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String nodeName() {
        return "split_part";
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.str(), this.delimiter(), this.partNum()}));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2));
    }

    public SplitPart copy(Expression str, Expression delimiter, Expression partNum) {
        return new SplitPart(str, delimiter, partNum);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Expression copy$default$3() {
        return this.partNum();
    }

    @Override
    public String productPrefix() {
        return "SplitPart";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.str();
                break;
            }
            case 1: {
                object = this.delimiter();
                break;
            }
            case 2: {
                object = this.partNum();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SplitPart;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "str";
                break;
            }
            case 1: {
                string = "delimiter";
                break;
            }
            case 2: {
                string = "partNum";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SplitPart)) return false;
        boolean bl = true;
        if (!bl) return false;
        SplitPart splitPart = (SplitPart)x$1;
        Expression expression = this.str();
        Expression expression2 = splitPart.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = splitPart.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.partNum();
        Expression expression6 = splitPart.partNum();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!splitPart.canEqual(this)) return false;
        return true;
    }

    public SplitPart(Expression str, Expression delimiter, Expression partNum) {
        this.str = str;
        this.delimiter = delimiter;
        this.partNum = partNum;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

