/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.analysis.TimeWindowing$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.SessionWindow;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.expressions.TimeWindow$;
import org.apache.spark.sql.catalyst.expressions.WindowTime;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

public final class TimeWindowing$
extends Rule<LogicalPlan> {
    public static final TimeWindowing$ MODULE$ = new TimeWindowing$();

    private final String WINDOW_COL_NAME() {
        return "window";
    }

    private final String WINDOW_START() {
        return "start";
    }

    private final String WINDOW_END() {
        return "end";
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        LogicalPlan logicalPlan;
        Object object = new Object();
        try {
            logicalPlan = plan2.resolveOperatorsUpWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.containsPattern(TreePattern$.MODULE$.TIME_WINDOW())), this.ruleId(), (PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(object){
                private static final long serialVersionUID = 0L;
                private final Object nonLocalReturnKey1$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1;
                    A1 A12 = x1;
                    if (A12 != null && (A1 = A12).children().size() == 1) {
                        Object object2;
                        LogicalPlan child = (LogicalPlan)A1.children().head();
                        Set windowExpressions = ((IterableOnceOps)A1.expressions().flatMap((Function1 & Serializable)x$2 -> x$2.collect(new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                if (A1 instanceof TimeWindow) {
                                    TimeWindow timeWindow = (TimeWindow)A1;
                                    object = timeWindow;
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Expression x1) {
                                Expression expression = x1;
                                boolean bl = expression instanceof TimeWindow;
                                return bl;
                            }
                        }))).toSet();
                        int numWindowExpr = ((IterableOnceOps)A1.expressions().flatMap((Function1 & Serializable)x$3 -> x$3.collect(new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x2;
                                if (A1 instanceof SessionWindow) {
                                    SessionWindow sessionWindow = (SessionWindow)A1;
                                    object = sessionWindow;
                                } else if (A1 instanceof TimeWindow) {
                                    TimeWindow timeWindow = (TimeWindow)A1;
                                    object = timeWindow;
                                } else {
                                    object = function1.apply(x2);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Expression x2) {
                                Expression expression = x2;
                                boolean bl = expression instanceof SessionWindow ? true : expression instanceof TimeWindow;
                                return bl;
                            }
                        }))).toSet().size();
                        if (numWindowExpr == 1 && windowExpressions.nonEmpty() && ((TimeWindow)windowExpressions.head()).timeColumn().resolved() && ((TimeWindow)windowExpressions.head()).checkInputDataTypes().isSuccess()) {
                            Metadata metadata;
                            TimeWindow window = (TimeWindow)windowExpressions.head();
                            if (StructType$.MODULE$.acceptsType(window.timeColumn().dataType())) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(null, window){
                                    private static final long serialVersionUID = 0L;
                                    private final TimeWindow window$1;

                                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                        Object object;
                                        A1 A1 = x3;
                                        if (A1 instanceof TimeWindow) {
                                            TimeWindow timeWindow = (TimeWindow)A1;
                                            object = timeWindow.copy(new WindowTime(this.window$1.timeColumn()), timeWindow.copy$default$2(), timeWindow.copy$default$3(), timeWindow.copy$default$4());
                                        } else {
                                            object = function1.apply(x3);
                                        }
                                        return (B1)object;
                                    }

                                    public final boolean isDefinedAt(Expression x3) {
                                        Expression expression = x3;
                                        boolean bl = expression instanceof TimeWindow;
                                        return bl;
                                    }
                                    {
                                        this.window$1 = window$1;
                                    }
                                }));
                            }
                            Expression expression = window.timeColumn();
                            if (expression instanceof Attribute) {
                                Attribute attribute = (Attribute)expression;
                                metadata = attribute.metadata();
                            } else {
                                metadata = Metadata$.MODULE$.empty();
                            }
                            Metadata metadata2 = metadata;
                            Metadata newMetadata = new MetadataBuilder().withMetadata(metadata2).putBoolean(TimeWindow$.MODULE$.marker(), true).build();
                            String x$1 = "window";
                            DataType x$22 = window.dataType();
                            Metadata x$32 = newMetadata;
                            boolean x$42 = AttributeReference$.MODULE$.apply$default$3();
                            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("window", x$22, x$42, x$32);
                            Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("window", x$22, x$42, x$32);
                            AttributeReference windowAttr = new AttributeReference("window", x$22, x$42, x$32, x$5, x$6);
                            if (window.windowDuration() == window.slideDuration()) {
                                Expression x$7 = anonfun.apply.2.getWindow$1(0, window.timeColumn().dataType(), window);
                                String x$8 = "window";
                                ExprId x$9 = windowAttr.exprId();
                                Some x$10 = new Some((Object)newMetadata);
                                Seq<String> x$11 = Alias$.MODULE$.apply$default$4(x$7, "window");
                                Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, "window");
                                Alias windowStruct = new Alias(x$7, "window", x$9, x$11, (Option<Metadata>)x$10, x$12);
                                LogicalPlan replacedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(null, windowAttr){
                                    private static final long serialVersionUID = 0L;
                                    private final AttributeReference windowAttr$1;

                                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                                        A1 A1 = x4;
                                        Object object = A1 instanceof TimeWindow ? this.windowAttr$1 : function1.apply(x4);
                                        return (B1)object;
                                    }

                                    public final boolean isDefinedAt(Expression x4) {
                                        Expression expression = x4;
                                        boolean bl = expression instanceof TimeWindow;
                                        return bl;
                                    }
                                    {
                                        this.windowAttr$1 = windowAttr$1;
                                    }
                                });
                                IsNotNull filterExpr = new IsNotNull(window.timeColumn());
                                Alias alias = windowStruct;
                                Project project = new Project((Seq<NamedExpression>)((Seq)child.output().$plus$colon((Object)alias)), new Filter(filterExpr, child));
                                object2 = replacedPlan.withNewChildren(package$.MODULE$.Nil().$colon$colon((Object)project));
                            } else {
                                int overlappingWindows = (int)scala.math.package$.MODULE$.ceil((double)window.windowDuration() * 1.0 / (double)window.slideDuration());
                                Seq windows = (Seq)package$.MODULE$.Seq().tabulate(overlappingWindows, (Function1 & Serializable)i -> anonfun.apply.2.$anonfun$applyOrElse$4(window, BoxesRunTime.unboxToInt((Object)i)));
                                Seq projections = (Seq)windows.map((Function1 & Serializable)x$4 -> {
                                    Expression expression = x$4;
                                    return (Seq)child.output().$plus$colon((Object)expression);
                                });
                                IsNotNull filterExpr = window.windowDuration() % window.slideDuration() == 0L ? new IsNotNull(window.timeColumn()) : package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(window.timeColumn()).$greater$eq(package$expressions$.MODULE$.DslExpression(windowAttr).getField("start")))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(window.timeColumn()).$less(package$expressions$.MODULE$.DslExpression(windowAttr).getField("end"))));
                                AttributeReference attributeReference = windowAttr;
                                Filter substitutedPlan = new Filter(filterExpr, new Expand((Seq<Seq<Expression>>)projections, (Seq<Attribute>)((Seq)child.output().$plus$colon((Object)attributeReference)), child));
                                LogicalPlan renamedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(null, windowAttr){
                                    private static final long serialVersionUID = 0L;
                                    private final AttributeReference windowAttr$1;

                                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                                        A1 A1 = x5;
                                        Object object = A1 instanceof TimeWindow ? this.windowAttr$1 : function1.apply(x5);
                                        return (B1)object;
                                    }

                                    public final boolean isDefinedAt(Expression x5) {
                                        Expression expression = x5;
                                        boolean bl = expression instanceof TimeWindow;
                                        return bl;
                                    }
                                    {
                                        this.windowAttr$1 = windowAttr$1;
                                    }
                                });
                                Filter filter = substitutedPlan;
                                object2 = renamedPlan.withNewChildren(package$.MODULE$.Nil().$colon$colon((Object)filter));
                            }
                        } else {
                            if (numWindowExpr > 1) {
                                throw QueryCompilationErrors$.MODULE$.multiTimeWindowExpressionsNotSupportedError(A1);
                            }
                            object2 = A1;
                        }
                        object = object2;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan;
                    LogicalPlan logicalPlan2 = x1;
                    boolean bl = logicalPlan2 != null && (logicalPlan = logicalPlan2).children().size() == 1;
                    return bl;
                }

                private static final Expression getWindow$1(int i, DataType dataType, TimeWindow window$1) {
                    PreciseTimestampConversion timestamp = new PreciseTimestampConversion(window$1.timeColumn(), dataType, (DataType)LongType$.MODULE$);
                    Expression remainder = package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(timestamp).$minus(package$expressions$.MODULE$.longToLiteral(window$1.startTime()))).$percent(package$expressions$.MODULE$.longToLiteral(window$1.slideDuration()));
                    Expression lastStart = package$expressions$.MODULE$.DslExpression(timestamp).$minus(new CaseWhen((Seq<Tuple2<Expression, Expression>>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new LessThan(remainder, package$expressions$.MODULE$.intToLiteral(0)), (Object)package$expressions$.MODULE$.DslExpression(remainder).$plus(package$expressions$.MODULE$.longToLiteral(window$1.slideDuration())))}))), (Option<Expression>)new Some((Object)remainder)));
                    Expression windowStart = package$expressions$.MODULE$.DslExpression(lastStart).$minus(package$expressions$.MODULE$.longToLiteral((long)i * window$1.slideDuration()));
                    Expression windowEnd = package$expressions$.MODULE$.DslExpression(windowStart).$plus(package$expressions$.MODULE$.longToLiteral(window$1.windowDuration()));
                    Literal literal = Literal$.MODULE$.apply("start");
                    Expression expression = package$expressions$.MODULE$.DslExpression(new PreciseTimestampConversion(windowStart, (DataType)LongType$.MODULE$, dataType)).castNullable();
                    Literal literal2 = Literal$.MODULE$.apply("end");
                    Expression expression2 = package$expressions$.MODULE$.DslExpression(new PreciseTimestampConversion(windowEnd, (DataType)LongType$.MODULE$, dataType)).castNullable();
                    return new CreateNamedStruct((Seq<Expression>)package$.MODULE$.Nil().$colon$colon((Object)expression2).$colon$colon((Object)literal2).$colon$colon((Object)expression).$colon$colon((Object)literal));
                }

                public static final /* synthetic */ Expression $anonfun$applyOrElse$4(TimeWindow window$1, int i) {
                    return anonfun.apply.2.getWindow$1(i, window$1.timeColumn().dataType(), window$1);
                }
                {
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$4$adapted(org.apache.spark.sql.catalyst.expressions.TimeWindow java.lang.Object ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                logicalPlan = (LogicalPlan)ex.value();
            }
            throw ex;
        }
        return logicalPlan;
    }

    private TimeWindowing$() {
    }
}

