/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MaskExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="_FUNC_(input[, upperChar, lowerChar, digitChar, otherChar]) - masks the given string value.\n       The function replaces characters with 'X' or 'x', and numbers with 'n'.\n       This can be useful for creating copies of tables with sensitive information removed.\n      ", arguments="\n    Arguments:\n      * input      - string value to mask. Supported types: STRING, VARCHAR, CHAR\n      * upperChar  - character to replace upper-case characters with. Specify NULL to retain original character. Default value: 'X'\n      * lowerChar  - character to replace lower-case characters with. Specify NULL to retain original character. Default value: 'x'\n      * digitChar  - character to replace digit characters with. Specify NULL to retain original character. Default value: 'n'\n      * otherChar  - character to replace all other characters with. Specify NULL to retain original character. Default value: NULL\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abcd-EFGH-8765-4321');\n        xxxx-XXXX-nnnn-nnnn\n      > SELECT _FUNC_('abcd-EFGH-8765-4321', 'Q');\n        xxxx-QQQQ-nnnn-nnnn\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q');\n        QqQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#');\n        XxXXnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q');\n        QxQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q');\n        QqQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q', 'd');\n        QqQQddd-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q', 'd', 'o');\n        QqQQdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, 'q', 'd', 'o');\n        AqCDdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, 'd', 'o');\n        AbCDdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, NULL, 'o');\n        AbCD123oooo\n      > SELECT _FUNC_(NULL, NULL, NULL, NULL, 'o');\n        NULL\n      > SELECT _FUNC_(NULL);\n        NULL\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, NULL, NULL);\n        AbCD123-@$#\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t<Q!\u0002\u0004\t\u0002M1Q!\u0006\u0004\t\u0002YAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005B\u0019BQAM\u0001\u0005BM\nQ#T1tW\u0016C\bO]3tg&|gNQ;jY\u0012,'O\u0003\u0002\b\u0011\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tI!\"\u0001\u0005dCR\fG._:u\u0015\tYA\"A\u0002tc2T!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001!\t!\u0012!D\u0001\u0007\u0005Ui\u0015m]6FqB\u0014Xm]:j_:\u0014U/\u001b7eKJ\u001c2!A\f\u001e!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fMB\u0011a$I\u0007\u0002?)\u0011\u0001\u0005C\u0001\tC:\fG._:jg&\u0011!e\b\u0002\u0012\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001\u0014\u0003E1WO\\2uS>t7+[4oCR,(/Z\u000b\u0002OA\u0019\u0001\u0004\u000b\u0016\n\u0005%J\"AB(qi&|g\u000e\u0005\u0002,a5\tAF\u0003\u0002.]\u00059An\\4jG\u0006d'BA\u0018\t\u0003\u0015\u0001H.\u00198t\u0013\t\tDFA\tGk:\u001cG/[8o'&<g.\u0019;ve\u0016\fQAY;jY\u0012$2\u0001N\u001cE!\t!R'\u0003\u00027\r\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000ba\"\u0001\u0019A\u001d\u0002\u0011\u0019,hn\u0019(b[\u0016\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f\u001a\u001b\u0005i$B\u0001 \u0013\u0003\u0019a$o\\8u}%\u0011\u0001)G\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A3!)q\u0001\u0002a\u0001\u000bB\u0019ai\u0013\u001b\u000f\u0005\u001dKeB\u0001\u001fI\u0013\u0005Q\u0012B\u0001&\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0007M+\u0017O\u0003\u0002K3!b\u0011a\u0014*T+ZC\u0016l\u0017/_?B\u0011A\u0003U\u0005\u0003#\u001a\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-I\u0001U\u0003\tmqLR+O\u0007~C\u0013N\u001c9vinc\u0003%\u001e9qKJ\u001c\u0005.\u0019:-A1|w/\u001a:DQ\u0006\u0014H\u0006\t3jO&$8\t[1sY\u0001zG\u000f[3s\u0007\"\f'/X\u0015![\u0001j\u0017m]6tAQDW\rI4jm\u0016t\u0007e\u001d;sS:<\u0007E^1mk\u0016t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a9mC\u000e,7\u000fI2iCJ\f7\r^3sg\u0002:\u0018\u000e\u001e5!Oa;\u0003e\u001c:!Oa<C\u0006I1oI\u0002rW/\u001c2feN\u0004s/\u001b;iA\u001drwE\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011UQ&\u001c\beY1oA\t,\u0007%^:fMVd\u0007EZ8sA\r\u0014X-\u0019;j]\u001e\u00043m\u001c9jKN\u0004sN\u001a\u0011uC\ndWm\u001d\u0011xSRD\u0007e]3og&$\u0018N^3!S:4wN]7bi&|g\u000e\t:f[>4X\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018%A,\u0002\t?T\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I5oaV$\b\u0005\t\u0011!A\u0001j\u0003e\u001d;sS:<\u0007E^1mk\u0016\u0004Co\u001c\u0011nCN\\g\u0006I*vaB|'\u000f^3eAQL\b/Z:;AM#&+\u0013(HY\u00012\u0016IU\"I\u0003Jc\u0003e\u0011%B%*\u0001\u0003\u0005\t\u0011!A)\u0002S\u000f\u001d9fe\u000eC\u0017M\u001d\u0011![\u0001\u001a\u0007.\u0019:bGR,'\u000f\t;pAI,\u0007\u000f\\1dK\u0002*\b\u000f]3s[\r\f7/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004s/\u001b;i]\u0001\u001a\u0006/Z2jMf\u0004c*\u0016'MAQ|\u0007E]3uC&t\u0007e\u001c:jO&t\u0017\r\u001c\u0011dQ\u0006\u0014\u0018m\u0019;fe:\u0002C)\u001a4bk2$\bE^1mk\u0016T\u0004e\n-(\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001bwn^3s\u0007\"\f'\u000f\t\u0011.A\rD\u0017M]1di\u0016\u0014\b\u0005^8!e\u0016\u0004H.Y2fA1|w/\u001a:.G\u0006\u001cX\rI2iCJ\f7\r^3sg\u0002:\u0018\u000e\u001e5/AM\u0003XmY5gs\u0002rU\u000b\u0014'!i>\u0004#/\u001a;bS:\u0004sN]5hS:\fG\u000eI2iCJ\f7\r^3s]\u0001\"UMZ1vYR\u0004c/\u00197vKj\u0002s\u0005_\u0014\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011Lw-\u001b;DQ\u0006\u0014\b\u0005I\u0017!G\"\f'/Y2uKJ\u0004Co\u001c\u0011sKBd\u0017mY3!I&<\u0017\u000e\u001e\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004s/\u001b;i]\u0001\u001a\u0006/Z2jMf\u0004c*\u0016'MAQ|\u0007E]3uC&t\u0007e\u001c:jO&t\u0017\r\u001c\u0011dQ\u0006\u0014\u0018m\u0019;fe:\u0002C)\u001a4bk2$\bE^1mk\u0016T\u0004e\n8(\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001zG\u000f[3s\u0007\"\f'\u000f\t\u0011.A\rD\u0017M]1di\u0016\u0014\b\u0005^8!e\u0016\u0004H.Y2fA\u0005dG\u000eI8uQ\u0016\u0014\be\u00195be\u0006\u001cG/\u001a:tA]LG\u000f\u001b\u0018!'B,7-\u001b4zA9+F\n\u0014\u0011u_\u0002\u0012X\r^1j]\u0002z'/[4j]\u0006d\u0007e\u00195be\u0006\u001cG/\u001a:/A\u0011+g-Y;mi\u00022\u0018\r\\;fu\u0001rU\u000b\u0014'\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u00025\u00069yN\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(C\n\u001cG-L#G\u000f\"k\u0003h\u000e\u001c6[Q\u001a$'M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0010\u001f=y[aC\u0006\fW\u0017o]:tWF\u001c8o]*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u00192dI6*ei\u0012%.q]2T'\f\u001b4eE:C\u0006I\u0014RO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t=yqbl\u0013+U)R[9tgN\\\u0017o]:t'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014BE\u000e#\u0015GM\u001a.\u0001\u0012\u001as\u0005\f\u0011(#\u001eb\u0003eJ9(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%U9R#:tg.\f!%G)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u00112D\tF\u00124'\f!%G\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011YqbCfN\u001c8.\u0001\u0012\u001a#\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014BE\u000e#\u0015GM\u001a.\u0001\u0012\u001as\u0005\f\u0011(#\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011RqF\u000bfN\u001c8.\u0001\u0012\u001a#\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014BE\u000e#\u0015GM\u001a.\u0001\u0012\u001as\u0005\f\u0011(#\u001eb\u0003eJ9(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%U9R#:tg.\f!%G)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u00112D\tF\u00124'\f!%G\u001db\u0003eJ)(Y\u0001:\u0013o\n\u0017!O\u0011<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!#F\f\u0016\u000b\u001a3e[\u0001#3E\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0003\n\u001cE)\r\u001a4[\u0001#3e\n\u0017!OE;C\u0006I\u0014rO1\u0002s\u0005Z\u0014-A\u001dzw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!AE\u000b\u0018+\u00153eI>|wn\u001c\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0005\u00137\tR\u00193g5\u0002EeI\u0014-A9+F\n\u0014\u0017!OE<C\u0006I\u0014eO1\u0002se\\\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)]\"EI\u0012$wn\\8p\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013IY\"EcI\u001aT\u0006\u0011\u0013$O1\u0002c*\u0016'MY\u0001rU\u000b\u0014'-A\u001d\"w\u0005\f\u0011(_\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011BE\u000e#E\r\u001a3p_>|'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014BE\u000e#\u0015GM\u001a.\u0001\u0012\u001as\u0005\f\u0011O+2cE\u0006\t(V\u00192c\u0003ET+M\u00192\u0002se\\\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013IY\"EcI\u001atn\\8p\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"rU\u000b\u0014'-A9+F\n\u0014\u0017!\u001dVcE\n\f\u0011O+2cE\u0006I\u0014pO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006FT+M\u0019&Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!c\u0007\u0012\u000b$gM\u0017AI\r:C\u0006\t(V\u00192c\u0003ET+M\u00192\u0002c*\u0016'MY\u0001rU\u000b\u0014'*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013IY\"EcI\u001aT\u0006\u0011\u0013$\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017%A/\u0002\u000bMrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0003\u0001\fAb\u001d;sS:<wLZ;oGNDC\u0002A(S'V3\u0006,W.]=~\u0003")
public final class MaskExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return MaskExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static Option<FunctionSignature> functionSignature() {
        return MaskExpressionBuilder$.MODULE$.functionSignature();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return MaskExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName);
    }
}

