/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ConditionalExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NaNvl$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns `expr1` if it's not NaN, or `expr2` otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double), 123);\n       123.0\n  ", since="1.5.0", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001\u0002\u0010 \u00012B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u00159\b\u0001\"\u0011y\u0011\u001d\ti\u0001\u0001C)\u0003\u001fA\u0011\"!\u0007\u0001\u0003\u0003%\t!a\u0007\t\u0013\u0005\u0005\u0002!%A\u0005\u0002\u0005\r\u0002\"CA\u001d\u0001E\u0005I\u0011AA\u0012\u0011%\tY\u0004AA\u0001\n\u0003\ni\u0004C\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R!I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00111\f\u0005\n\u0003C\u0002\u0011\u0011!C!\u0003GB\u0011\"!\u001d\u0001\u0003\u0003%\t!a\u001d\t\u0013\u0005u\u0004!!A\u0005B\u0005}\u0004\"CAB\u0001\u0005\u0005I\u0011IAC\u000f%\tIkHA\u0001\u0012\u0003\tYK\u0002\u0005\u001f?\u0005\u0005\t\u0012AAW\u0011\u0019\t\u0006\u0004\"\u0001\u0002F\"I\u0011q\u0019\r\u0002\u0002\u0013\u0015\u0013\u0011\u001a\u0005\n\u0003\u0017D\u0012\u0011!CA\u0003\u001bD\u0011\"a5\u0019\u0003\u0003%\t)!6\t\u0013\u0005\u001d\b$!A\u0005\n\u0005%(!\u0002(b\u001dZd'B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001i\u0013\u0007N\u001c>!\tqs&D\u0001 \u0013\t\u0001tD\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011aFM\u0005\u0003g}\u0011QcQ8oI&$\u0018n\u001c8bY\u0016C\bO]3tg&|g\u000e\u0005\u0002/k%\u0011ag\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t9\u0001K]8ek\u000e$\bC\u0001 G\u001d\tyDI\u0004\u0002A\u00076\t\u0011I\u0003\u0002CW\u00051AH]8pizJ\u0011AO\u0005\u0003\u000bf\nq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\na1+\u001a:jC2L'0\u00192mK*\u0011Q)O\u0001\u0005Y\u00164G/F\u0001L!\tqC*\u0003\u0002N?\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u00191\u000bV+\u0011\u00059\u0002\u0001\"B%\u0006\u0001\u0004Y\u0005\"B(\u0006\u0001\u0004Y\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!aW\u0012\u0002\u000bQL\b/Z:\n\u0005uS&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001a!\rq\u0014mY\u0005\u0003E\"\u00131aU3r!\tIF-\u0003\u0002f5\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0016C2<\u0018-_:Fm\u0006dW/\u0019;fI&s\u0007/\u001e;t+\u0005A\u0007c\u0001 b\u0017\u0006a!M]1oG\"<%o\\;qgV\t1\u000eE\u0002?C\"\fA!\u001a<bYR\u0011a.\u001d\t\u0003q=L!\u0001]\u001d\u0003\u0007\u0005s\u0017\u0010C\u0004s\u0015A\u0005\t\u0019A:\u0002\u000b%t\u0007/\u001e;\u0011\u0005Q,X\"A\u0011\n\u0005Y\f#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\te|\u0018\u0011\u0002\t\u0003uvl\u0011a\u001f\u0006\u0003y~\tqaY8eK\u001e,g.\u0003\u0002\u007fw\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u0002-\u0001\r!a\u0001\u0002\u0007\r$\b\u0010E\u0002{\u0003\u000bI1!a\u0002|\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!a\u0003\f\u0001\u0004I\u0018AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003T\u0003#\t)\u0002\u0003\u0004\u0002\u00141\u0001\raS\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t9\u0002\u0004a\u0001\u0017\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B*\u0002\u001e\u0005}\u0001bB%\u000e!\u0003\u0005\ra\u0013\u0005\b\u001f6\u0001\n\u00111\u0001L\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\n+\u0007-\u000b9c\u000b\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!C;oG\",7m[3e\u0015\r\t\u0019$O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001c\u0003[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nA\u0001\\1oO*\u0011\u0011\u0011J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002N\u0005\r#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002TA\u0019\u0001(!\u0016\n\u0007\u0005]\u0013HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002o\u0003;B\u0011\"a\u0018\u0013\u0003\u0003\u0005\r!a\u0015\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0007E\u0003\u0002h\u00055d.\u0004\u0002\u0002j)\u0019\u00111N\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002p\u0005%$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001e\u0002|A\u0019\u0001(a\u001e\n\u0007\u0005e\u0014HA\u0004C_>dW-\u00198\t\u0011\u0005}C#!AA\u00029\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qHAA\u0011%\ty&FA\u0001\u0002\u0004\t\u0019&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003k\n9\t\u0003\u0005\u0002`Y\t\t\u00111\u0001oQM\u0001\u00111RAI\u0003'\u000b9*!'\u0002\u001e\u0006}\u00151UAS!\rq\u0013QR\u0005\u0004\u0003\u001f{\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003+\u000bQj\u0018$V\u001d\u000e{\u0006&\u001a=qeFb\u0003%\u001a=qeJJ\u0003%\f\u0011SKR,(O\\:!A\u0016D\bO]\u0019aA%4\u0007%\u001b;(g\u0002rw\u000e\u001e\u0011OC:c\u0003e\u001c:!A\u0016D\bO\u001d\u001aaA=$\b.\u001a:xSN,g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY*A)\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r\f7\u000f\u001e\u0015(\u001d\u0006tu\u0005I1tA\u0011|WO\u00197fS1\u0002\u0013GM\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$g\r\u00181\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAQ\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\t9+A\td_:$\u0017\u000e^5p]\u0006dwLZ;oGN\fQAT1Om2\u0004\"A\f\r\u0014\u000ba\ty+a/\u0011\u000f\u0005E\u0016qW&L'6\u0011\u00111\u0017\u0006\u0004\u0003kK\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003s\u000b\u0019LA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f9%\u0001\u0002j_&\u0019q)a0\u0015\u0005\u0005-\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0012!B1qa2LH#B*\u0002P\u0006E\u0007\"B%\u001c\u0001\u0004Y\u0005\"B(\u001c\u0001\u0004Y\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003/\f\u0019\u000fE\u00039\u00033\fi.C\u0002\u0002\\f\u0012aa\u00149uS>t\u0007#\u0002\u001d\u0002`.[\u0015bAAqs\t1A+\u001e9mKJB\u0001\"!:\u001d\u0003\u0003\u0005\raU\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAv!\u0011\t\t%!<\n\t\u0005=\u00181\t\u0002\u0007\u001f\nTWm\u0019;")
public class NaNvl
extends BinaryExpression
implements ConditionalExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(NaNvl x$0) {
        return NaNvl$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, NaNvl> tupled() {
        return NaNvl$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NaNvl>> curried() {
        return NaNvl$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final boolean foldable() {
        return ConditionalExpression.foldable$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))}));
    }

    @Override
    public Seq<Expression> alwaysEvaluatedInputs() {
        Expression expression = this.left();
        return package$.MODULE$.Nil().$colon$colon((Object)expression);
    }

    @Override
    public Seq<Seq<Expression>> branchGroups() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{this.children()}));
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object value = this.left().eval(input);
        if (value == null) {
            object = null;
        } else {
            Object object2;
            DataType dataType = this.left().dataType();
            if (DoubleType$.MODULE$.equals(dataType)) {
                object2 = !Double.isNaN(BoxesRunTime.unboxToDouble((Object)value)) ? value : this.right().eval(input);
            } else if (FloatType$.MODULE$.equals(dataType)) {
                object2 = !Float.isNaN(BoxesRunTime.unboxToFloat((Object)value)) ? value : this.right().eval(input);
            } else {
                throw new MatchError((Object)dataType);
            }
            object = object2;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        DataType dataType = this.left().dataType();
        boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
        if (!bl) {
            throw new MatchError((Object)dataType);
        }
        ExprCode exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = false;\n          ", " ", " = ", ";\n          if (", ") {\n            ", " = true;\n          } else {\n            if (!Double.isNaN(", ")) {\n              ", " = ", ";\n            } else {\n              ", "\n              if (", ") {\n                ", " = true;\n              } else {\n                ", " = ", ";\n              }\n            }\n          }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), leftGen.isNull(), ev.isNull(), leftGen.value(), ev.value(), leftGen.value(), rightGen.code(), rightGen.isNull(), ev.isNull(), ev.value(), rightGen.value()})), ev.copy$default$2(), ev.copy$default$3());
        return exprCode;
    }

    @Override
    public NaNvl withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public NaNvl copy(Expression left, Expression right) {
        return new NaNvl(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "NaNvl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NaNvl;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NaNvl)) return false;
        boolean bl = true;
        if (!bl) return false;
        NaNvl naNvl = (NaNvl)x$1;
        Expression expression = this.left();
        Expression expression2 = naNvl.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = naNvl.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!naNvl.canEqual(this)) return false;
        return true;
    }

    public NaNvl(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ConditionalExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

