/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.types;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$StoreAssignmentPolicy$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class DataTypeUtils$ {
    public static final DataTypeUtils$ MODULE$ = new DataTypeUtils$();
    private static final Regex SparkGeneratedName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("col\\d+"));

    public boolean sameType(DataType left, DataType right) {
        return left.sameType(right);
    }

    public boolean equalsIgnoreNullability(DataType left, DataType right) {
        return DataType$.MODULE$.equalsIgnoreNullability(left, right);
    }

    public boolean equalsIgnoreCaseAndNullability(DataType from, DataType to) {
        return DataType$.MODULE$.equalsIgnoreCaseAndNullability(from, to);
    }

    private Regex SparkGeneratedName() {
        return SparkGeneratedName;
    }

    private boolean isSparkGeneratedName(String name) {
        Option option;
        String string = name;
        boolean bl = string != null && !(option = this.SparkGeneratedName().unapplySeq((CharSequence)string)).isEmpty();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canWrite(String tableName, DataType write, DataType read, boolean byName, Function2<String, String, Object> resolver, String context, Enumeration.Value storeAssignmentPolicy, Function1<String, BoxedUnit> addError) {
        DataType r;
        DataType w;
        Tuple2 tuple2 = new Tuple2((Object)write, (Object)read);
        if (tuple2 != null) {
            DataType wArr = (DataType)tuple2._1();
            DataType rArr = (DataType)tuple2._2();
            if (wArr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)wArr;
                if (rArr instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)rArr;
                    boolean typesCompatible = this.canWrite(tableName, arrayType.elementType(), arrayType2.elementType(), byName, resolver, new StringBuilder(8).append(context).append(".element").toString(), storeAssignmentPolicy, addError);
                    if (!arrayType.containsNull()) return typesCompatible;
                    if (arrayType2.containsNull()) return typesCompatible;
                    throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableNullableArrayElementsError(tableName, context);
                }
            }
        }
        if (tuple2 != null) {
            DataType wMap = (DataType)tuple2._1();
            DataType rMap = (DataType)tuple2._2();
            if (wMap instanceof MapType) {
                MapType mapType = (MapType)wMap;
                if (rMap instanceof MapType) {
                    MapType mapType2 = (MapType)rMap;
                    boolean keyCompatible = this.canWrite(tableName, mapType.keyType(), mapType2.keyType(), byName, resolver, new StringBuilder(4).append(context).append(".key").toString(), storeAssignmentPolicy, addError);
                    boolean valueCompatible = this.canWrite(tableName, mapType.valueType(), mapType2.valueType(), byName, resolver, new StringBuilder(6).append(context).append(".value").toString(), storeAssignmentPolicy, addError);
                    if (mapType.valueContainsNull() && !mapType2.valueContainsNull()) {
                        throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableNullableMapValuesError(tableName, context);
                    }
                    if (!keyCompatible) return false;
                    if (!valueCompatible) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] writeFields = structType.fields();
                if (dataType2 instanceof StructType) {
                    StructType structType2 = (StructType)dataType2;
                    StructField[] readFields = structType2.fields();
                    BooleanRef fieldCompatible = BooleanRef.create((boolean)true);
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])readFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])writeFields))))), (Function1 & Serializable)x0$1 -> {
                        DataTypeUtils$.$anonfun$canWrite$1(resolver, context, tableName, byName, storeAssignmentPolicy, addError, fieldCompatible, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])readFields)) > ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])writeFields))) {
                        String missingFieldsStr = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])readFields), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])readFields)) - ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])writeFields)))), (Function1 & Serializable)f -> String.valueOf(TypeUtils$.MODULE$.toSQLId(f.name())), ClassTag$.MODULE$.apply(String.class))).mkString(", ");
                        if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(missingFieldsStr))) return fieldCompatible.elem;
                        throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableStructMissingFieldsError(tableName, context, missingFieldsStr);
                    }
                    if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])writeFields)) <= ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])readFields))) return fieldCompatible.elem;
                    String extraFieldsStr = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])writeFields), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])writeFields)) - ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])readFields)))), (Function1 & Serializable)f -> String.valueOf(TypeUtils$.MODULE$.toSQLId(f.name())), ClassTag$.MODULE$.apply(String.class))).mkString(", ");
                    throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableExtraStructFieldsError(tableName, context, extraFieldsStr);
                }
            }
        }
        if (tuple2 != null) {
            DataType w2 = (DataType)tuple2._1();
            DataType r2 = (DataType)tuple2._2();
            if (w2 instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)w2;
                if (r2 instanceof AtomicType) {
                    AtomicType atomicType2 = (AtomicType)r2;
                    Enumeration.Value value = storeAssignmentPolicy;
                    Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.STRICT();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        if (Cast$.MODULE$.canUpCast((DataType)atomicType, (DataType)atomicType2)) return true;
                        throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotSafelyCastError(tableName, context, atomicType.catalogString(), atomicType2.catalogString());
                    }
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof NullType) {
            Enumeration.Value value = storeAssignmentPolicy;
            Enumeration.Value value3 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
            if (value == null) {
                if (value3 == null) return true;
            } else if (value.equals(value3)) {
                return true;
            }
        }
        if (tuple2 != null) {
            DataType w3 = (DataType)tuple2._1();
            DataType r3 = (DataType)tuple2._2();
            if (w3 instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)w3;
                if (r3 instanceof AtomicType) {
                    AtomicType atomicType3 = (AtomicType)r3;
                    Enumeration.Value value = storeAssignmentPolicy;
                    Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
                    if (!(value != null ? !value.equals(value4) : value4 != null)) {
                        if (Cast$.MODULE$.canANSIStoreAssign((DataType)atomicType, (DataType)atomicType3)) return true;
                        throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotSafelyCastError(tableName, context, atomicType.catalogString(), atomicType3.catalogString());
                    }
                }
            }
        }
        if (tuple2 != null && this.sameType(w = (DataType)tuple2._1(), r = (DataType)tuple2._2()) && !(w instanceof NullType)) {
            return true;
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DataType w4 = (DataType)tuple2._1();
        DataType r4 = (DataType)tuple2._2();
        throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotSafelyCastError(tableName, context, w4.catalogString(), r4.catalogString());
    }

    public AttributeReference toAttribute(StructField field) {
        String x$1 = field.name();
        DataType x$2 = field.dataType();
        boolean x$3 = field.nullable();
        Metadata x$4 = field.metadata();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public Seq<AttributeReference> toAttributes(StructType schema) {
        return (Seq)schema.map((Function1 & Serializable)field -> MODULE$.toAttribute((StructField)field));
    }

    public StructType fromAttributes(Seq<Attribute> attributes) {
        return StructType$.MODULE$.apply((Seq)attributes.map((Function1 & Serializable)a -> new StructField(a.name(), a.dataType(), a.nullable(), a.metadata())));
    }

    public DecimalType fromLiteral(Literal literal) {
        DecimalType decimalType;
        Object object = literal.value();
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            decimalType = DecimalType$.MODULE$.fromDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply((int)s)));
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            decimalType = DecimalType$.MODULE$.fromDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(n)));
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            decimalType = DecimalType$.MODULE$.fromDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(l)));
        } else {
            decimalType = DecimalType$.MODULE$.forType(literal.dataType());
        }
        return decimalType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$canWrite$1(Function2 resolver$1, String context$1, String tableName$1, boolean byName$1, Enumeration.Value storeAssignmentPolicy$1, Function1 addError$1, BooleanRef fieldCompatible$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int i = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        StructField rField = (StructField)tuple22._1();
        StructField wField = (StructField)tuple22._2();
        boolean nameMatch = BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)wField.name(), (Object)rField.name())) || MODULE$.isSparkGeneratedName(wField.name());
        String fieldContext = new StringBuilder(1).append(context$1).append(".").append(rField.name()).toString();
        boolean typesCompatible = MODULE$.canWrite(tableName$1, wField.dataType(), rField.dataType(), byName$1, (Function2<String, String, Object>)resolver$1, fieldContext, storeAssignmentPolicy$1, (Function1<String, BoxedUnit>)addError$1);
        if (byName$1 && !nameMatch) {
            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableUnexpectedColumnNameError(tableName$1, context$1, i, rField.name(), wField.name());
        }
        if (!rField.nullable() && wField.nullable()) {
            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableNullableColumnError(tableName$1, fieldContext);
        }
        if (!typesCompatible) {
            fieldCompatible$1.elem = false;
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private DataTypeUtils$() {
    }
}

