/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.GraphLoader$;
import org.apache.spark.graphx.impl.EdgePartition;
import org.apache.spark.graphx.impl.EdgePartitionBuilder;
import org.apache.spark.graphx.impl.EdgePartitionBuilder$;
import org.apache.spark.graphx.impl.EdgePartitionBuilder$mcI$sp;
import org.apache.spark.graphx.impl.GraphImpl$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GraphLoader$
implements Logging {
    public static final GraphLoader$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GraphLoader$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Graph<Object, Object> edgeListFile(SparkContext sc, String path, boolean canonicalOrientation, int numEdgePartitions, StorageLevel edgeStorageLevel, StorageLevel vertexStorageLevel) {
        RDD rDD;
        long startTime = System.currentTimeMillis();
        if (numEdgePartitions > 0) {
            RDD qual$1 = sc.textFile(path, numEdgePartitions);
            int x$1 = numEdgePartitions;
            boolean x$2 = qual$1.coalesce$default$2();
            rDD = qual$1.coalesce(x$1, x$2, (Ordering)Ordering.String$.MODULE$);
        } else {
            rDD = sc.textFile(path, sc.textFile$default$2());
        }
        RDD lines = rDD;
        RDD edges = lines.mapPartitionsWithIndex((Function2)new Serializable(canonicalOrientation){
            public static final long serialVersionUID = 0L;
            public final boolean canonicalOrientation$1;

            public final Iterator<Tuple2<Object, EdgePartition<Object, Object>>> apply(int pid, Iterator<String> iter) {
                EdgePartitionBuilder$mcI$sp<VD> builder = new EdgePartitionBuilder$mcI$sp<VD>(EdgePartitionBuilder$.MODULE$.$lessinit$greater$default$1(), (ClassTag<Object>)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
                iter.foreach((Function1)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final EdgePartitionBuilder builder$1;

                    public final void apply(String line) {
                        if (!line.isEmpty() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(line), 0) != '#') {
                            String[] lineArray = line.split("\\s+");
                            if (lineArray.length < 2) {
                                throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid line: ").append((Object)line).toString());
                            }
                            long srcId = new StringOps(Predef$.MODULE$.augmentString(lineArray[0])).toLong();
                            long dstId = new StringOps(Predef$.MODULE$.augmentString(lineArray[1])).toLong();
                            if (this.$outer.canonicalOrientation$1 && srcId > dstId) {
                                this.builder$1.add$mcI$sp(dstId, srcId, 1);
                            } else {
                                this.builder$1.add$mcI$sp(srcId, dstId, 1);
                            }
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builder$1 = builder$1;
                    }
                });
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)pid), ((EdgePartitionBuilder)builder).toEdgePartition$mcI$sp())}));
            }
            {
                this.canonicalOrientation$1 = canonicalOrientation$1;
            }
        }, lines.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).persist(edgeStorageLevel).setName(new StringOps(Predef$.MODULE$.augmentString("GraphLoader.edgeListFile - edges (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        edges.count();
        this.logInfo((Function0<String>)new Serializable(startTime){
            public static final long serialVersionUID = 0L;
            private final long startTime$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("It took %d ms to load the edges")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.startTime$1))}));
            }
            {
                this.startTime$1 = startTime$1;
            }
        });
        return GraphImpl$.MODULE$.fromEdgePartitions(edges, BoxesRunTime.boxToInteger((int)1), edgeStorageLevel, vertexStorageLevel, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
    }

    public boolean edgeListFile$default$3() {
        return false;
    }

    public int edgeListFile$default$4() {
        return -1;
    }

    public StorageLevel edgeListFile$default$5() {
        return StorageLevel$.MODULE$.MEMORY_ONLY();
    }

    public StorageLevel edgeListFile$default$6() {
        return StorageLevel$.MODULE$.MEMORY_ONLY();
    }

    private GraphLoader$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

