/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class HiveExternalCatalog$ {
    public static HiveExternalCatalog$ MODULE$;
    private final String SPARK_SQL_PREFIX;
    private final String DATASOURCE_PREFIX;
    private final String DATASOURCE_PROVIDER;
    private final String DATASOURCE_SCHEMA;
    private final String DATASOURCE_SCHEMA_PREFIX;
    private final String DATASOURCE_SCHEMA_NUMPARTCOLS;
    private final String DATASOURCE_SCHEMA_NUMSORTCOLS;
    private final String DATASOURCE_SCHEMA_NUMBUCKETS;
    private final String DATASOURCE_SCHEMA_NUMBUCKETCOLS;
    private final String DATASOURCE_SCHEMA_PART_PREFIX;
    private final String DATASOURCE_SCHEMA_PARTCOL_PREFIX;
    private final String DATASOURCE_SCHEMA_BUCKETCOL_PREFIX;
    private final String DATASOURCE_SCHEMA_SORTCOL_PREFIX;
    private final String STATISTICS_PREFIX;
    private final String STATISTICS_TOTAL_SIZE;
    private final String STATISTICS_NUM_ROWS;
    private final String STATISTICS_COL_STATS_PREFIX;
    private final String TABLE_PARTITION_PROVIDER;
    private final String TABLE_PARTITION_PROVIDER_CATALOG;
    private final String TABLE_PARTITION_PROVIDER_FILESYSTEM;
    private final String CREATED_SPARK_VERSION;
    private final Set<String> HIVE_GENERATED_TABLE_PROPERTIES;
    private final Set<String> HIVE_GENERATED_STORAGE_PROPERTIES;
    private final StructType EMPTY_DATA_SCHEMA;

    static {
        new HiveExternalCatalog$();
    }

    public String SPARK_SQL_PREFIX() {
        return this.SPARK_SQL_PREFIX;
    }

    public String DATASOURCE_PREFIX() {
        return this.DATASOURCE_PREFIX;
    }

    public String DATASOURCE_PROVIDER() {
        return this.DATASOURCE_PROVIDER;
    }

    public String DATASOURCE_SCHEMA() {
        return this.DATASOURCE_SCHEMA;
    }

    public String DATASOURCE_SCHEMA_PREFIX() {
        return this.DATASOURCE_SCHEMA_PREFIX;
    }

    public String DATASOURCE_SCHEMA_NUMPARTCOLS() {
        return this.DATASOURCE_SCHEMA_NUMPARTCOLS;
    }

    public String DATASOURCE_SCHEMA_NUMSORTCOLS() {
        return this.DATASOURCE_SCHEMA_NUMSORTCOLS;
    }

    public String DATASOURCE_SCHEMA_NUMBUCKETS() {
        return this.DATASOURCE_SCHEMA_NUMBUCKETS;
    }

    public String DATASOURCE_SCHEMA_NUMBUCKETCOLS() {
        return this.DATASOURCE_SCHEMA_NUMBUCKETCOLS;
    }

    public String DATASOURCE_SCHEMA_PART_PREFIX() {
        return this.DATASOURCE_SCHEMA_PART_PREFIX;
    }

    public String DATASOURCE_SCHEMA_PARTCOL_PREFIX() {
        return this.DATASOURCE_SCHEMA_PARTCOL_PREFIX;
    }

    public String DATASOURCE_SCHEMA_BUCKETCOL_PREFIX() {
        return this.DATASOURCE_SCHEMA_BUCKETCOL_PREFIX;
    }

    public String DATASOURCE_SCHEMA_SORTCOL_PREFIX() {
        return this.DATASOURCE_SCHEMA_SORTCOL_PREFIX;
    }

    public String STATISTICS_PREFIX() {
        return this.STATISTICS_PREFIX;
    }

    public String STATISTICS_TOTAL_SIZE() {
        return this.STATISTICS_TOTAL_SIZE;
    }

    public String STATISTICS_NUM_ROWS() {
        return this.STATISTICS_NUM_ROWS;
    }

    public String STATISTICS_COL_STATS_PREFIX() {
        return this.STATISTICS_COL_STATS_PREFIX;
    }

    public String TABLE_PARTITION_PROVIDER() {
        return this.TABLE_PARTITION_PROVIDER;
    }

    public String TABLE_PARTITION_PROVIDER_CATALOG() {
        return this.TABLE_PARTITION_PROVIDER_CATALOG;
    }

    public String TABLE_PARTITION_PROVIDER_FILESYSTEM() {
        return this.TABLE_PARTITION_PROVIDER_FILESYSTEM;
    }

    public String CREATED_SPARK_VERSION() {
        return this.CREATED_SPARK_VERSION;
    }

    public Set<String> HIVE_GENERATED_TABLE_PROPERTIES() {
        return this.HIVE_GENERATED_TABLE_PROPERTIES;
    }

    public Set<String> HIVE_GENERATED_STORAGE_PROPERTIES() {
        return this.HIVE_GENERATED_STORAGE_PROPERTIES;
    }

    public StructType EMPTY_DATA_SCHEMA() {
        return this.EMPTY_DATA_SCHEMA;
    }

    private Seq<String> getColumnNamesByType(Map<String, String> props, String colType, String typeName) {
        return (Seq)Option$.MODULE$.option2Iterable(props.get((Object)new StringBuilder(32).append("spark.sql.sources.schema.num").append(new StringOps(Predef$.MODULE$.augmentString(colType)).capitalize()).append("Cols").toString())).toSeq().flatMap((Function1 & Serializable & scala.Serializable)numCols -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new StringOps(Predef$.MODULE$.augmentString(numCols)).toInt()).map((Function1 & Serializable & scala.Serializable)index -> HiveExternalCatalog$.$anonfun$getColumnNamesByType$2(props, colType, typeName, numCols, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> org$apache$spark$sql$hive$HiveExternalCatalog$$getPartitionColumnsFromTableProperties(CatalogTable metadata) {
        return this.getColumnNamesByType((Map<String, String>)metadata.properties(), "part", "partitioning columns");
    }

    public Option<BucketSpec> org$apache$spark$sql$hive$HiveExternalCatalog$$getBucketSpecFromTableProperties(CatalogTable metadata) {
        return metadata.properties().get((Object)this.DATASOURCE_SCHEMA_NUMBUCKETS()).map((Function1 & Serializable & scala.Serializable)numBuckets -> new BucketSpec(new StringOps(Predef$.MODULE$.augmentString(numBuckets)).toInt(), MODULE$.getColumnNamesByType((Map<String, String>)metadata.properties(), "bucket", "bucketing columns"), MODULE$.getColumnNamesByType((Map<String, String>)metadata.properties(), "sort", "sorting columns")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDatasourceTable(CatalogTable table) {
        Option provider = table.provider().orElse((Function0 & Serializable & scala.Serializable)() -> table.properties().get((Object)MODULE$.DATASOURCE_PROVIDER()));
        if (!provider.isDefined()) return false;
        Option option = provider;
        Some some = new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER());
        if (option == null) {
            if (some == null) return false;
            return true;
        } else if (option.equals(some)) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$getColumnNamesByType$2(Map props$1, String colType$1, String typeName$1, String numCols$1, int index) {
        return (String)props$1.getOrElse((Object)new StringBuilder(4).append(MODULE$.DATASOURCE_SCHEMA_PREFIX()).append(colType$1).append("Col.").append(index).toString(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new AnalysisException(new StringBuilder(61).append("Corrupted ").append(typeName$1).append(" in catalog: ").append(numCols$1).append(" parts expected, but part ").append(index).append(" is missing.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        });
    }

    private HiveExternalCatalog$() {
        MODULE$ = this;
        this.SPARK_SQL_PREFIX = "spark.sql.";
        this.DATASOURCE_PREFIX = new StringBuilder(8).append(this.SPARK_SQL_PREFIX()).append("sources.").toString();
        this.DATASOURCE_PROVIDER = new StringBuilder(8).append(this.DATASOURCE_PREFIX()).append("provider").toString();
        this.DATASOURCE_SCHEMA = new StringBuilder(6).append(this.DATASOURCE_PREFIX()).append("schema").toString();
        this.DATASOURCE_SCHEMA_PREFIX = new StringBuilder(1).append(this.DATASOURCE_SCHEMA()).append(".").toString();
        this.DATASOURCE_SCHEMA_NUMPARTCOLS = new StringBuilder(11).append(this.DATASOURCE_SCHEMA_PREFIX()).append("numPartCols").toString();
        this.DATASOURCE_SCHEMA_NUMSORTCOLS = new StringBuilder(11).append(this.DATASOURCE_SCHEMA_PREFIX()).append("numSortCols").toString();
        this.DATASOURCE_SCHEMA_NUMBUCKETS = new StringBuilder(10).append(this.DATASOURCE_SCHEMA_PREFIX()).append("numBuckets").toString();
        this.DATASOURCE_SCHEMA_NUMBUCKETCOLS = new StringBuilder(13).append(this.DATASOURCE_SCHEMA_PREFIX()).append("numBucketCols").toString();
        this.DATASOURCE_SCHEMA_PART_PREFIX = new StringBuilder(5).append(this.DATASOURCE_SCHEMA_PREFIX()).append("part.").toString();
        this.DATASOURCE_SCHEMA_PARTCOL_PREFIX = new StringBuilder(8).append(this.DATASOURCE_SCHEMA_PREFIX()).append("partCol.").toString();
        this.DATASOURCE_SCHEMA_BUCKETCOL_PREFIX = new StringBuilder(10).append(this.DATASOURCE_SCHEMA_PREFIX()).append("bucketCol.").toString();
        this.DATASOURCE_SCHEMA_SORTCOL_PREFIX = new StringBuilder(8).append(this.DATASOURCE_SCHEMA_PREFIX()).append("sortCol.").toString();
        this.STATISTICS_PREFIX = new StringBuilder(11).append(this.SPARK_SQL_PREFIX()).append("statistics.").toString();
        this.STATISTICS_TOTAL_SIZE = new StringBuilder(9).append(this.STATISTICS_PREFIX()).append("totalSize").toString();
        this.STATISTICS_NUM_ROWS = new StringBuilder(7).append(this.STATISTICS_PREFIX()).append("numRows").toString();
        this.STATISTICS_COL_STATS_PREFIX = new StringBuilder(9).append(this.STATISTICS_PREFIX()).append("colStats.").toString();
        this.TABLE_PARTITION_PROVIDER = new StringBuilder(17).append(this.SPARK_SQL_PREFIX()).append("partitionProvider").toString();
        this.TABLE_PARTITION_PROVIDER_CATALOG = "catalog";
        this.TABLE_PARTITION_PROVIDER_FILESYSTEM = "filesystem";
        this.CREATED_SPARK_VERSION = new StringBuilder(14).append(this.SPARK_SQL_PREFIX()).append("create.version").toString();
        this.HIVE_GENERATED_TABLE_PROPERTIES = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transient_lastDdlTime"}));
        this.HIVE_GENERATED_STORAGE_PROPERTIES = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"serialization.format"}));
        this.EMPTY_DATA_SCHEMA = new StructType().add("col", "array<string>", true, "from deserializer");
    }
}

