/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.ml.classification.LogisticRegressionParams;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class LogisticRegressionParams$class {
    public static LogisticRegressionParams setThreshold(LogisticRegressionParams $this, double value) {
        Object object = $this.isSet($this.thresholds()) ? $this.clear($this.thresholds()) : BoxedUnit.UNIT;
        return (LogisticRegressionParams)$this.set($this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public static double getThreshold(LogisticRegressionParams $this) {
        double d;
        $this.checkThresholdConsistency();
        if ($this.isSet($this.thresholds())) {
            double[] ts = $this.$($this.thresholds());
            Predef$.MODULE$.require(ts.length == 2, (Function0)new Serializable($this, ts){
                public static final long serialVersionUID = 0L;
                private final double[] ts$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Logistic Regression getThreshold only applies to binary classification, but thresholds has length != 2.  thresholds: ").append((Object)Predef$.MODULE$.doubleArrayOps(this.ts$1).mkString(",")).toString();
                }
                {
                    this.ts$1 = ts$1;
                }
            });
            d = 1.0 / (1.0 + ts[0] / ts[1]);
        } else {
            d = BoxesRunTime.unboxToDouble((Object)$this.$($this.threshold()));
        }
        return d;
    }

    public static LogisticRegressionParams setThresholds(LogisticRegressionParams $this, double[] value) {
        Object object = $this.isSet($this.threshold()) ? $this.clear($this.threshold()) : BoxedUnit.UNIT;
        return (LogisticRegressionParams)$this.set($this.thresholds(), value);
    }

    public static double[] getThresholds(LogisticRegressionParams $this) {
        double[] dArray;
        $this.checkThresholdConsistency();
        if (!$this.isSet($this.thresholds()) && $this.isSet($this.threshold())) {
            double t = BoxesRunTime.unboxToDouble((Object)$this.$($this.threshold()));
            double[] dArray2 = new double[2];
            dArray2[0] = 1.0 - t;
            dArray = dArray2;
            dArray2[1] = t;
        } else {
            dArray = $this.$($this.thresholds());
        }
        return dArray;
    }

    public static void checkThresholdConsistency(LogisticRegressionParams $this) {
        if ($this.isSet($this.threshold()) && $this.isSet($this.thresholds())) {
            double[] ts = $this.$($this.thresholds());
            Predef$.MODULE$.require(ts.length == 2, (Function0)new Serializable($this, ts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegressionParams $outer;
                private final double[] ts$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Logistic Regression found inconsistent values for threshold and").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" thresholds.  Param threshold is set (", "), indicating binary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.$(this.$outer.threshold())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" classification, but Param thresholds is set with length ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ts$2.length)}))).append((Object)" Clear one Param value to fix this problem.").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.ts$2 = ts$2;
                }
            });
            double t = 1.0 / (1.0 + ts[0] / ts[1]);
            Predef$.MODULE$.require(package$.MODULE$.abs(BoxesRunTime.unboxToDouble((Object)$this.$($this.threshold())) - t) < 1.0E-5, (Function0)new Serializable($this, t){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegressionParams $outer;
                private final double t$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Logistic Regression getThreshold found").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" inconsistent values for threshold (", ") and thresholds (equivalent to ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.$(this.$outer.threshold()), BoxesRunTime.boxToDouble((double)this.t$1)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.t$1 = t$1;
                }
            });
        }
    }

    public static void validateParams(LogisticRegressionParams $this) {
        $this.checkThresholdConsistency();
    }

    public static void $init$(LogisticRegressionParams $this) {
    }
}

